/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.exception.OperateException;
import com.digiwin.dap.middleware.iam.api.base.AppBaseController;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.app.ActionVO;
import com.digiwin.dap.middleware.iam.domain.app.AppTokenQueryResultVO;
import com.digiwin.dap.middleware.iam.domain.app.SysCascade;
import com.digiwin.dap.middleware.iam.domain.app.SysCascadeVO;
import com.digiwin.dap.middleware.iam.domain.app.SysVO;
import com.digiwin.dap.middleware.iam.domain.org.RequestParameterVO;
import com.digiwin.dap.middleware.iam.domain.tenant.QuerySysInTenantPageVO;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.SysNotice;
import com.digiwin.dap.middleware.iam.service.app.ModuleQueryService;
import com.digiwin.dap.middleware.iam.service.notice.SysNoticeCrudService;
import com.digiwin.dap.middleware.iam.service.sys.AppTokenQueryService;
import com.digiwin.dap.middleware.iam.service.sys.SysCrudService;
import com.digiwin.dap.middleware.iam.service.sys.SysInTenantQueryService;
import com.digiwin.dap.middleware.iam.service.sys.SysQueryService;
import com.digiwin.dap.middleware.iam.service.sys.SysService;
import com.digiwin.dap.middleware.iam.service.tenant.PurchaseApplicationService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantQueryService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleService;
import com.digiwin.dap.middleware.iam.support.auth.domain.IamAuthoredUser;
import com.digiwin.dap.middleware.iam.support.clean.RefreshCacheService;
import com.digiwin.dap.middleware.iam.support.remote.domain.MultiLanguageSysCascadeVO;
import io.github.resilience4j.ratelimiter.annotation.RateLimiter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2/app"})
public class AppController
extends AppBaseController {
    @Autowired
    private SysService sysService;
    @Autowired
    private SysQueryService sysQueryService;
    @Autowired
    private ModuleQueryService moduleQueryService;
    @Autowired
    private SysCrudService sysCrudService;
    @Autowired
    private SysInTenantQueryService sysInTenantQueryService;
    @Autowired
    private AppTokenQueryService appTokenQueryService;
    @Autowired
    private PurchaseApplicationService purchaseApplicationService;
    @Autowired
    private TenantQueryService tenantQueryService;
    @Autowired
    private SysNoticeCrudService sysNoticeCrudService;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private UserInRoleService userInRoleService;
    @Autowired
    private RefreshCacheService refreshCacheService;

    @PostMapping(value={""})
    @RateLimiter(name="/api/iam/v2/app")
    public ResponseEntity<?> getApp(@RequestBody RequestParameterVO requestParameterVO, @RequestAttribute(value="digi-middleware-auth-user-data") IamAuthoredUser authoredUser) {
        String appId = requestParameterVO.getId();
        long appSid = requestParameterVO.getSid();
        if (appSid == 0L && StringUtils.isEmpty((Object)appId)) {
            throw new IllegalArgumentException("id\u548csid\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        SysCascade sysCascade = this.sysQueryService.getSysCascadeBySid(authoredUser.getTenantSid(), authoredUser.getTenantId(), appSid, appId, authoredUser.isDealer(), authoredUser.isEoc());
        sysCascade.setApps(this.sysQueryService.getPlatFormSysCascadeBySid(authoredUser.getTenantSid(), authoredUser.getTenantId(), appSid, appId, authoredUser.isDealer(), authoredUser.isEoc()));
        sysCascade.setBundleApps(this.sysQueryService.getBundleSysCascadeBySid(authoredUser.getTenantSid(), authoredUser.getTenantId(), appSid, appId, authoredUser.isDealer(), authoredUser.isEoc()));
        sysCascade.getApp().setBackUri(sysCascade.getApp().getMetaUri());
        return ResponseEntity.ok((Object)sysCascade);
    }

    @GetMapping(value={"/{appId}/tenants"})
    public ResponseEntity<?> getTenantsInApp(@PathVariable(value="appId") String appId, @RequestParam(value="customerId", required=false) String customerId) {
        List tenantVOS = this.tenantQueryService.getTenantsByPurchaseApp(appId, customerId);
        return new ResponseEntity((Object)tenantVOS, HttpStatus.OK);
    }

    @PostMapping(value={"/apps/tenants"})
    public StdData<?> getTenantsInApps(@RequestBody @Validated QuerySysInTenantPageVO vo) {
        return StdData.ok((Object)this.tenantQueryService.getTenantsByPurchaseApps(vo));
    }

    @PostMapping(value={"/default/update/withlanguage"})
    public ResponseEntity<?> updateLanguageApplication(@RequestBody MultiLanguageSysCascadeVO multiLanguageSysCascadeVO) {
        if (multiLanguageSysCascadeVO.getSysCascadeVO() == null) {
            throw new OperateException("\u7f3a\u5c11sysCascadeVO\u53c2\u6570\uff0c\u4e0d\u80fd\u6dfb\u52a0");
        }
        this.checkAction(multiLanguageSysCascadeVO.getSysCascadeVO().getActions());
        this.sysService.addSysCascadeWithLanguage(multiLanguageSysCascadeVO.getSysCascadeVO(), multiLanguageSysCascadeVO.getMultiLanguageSysDetailVOS(), true, 0L);
        SysVO app = multiLanguageSysCascadeVO.getSysCascadeVO().getApp();
        this.refreshCacheService.deletePermissionBySys(app.getSid(), app.getId(), 0L);
        return new ResponseEntity(HttpStatus.CREATED);
    }

    @PostMapping(value={"/query/module"})
    public ResponseEntity<?> getCascade(@RequestBody RequestParameterVO requestParameterVO) {
        long appSid = this.getAppSid(this.sysCrudService, requestParameterVO.getSid(), requestParameterVO.getId());
        List moduleQueryResultVOS = this.moduleQueryService.getModuleVOSBySid(appSid);
        return ResponseEntity.ok((Object)moduleQueryResultVOS);
    }

    @PostMapping(value={"/query"})
    public ResponseEntity<?> queryApp(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        long tenantSid = authoredUser.getTenantSid();
        List sysQueryResultVOS = this.sysInTenantQueryService.getSysVOByTenantSid(tenantSid);
        return ResponseEntity.ok((Object)sysQueryResultVOS);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/token"})
    public ResponseEntity<?> getToken(@RequestBody RequestParameterVO requestParameterVO) {
        long appSid = this.getAppSid(this.sysCrudService, requestParameterVO.getSid(), requestParameterVO.getId());
        AppTokenQueryResultVO appTokenQueryResultVO = this.appTokenQueryService.getAppTokenQueryResultVO(appSid);
        return ResponseEntity.ok((Object)appTokenQueryResultVO);
    }

    @Transactional
    @PostMapping(value={"/default/update/landing"})
    public StdData updateAppWithAuth(@RequestBody MultiLanguageSysCascadeVO multiLanguageSysCascadeVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        if (StringUtils.isEmpty((Object)user.getTenantId())) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_ID_NOT_NULL);
        }
        if (multiLanguageSysCascadeVO.getSysCascadeVO() == null || multiLanguageSysCascadeVO.getSysCascadeVO().getApp() == null || StringUtils.isEmpty((Object)multiLanguageSysCascadeVO.getSysCascadeVO().getApp().getId())) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_NOT_EXISTED);
        }
        if (0 != this.envProperties.getCloud() && !this.userInRoleService.checkSuperAdmin(Long.valueOf(user.getTenantSid()), Long.valueOf(user.getSid()))) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_USER_PERMISSION_OPERATE_ERROR);
        }
        this.updateLanguageApplication(multiLanguageSysCascadeVO);
        this.purchaseApplicationService.purchaseAppWithAuthLanding(Long.valueOf(user.getTenantSid()), user.getTenantId(), user.getTenantName(), multiLanguageSysCascadeVO.getSysCascadeVO());
        return StdData.ok().build();
    }

    @PostMapping(value={"/default/update"})
    public ResponseEntity<?> updateLanguageApplication(@RequestBody SysCascadeVO sysCascadeVO) {
        this.sysService.addSysCascade(sysCascadeVO, true, 0L);
        SysVO app = sysCascadeVO.getApp();
        this.refreshCacheService.deletePermissionBySys(app.getSid(), app.getId(), 0L);
        return new ResponseEntity(HttpStatus.CREATED);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/del"})
    public StdData<?> deleteSys(@RequestBody RequestParameterVO body) {
        Sys sys = (Sys)this.sysCrudService.findById(body.getId());
        if (sys != null) {
            this.sysCrudService.deleteById(sys.getSid());
        }
        List sysNotice = this.sysNoticeCrudService.findBySysId(body.getId());
        for (SysNotice notice : sysNotice) {
            this.sysNoticeCrudService.deleteById(notice.getSid());
        }
        return StdData.ok().build();
    }

    private void checkAction(List<ActionVO> actions) {
        HashMap moduleTenantActionIds = new HashMap();
        ArrayList<ActionVO> duplicateActions = new ArrayList<ActionVO>();
        for (ActionVO action : actions) {
            String key = action.getTenantSid() + "_" + action.getModuleId();
            moduleTenantActionIds.putIfAbsent(key, new HashSet());
            if (((Set)moduleTenantActionIds.get(key)).add(action.getId())) continue;
            duplicateActions.add(action);
        }
        if (!duplicateActions.isEmpty()) {
            StringBuilder errorMessage = new StringBuilder("\u540ctenantSid\u548cmoduleId\u4e0b\uff0caction id\u5df2\u5b58\u5728: ");
            for (ActionVO action : duplicateActions) {
                errorMessage.append("tenantSid=").append(action.getTenantSid()).append(", moduleId=").append(action.getModuleId()).append(", id=").append(action.getId()).append("; \n");
            }
            throw new BusinessException(errorMessage.toString());
        }
    }
}

