/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.commons.core.codec.Base64;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.role.QueryRoleResultVO;
import com.digiwin.dap.middleware.iam.domain.user.BatchQueryUserInRoleResultVO;
import com.digiwin.dap.middleware.iam.domain.user.BatchQueryUserInRoleVO;
import com.digiwin.dap.middleware.iam.domain.user.RoleInUserInfoVO;
import com.digiwin.dap.middleware.iam.domain.user.UserInOrgVO;
import com.digiwin.dap.middleware.iam.domain.user.UserInRoleInfoVO;
import com.digiwin.dap.middleware.iam.domain.user.UserSimpleVO;
import com.digiwin.dap.middleware.iam.entity.Role;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.repository.UserInTenantRepository;
import com.digiwin.dap.middleware.iam.service.role.RoleCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleQueryService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleService;
import com.digiwin.dap.middleware.iam.service.user.UserQueryService;
import com.digiwin.dap.middleware.iam.support.validate.AuthValidateService;
import com.digiwin.dap.middleware.iam.util.StringUtil;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import com.github.pagehelper.PageSerializable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2/association"})
public class AssociationController {
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private RoleCrudService roleCrudService;
    @Autowired
    private UserInRoleQueryService userInRoleQueryService;
    @Autowired
    private UserInRoleService userInRoleService;
    @Autowired
    private UserInTenantRepository userInTenantRepository;
    @Autowired
    private UserQueryService userQueryService;
    @Autowired
    private AuthValidateService authValidateService;

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/user/updaterole"})
    public ResponseEntity<?> updateRoleInUser(@RequestBody RoleInUserInfoVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Assert.notNull((Object)body.getUserId(), (String)"\u7528\u6237Id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)body.getRoleIds(), (String)"\u89d2\u8272Id\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        User user = (User)this.userCrudService.findById(body.getUserId());
        Assert.notNull((Object)user, (String)String.format("\u8be5\u89d2\u8272[%s]\u4e0d\u5b58\u5728\uff01", body.getUserId()));
        this.userInRoleService.updateUserInRoleByUser(Long.valueOf(authoredUser.getTenantSid()), Long.valueOf(user.getSid()), body.getRoleIds());
        return new ResponseEntity(HttpStatus.OK);
    }

    @Transactional
    @PostMapping(value={"/user/updaterole/action"})
    public ResponseEntity<?> updateUserRoles(@RequestBody RoleInUserInfoVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Assert.notNull((Object)body.getUserId(), (String)"\u7528\u6237Id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)body.getRoleIds(), (String)"\u89d2\u8272Id\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        User user = (User)this.userCrudService.findById(body.getUserId());
        Assert.notNull((Object)user, (String)String.format("\u8be5\u89d2\u8272[%s]\u4e0d\u5b58\u5728\uff01", body.getUserId()));
        this.userInRoleService.updateRoleByUserWithAction(Long.valueOf(authoredUser.getTenantSid()), Long.valueOf(user.getSid()), body);
        return new ResponseEntity(HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/userinrole"})
    public ResponseEntity<?> getUserInRole(@RequestBody UserInRoleInfoVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Assert.notNull((Object)body.getRoleId(), (String)"\u89d2\u8272Id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Role role = this.roleCrudService.findByTenantSidAndId(authoredUser.getTenantSid(), body.getRoleId());
        if (role == null) {
            throw new BusinessException((ErrorHandler)I18nError.ASSOCIATION_NOT_EXISTED, new Object[]{body.getRoleId(), authoredUser.getTenantId()});
        }
        List users = this.userInRoleQueryService.queryUsersInRole(role.getTenantSid(), role.getSid(), body.getStatus());
        return new ResponseEntity((Object)users, HttpStatus.OK);
    }

    @GetMapping(value={"/userinrole/list"})
    public ResponseEntity<?> getUserPageInRole(@RequestParam String roleId, @RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orderBy", defaultValue="u.id") String orderBy, @RequestParam(name="params", required=false) String params, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Assert.notNull((Object)roleId, (String)"\u89d2\u8272Id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Role role = this.roleCrudService.findByTenantSidAndId(authoredUser.getTenantSid(), roleId);
        if (role == null) {
            throw new BusinessException((ErrorHandler)I18nError.ASSOCIATION_NOT_EXISTED, new Object[]{roleId, authoredUser.getTenantId()});
        }
        UserInRoleInfoVO dto = new UserInRoleInfoVO();
        if (StringUtils.hasLength((String)params)) {
            try {
                dto = (UserInRoleInfoVO)JsonUtils.createObjectMapper().readValue(params, UserInRoleInfoVO.class);
            }
            catch (IOException o) {
                throw new BusinessException((ErrorHandler)I18nError.PARAM_ERROR);
            }
        }
        List users = this.userInRoleQueryService.queryUserListInRole(role.getSid(), authoredUser.getTenantSid(), dto, pageNum, pageSize, orderBy);
        return new ResponseEntity((Object)new PageSerializable(users), HttpStatus.OK);
    }

    @PostMapping(value={"/userinrole/username"})
    public ResponseEntity<?> queryUserByRoleSidUserName(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestBody UserInOrgVO vo) {
        Assert.isTrue((user.getTenantSid() > 0L ? 1 : 0) != 0, (String)"\u5f53\u524d\u767b\u9646\u7528\u6237\u5fc5\u987b\u643a\u5e26\u79df\u6237\u4fe1\u606f\uff01");
        List users = this.userInRoleQueryService.queryUserListInRoleUserName(vo.getRoleSid(), user.getTenantSid(), vo.getUserName());
        return new ResponseEntity((Object)users, HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/role/removeusers"})
    public ResponseEntity<?> removeUsersInRole(@RequestBody UserInRoleInfoVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestAttribute(value="digi-middleware-auth-app-data") AuthoredSys sys) {
        Assert.notNull((Object)body.getRoleId(), (String)"\u89d2\u8272Id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Role role = this.roleCrudService.findByTenantSidAndId(authoredUser.getTenantSid(), body.getRoleId());
        if (role == null) {
            throw new BusinessException((ErrorHandler)I18nError.ASSOCIATION_NOT_EXISTED, new Object[]{body.getRoleId(), authoredUser.getTenantId()});
        }
        ArrayList userSids = new ArrayList();
        List userIds = body.getUserIds();
        if (!userIds.isEmpty()) {
            userIds.forEach(userId -> {
                User user = (User)this.userCrudService.findById(userId);
                if (user == null) {
                    throw new BusinessException((ErrorHandler)I18nError.ERROR_21001, new Object[]{userId});
                }
                userSids.add(user.getSid());
            });
            if ("superadmin".equals(body.getRoleId())) {
                List users = this.userInRoleQueryService.queryUsersInRole(role.getTenantSid(), role.getSid(), body.getStatus());
                List userSidCollect = users.stream().map(BaseEntity::getSid).collect(Collectors.toList());
                userSidCollect.removeAll(userSids);
                if (userSidCollect.isEmpty()) {
                    throw new BusinessException((ErrorHandler)I18nError.USER_ROLE_DELETE_ALL_ERROR, new Object[]{"superadmin"});
                }
            }
            this.userInRoleService.deleteUsersInRole(Long.valueOf(role.getSid()), userSids, role.getTenantSid());
        }
        return new ResponseEntity(HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/role/addusers"})
    public ResponseEntity<?> addUsersInRole(@RequestBody UserInRoleInfoVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestAttribute(value="digi-middleware-auth-app-data") AuthoredSys sys) {
        List users;
        List userSidCollect;
        Assert.notNull((Object)body.getRoleId(), (String)"\u89d2\u8272Id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Role role = this.roleCrudService.findByTenantSidAndId(authoredUser.getTenantSid(), body.getRoleId());
        if (role == null) {
            throw new BusinessException((ErrorHandler)I18nError.ASSOCIATION_NOT_EXISTED, new Object[]{body.getRoleId(), authoredUser.getTenantId()});
        }
        if ("superadmin".equals(body.getRoleId()) && !(userSidCollect = (users = this.userInRoleQueryService.queryUsersInRole(role.getTenantSid(), role.getSid(), body.getStatus())).stream().map(BaseEntity::getSid).collect(Collectors.toList())).contains(authoredUser.getSid())) {
            throw new BusinessException((ErrorHandler)I18nError.USER_ROLE_NOT_SUPERADMIN_ADD_ERROR, new Object[]{authoredUser.getUserId(), "superadmin", "superadmin"});
        }
        ArrayList userSids = new ArrayList();
        List userIds = body.getUserIds();
        if (userIds.isEmpty()) {
            throw new BusinessException(String.format("\u7528\u6237[%s]\u4e0d\u5b58\u5728\uff01", userIds));
        }
        userIds.forEach(userId -> {
            User user = (User)this.userCrudService.findById(userId);
            if (user == null) {
                throw new BusinessException(String.format("\u7528\u6237[%s]\u4e0d\u5b58\u5728\uff01", userId));
            }
            if (!this.userInTenantRepository.existsByTenantSidAndUserSid(authoredUser.getTenantSid(), user.getSid())) {
                throw new BusinessException((ErrorHandler)I18nError.IAM_USER_PERMISSION_COMMON_ERROR, new Object[]{UserUtils.getUserName(), UserUtils.getUserId(), AppAuthContextHolder.getContext().getClientIP(), Base64.encode((String)JsonUtils.writeValue((Object)body))});
            }
            QueryRoleResultVO queryRoleResultVO = this.userInRoleQueryService.queryUserInRoleByUserAndRole(authoredUser.getTenantSid(), user.getSid(), role.getId());
            if (queryRoleResultVO == null) {
                userSids.add(user.getSid());
            }
        });
        this.userInRoleService.addUsersInRole(Long.valueOf(role.getSid()), userSids, role.getTenantSid());
        return new ResponseEntity(HttpStatus.OK);
    }

    @PostMapping(value={"/usernotinrole"})
    public ResponseEntity<?> getUserNotInRole(@RequestBody UserInRoleInfoVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Assert.notNull((Object)body.getRoleId(), (String)"\u89d2\u8272Id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Role role = this.roleCrudService.findByTenantSidAndId(authoredUser.getTenantSid(), body.getRoleId());
        if (role == null) {
            throw new BusinessException((ErrorHandler)I18nError.ASSOCIATION_ROLE_NOT_EXISTED, new Object[]{body.getRoleId()});
        }
        Assert.notNull((Object)role, (String)String.format("\u8be5\u89d2\u8272[%s]\u4e0d\u5b58\u5728\uff01", body.getRoleId()));
        List users = this.userInRoleQueryService.queryUserNotInRole(authoredUser.getTenantSid(), role.getSid(), body.getStatus());
        return new ResponseEntity((Object)users, HttpStatus.OK);
    }

    @PostMapping(value={"/usernotinrole/list"})
    public ResponseEntity<?> getUserNotInRolePage(@RequestBody UserInRoleInfoVO body) {
        Assert.notNull((Object)body.getRoleId(), (String)"\u89d2\u8272Id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Role role = this.roleCrudService.findByTenantSidAndId(UserUtils.getTenantSid(), body.getRoleId());
        if (role == null) {
            throw new BusinessException((ErrorHandler)I18nError.ASSOCIATION_ROLE_NOT_EXISTED, new Object[]{body.getRoleId()});
        }
        Assert.notNull((Object)role, (String)String.format("\u8be5\u89d2\u8272[%s]\u4e0d\u5b58\u5728\uff01", body.getRoleId()));
        PageSerializable users = this.userInRoleQueryService.queryUserNotInRolePage(UserUtils.getTenantSid(), role.getSid(), body);
        return new ResponseEntity((Object)users, HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/role/updateuser"})
    public ResponseEntity<?> updateUserInRole(@RequestBody UserInRoleInfoVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Assert.notNull((Object)body.getRoleId(), (String)"\u89d2\u8272Id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)body.getUserIds(), (String)"\u7528\u6237Id\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        if (!StringUtil.checkUserId((String)body.getRoleId())) {
            throw new IllegalArgumentException("\u89d2\u8272Id\u4e0d\u89c4\u8303\uff01");
        }
        Role role = this.roleCrudService.findByTenantSidAndId(authoredUser.getTenantSid(), body.getRoleId());
        if (role == null) {
            throw new BusinessException((ErrorHandler)I18nError.ASSOCIATION_ROLE_NOT_EXISTED, new Object[]{body.getRoleId()});
        }
        ArrayList<User> users = new ArrayList<User>();
        for (String userId : body.getUserIds()) {
            User user = (User)this.userCrudService.findById(userId);
            if (user == null) continue;
            users.add(user);
        }
        this.userInRoleService.updateUserInRole(Long.valueOf(authoredUser.getTenantSid()), Long.valueOf(role.getSid()), users);
        return new ResponseEntity(HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/user/removerole"})
    public ResponseEntity<?> removeRoleInUser(@RequestBody RoleInUserInfoVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Assert.notNull((Object)body.getUserId(), (String)"\u89d2\u8272Id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        User user = (User)this.userCrudService.findById(body.getUserId());
        if (user == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21001, new Object[]{body.getUserId()});
        }
        this.userInRoleService.deleteRoleInUser(Long.valueOf(authoredUser.getTenantSid()), Long.valueOf(user.getSid()));
        return new ResponseEntity(HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"role/removeuser"})
    public ResponseEntity<?> removeUserInRole(@RequestBody UserInRoleInfoVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestAttribute(value="digi-middleware-auth-app-data") AuthoredSys sys) {
        Assert.notNull((Object)body.getRoleId(), (String)"\u89d2\u8272Id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Role role = this.roleCrudService.findByTenantSidAndId(authoredUser.getTenantSid(), body.getRoleId());
        Assert.notNull((Object)role, (String)String.format("\u8be5\u89d2\u8272[%s]\u4e0d\u5b58\u5728\uff01", body.getRoleId()));
        this.userInRoleService.deleteUserInRole(Long.valueOf(role.getSid()), Long.valueOf(authoredUser.getTenantSid()), sys.getId());
        return new ResponseEntity(HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/userinrole/simple"})
    public ResponseEntity<?> getUserSimpleInfoInRole(@RequestBody UserInRoleInfoVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Assert.notNull((Object)body.getRoleId(), (String)"\u89d2\u8272Id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        if (body.getTenantIds().isEmpty()) {
            Assert.notNull((Object)authoredUser.getTenantId(), (String)"\u5f53\u524d\u767b\u5f55\u7528\u6237\u6ca1\u6709\u79df\u6237\u4fe1\u606f\uff01");
            body.getTenantIds().add(authoredUser.getTenantId());
        } else if (!(body.getTenantIds().size() <= 1 && body.getTenantIds().contains(authoredUser.getTenantId()) || this.authValidateService.checkAccessPermission(TargetType.Sys.name(), "POST", "/api/iam/v2/association/userinrole/simple", UserUtils.getSysId()).booleanValue())) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        return new ResponseEntity((Object)this.userQueryService.queryUserInfosInRole(body), HttpStatus.OK);
    }

    @PostMapping(value={"/userinrole/list/simple"})
    public StdData<?> batchGetUserSimpleInfoInRole(@RequestBody @Valid BatchQueryUserInRoleVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        List userInRoleList = this.userInRoleQueryService.batchQueryUserInRole(authoredUser.getTenantSid(), body.getRoleSids());
        Map<Long, List<QueryRoleResultVO>> userInRoleMap = Optional.ofNullable(userInRoleList).orElse(Collections.emptyList()).stream().collect(Collectors.groupingBy(QueryRoleResultVO::getSid));
        List resultList = userInRoleMap.entrySet().stream().map(e -> {
            BatchQueryUserInRoleResultVO resultVO = new BatchQueryUserInRoleResultVO();
            resultVO.setRoleSid(((Long)e.getKey()).longValue());
            resultVO.setUsers(((List)e.getValue()).stream().map(u -> {
                UserSimpleVO user = new UserSimpleVO();
                user.setSid(u.getUserSid().longValue());
                user.setId(u.getUserId());
                user.setName(u.getUserName());
                user.setStatus(u.getUserStatus());
                return user;
            }).collect(Collectors.toList()));
            return resultVO;
        }).collect(Collectors.toList());
        return StdData.ok(resultList);
    }
}

