/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.authentication.AuthenticationInfoVO;
import com.digiwin.dap.middleware.iam.domain.authentication.AuthenticationTenantCallbackVO;
import com.digiwin.dap.middleware.iam.domain.authentication.AuthenticationTwUserInfoVO;
import com.digiwin.dap.middleware.iam.domain.authentication.AuthenticationUserCallbackVO;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.service.authentication.TenantAuthenticationService;
import com.digiwin.dap.middleware.iam.service.authentication.UserAuthenticationService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteLMCService;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.Transactional;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2/authentication"})
public class AuthenticationController {
    private static final Logger logger = LoggerFactory.getLogger(AuthenticationController.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private UserAuthenticationService userAuthenticationService;
    @Autowired
    private TenantAuthenticationService tenantAuthenticationService;
    @Autowired
    private RemoteLMCService remoteLMCService;

    @Transactional(rollbackOn={Exception.class})
    @GetMapping(value={"/user/url"})
    public ResponseEntity<?> getUserAuthenticationUrl(@RequestParam(name="redirectUrl", required=false) String redirectUrl, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Map result;
        if (!Strings.isEmpty((CharSequence)this.envProperties.getEsignUri())) {
            User user;
            if (redirectUrl == null) {
                redirectUrl = this.envProperties.getMarketUri();
            }
            Assert.isTrue((!(user = (User)this.userCrudService.findById(authoredUser.getUserId())).isEnterprise() ? 1 : 0) != 0, (String)String.format("\u7528\u6237[%s]\u662f\u4f01\u4e1a\u7528\u6237\u65e0\u6cd5\u8fdb\u884c\u4e2a\u4eba\u5b9e\u540d\u8ba4\u8bc1\uff01", user.getId()));
            Assert.notNull((Object)user, (String)String.format("\u7528\u6237[%s]\u4e0d\u5b58\u5728\uff01", authoredUser.getUserId()));
            result = this.userAuthenticationService.getUserAuthenticationUrl(user, redirectUrl);
        } else {
            logger.error("e\u7b7e\u5b9d\u5730\u5740\u914d\u7f6e\u4e3a\u7a7a\uff01");
            result = new HashMap();
        }
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @Transactional(rollbackOn={Exception.class})
    @GetMapping(value={"/tenant/url"})
    public ResponseEntity<?> getAuthenticationUrl(@RequestParam(name="redirectUrl", required=false) String redirectUrl, @RequestParam(name="agreeCertificationAgreement", required=false) Boolean agreeCertificationAgreement, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Map result;
        if (!Strings.isEmpty((CharSequence)this.envProperties.getEsignUri())) {
            long tenantSid;
            if (redirectUrl == null) {
                redirectUrl = this.envProperties.getMarketUri();
            }
            Assert.isTrue(((tenantSid = authoredUser.getTenantSid()) > 0L ? 1 : 0) != 0, (String)"\u65e0\u6cd5\u5f97\u5230\u5f53\u524d\u7528\u6237[%s]\u7684\u79df\u6237\u4fe1\u606f\uff01");
            Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
            Assert.notNull((Object)tenant, (String)String.format("\u79df\u6237[%s]\u4e0d\u5b58\u5728\uff01", authoredUser.getTenantId()));
            Assert.isTrue((tenant.getOwnerUserSid() == authoredUser.getSid() ? 1 : 0) != 0, (String)String.format("\u7528\u6237[%s]\u4e0d\u662f\u79df\u6237[%s]\u7684\u521b\u5efa\u8005\uff0c\u65e0\u6cd5\u5bf9\u5176\u8fdb\u884c\u5b9e\u540d\u8ba4\u8bc1\uff01", authoredUser.getUserId(), tenant.getId()));
            User user = (User)this.userCrudService.findBySid(tenant.getOwnerUserSid());
            Assert.notNull((Object)user, (String)String.format("\u79df\u6237[%s]\u7684\u521b\u5efa\u8005[%s]\u4e0d\u5b58\u5728\uff01", tenant.getId(), tenant.getOwnerUserSid()));
            result = this.tenantAuthenticationService.getTenantAuthenticationUrl(user, tenant, redirectUrl);
            if (!Boolean.TRUE.equals(tenant.getAgreeCertificationAgreement()) && Boolean.TRUE.equals(agreeCertificationAgreement)) {
                tenant.setAgreeCertificationAgreement(Boolean.TRUE);
                this.tenantCrudService.update((BaseEntity)tenant);
            }
            this.remoteLMCService.saveAgreeCertificationAgreementChangeLog(tenant, authoredUser, "DigiwinCloud".toLowerCase(), agreeCertificationAgreement);
        } else {
            logger.error("e\u7b7e\u5b9d\u5730\u5740\u914d\u7f6e\u4e3a\u7a7a\uff01");
            result = new HashMap();
        }
        return ResponseEntity.ok(result);
    }

    @Transactional(rollbackOn={Exception.class})
    @PostMapping(value={"/user/callback"})
    public ResponseEntity<?> authenticationRollBack(@RequestBody AuthenticationUserCallbackVO body) {
        if (!Strings.isEmpty((CharSequence)this.envProperties.getEsignUri())) {
            Assert.hasText((String)body.getAccountId(), (String)"AccountId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            Assert.hasText((String)body.getServiceId(), (String)"serviceId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.userAuthenticationService.authenticationCallback(body.getAccountId(), body.getServiceId());
        } else {
            logger.error("e\u7b7e\u5b9d\u5730\u5740\u914d\u7f6e\u4e3a\u7a7a\uff01");
        }
        return new ResponseEntity(HttpStatus.OK);
    }

    @Transactional(rollbackOn={Exception.class})
    @PostMapping(value={"/tenant/callback"})
    public ResponseEntity<?> authenticationRollBack(@RequestBody AuthenticationTenantCallbackVO body) {
        if (!Strings.isEmpty((CharSequence)this.envProperties.getEsignUri())) {
            Assert.hasText((String)body.getServiceId(), (String)"serviceId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            Assert.hasText((String)body.getOrgAccountId(), (String)"OrgAccountId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            Assert.hasText((String)body.getAgentAccountId(), (String)"AgentAccountId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.tenantAuthenticationService.authenticationCallback(body.getOrgAccountId(), body.getAgentAccountId(), body.getServiceId(), null);
        } else {
            logger.error("e\u7b7e\u5b9d\u5730\u5740\u914d\u7f6e\u4e3a\u7a7a\uff01");
        }
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @Transactional(rollbackOn={Exception.class})
    @PostMapping(value={"/user"})
    public ResponseEntity<?> authenticationTwUser(@RequestBody AuthenticationTwUserInfoVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        User user = (User)this.userCrudService.findById(authoredUser.getUserId());
        Assert.isTrue((!user.isEnterprise() ? 1 : 0) != 0, (String)String.format("\u7528\u6237[%s]\u662f\u4f01\u4e1a\u7528\u6237\u65e0\u6cd5\u8fdb\u884c\u4e2a\u4eba\u5b9e\u540d\u8ba4\u8bc1", user.getId()));
        Map result = this.userAuthenticationService.authenticationTwUser(user, body);
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @Transactional(rollbackOn={Exception.class})
    @PostMapping(value={"/tenant/{businessAccountingNo}"})
    public ResponseEntity<?> authenticationTwTenant(@PathVariable String businessAccountingNo, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Map result;
        if (!Strings.isEmpty((CharSequence)this.envProperties.getAoneUri())) {
            Assert.isTrue((authoredUser.getTenantSid() > 0L ? 1 : 0) != 0, (String)"\u65e0\u6cd5\u5f97\u5230\u5f53\u524d\u7528\u6237[%s]\u7684\u79df\u6237\u4fe1\u606f\uff01");
            Tenant tenant = (Tenant)this.tenantCrudService.findBySid(authoredUser.getTenantSid());
            Assert.notNull((Object)tenant, (String)String.format("\u79df\u6237[%s]\u4e0d\u5b58\u5728\uff01", authoredUser.getTenantSid()));
            Assert.isTrue((tenant.getOwnerUserSid() == authoredUser.getSid() ? 1 : 0) != 0, (String)String.format("\u7528\u6237[%s]\u4e0d\u662f\u79df\u6237[%s]\u7684\u521b\u5efa\u8005\uff0c\u65e0\u6cd5\u5bf9\u5176\u8fdb\u884c\u5b9e\u540d\u8ba4\u8bc1\uff01", authoredUser.getUserId(), tenant.getId()));
            result = this.tenantAuthenticationService.authenticationTwTenant(authoredUser.getTenantSid(), tenant.getName(), businessAccountingNo);
        } else {
            logger.error("Aone\u5730\u5740\u914d\u7f6e\u4e3a\u7a7a\uff01");
            result = new HashMap();
        }
        return ResponseEntity.ok(result);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Transactional(rollbackOn={Exception.class})
    @GetMapping(value={"/info"})
    public ResponseEntity<?> getAuthentication(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        AuthenticationInfoVO authenticationInfoVO;
        if (!Strings.isEmpty((CharSequence)this.envProperties.getEsignUri())) {
            Assert.isTrue((authoredUser.getTenantSid() > 0L ? 1 : 0) != 0, (String)"\u65e0\u6cd5\u5f97\u5230\u5f53\u524d\u7528\u6237\u79df\u6237\u4fe1\u606f\uff01");
            User user = (User)this.userCrudService.findBySid(authoredUser.getSid());
            Assert.notNull((Object)user, (String)String.format("\u7528\u6237[%s]\u4e0d\u5b58\u5728\uff01", authoredUser.getUserId()));
            Tenant tenant = (Tenant)this.tenantCrudService.findBySid(authoredUser.getTenantSid());
            Assert.notNull((Object)tenant, (String)String.format("\u79df\u6237[%s]\u4e0d\u5b58\u5728\uff01", authoredUser.getTenantId()));
            if (user.getSid() != tenant.getOwnerUserSid() && !"integration".equals(authoredUser.getUserId())) throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_CREATE_BY_USER_NO_PERMISSION, new Object[]{authoredUser.getUserId(), authoredUser.getTenantId()});
            authenticationInfoVO = this.tenantAuthenticationService.getAuthenticationInfo(authoredUser.getTenantSid());
            return new ResponseEntity((Object)authenticationInfoVO, HttpStatus.OK);
        } else {
            logger.error("e\u7b7e\u5b9d\u5730\u5740\u914d\u7f6e\u4e3a\u7a7a\uff01");
            authenticationInfoVO = new AuthenticationInfoVO();
        }
        return new ResponseEntity((Object)authenticationInfoVO, HttpStatus.OK);
    }

    @Transactional(rollbackOn={Exception.class})
    @PostMapping(value={"/tenant/remove"})
    public ResponseEntity<?> removeAuthentication(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (!Strings.isEmpty((CharSequence)this.envProperties.getEsignUri())) {
            Tenant tenant = (Tenant)this.tenantCrudService.findBySid(authoredUser.getTenantSid());
            Assert.isTrue((authoredUser.getTenantSid() > 0L ? 1 : 0) != 0, (String)"\u65e0\u6cd5\u5f97\u5230\u5f53\u524d\u7528\u6237\u79df\u6237\u4fe1\u606f\uff01");
            User user = (User)this.userCrudService.findBySid(authoredUser.getSid());
            Assert.notNull((Object)user, (String)String.format("\u7528\u6237[%s]\u4e0d\u5b58\u5728\uff01", authoredUser.getUserId()));
            Assert.notNull((Object)tenant, (String)String.format("\u79df\u6237[%s]\u4e0d\u5b58\u5728\uff01", authoredUser.getTenantId()));
            Assert.isTrue((user.getSid() == tenant.getOwnerUserSid() ? 1 : 0) != 0, (String)"\u7528\u6237[%s]\u4e0d\u662f\u79df\u6237[%s]\u7684\u521b\u5efa\u8005\uff0c\u65e0\u6cd5\u6e05\u9664\u4f01\u4e1a\u5b9e\u540d\u8ba4\u8bc1\u4fe1\u606f\uff01");
            this.tenantAuthenticationService.removeAuthenticationInfo(authoredUser.getTenantSid(), user.getSid());
        } else {
            logger.error("e\u7b7e\u5b9d\u5730\u5740\u914d\u7f6e\u4e3a\u7a7a\uff01");
        }
        return new ResponseEntity(HttpStatus.OK);
    }
}

