/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import cn.hutool.captcha.CaptchaUtil;
import cn.hutool.captcha.LineCaptcha;
import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.iam.domain.login.ImageCode;
import com.digiwin.dap.middleware.iam.domain.login.LoginUser;
import com.digiwin.dap.middleware.util.SnowFlake;
import com.digiwin.dap.middleware.util.UserUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.time.Duration;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2/captcha"})
public class CaptchaController {
    @PostMapping(value={"/image"})
    public StdData<ImageCode> getCaptchaImage(@RequestBody LoginUser loginUser, HttpServletResponse response) {
        Assert.hasText((String)loginUser.getUserId(), (String)"userId is null");
        LineCaptcha lineCaptcha = CaptchaUtil.createLineCaptcha((int)260, (int)100, (int)4, (int)50);
        String code = lineCaptcha.getCode();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        lineCaptcha.write((OutputStream)stream);
        String imageStr = Base64.encodeBase64String((byte[])stream.toByteArray());
        ImageCode imageCode = new ImageCode(Long.valueOf(SnowFlake.getInstance().newId()), imageStr, code, 5);
        String redisKey = String.format("iam:failure:login:app:user:image:%s:%s:%s", UserUtils.getSysId(), loginUser.getUserId(), imageCode.getSid()).toLowerCase();
        if (!RedisUtils.hasKey((String)redisKey)) {
            RedisUtils.set((String)redisKey, (Object)imageCode, (Duration)Duration.ofSeconds(300L));
        }
        return StdData.ok((Object)imageCode);
    }
}

