/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.tenant.ImportExcelResultVO;
import com.digiwin.dap.middleware.iam.domain.tenant.UserInTenantDTO;
import com.digiwin.dap.middleware.iam.domain.tenant.UserInTenantVO;
import com.digiwin.dap.middleware.iam.mapper.PermissionMapper;
import com.digiwin.dap.middleware.iam.mapper.UserInTenantMapper;
import com.digiwin.dap.middleware.iam.service.card.CardInfoCrudService;
import com.digiwin.dap.middleware.iam.support.excel.IExcelService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEocService;
import com.digiwin.dap.middleware.iam.support.remote.domain.EmpInfoVO;
import com.digiwin.dap.middleware.util.UserUtils;
import com.github.pagehelper.PageSerializable;
import com.github.pagehelper.page.PageMethod;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2/card"})
public class CardController {
    private static final Logger logger = LoggerFactory.getLogger(CardController.class);
    @Autowired
    private UserInTenantMapper userInTenantMapper;
    @Autowired
    private PermissionMapper permissionMapper;
    @Autowired
    private RemoteEocService remoteEocService;
    @Autowired
    private CardInfoCrudService cardInfoCrudService;
    @Autowired
    private IExcelService excelService;

    @PostMapping(value={"/add"})
    public StdData<?> addCard(@RequestBody UserInTenantVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        body.setCardId(UUID.randomUUID().toString());
        body.setCardType("rfid");
        body.setTenantSid(Long.valueOf(authoredUser.getTenantSid()));
        body.setTenantId(authoredUser.getTenantId());
        body.setTenantName(authoredUser.getTenantName());
        this.cardInfoCrudService.bind(body);
        return StdData.ok((Object)body);
    }

    @PostMapping(value={"/del"})
    public StdData<?> delCard(@RequestBody UserInTenantVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        body.setCardType("rfid");
        body.setTenantId(authoredUser.getTenantId());
        this.cardInfoCrudService.unbind(body);
        return StdData.ok((Object)body);
    }

    @PostMapping(value={"/mod"})
    public StdData<?> modCard(@RequestBody UserInTenantVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        body.setCardType("rfid");
        body.setTenantSid(Long.valueOf(authoredUser.getTenantSid()));
        body.setTenantId(authoredUser.getTenantId());
        body.setTenantName(authoredUser.getTenantName());
        this.cardInfoCrudService.bindForce(body);
        return StdData.ok((Object)body);
    }

    @PostMapping(value={"/find"})
    public StdData<?> findCard(@RequestBody UserInTenantDTO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        List roles = this.permissionMapper.findUserRoles(authoredUser.getTenantSid(), authoredUser.getSid());
        boolean admin = roles.stream().anyMatch(o -> "superadmin".equals(o.getId()));
        if (!admin) {
            throw new BusinessException((ErrorHandler)I18nError.PERMISSION_DENIED);
        }
        List userInTenantInfos = this.userInTenantMapper.getUserInTenantInfo(body.getPageNum(), body.getPageSize(), authoredUser.getTenantSid(), body.getUserId(), body.getCardId());
        PageSerializable pageInfo = new PageSerializable(userInTenantInfos);
        return StdData.ok((Object)pageInfo);
    }

    @PostMapping(value={"/bind/find"})
    public StdData<?> findCardWithBind(@RequestBody UserInTenantDTO body) {
        List roles = this.permissionMapper.findUserRoles(UserUtils.getTenantSid(), UserUtils.getUserSid());
        boolean admin = roles.stream().anyMatch(o -> "superadmin".equals(o.getId()));
        if (!admin) {
            throw new BusinessException((ErrorHandler)I18nError.PERMISSION_DENIED);
        }
        body.setTenantSid(Long.valueOf(UserUtils.getTenantSid()));
        PageMethod.startPage((int)body.getPageNum(), (int)body.getPageSize());
        List userInTenantInfos = this.userInTenantMapper.getUserInTenantInfoWithCard(body);
        PageSerializable pageInfo = new PageSerializable(userInTenantInfos);
        return StdData.ok((Object)pageInfo);
    }

    @PostMapping(value={"/bind"})
    public StdData<?> bindCard(@RequestBody UserInTenantVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        body.setTenantSid(Long.valueOf(authoredUser.getTenantSid()));
        body.setTenantId(authoredUser.getTenantId());
        body.setTenantName(authoredUser.getTenantName());
        this.cardInfoCrudService.bind(body);
        return StdData.ok((Object)body);
    }

    @PostMapping(value={"/unbind"})
    public StdData<?> unbindCard(@RequestBody UserInTenantVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        body.setTenantId(authoredUser.getTenantId());
        this.cardInfoCrudService.unbind(body);
        return StdData.ok((Object)body);
    }

    @PostMapping(value={"/unbind/batch"})
    public StdData<?> batchUnbindCard(@RequestBody List<UserInTenantVO> body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        for (UserInTenantVO vo : body) {
            vo.setTenantId(authoredUser.getTenantId());
            this.cardInfoCrudService.unbind(vo);
        }
        return StdData.ok(body);
    }

    @PostMapping(value={"/info"})
    public StdData<?> getCardInfo(@RequestBody UserInTenantVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        body.setTenantId(authoredUser.getTenantId());
        this.cardInfoCrudService.info(body);
        try {
            EmpInfoVO empInfo = this.remoteEocService.getEmpByUserId(body.getUserId(), Boolean.valueOf(true));
            body.setEocId(empInfo.getId());
            body.setEocName(empInfo.getName());
        }
        catch (Exception e) {
            logger.error(String.format("\u7528\u6237%s\u83b7\u53d6\u5458\u5de5\u4fe1\u606f", body.getUserId()), (Throwable)e);
        }
        return StdData.ok((Object)body);
    }

    @GetMapping(value={"/export"})
    public StdData<?> exportCard() {
        UserInTenantVO body = new UserInTenantVO();
        body.setTenantSid(Long.valueOf(UserUtils.getTenantSid()));
        return StdData.ok((Object)this.excelService.exportCard(body));
    }

    @PostMapping(value={"/import/{fileId}"})
    public ResponseEntity<ImportExcelResultVO> importUserMapping(@PathVariable String fileId) {
        return ResponseEntity.ok((Object)this.excelService.importCard(fileId));
    }
}

