/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.constant.IamConstants;
import com.digiwin.dap.middleware.iam.constant.enums.SsoTypeEnum;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.cache.UserTempTokenCacheVO;
import com.digiwin.dap.middleware.iam.domain.tenant.metadata.TenantMetadataCasVO;
import com.digiwin.dap.middleware.iam.domain.usermapping.UserMappingQueryResultVO;
import com.digiwin.dap.middleware.iam.entity.SysSsoUrlConfig;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.service.sso.SysSsoUrlConfigCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.tenantmetadata.TenantMetadataCrudService;
import com.digiwin.dap.middleware.iam.service.usermapping.UserMappingService;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@RestController
@RequestMapping(value={"/api/iam/v2/cas"})
public class CasController {
    private static final Logger logger = LoggerFactory.getLogger(CasController.class);
    @Autowired
    private TenantMetadataCrudService tenantMetadataCrudService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private SysSsoUrlConfigCrudService sysSsoUrlConfigCrudService;
    @Autowired
    private UserMappingService userMappingService;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;

    @GetMapping(value={"/login"})
    public void login(@RequestParam(value="tenantId", required=false) String tenantId, @RequestParam(value="sysId", required=false) String sysId, HttpServletRequest request, HttpServletResponse response) {
        SysSsoUrlConfig sysSsoUrlConfig;
        try {
            if (!StringUtils.hasText((String)tenantId) || !StringUtils.hasText((String)sysId)) {
                throw new BusinessException((ErrorHandler)I18nError.PARAM_ERROR);
            }
            sysSsoUrlConfig = this.sysSsoUrlConfigCrudService.findBySysIdAndSsoType(sysId, SsoTypeEnum.CAS.getCode());
            if (Objects.isNull(sysSsoUrlConfig)) {
                throw new BusinessException((ErrorHandler)I18nError.IAM_CAS_SYS_NOT_EXIST);
            }
        }
        catch (Exception e) {
            logger.error("\u3010cas\u3011 \u767b\u5f55\u5f02\u5e38", (Throwable)e);
            this.sendResponse(response, e.getMessage());
            return;
        }
        try {
            TenantMetadataCasVO casVO = this.getTenantMetadataCasVO(tenantId);
            String ssoUrl = casVO.getSsoUrl();
            String iamUrl = this.envProperties.getIamUri();
            String consumerUrl = String.format("%s/api/iam/v2/cas/consumer/%s/%s", iamUrl, tenantId, sysId);
            String redirectUrl = String.format("%s?service=%s", ssoUrl, URLEncoder.encode(consumerUrl, "UTF-8"));
            this.redirect(response, redirectUrl);
        }
        catch (BusinessException e) {
            logger.error("\u3010cas\u3011 \u767b\u5f55\u5f02\u5e38", (Throwable)e);
            this.redirect(response, this.getFailCallbackUrl(sysSsoUrlConfig.getFailCallbackUrl(), e.getMessage()));
        }
        catch (Exception e) {
            logger.error("\u3010cas\u3011 \u767b\u5f55\u5f02\u5e38", (Throwable)e);
            this.redirect(response, this.getFailCallbackUrl(sysSsoUrlConfig.getFailCallbackUrl(), "\u7cfb\u7edf\u5f02\u5e38"));
        }
    }

    @GetMapping(value={"/logout"})
    public void logout(@RequestParam(value="tenantId", required=false) String tenantId, @RequestParam(value="sysId", required=false) String sysId, HttpServletRequest request, HttpServletResponse response) {
        SysSsoUrlConfig sysSsoUrlConfig;
        try {
            if (!StringUtils.hasText((String)tenantId) || !StringUtils.hasText((String)sysId)) {
                throw new BusinessException((ErrorHandler)I18nError.PARAM_ERROR);
            }
            sysSsoUrlConfig = this.sysSsoUrlConfigCrudService.findBySysIdAndSsoType(sysId, SsoTypeEnum.CAS.getCode());
            if (Objects.isNull(sysSsoUrlConfig)) {
                throw new BusinessException((ErrorHandler)I18nError.IAM_CAS_SYS_NOT_EXIST);
            }
        }
        catch (Exception e) {
            logger.error("\u3010cas\u3011 \u767b\u51fa\u5f02\u5e38", (Throwable)e);
            this.sendResponse(response, e.getMessage());
            return;
        }
        try {
            TenantMetadataCasVO casVO = this.getTenantMetadataCasVO(tenantId);
            if (!StringUtils.hasText((String)casVO.getLogoutUrl())) {
                this.redirect(response, sysSsoUrlConfig.getLogoutCallbackUrl());
                return;
            }
            String logoutUrl = casVO.getLogoutUrl();
            String iamUrl = this.envProperties.getIamUri();
            String consumerUrl = String.format("%s/api/iam/v2/cas/consumer/%s/%s", iamUrl, tenantId, sysId);
            String redirectUrl = String.format("%s?service=%s", logoutUrl, URLEncoder.encode(consumerUrl, "UTF-8"));
            this.redirect(response, redirectUrl);
        }
        catch (BusinessException e) {
            logger.error("\u3010cas\u3011 \u767b\u5f55\u5f02\u5e38", (Throwable)e);
            this.redirect(response, this.getFailCallbackUrl(sysSsoUrlConfig.getFailCallbackUrl(), e.getMessage()));
        }
        catch (Exception e) {
            logger.error("\u3010cas\u3011 \u767b\u5f55\u5f02\u5e38", (Throwable)e);
            this.redirect(response, this.getFailCallbackUrl(sysSsoUrlConfig.getFailCallbackUrl(), "\u7cfb\u7edf\u5f02\u5e38"));
        }
    }

    @RequestMapping(value={"/consumer/{tenantId:.+}/{sysId}"})
    public void consumer(@PathVariable(value="tenantId") String tenantId, @PathVariable(value="sysId") String sysId, @RequestParam(value="ticket", required=false) String ticket, HttpServletResponse response) {
        SysSsoUrlConfig sysSsoUrlConfig;
        try {
            sysSsoUrlConfig = this.sysSsoUrlConfigCrudService.findBySysIdAndSsoType(sysId, SsoTypeEnum.CAS.getCode());
            if (Objects.isNull(sysSsoUrlConfig)) {
                throw new BusinessException((ErrorHandler)I18nError.IAM_CAS_SYS_NOT_EXIST);
            }
        }
        catch (Exception e) {
            logger.error("\u3010cas\u3011 \u767b\u5f55\u5f02\u5e38", (Throwable)e);
            this.sendResponse(response, e.getMessage());
            return;
        }
        try {
            String verifyUserId;
            String iamUrl;
            String consumerUrl;
            if (!StringUtils.hasText((String)ticket)) {
                String logoutCallbackUrl = sysSsoUrlConfig.getLogoutCallbackUrl();
                this.redirect(response, logoutCallbackUrl);
                return;
            }
            Tenant tenant = (Tenant)this.tenantCrudService.findById(tenantId);
            if (Objects.isNull(tenant)) {
                throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{tenantId});
            }
            List tenantMetadataVOList = this.tenantMetadataCrudService.getTenantMetadataValue(tenant.getSid(), "cas", IamConstants.CAS_KEY_LIST);
            TenantMetadataCasVO casVO = new TenantMetadataCasVO(tenantMetadataVOList);
            String validateUrl = casVO.getValidateUrl();
            String validTicketUrl = String.format("%s?service=%s&ticket=%s", validateUrl, consumerUrl = String.format("%s/api/iam/v2/cas/consumer/%s/%s", iamUrl = this.envProperties.getIamUri(), tenantId, sysId), ticket);
            ResponseEntity responseEntity = this.restTemplate.getForEntity(validTicketUrl, String.class, new Object[0]);
            if (!responseEntity.getStatusCode().is2xxSuccessful()) {
                throw new BusinessException((ErrorHandler)I18nError.IAM_CAS_SERVER_VALIDATE_ERROR);
            }
            String casResult = (String)responseEntity.getBody();
            if (!StringUtils.hasText((String)casResult)) {
                throw new BusinessException((ErrorHandler)I18nError.IAM_CAS_SERVER_VALIDATE_ERROR);
            }
            logger.info("\u3010cas\u3011 tenantId:{},sysId:{},casResult:{}", new Object[]{tenantId, sysId, casResult});
            if (casResult.startsWith("<")) {
                XPathExpression userExpression;
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.parse(new InputSource(new StringReader(casResult)));
                XPathFactory xPathFactory = XPathFactory.newInstance();
                XPath xPath = xPathFactory.newXPath();
                XPathExpression failureExpression = xPath.compile("/serviceResponse/authenticationFailure");
                NodeList nodes = (NodeList)failureExpression.evaluate(document, XPathConstants.NODESET);
                if (nodes != null && nodes.getLength() > 0) {
                    throw new BusinessException((ErrorHandler)I18nError.IAM_CAS_SERVER_VALIDATE_ERROR);
                }
                if ("user".equals(casVO.getUserId())) {
                    userExpression = xPath.compile("/serviceResponse/authenticationSuccess/user");
                } else if (casVO.getUserId().startsWith("attribute.")) {
                    String attributeName = casVO.getUserId().substring(9);
                    userExpression = xPath.compile("/serviceResponse/authenticationSuccess/attributes/" + attributeName);
                } else {
                    throw new BusinessException((ErrorHandler)I18nError.IAM_USER_ID_MAPPING_ATTRIBUTE_NOT_EXIST);
                }
                verifyUserId = (String)userExpression.evaluate(document, XPathConstants.STRING);
            } else {
                if (casResult.startsWith("no")) {
                    throw new BusinessException((ErrorHandler)I18nError.IAM_CAS_SERVER_VALIDATE_ERROR);
                }
                String[] splitArr = casResult.split("\n");
                if (splitArr.length != 2) {
                    throw new BusinessException((ErrorHandler)I18nError.IAM_CAS_SERVER_VALIDATE_ERROR);
                }
                verifyUserId = splitArr[1];
            }
            logger.info("\u3010cas\u3011 tenantId:{},sysId:{},verifyUserId:{}", new Object[]{tenantId, sysId, verifyUserId});
            if (Objects.isNull(verifyUserId)) {
                throw new BusinessException((ErrorHandler)I18nError.IAM_USER_ID_MAPPING_ATTRIBUTE_NOT_EXIST);
            }
            UserMappingQueryResultVO userMappingInfo = this.userMappingService.getUserByMapping(Long.valueOf(tenant.getSid()), casVO.getMappingAppId(), null, verifyUserId);
            if (Objects.isNull(userMappingInfo)) {
                logger.error("\u3010cas\u3011 \u5f52\u6237\u4fe1\u606f\u4e0d\u5b58\u5728,verifyUserId:{},tenantId:{},mappingAppId:{}", new Object[]{verifyUserId, tenant.getId(), casVO.getMappingAppId()});
                throw new BusinessException((ErrorHandler)I18nError.IAM_USER_MAPPING_NOT_EXIST);
            }
            UserTempTokenCacheVO cacheVO = new UserTempTokenCacheVO();
            cacheVO.setValue(String.join((CharSequence)":_", userMappingInfo.getUserId(), tenantId, sysId));
            cacheVO.setCreateTime(Long.valueOf(System.currentTimeMillis()));
            String casToken = UUID.randomUUID().toString().toLowerCase();
            String casTokenKey = String.format("iam:sso:token:%s:%s", "cas", casToken);
            RedisUtils.set((String)casTokenKey, (Object)cacheVO, (Duration)Duration.ofMinutes(3L));
            this.redirect(response, this.getSuccessCallbackUrl(sysSsoUrlConfig.getSuccessCallbackUrl(), casToken));
        }
        catch (BusinessException e) {
            logger.error("\u3010cas\u3011 \u6d88\u8d39\u65ad\u8a00\u5f02\u5e38", (Throwable)e);
            this.redirect(response, this.getFailCallbackUrl(sysSsoUrlConfig.getFailCallbackUrl(), e.getMessage()));
        }
        catch (Exception e) {
            logger.error("\u3010cas\u3011 \u6d88\u8d39\u65ad\u8a00\u5f02\u5e38", (Throwable)e);
            this.redirect(response, this.getFailCallbackUrl(sysSsoUrlConfig.getFailCallbackUrl(), "\u7cfb\u7edf\u5f02\u5e38"));
        }
    }

    @GetMapping(value={"/service/metadata"})
    public StdData<String> getServiceMetadata(@RequestParam(value="sysId", required=false) String sysId, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (!StringUtils.hasText((String)sysId)) {
            throw new BusinessException((ErrorHandler)I18nError.PARAM_ERROR);
        }
        String serviceUrl = String.format("%s/api/iam/v2/cas/consumer/%s/%s", this.envProperties.getIamUri(), authoredUser.getTenantId(), sysId);
        return StdData.ok((Object)serviceUrl);
    }

    private String getFailCallbackUrl(String failCallbackUrl, String errorMsg) {
        String joinFlag = failCallbackUrl.contains("?") ? "&" : "?";
        return failCallbackUrl + joinFlag + "errormsg=" + this.urlEncode(errorMsg);
    }

    private String getSuccessCallbackUrl(String successCallbackUrl, String code) {
        String joinFlag = successCallbackUrl.contains("?") ? "&" : "?";
        return successCallbackUrl + joinFlag + "code=" + code;
    }

    private String urlEncode(String msg) {
        try {
            return URLEncoder.encode(msg, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u3010cas\u3011 urlEncode\u5f02\u5e38", (Throwable)e);
            return msg;
        }
    }

    private TenantMetadataCasVO getTenantMetadataCasVO(String tenantId) {
        Tenant tenant = (Tenant)this.tenantCrudService.findById(tenantId);
        if (Objects.isNull(tenant)) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{tenantId});
        }
        List tenantMetadataVOList = this.tenantMetadataCrudService.getTenantMetadataValue(tenant.getSid(), "cas", IamConstants.CAS_KEY_LIST);
        return new TenantMetadataCasVO(tenantMetadataVOList);
    }

    private void redirect(HttpServletResponse response, String url) {
        try {
            response.sendRedirect(url);
        }
        catch (IOException ex) {
            logger.error("\u3010cas\u3011 \u8df3\u8f6c\u5931\u8d25\u9875\u9762\u5f02\u5e38", (Throwable)ex);
        }
    }

    private void sendResponse(HttpServletResponse response, String message) {
        try {
            response.reset();
            response.setCharacterEncoding("UTF-8");
            response.setContentType("text/plain; charset=UTF-8");
            PrintWriter printWriter = response.getWriter();
            printWriter.write(message);
            printWriter.flush();
            printWriter.close();
        }
        catch (Exception ex) {
            logger.error("\u3010cas\u3011 \u8fd4\u56de\u9519\u8bef\u4fe1\u606f\u5f02\u5e38", (Throwable)ex);
        }
    }
}

