/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import com.digiwin.dap.middleware.exception.OperateException;
import com.digiwin.dap.middleware.iam.api.base.AppBaseController;
import com.digiwin.dap.middleware.iam.domain.app.ConditionQueryResultVO;
import com.digiwin.dap.middleware.iam.domain.app.ConditionVO;
import com.digiwin.dap.middleware.iam.service.app.ActionCrudService;
import com.digiwin.dap.middleware.iam.service.app.ConditionCrudService;
import com.digiwin.dap.middleware.iam.service.app.ConditionQueryService;
import com.digiwin.dap.middleware.iam.service.app.ConditionService;
import com.digiwin.dap.middleware.iam.service.app.ModuleCrudService;
import com.digiwin.dap.middleware.iam.service.sys.SysCrudService;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2/app"})
public class ConditionController
extends AppBaseController {
    private static ObjectMapper objectMapper = JsonUtils.createObjectMapper();
    @Autowired
    private SysCrudService sysCrudService;
    @Autowired
    private ModuleCrudService moduleCrudService;
    @Autowired
    private ActionCrudService actionCrudService;
    @Autowired
    private ConditionCrudService conditionCrudService;
    @Autowired
    private ConditionQueryService conditionQueryService;
    @Autowired
    private ConditionService conditionService;

    @PostMapping(value={"/condition"})
    public ResponseEntity<?> getCondition(@RequestBody ConditionVO conditionVO) {
        long conditionSid = conditionVO.getSid();
        if (conditionSid == 0L) {
            long actionSid = conditionVO.getActionSid();
            if (actionSid == 0L) {
                long appSid = this.getAppSid(this.sysCrudService, conditionVO.getAppSid(), conditionVO.getAppId());
                long moduleSid = this.getModuleSid(this.moduleCrudService, appSid, conditionVO.getModuleSid(), conditionVO.getModuleId());
                actionSid = this.getActionSid(this.actionCrudService, 0L, moduleSid, conditionVO.getActionSid(), conditionVO.getActionId());
            }
            conditionSid = this.getConditionSid(actionSid, conditionVO.getSid(), conditionVO.getKey());
        }
        ConditionQueryResultVO conditionQueryResultVO = this.conditionQueryService.getConditionQueryResultVOBySid(conditionSid);
        String typeParameter = conditionQueryResultVO.getParameter();
        try {
            if (typeParameter != null) {
                conditionQueryResultVO.setTypeParameter((List)objectMapper.readValue(typeParameter, List.class));
            }
        }
        catch (IOException e) {
            throw new OperateException((Throwable)e);
        }
        return ResponseEntity.ok((Object)conditionQueryResultVO);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/condition/update"})
    public ResponseEntity<?> updateCondition(@RequestBody ConditionVO conditionVO) {
        long actionSid = conditionVO.getActionSid();
        if (actionSid == 0L) {
            long appSid = this.getAppSid(this.sysCrudService, conditionVO.getAppSid(), conditionVO.getAppId());
            conditionVO.setAppSid(appSid);
            long moduleSid = this.getModuleSid(this.moduleCrudService, appSid, conditionVO.getModuleSid(), conditionVO.getModuleId());
            conditionVO.setModuleSid(moduleSid);
            actionSid = this.getActionSid(this.actionCrudService, 0L, moduleSid, conditionVO.getActionSid(), conditionVO.getActionId());
        }
        conditionVO.setActionSid(actionSid);
        long oldConditionSid = this.conditionCrudService.getSidByUnionKey(new Object[]{conditionVO.getKey(), conditionVO.getActionSid()});
        if (oldConditionSid == 0L) {
            long conditionSid = this.conditionService.addCondition(conditionVO);
            return ResponseEntity.ok((Object)conditionSid);
        }
        this.conditionService.modifyCondition(conditionVO);
        return ResponseEntity.ok((Object)oldConditionSid);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/condition/remove"})
    public void deleteCondition(@RequestBody ConditionVO conditionVO) {
        long conditionSid = conditionVO.getSid();
        if (conditionSid == 0L) {
            long actionSid = conditionVO.getActionSid();
            if (actionSid == 0L) {
                long appSid = this.getAppSid(this.sysCrudService, conditionVO.getAppSid(), conditionVO.getAppId());
                long moduleSid = this.getModuleSid(this.moduleCrudService, appSid, conditionVO.getModuleSid(), conditionVO.getModuleId());
                actionSid = this.getActionSid(this.actionCrudService, 0L, moduleSid, conditionVO.getActionSid(), conditionVO.getActionId());
            }
            conditionSid = this.getConditionSid(actionSid, conditionVO.getSid(), conditionVO.getKey());
        }
        this.conditionCrudService.deleteById(conditionSid);
    }

    private long getConditionSid(long actionSid, long conditionSid, String key) {
        if (conditionSid > 0L) {
            return conditionSid;
        }
        long sid = 0L;
        if (key != null) {
            sid = this.conditionCrudService.getSidByUnionKey(new Object[]{key, actionSid});
        }
        return sid;
    }
}

