/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.iam.domain.datapolicy.DataPolicyVO;
import com.digiwin.dap.middleware.iam.domain.datapolicy.DeleteSysDataPolicyRequest;
import com.digiwin.dap.middleware.iam.domain.datapolicy.PolicyIdentifierEnum;
import com.digiwin.dap.middleware.iam.domain.permission.DataPermission;
import com.digiwin.dap.middleware.iam.domain.permission.PermissionDataDTO;
import com.digiwin.dap.middleware.iam.entity.DataPolicy;
import com.digiwin.dap.middleware.iam.service.datapolicy.DataPolicyService;
import com.digiwin.dap.middleware.iam.service.datapolicy.DataStatementCrudService;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/api/iam/v2/datapolicy"})
public class DataPolicyController {
    @Autowired
    private DataPolicyService dataPolicyService;
    @Autowired
    private DataStatementCrudService dataStatementCrudService;

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/data"}, produces={"application/json; charset=utf-8"})
    public ResponseEntity<?> updatePolicyData(@RequestBody @Valid DataPolicyVO input, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Assert.isTrue((authoredUser.getTenantSid() > 0L ? 1 : 0) != 0, (String)String.format("\u65e0\u6cd5\u5f97\u5230\u5f53\u524d\u7528\u6237[%s]\u7684\u79df\u6237\u4fe1\u606f\uff01", authoredUser.getUserId()));
        this.dataPolicyService.updateDataPolicy(authoredUser.getTenantSid(), input);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @DeleteMapping(value={"/data"}, produces={"application/json; charset=utf-8"})
    public ResponseEntity<?> deleteDataPolicy(@NotBlank @RequestParam String type, @NotNull @RequestParam Long targetSid, @NotNull @RequestParam Long sysSid, @NotNull @RequestParam Long actionSid, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        DataPolicy dataPolicy = this.dataPolicyService.getDataPolicy(authoredUser.getTenantSid(), type, targetSid.longValue(), sysSid.longValue());
        if (dataPolicy != null) {
            this.dataStatementCrudService.deleteByUnionKey(new Object[]{dataPolicy.getSid(), actionSid});
        }
        return new ResponseEntity(HttpStatus.OK);
    }

    @PostMapping(value={"/sys/del"})
    public StdData<?> deleteSysDataPolicy(@RequestBody DeleteSysDataPolicyRequest request, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        this.dataPolicyService.deleteSysDataPolicy(Long.valueOf(authoredUser.getTenantSid()), request.getType(), request.getTargetSid(), request.getSysSid());
        return StdData.ok().build();
    }

    @GetMapping(value={"/data"}, produces={"application/json; charset=utf-8"})
    public ResponseEntity<?> getDataPolicy(@NotBlank @RequestParam String type, @NotNull @RequestParam Long targetSid, @NotNull @RequestParam Long sysSid, @NotNull @RequestParam Long actionSid, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        DataPermission map = this.dataPolicyService.getDataPolicy(authoredUser.getTenantSid(), type, targetSid.longValue(), sysSid.longValue(), actionSid.longValue(), Boolean.valueOf(false));
        return ResponseEntity.ok((Object)map);
    }

    @PostMapping(value={"/dev/data"}, produces={"application/json; charset=utf-8"})
    public StdData updateDataPolicyForDev(@RequestBody @Valid PermissionDataDTO dataPolicyDTO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        this.dataPolicyService.updateDataPolicyForDev(authoredUser.getTenantSid(), dataPolicyDTO);
        return StdData.ok().build();
    }

    @GetMapping(value={"/identifier"})
    public StdData getDataPolicyIdentifierList() {
        List identifiers = Arrays.asList(PolicyIdentifierEnum.values()).stream().map(PolicyIdentifierEnum::getCode).collect(Collectors.toList());
        return StdData.ok(identifiers);
    }
}

