/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.constant.enums.RegexRuleEnum;
import com.digiwin.dap.middleware.iam.domain.BaseVO;
import com.digiwin.dap.middleware.iam.domain.auth.AuthDataDO;
import com.digiwin.dap.middleware.iam.domain.dev.AppSecretVO;
import com.digiwin.dap.middleware.iam.domain.dev.DeleteCheckDTO;
import com.digiwin.dap.middleware.iam.domain.dev.DevActionQueryResultVO;
import com.digiwin.dap.middleware.iam.domain.dev.DevActionVO;
import com.digiwin.dap.middleware.iam.domain.dev.DevAppCond;
import com.digiwin.dap.middleware.iam.domain.dev.DevAppVO;
import com.digiwin.dap.middleware.iam.domain.dev.DevModuleVO;
import com.digiwin.dap.middleware.iam.domain.dev.DevSysDTO;
import com.digiwin.dap.middleware.iam.domain.dev.DevSysInfoVO;
import com.digiwin.dap.middleware.iam.domain.dev.DevSysSyncVO;
import com.digiwin.dap.middleware.iam.domain.dev.DevSysVO;
import com.digiwin.dap.middleware.iam.domain.dev.DevSysVO3;
import com.digiwin.dap.middleware.iam.domain.dev.DevelopApp;
import com.digiwin.dap.middleware.iam.domain.dev.DevelopAppImportInfo;
import com.digiwin.dap.middleware.iam.domain.dev.DevelopSys;
import com.digiwin.dap.middleware.iam.domain.enumeration.ChangeTypeEnum;
import com.digiwin.dap.middleware.iam.domain.org.RequestParameterVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantBasicInfoVO;
import com.digiwin.dap.middleware.iam.entity.DevSys;
import com.digiwin.dap.middleware.iam.mapper.DevSysMapper;
import com.digiwin.dap.middleware.iam.repository.DevSysRepository;
import com.digiwin.dap.middleware.iam.service.WhiteListService;
import com.digiwin.dap.middleware.iam.service.dev.app.DevActionQueryService;
import com.digiwin.dap.middleware.iam.service.dev.app.DevActionService;
import com.digiwin.dap.middleware.iam.service.dev.app.DevModuleQueryService;
import com.digiwin.dap.middleware.iam.service.dev.app.DevModuleService;
import com.digiwin.dap.middleware.iam.service.dev.sys.DevSysCrudService;
import com.digiwin.dap.middleware.iam.service.dev.sys.DevSysService;
import com.digiwin.dap.middleware.iam.support.log.ChangeLogService;
import com.digiwin.dap.middleware.iam.support.validate.AuthValidateService;
import com.digiwin.dap.middleware.util.AssertUtils;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import com.github.pagehelper.PageSerializable;
import com.github.pagehelper.page.PageMethod;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2"})
public class DevSysController {
    @Autowired
    private DevSysService devSysService;
    @Autowired
    private DevSysRepository devSysRepository;
    @Autowired
    private DevSysMapper devSysMapper;
    @Autowired
    private DevModuleService devModuleService;
    @Autowired
    private DevActionService devActionService;
    @Autowired
    private DevModuleQueryService devModuleQueryService;
    @Autowired
    private DevActionQueryService devActionQueryService;
    @Autowired
    private DevSysCrudService devSysCrudService;
    @Autowired
    private WhiteListService whiteListService;
    @Autowired
    private ChangeLogService changeLogService;
    @Autowired
    private AuthValidateService authValidateService;

    @PostMapping(value={"/dev/app"})
    public StdData saveDevSys(@RequestBody DevSysDTO dto, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Assert.isTrue((authoredUser.getTenantSid() != 0L ? 1 : 0) != 0, (String)"\u79df\u6237Sid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)dto.getId(), (String)"\u5e94\u7528Id\u4e0d\u80fd\u4e3a\u7a7a");
        RegexRuleEnum.REGEX_APP_ID.check(dto.getId());
        if (!dto.getNonDev().booleanValue()) {
            Assert.hasText((String)dto.getLogoImageUrl(), (String)"LOGO\u56fe\u7247\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.notNull((Object)dto.getSysType(), (String)"\u5e94\u7528\u4f7f\u7528\u4e8e\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.notNull((Object)dto.getDevPlatform(), (String)"\u5f00\u53d1\u5e73\u53f0\u4e0d\u80fd\u4e3a\u7a7a");
            dto.setTenantSid(Long.valueOf(authoredUser.getTenantSid()));
            if (StringUtils.isEmpty((Object)dto.getTenantId())) {
                dto.setTenantId(authoredUser.getTenantId());
            }
            if (StringUtils.isEmpty((Object)dto.getTenantName())) {
                dto.setTenantName(authoredUser.getTenantName());
            }
        } else if (StringUtils.isEmpty((Object)dto.getTenantId()) || StringUtils.isEmpty((Object)dto.getTenantName())) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_INFO_EMPTY);
        }
        if (dto.isLandingApp()) {
            if (!dto.getId().startsWith(String.format("%s_", authoredUser.getTenantId()))) {
                throw new BusinessException((ErrorHandler)I18nError.OWN_APPLICATION_EXCEPTION, new Object[]{dto.getId(), authoredUser.getTenantId()});
            }
            dto.setTenantSid(Long.valueOf(authoredUser.getTenantSid()));
            dto.setTenantId(authoredUser.getTenantId());
            dto.setTenantName(authoredUser.getTenantName());
        }
        Assert.isTrue((!StringUtils.isEmpty((Object)dto.getNameTW()) || !StringUtils.isEmpty((Object)dto.getNameUS()) || !StringUtils.isEmpty((Object)dto.getNameCN()) ? 1 : 0) != 0, (String)"\u540d\u79f0\u4e0d\u80fd\u5168\u90e8\u4e3a\u7a7a");
        dto.setEnableAuth(dto.getEnableAuth() == null ? Boolean.FALSE : dto.getEnableAuth());
        return StdData.ok((Object)this.devSysService.save(dto));
    }

    @PutMapping(value={"/dev/app"})
    public StdData updateDevSys(@RequestBody DevSysDTO dto, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Assert.isTrue((authoredUser.getTenantSid() != 0L ? 1 : 0) != 0, (String)"\u79df\u6237Sid\u4e0d\u80fd\u4e3a\u7a7a");
        if (dto.getSid() == null && StringUtils.isEmpty((Object)dto.getId())) {
            throw new BusinessException((ErrorHandler)I18nError.APPLICATION_SID_AND_ID_CANNOT_BOTH_BE_EMPTY);
        }
        if (!dto.getNonDev().booleanValue()) {
            Assert.hasText((String)dto.getLogoImageUrl(), (String)"LOGO\u56fe\u7247\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.notNull((Object)dto.getSysType(), (String)"\u5e94\u7528\u4f7f\u7528\u4e8e\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.notNull((Object)dto.getDevPlatform(), (String)"\u5f00\u53d1\u5e73\u53f0\u4e0d\u80fd\u4e3a\u7a7a");
            dto.setTenantSid(Long.valueOf(authoredUser.getTenantSid()));
            if (StringUtils.isEmpty((Object)dto.getTenantId())) {
                dto.setTenantId(authoredUser.getTenantId());
            }
            if (StringUtils.isEmpty((Object)dto.getTenantName())) {
                dto.setTenantName(authoredUser.getTenantName());
            }
        } else if (StringUtils.isEmpty((Object)dto.getTenantId()) || StringUtils.isEmpty((Object)dto.getTenantName())) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_INFO_EMPTY);
        }
        Assert.isTrue((!StringUtils.isEmpty((Object)dto.getNameTW()) || !StringUtils.isEmpty((Object)dto.getNameUS()) || !StringUtils.isEmpty((Object)dto.getNameCN()) ? 1 : 0) != 0, (String)"\u540d\u79f0\u4e0d\u80fd\u5168\u90e8\u4e3a\u7a7a");
        this.devSysService.update(dto);
        return StdData.ok((Object)true);
    }

    @PostMapping(value={"/dev/app/fullInfo/{id}"})
    public StdData getDevSysFullInfo(@PathVariable String id) {
        DevSysInfoVO devSysVO = this.devSysService.getDevSysFullInfo(id);
        return StdData.ok((Object)devSysVO);
    }

    @GetMapping(value={"/dev/app/{sid}"})
    public StdData<?> findDevSys(@PathVariable Long sid) {
        DevSysVO devSysVO = this.devSysService.findDevSysBySid(sid);
        return StdData.ok((Object)devSysVO);
    }

    @GetMapping(value={"/dev/app/id/{id}"})
    public StdData findDevSys(@PathVariable String id) {
        DevSysVO devSysVO = this.devSysService.findDevSysById(id);
        return StdData.ok((Object)devSysVO);
    }

    @PostMapping(value={"/dev/app/one"})
    public StdData<DevSysVO> findDevSys(@RequestBody DevSysDTO dto) {
        boolean check = StringUtils.isEmpty((Object)dto.getId()) && StringUtils.isEmpty((Object)dto.getAppToken()) && dto.getSid() == null;
        Assert.isTrue((!check ? 1 : 0) != 0, (String)"\u5e94\u7528sid\u3001id\u3001appToken\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        DevSysVO devSysVO = this.devSysService.findDevSys(dto);
        return StdData.ok((Object)devSysVO);
    }

    @GetMapping(value={"/dev/app/id/{id}/current"})
    public StdData findDevSysCurrent(@PathVariable String id, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        DevSysVO devSysVO = this.devSysService.findDevSysByIdAndTenantSid(id, Long.valueOf(authoredUser.getTenantSid()));
        return StdData.ok((Object)devSysVO);
    }

    @GetMapping(value={"/dev/app/id/{id}/existed"})
    public StdData existsDevSys(@PathVariable String id) {
        return StdData.ok((Object)this.devSysRepository.existsById(id));
    }

    @GetMapping(value={"/dev/app/id/{id}/prod/existed"})
    public StdData<Boolean> existsDevSysWithProd(@PathVariable String id) {
        return StdData.ok((Object)this.devSysService.existsWithProdById(id));
    }

    @DeleteMapping(value={"/dev/app/{sid}"})
    public StdData deleteDevSysBySid(@PathVariable Long sid) {
        DevSys devSys = (DevSys)this.devSysCrudService.findBySid(sid.longValue());
        if (devSys != null) {
            if (!UserUtils.getTenantId().equals(devSys.getTenantId()) && !this.authValidateService.checkAccessPermission(TargetType.Sys.name(), "DELETE", "/api/iam/v2/dev/app/{sid}", UserUtils.getSysId()).booleanValue()) {
                throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
            }
            this.devSysService.deleteDevSysBySid(sid);
            this.changeLogService.createChangeLog(ChangeTypeEnum.DEV_APP_DEL.getName(), (Object)devSys, ChangeTypeEnum.DEV_APP_DEL.getPrimaryKey(), String.valueOf(devSys.getSid()));
            this.devSysService.sync(null, null, null, devSys.getId());
        }
        return StdData.ok((Object)true);
    }

    @PostMapping(value={"/dev/app/cascade/del/check"})
    public ResponseEntity<DeleteCheckDTO> deleteDevSysCascadeCheck(@RequestBody AuthDataDO appInfo) {
        return ResponseEntity.ok((Object)this.devSysService.deleteAppCascadeCheck(appInfo.getAppId()));
    }

    @PostMapping(value={"/dev/app/cascade/del/delete"})
    public ResponseEntity<Boolean> deleteDevSysCascadeDelete(@RequestBody DeleteCheckDTO dto) {
        return ResponseEntity.ok((Object)this.devSysService.deleteAppCascadeDelete(dto));
    }

    @GetMapping(value={"/dev/app/currentTenant"})
    public StdData findTenantDevSyses(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orderBy", defaultValue="ds.create_date asc") String orderBy, @RequestParam(name="params", required=false) String params, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (authoredUser.getTenantSid() == 0L) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_ID_NOT_NULL);
        }
        DevSysDTO dto = DevSysDTO.getSelf((String)params);
        dto.setTenantSid(Long.valueOf(authoredUser.getTenantSid()));
        dto.setTenantId(authoredUser.getTenantId());
        PageSerializable result = this.devSysService.findDevSyses(pageNum, pageSize, orderBy, dto);
        return StdData.ok((Object)result);
    }

    @PostMapping(value={"/dev/current/tenant/apps"})
    public StdData findTenantDevSysesWithoutPolicy(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orderBy", defaultValue="ds.create_date asc") String orderBy, @RequestBody DevSysDTO devSysDTO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (authoredUser.getTenantSid() == 0L) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_ID_NOT_NULL);
        }
        devSysDTO.setTenantSid(Long.valueOf(authoredUser.getTenantSid()));
        devSysDTO.setTenantId(authoredUser.getTenantId());
        List result = this.devSysMapper.findDevSysListNonePolicy(pageNum.intValue(), pageSize.intValue(), orderBy, devSysDTO);
        return StdData.ok((Object)new PageSerializable(result));
    }

    @PostMapping(value={"/dev/tenant/apps"})
    public StdData findTenantDevSyses(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orderBy", defaultValue="ds.create_date asc") String orderBy, @RequestBody DevSysDTO devSysDTO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (authoredUser.getTenantSid() == 0L) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_ID_NOT_NULL);
        }
        devSysDTO.setTenantSid(Long.valueOf(authoredUser.getTenantSid()));
        devSysDTO.setTenantId(authoredUser.getTenantId());
        devSysDTO.setAgentTenantId(authoredUser.getTenantId());
        devSysDTO.setSource("all");
        List result = this.devSysMapper.findDevSysListNonePolicy(pageNum.intValue(), pageSize.intValue(), orderBy, devSysDTO);
        return StdData.ok((Object)new PageSerializable(result));
    }

    @GetMapping(value={"/dev/app"})
    public StdData findDevSyses(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orderBy", defaultValue="ds.create_date desc") String orderBy, @RequestParam(name="params", required=false) String params) {
        DevSysDTO devSysDTO = DevSysDTO.getSelf((String)params);
        if (devSysDTO.isLandingApp()) {
            List result = this.devSysService.getLandingSysInfos(devSysDTO);
            return StdData.ok((Object)result);
        }
        if (!devSysDTO.getNonDev().booleanValue()) {
            PageSerializable result = this.devSysService.findDevSyses(pageNum, pageSize, orderBy, devSysDTO);
            return StdData.ok((Object)result);
        }
        List result = this.devSysService.getAllSysInfos(devSysDTO);
        return StdData.ok((Object)result);
    }

    @PostMapping(value={"/dev/app/mmc"})
    public StdData<?> findDevSys(@RequestBody DevAppCond condition) {
        List whiteList = this.whiteListService.getWhiteList("ALLOW_GRANT_ADMIN");
        if (whiteList.contains(UserUtils.getUserId())) {
            condition.setSource("all");
        } else {
            condition.setSource("non-dev");
        }
        condition.setOrderBy(Optional.ofNullable(condition.getOrderBy()).orElse("ds.sid desc"));
        PageMethod.startPage((int)condition.getPageNum(), (int)condition.getPageSize(), (String)condition.getOrderBy());
        List devSysVOS = this.devSysMapper.findMMCPage(condition);
        return StdData.ok((Object)new PageSerializable(devSysVOS));
    }

    @PostMapping(value={"/dev/app/simple"})
    public ResponseEntity<?> findAllDevSys(@RequestBody(required=false) DevSys body) {
        Specification & Serializable spec = (Specification & Serializable)(root, query, cb) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (body != null && StringUtils.hasText((String)body.getId())) {
                predicates.add(cb.like((Expression)root.get("id"), "%" + body.getId() + "%"));
            }
            Predicate[] pre = new Predicate[predicates.size()];
            return query.where(predicates.toArray(pre)).getRestriction();
        };
        List devSys = this.devSysRepository.findAll((Specification)spec);
        List list = devSys.stream().map(o -> {
            BaseVO sys = new BaseVO();
            sys.setSid(Long.valueOf(o.getSid()));
            sys.setId(o.getId());
            sys.setName(o.getNameCN());
            return sys;
        }).collect(Collectors.toList());
        return ResponseEntity.ok(list);
    }

    @PostMapping(value={"/dev/app/list"})
    public StdData<?> findAllDevSysByPage(@RequestBody(required=false) DevAppCond cond) {
        List devSysVOS = this.devSysMapper.findListByPage(cond, Integer.valueOf(cond.getPageSize()), Integer.valueOf(cond.getPageNum()), cond.getOrderBy());
        devSysVOS.forEach(DevSysVO::language);
        return StdData.ok((Object)new PageSerializable(devSysVOS));
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/dev/app/{appSid}/visible"})
    public StdData updateDevAction(@PathVariable Long appSid) {
        this.devSysService.updateDevSysVisible(appSid);
        return StdData.ok().build();
    }

    @PostMapping(value={"/dev/app/info"})
    public StdData getDevAppInfo(@RequestBody RequestParameterVO body) {
        DevelopApp app = this.devSysService.getDevAppInfo(body.getId(), Boolean.valueOf(true));
        return StdData.ok((Object)app);
    }

    @GetMapping(value={"/dev/app/info/all"})
    public StdData getDevAppAllInfo(@RequestParam String appId, @RequestParam(required=false, defaultValue="false") Boolean withApi) {
        DevelopApp app = this.devSysService.getDevAppInfoWithApiMetadata(appId, Boolean.valueOf(false), withApi);
        return StdData.ok((Object)app);
    }

    @PostMapping(value={"/dev/app/info/language"})
    public ResponseEntity<?> getDevAppInfoLanguage(@RequestBody RequestParameterVO body) throws Exception {
        DevelopApp app = this.devSysService.getDevApp(body.getId());
        HashMap result = new HashMap();
        HashMap<String, String> appCn = new HashMap<String, String>();
        app.toLanguage(Locale.SIMPLIFIED_CHINESE.toLanguageTag());
        appCn.put("goodsName", app.getApp().getName());
        appCn.put("modules", JsonUtils.createObjectMapper().writeValueAsString((Object)app));
        HashMap<String, String> appTw = new HashMap<String, String>();
        app.toLanguage(Locale.TRADITIONAL_CHINESE.toLanguageTag());
        appTw.put("goodsName", app.getApp().getName());
        appTw.put("modules", JsonUtils.createObjectMapper().writeValueAsString((Object)app));
        HashMap<String, String> appUs = new HashMap<String, String>();
        app.toLanguage(Locale.US.toLanguageTag());
        appUs.put("goodsName", app.getApp().getName());
        appUs.put("modules", JsonUtils.createObjectMapper().writeValueAsString((Object)app));
        result.put(Locale.SIMPLIFIED_CHINESE.toLanguageTag(), appCn);
        result.put(Locale.TRADITIONAL_CHINESE.toLanguageTag(), appTw);
        result.put(Locale.US.toLanguageTag(), appUs);
        return ResponseEntity.ok(result);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/dev/app/module"})
    public StdData addDevModule(@RequestBody DevModuleVO devModuleVO) {
        return StdData.ok((Object)this.devModuleService.addDevModule(devModuleVO));
    }

    @Transactional(rollbackFor={Exception.class})
    @PutMapping(value={"/dev/app/module/update"})
    public StdData<?> updateDevModule(@RequestBody DevModuleVO devModuleVO) {
        this.devModuleService.modifyDevModule(devModuleVO);
        return StdData.ok((Object)devModuleVO.getSid());
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/dev/app/module/action"})
    public StdData addDevAction(@RequestBody DevActionVO devActionVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        return StdData.ok((Object)this.devActionService.addDevAction(devActionVO, authoredUser.getTenantSid()));
    }

    @Transactional(rollbackFor={Exception.class})
    @PutMapping(value={"/dev/app/module/action/update"})
    public StdData updateDevAction(@RequestBody DevActionVO devActionVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        this.devActionService.updateDevAction(devActionVO, authoredUser.getTenantSid());
        return StdData.ok((Object)devActionVO.getSid());
    }

    @GetMapping(value={"/dev/app/module/action/{sid}"})
    public StdData getDevAppModules(@PathVariable Long sid) {
        DevActionQueryResultVO actionQueryResultVO = this.devActionQueryService.getAction(sid.longValue());
        return StdData.ok((Object)actionQueryResultVO);
    }

    @GetMapping(value={"/dev/app/{sid}/module"})
    public StdData getCascade(@PathVariable Long sid) {
        List devModuleQueryResultVOS = this.devModuleQueryService.getDevModuleVOSBySid(sid.longValue());
        return StdData.ok((Object)devModuleQueryResultVOS);
    }

    @Transactional(rollbackFor={Exception.class})
    @DeleteMapping(value={"/dev/app/module/action/{sid}"})
    public StdData deleteAction(@PathVariable Long sid) {
        this.devActionService.deleteDevAction(sid.longValue());
        return StdData.ok().build();
    }

    @Transactional(rollbackFor={Exception.class})
    @DeleteMapping(value={"/dev/app/module/{sid}"})
    public StdData deleteModule(@PathVariable Long sid) {
        this.devModuleService.deleteDevModule(sid.longValue());
        return StdData.ok().build();
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/app/to/tenant"})
    public StdData updateTenantCommonApp(@RequestBody DevSysVO devSysVO) {
        this.devSysService.updateAppToTenant(devSysVO);
        return StdData.ok().build();
    }

    @PostMapping(value={"/dev/apps/tenant"})
    public StdData<?> getAppTenant(@RequestBody(required=false) DevAppVO body) {
        List devSys;
        if (null != body) {
            body.afterPropertiesSet();
            if (body.getAppIds().isEmpty()) {
                return StdData.ok(Collections.emptyList());
            }
            devSys = this.devSysMapper.findSysTenantByIds(body.getAppIds());
        } else {
            devSys = this.devSysMapper.findSysTenantByIds(Collections.emptyList());
        }
        return StdData.ok((Object)devSys);
    }

    @PostMapping(value={"dev/app/full"})
    public StdData<?> addDevApp(@RequestBody DevSysVO3 body) {
        this.devSysService.updateSys(body);
        return StdData.ok().build();
    }

    @PostMapping(value={"dev/app/secret/reset"})
    public StdData<?> resetAppSecret(@RequestBody DevSysDTO body) {
        this.devSysService.resetAppSecret(body.getId());
        return StdData.ok().build();
    }

    @GetMapping(value={"/dev/app/secret/current"})
    public StdData<?> getCurrentAppSecret(@RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser authoredUser, @RequestAttribute(value="digi-middleware-auth-app-data", required=false) AuthoredSys authoredSys) {
        if (authoredSys == null || authoredSys.getSid() == 0L) {
            return StdData.of((int)500, (String)"\u5e94\u7528\u4e0d\u5b58\u5728");
        }
        return StdData.ok((Object)new AppSecretVO(authoredSys.getId(), this.devSysService.getCurrentSecret()));
    }

    @PostMapping(value={"dev/app/sync"})
    public StdData<?> syncSys(@RequestBody DevSysSyncVO body) {
        this.devSysService.syncSys(body);
        return StdData.ok().build();
    }

    @PostMapping(value={"dev/app/synconce"})
    public StdData<?> syncSysUpgrade(@RequestBody String body) {
        return StdData.ok((Object)this.devSysService.syncSysUpgrade(body));
    }

    @PostMapping(value={"/dev/app/tenant/sys"})
    public ResponseEntity<List<DevelopSys>> addDevAppByTenant() {
        List sys = this.devSysMapper.findSysByTenant(UserUtils.getTenantSid());
        return ResponseEntity.ok((Object)sys);
    }

    @GetMapping(value={"/dev/app/tenant/id"})
    public StdData<List<String>> getTenantDevSysId(@RequestParam String tenantId) {
        List sysByTenantId = this.devSysMapper.findSysByTenantId(tenantId, Integer.valueOf(1));
        return StdData.ok(sysByTenantId.stream().map(DevelopSys::getId).collect(Collectors.toList()));
    }

    @GetMapping(value={"/dev/app/tenant/customer"})
    public StdData<List<DevelopSys>> getTenantDevSysByCustomer(TenantBasicInfoVO tenantCond) {
        AssertUtils.paramHasText((String)tenantCond.getCustomerId(), (String)"CustomerId");
        return StdData.ok((Object)this.devSysService.getDevSysOrByCustomer(tenantCond.getCustomerId()));
    }

    @PostMapping(value={"/dev/app/module/import"})
    public StdData<?> importSysInfo(@RequestBody DevelopAppImportInfo devSysInfo) {
        this.devSysService.importSys(devSysInfo.getLanguage(), devSysInfo.getAppId(), devSysInfo.getAppInfo());
        return StdData.ok().build();
    }
}

