/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.dev.DevTestCheckResultVO;
import com.digiwin.dap.middleware.iam.domain.dev.DevTestRegisterInfo;
import com.digiwin.dap.middleware.iam.domain.dev.RegisterResultInfoVO;
import com.digiwin.dap.middleware.iam.service.dev.test.DevTestEnvService;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2/dev/test/env"})
public class DevTestController {
    @Autowired
    private DevTestEnvService devTestEnvService;

    @PostMapping(value={"/tenant/apps/existed"})
    public StdData existedInCurrent(@RequestBody DevTestCheckResultVO checkRequest) {
        if (StringUtils.isEmpty((Object)checkRequest.getTenantId())) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_ID_NOT_NULL);
        }
        String testTenantId = String.format("test_%s", checkRequest.getTenantId());
        return StdData.ok((Object)this.devTestEnvService.existedTenantAndApps(testTenantId, checkRequest.getApps()));
    }

    @PostMapping(value={"/exists/tenant/apps/test"})
    public StdData existedInTestEnv(@RequestBody DevTestCheckResultVO checkRequest) {
        if (StringUtils.isEmpty((Object)checkRequest.getTenantId())) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_ID_NOT_NULL);
        }
        String testTenantId = String.format("test_%s", checkRequest.getTenantId());
        return StdData.ok((Object)this.devTestEnvService.existedTenantAndApps(testTenantId, checkRequest.getApps()));
    }

    @PostMapping(value={"/init/tenant"})
    public ResponseEntity<RegisterResultInfoVO> initializeTenantInfos(@RequestBody @Valid DevTestRegisterInfo registerInfo) {
        if (null == registerInfo || null == registerInfo.getTenant() || StringUtils.isEmpty((Object)registerInfo.getTenant().getTeamId())) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_ID_NOT_NULL);
        }
        RegisterResultInfoVO result = this.devTestEnvService.initializeTenantInfos(registerInfo.getTenant(), registerInfo.getUser(), registerInfo.getAppId(), registerInfo.getSysCategory(), registerInfo.getTenant().getTeamId(), registerInfo.getTempPassword());
        return ResponseEntity.ok((Object)result);
    }
}

