/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import cn.hutool.core.lang.UUID;
import cn.hutool.http.useragent.UserAgent;
import cn.hutool.http.useragent.UserAgentUtil;
import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.AuthoredDevice;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.constant.DapHttpHeaders;
import com.digiwin.dap.middleware.domain.StdData;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2/device"})
public class DeviceController {
    @GetMapping(value={"/id"})
    public StdData<String> getDeviceId(@RequestAttribute(value="digi-middleware-auth-app-data") AuthoredSys sys, HttpServletRequest request) {
        AuthoredDevice device;
        String source = request.getHeader(DapHttpHeaders.M_SOURCE.getHeader());
        String ip = AppAuthContextHolder.getContext().getClientIP();
        if (StringUtils.hasText((String)source)) {
            String deviceType = request.getHeader(DapHttpHeaders.M_DEVICE_TYPE.getHeader());
            String deviceId = request.getHeader(DapHttpHeaders.M_DEVICE_ID.getHeader());
            device = new AuthoredDevice(source, sys.getId(), deviceType, deviceId, ip);
        } else {
            String userAgentString = request.getHeader("User-Agent");
            UserAgent userAgent = UserAgentUtil.parse((String)userAgentString);
            String browserName = userAgent.getBrowser().getName();
            String uuid = UUID.fastUUID().toString(true);
            device = new AuthoredDevice("web", sys.getId(), browserName, uuid, ip);
        }
        String deviceIdHeaderVal = device.generateMiddlewareDeviceId();
        return StdData.ok((Object)deviceIdHeaderVal);
    }
}

