/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import com.digiwin.dap.middleware.iam.domain.eai.EaiRequest;
import com.digiwin.dap.middleware.iam.domain.eai.EaiResponse;
import com.digiwin.dap.middleware.iam.domain.eai.EaiResponseExecution;
import com.digiwin.dap.middleware.iam.support.remote.eai.EaiAnalyzeService;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2/eai"})
public class EaiManagerController {
    private Logger logger = LoggerFactory.getLogger(EaiManagerController.class);
    @Autowired
    private List<EaiAnalyzeService> eaiAnalyzeServices;

    @PostMapping(value={""})
    public ResponseEntity<?> analyzeEaiRequest(HttpServletRequest request, @RequestBody(required=false) EaiRequest eaiParameter, HttpServletResponse response) {
        this.logger.info("1.parameter:{}", (Object)JsonUtils.writeValue((Object)eaiParameter));
        EaiResponse eaiResponse = new EaiResponse();
        EaiResponseExecution eaiResponseExecution = new EaiResponseExecution();
        String serviceContent = request.getHeader("digi-service");
        if (StringUtils.isEmpty((Object)serviceContent)) {
            eaiResponseExecution.setCode("500");
            eaiResponseExecution.setDescription("\u8bf7\u6c42\u5934digi-service\u4fe1\u606f\u4e3a\u7a7a");
            eaiResponse.getStd_data().setExecution(eaiResponseExecution);
        } else {
            HashMap serviceMap = (HashMap)JsonUtils.jsonToObj((String)serviceContent, HashMap.class);
            if (serviceMap == null || !serviceMap.containsKey("name") || StringUtils.isEmpty(serviceMap.get("name"))) {
                eaiResponseExecution.setCode("500");
                eaiResponseExecution.setDescription("\u8bf7\u6c42\u5934digi-service\u4e0a\u7684\u670d\u52a1\u540d\u79f0\u4e3a\u7a7a");
                eaiResponse.getStd_data().setExecution(eaiResponseExecution);
            } else {
                String serviceName = (String)serviceMap.get("name");
                for (EaiAnalyzeService eaiService : this.eaiAnalyzeServices) {
                    if (!eaiService.support(serviceName)) continue;
                    eaiResponse = eaiService.get(request, eaiParameter);
                }
                if (eaiResponse.getStd_data() == null) {
                    eaiResponseExecution.setCode("500");
                    eaiResponseExecution.setDescription(String.format("\u8bf7\u6c42\u670d\u52a1%s\u4e0d\u5339\u914d", serviceName));
                    eaiResponse.getStd_data().setExecution(eaiResponseExecution);
                }
            }
        }
        response.addHeader("digi-srvver", "1.0");
        if (!"0".equals(eaiResponse.getStd_data().getExecution().getCode())) {
            response.addHeader("digi-srvcode", "100");
        } else {
            response.addHeader("digi-srvcode", "000");
        }
        return ResponseEntity.ok((Object)eaiResponse);
    }
}

