/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import com.digiwin.dap.middle.kms.constants.KeyConstant;
import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middleware.commons.crypto.DigestUtils;
import com.digiwin.dap.middleware.commons.crypto.PwdUtils;
import com.digiwin.dap.middleware.commons.crypto.RSA;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.iam.api.EnvController;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.service.dev.sys.DevSysService;
import com.digiwin.dap.middleware.iam.service.sys.SysCrudService;
import com.digiwin.dap.middleware.iam.support.schedule.ScheduleTaskService;
import com.digiwin.dap.middleware.iam.util.SecretKeyUtil;
import com.digiwin.dap.middleware.util.NetUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.RedisConnectionCommands;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@RestController
@RequestMapping
public class EnvController {
    private static final Logger logger = LoggerFactory.getLogger(EnvController.class);
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RedisTemplate<Object, Object> redisTemplate;
    @Autowired
    private ScheduleTaskService scheduleTaskService;
    @Autowired
    private SysCrudService sysCrudService;
    @Autowired
    private WebApplicationContext webApplicationContext;
    @Autowired
    private DevSysService devSysService;

    @GetMapping(value={"/api/iam/v2/env"}, produces={"application/json; charset=utf-8"})
    public ResponseEntity<?> getRuntimeEnv() {
        this.envProperties.refresh();
        return ResponseEntity.ok((Object)this.envProperties);
    }

    @RequestMapping(value={"/api/iam/v2/env/health"}, method={RequestMethod.POST, RequestMethod.GET})
    public ResponseEntity<?> health(HttpServletRequest request) {
        Enumeration headerNames = request.getHeaderNames();
        if (headerNames != null) {
            logger.info("\u6253\u5370\u5934 \u5f00\u59cb >>>>>>>");
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                Enumeration headers = request.getHeaders(headerName);
                Collections.list(headers).forEach(headerValue -> logger.info("{}: {}", (Object)headerName, headerValue));
            }
            logger.info("\u6253\u5370\u5934 \u7ed3\u675f <<<<<<, ip = {}", (Object)NetUtils.getClientIP((HttpServletRequest)request));
        } else {
            logger.info("No headers found.");
        }
        return ResponseEntity.ok(Collections.singletonMap("status", "success"));
    }

    @GetMapping(value={"/api/iam/v2/env/health/{component}"})
    public StdData getHealth(@PathVariable String component) {
        if (Component.REDIS.name().equalsIgnoreCase(component)) {
            this.redisTemplate.execute(RedisConnectionCommands::ping);
        } else if (Component.MARIADB.name().equalsIgnoreCase(component)) {
            this.jdbcTemplate.queryForList("SELECT 1");
        }
        return StdData.ok().build();
    }

    @PostMapping(value={"/api/iam/v2/env/hash/{targetValue}"}, produces={"application/json; charset=utf-8"})
    public ResponseEntity<?> generateHash(@PathVariable String targetValue) {
        return ResponseEntity.ok((Object)DigestUtils.sha256((String)targetValue));
    }

    @GetMapping(value={"/api/iam/v2/env/secret"})
    public ResponseEntity<?> getSecretKey(@RequestParam(required=false) String tenantId, @RequestParam(required=false) String userId, @RequestParam(required=false) String sysId, @RequestParam(required=false) String key) {
        String result = StringUtils.isEmpty((Object)key) ? SecretKeyUtil.getSecretKey((String)tenantId, (String)userId, (String)sysId) : AES.decryptCBC((String)key, (String)KeyConstant.OTHER);
        return ResponseEntity.ok((Object)result);
    }

    @GetMapping(value={"/api/iam/v2/env/encrypt/secret"})
    public ResponseEntity<?> getEncryptSecretKey(@RequestParam(required=false) String secretKey) {
        HashMap<String, String> result = null;
        try {
            KeyPair keyPair = RSA.generateKeyPair((int)1024);
            String privateKey = new String(Base64.encodeBase64((byte[])keyPair.getPrivate().getEncoded()));
            String clientPublicKey = new String(Base64.encodeBase64((byte[])keyPair.getPublic().getEncoded()));
            String encryptPublicKey = RSA.encrypt((String)clientPublicKey, (String)KeyConstant.BASE64_PUBLIC_KEY);
            String encryptKey = PwdUtils.encryptPwd((String)secretKey, (String)clientPublicKey);
            result = new HashMap<String, String>();
            result.put("clientPublickKey", encryptPublicKey);
            result.put("secretKey", encryptKey);
        }
        catch (Exception exception) {
            logger.error(exception.getMessage());
        }
        return ResponseEntity.ok(result);
    }

    @GetMapping(value={"/api/iam/v2/uris"})
    public ResponseEntity<?> getAllUris() {
        RequestMappingHandlerMapping mappingHandlerMapping = (RequestMappingHandlerMapping)this.webApplicationContext.getBean(RequestMappingHandlerMapping.class);
        Map map = mappingHandlerMapping.getHandlerMethods();
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry m : map.entrySet()) {
            RequestMappingInfo info = (RequestMappingInfo)m.getKey();
            HandlerMethod method = (HandlerMethod)m.getValue();
            list.add(String.format("%s-%s", info.getMethodsCondition().toString(), info.getPatternsCondition().toString()));
        }
        return ResponseEntity.ok(list);
    }

    @GetMapping(value={"/api/iam/v2/env/schedule"})
    public ResponseEntity<?> startScheduleTask(@RequestParam String methodName) throws InvocationTargetException, IllegalAccessException {
        Method[] methods;
        for (Method method : methods = this.scheduleTaskService.getClass().getMethods()) {
            if (!methodName.endsWith(method.getName())) continue;
            method.invoke((Object)this.scheduleTaskService, new Object[0]);
        }
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @GetMapping(value={"/api/iam/v2/env/double/check/{sysId}/{check}"})
    public StdData enableDoubleCheckApp(@PathVariable(value="sysId") String sysId, @PathVariable(value="check") Boolean check) {
        Sys sys = (Sys)this.sysCrudService.findById(sysId);
        if (sys != null) {
            sys.setDoubleCheck(check == null ? false : check);
            this.sysCrudService.update((BaseEntity)sys);
        }
        return StdData.ok().build();
    }
}

