/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.constant.enums.UpdateModeEnum;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.excel.BatchRegisterUserVO;
import com.digiwin.dap.middleware.iam.domain.tenant.ImportExcelResultVO;
import com.digiwin.dap.middleware.iam.domain.tenant.ImportResultVO;
import com.digiwin.dap.middleware.iam.domain.user.UserCorpWechatVO;
import com.digiwin.dap.middleware.iam.service.org.ExportOrgService;
import com.digiwin.dap.middleware.iam.service.org.OrgAspectCrudService;
import com.digiwin.dap.middleware.iam.service.role.ExportRoleService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.tenantmetadata.TenantMetadataCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleService;
import com.digiwin.dap.middleware.iam.support.excel.IExcelService;
import com.digiwin.dap.middleware.iam.support.excel.ImportOrgExcelService;
import com.digiwin.dap.middleware.iam.support.excel.ImportRoleExcelService;
import com.digiwin.dap.middleware.iam.support.excel.ImportUserInfoByExcelService;
import com.digiwin.dap.middleware.iam.support.excel.TenantBatchInviteUserService;
import com.digiwin.dap.middleware.iam.support.validate.AuthValidateService;
import com.digiwin.dap.middleware.util.AssertUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import javax.transaction.Transactional;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2/excel"})
public class ExcelController {
    @Autowired
    private ImportUserInfoByExcelService importUserInfoByExcelService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private TenantBatchInviteUserService tenantBatchInviteUserService;
    @Autowired
    OrgAspectCrudService orgAspectCrudService;
    @Autowired
    ExportOrgService exportOrgService;
    @Autowired
    ExportRoleService exportRoleService;
    @Autowired
    ImportRoleExcelService importRoleExcelService;
    @Autowired
    ImportOrgExcelService importOrgExcelService;
    @Autowired
    private IExcelService excelService;
    @Autowired
    private TenantMetadataCrudService tenantMetadataCrudService;
    @Autowired
    private AuthValidateService authValidateService;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private UserInRoleService userInRoleService;

    @PostMapping(value={"/{tenantId:.+}/fileid/{fileId}"})
    public ResponseEntity<?> importUserInfo(@PathVariable(value="tenantId") String tenantId, @PathVariable(value="fileId") String fileId, @RequestBody(required=false) UserCorpWechatVO userCorpWechatVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        boolean hasCorpWechat = false;
        if (null != userCorpWechatVO) {
            hasCorpWechat = userCorpWechatVO.isHasCorpWechat();
        }
        if (!UserUtils.getTenantId().equals(tenantId) && Boolean.TRUE.equals(this.authValidateService.checkAccessPermission(TargetType.Sys.name(), "POST", "/api/iam/v2/excel/{tenantId}/fileid/{fileId}", UserUtils.getSysId()) == false)) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        if (0 != this.envProperties.getCloud() && !this.userInRoleService.checkSuperAdmin(Long.valueOf(authoredUser.getTenantSid()), Long.valueOf(authoredUser.getSid()))) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_USER_PERMISSION_OPERATE_ERROR);
        }
        long tenantSid = this.tenantCrudService.getSidById(tenantId);
        if (tenantSid == 0L) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{tenantSid});
        }
        ImportExcelResultVO importExcelResultVO = this.importUserInfoByExcelService.checkAndImportUserExcel(fileId, tenantSid, hasCorpWechat);
        return new ResponseEntity((Object)importExcelResultVO, HttpStatus.OK);
    }

    @PostMapping(value={"/user/register"})
    public StdData<?> batchRegister(@RequestBody @Valid BatchRegisterUserVO batchRegisterUserVO) {
        if (!UserUtils.getTenantId().equalsIgnoreCase(batchRegisterUserVO.getTenantId()) && !this.authValidateService.checkAccessPermission(TargetType.Sys.name(), "POST", AppAuthContextHolder.getContext().getRequestInfo().getPath(), UserUtils.getSysId()).booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        long tenantSid = this.tenantCrudService.getSidById(batchRegisterUserVO.getTenantId());
        if (tenantSid == 0L) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21018);
        }
        ImportResultVO resultVO = this.importUserInfoByExcelService.registerUser(batchRegisterUserVO, tenantSid);
        return StdData.ok((Object)resultVO);
    }

    @PostMapping(value={"/batch/user/register"})
    public ResponseEntity<?> batchRegisterUser(@RequestBody BatchRegisterUserVO batchRegisterUserVO) {
        boolean hasCorpWechat = false;
        String tenantId = batchRegisterUserVO.getTenantId();
        if (null != tenantId) {
            hasCorpWechat = batchRegisterUserVO.isHasCorpWechat();
        }
        batchRegisterUserVO.setHasCorpWechat(hasCorpWechat);
        long tenantSid = this.tenantCrudService.getSidById(tenantId);
        if (tenantSid == 0L) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{tenantId});
        }
        ImportResultVO importExcelResultVO = this.importUserInfoByExcelService.batchRegisterUser(batchRegisterUserVO, tenantSid);
        return new ResponseEntity((Object)importExcelResultVO, HttpStatus.OK);
    }

    @Transactional(rollbackOn={Exception.class})
    @PostMapping(value={"/batch/user/invite/{fileId}"})
    public ResponseEntity<?> batchInvitedUserJoinTenant(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @PathVariable String fileId, @RequestBody(required=false) UserCorpWechatVO userCorpWechatVO) {
        boolean hasCorpWechat = false;
        if (null != userCorpWechatVO) {
            hasCorpWechat = userCorpWechatVO.isHasCorpWechat();
        }
        if (0L == authoredUser.getSid()) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED);
        }
        if (0L == authoredUser.getTenantSid()) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED);
        }
        return ResponseEntity.ok((Object)StdData.ok((Object)this.tenantBatchInviteUserService.batchInvitedUser(authoredUser, fileId, hasCorpWechat)));
    }

    @GetMapping(value={"/export/role/{tenantSid}"})
    public void exportRole(@PathVariable long tenantSid, HttpServletResponse response) {
        byte[] fileByte = this.exportRoleService.getRoleFileByte(tenantSid);
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        String localTime = df.format(LocalDateTime.now());
        this.getResponseEntity(response, fileByte, "role" + localTime + ".xlsx");
    }

    @GetMapping(value={"/export/role"})
    public void exportRoleCurrentTenant(HttpServletResponse response) {
        byte[] fileByte = this.exportRoleService.getRoleFileByte(UserUtils.getTenantSid());
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        String localTime = df.format(LocalDateTime.now());
        this.getResponseEntity(response, fileByte, "role" + localTime + ".xlsx");
    }

    @GetMapping(value={"/export/org/{aspectSid}"})
    public void exportOrg(@PathVariable long aspectSid, HttpServletResponse response) {
        byte[] fileByte = this.exportOrgService.getOrgFileByte(aspectSid);
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        String localTime = df.format(LocalDateTime.now());
        this.getResponseEntity(response, fileByte, "org" + localTime + ".xlsx");
    }

    private void getResponseEntity(HttpServletResponse response, byte[] fileByte, String fileName) {
        try {
            fileName = URLEncoder.encode(fileName, "utf-8");
            fileName = fileName.replace("+", "%20");
            response.setContentType("application/octet-stream");
            response.setHeader("Content-disposition", "attachment;filename=" + fileName);
            response.setHeader("ContentLength", String.valueOf(fileByte.length));
            response.getOutputStream().write(fileByte);
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
    }

    @Transactional(rollbackOn={Exception.class})
    @PostMapping(value={"/{tenantSid}/import/role/{fileId}"})
    public StdData<?> importRole(@PathVariable long tenantSid, @PathVariable String fileId) {
        if (!this.tenantCrudService.exists(tenantSid)) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED);
        }
        this.importRoleExcelService.importRoleExcel(fileId, tenantSid);
        return StdData.ok((Object)StdData.ok().build());
    }

    @Transactional(rollbackOn={Exception.class})
    @PostMapping(value={"/import/role/{fileId}"})
    public StdData<?> importRole(@PathVariable String fileId) {
        ImportExcelResultVO result = this.importRoleExcelService.importRoleExcelNew(fileId, UserUtils.getTenantSid());
        return StdData.ok((Object)result);
    }

    @Transactional(rollbackOn={Exception.class})
    @PostMapping(value={"/{tenantSid}/import/org/{fileId}"})
    public ResponseEntity<?> importOrg(@PathVariable long tenantSid, @PathVariable String fileId) {
        if (!this.tenantCrudService.exists(tenantSid)) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED);
        }
        ImportExcelResultVO importExcelResultVO = this.importOrgExcelService.importOrgExcel(fileId, tenantSid);
        return ResponseEntity.ok((Object)StdData.ok((Object)importExcelResultVO));
    }

    @PostMapping(value={"/user/enterprise/import/{fileId}"})
    public ResponseEntity<?> importEnterpriseUser(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @PathVariable String fileId, @RequestBody(required=false) UserCorpWechatVO userCorpWechatVO) {
        boolean hasCorpWechat = userCorpWechatVO != null && userCorpWechatVO.isHasCorpWechat();
        UpdateModeEnum updateModeEnum = Optional.ofNullable(userCorpWechatVO).map(UserCorpWechatVO::getUpdateMode).orElse(UpdateModeEnum.onlyAppend);
        AssertUtils.isTrue((0L != authoredUser.getTenantSid() ? 1 : 0) != 0, (ErrorHandler)I18nError.TENANT_INFO_EMPTY);
        return ResponseEntity.ok((Object)StdData.ok((Object)this.tenantBatchInviteUserService.batchImportEnterpriseUser(authoredUser, fileId, hasCorpWechat, updateModeEnum)));
    }

    @GetMapping(value={"/export/user/wechat"})
    public void exportUserWechat(HttpServletResponse response, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        this.excelService.exportUserWechat(Long.valueOf(authoredUser.getTenantSid()), response);
    }

    @PostMapping(value={"/export/user/wechat/{fileId}"})
    public StdData importUserWechat(@PathVariable String fileId, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Assert.isTrue((authoredUser.getTenantSid() > 0L ? 1 : 0) != 0, (String)"\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u79df\u6237\u4fe1\u606f\uff01");
        String corpId = this.tenantMetadataCrudService.getTenantMetadataValue(authoredUser.getTenantSid(), "contact", "corpId");
        if (StringUtils.isEmpty((Object)corpId)) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_CORP_ID_EMPTY, new Object[]{authoredUser.getTenantId()});
        }
        return StdData.ok((Object)this.excelService.importUserWechat(fileId, authoredUser));
    }

    @PostMapping(value={"/user/join/fileid/{fileId}/import"})
    public StdData importUserJoinTenant(@PathVariable String fileId, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Assert.isTrue((authoredUser.getTenantSid() > 0L ? 1 : 0) != 0, (String)"\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u79df\u6237\u4fe1\u606f\uff01");
        return StdData.ok((Object)this.excelService.importUserJoinTenant(authoredUser.getTenantId(), fileId));
    }
}

