/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.user.RegisterUserVO;
import com.digiwin.dap.middleware.iam.domain.usermapping.UserMappingQueryResultVO;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.repository.UserRepository;
import com.digiwin.dap.middleware.iam.service.login.impl.FiiIdentityServiceImpl;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.usermapping.UserMappingService;
import com.digiwin.dap.middleware.iam.support.auth.domain.IamAuthoredUser;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2"})
public class FiiController {
    @Autowired
    private UserMappingService userMappingService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private FiiIdentityServiceImpl fiiIdentityService;

    @PostMapping(value={"/fii/query/user/id/bymapper"}, produces={"application/json; charset=utf-8"})
    public ResponseEntity<?> queryUserIdByMapperInfo(@RequestBody UserMappingQueryResultVO userMappingVO) {
        if (ObjectUtils.isEmpty((Object)userMappingVO.getTenantId())) {
            throw new IllegalArgumentException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)userMappingVO.getVerifyUserId())) {
            throw new IllegalArgumentException("\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long tenantSid = this.tenantCrudService.getSidById(userMappingVO.getTenantId());
        Long userSid = this.userMappingService.getUserSidByVerifyUserId(tenantSid, "FII", userMappingVO.getVerifyUserId(), null);
        User user = (User)this.userCrudService.findBySid(userSid.longValue());
        if (user == null) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST);
        }
        return ResponseEntity.ok(Collections.singletonMap("userId", user.getId()));
    }

    @PostMapping(value={"/fii/query/user/isfii"})
    public ResponseEntity<?> isFii(@RequestBody RegisterUserVO body) {
        if (ObjectUtils.isEmpty((Object)body.getId())) {
            throw new IllegalArgumentException("id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(1);
        User user = this.userCrudService.queryUserByIdOrAliasIdAndComeFrom("FII-" + body.getId(), body.getId(), "fii");
        if (Objects.isNull(user)) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST);
        }
        String comeFrom = user.getComeFrom();
        result.put("isfii", "FII".equalsIgnoreCase(comeFrom));
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/oauth/fii/usertoken"}, produces={"application/json; charset=utf-8"})
    public ResponseEntity<?> login(@RequestBody Map<String, Object> paras) {
        IamAuthoredUser authoredUser = this.fiiIdentityService.getByCode(paras);
        if (authoredUser != null) {
            return ResponseEntity.ok((Object)authoredUser);
        }
        throw new BusinessException((ErrorHandler)I18nError.FII_EXCEPTION);
    }

    @Transactional(rollbackFor={Exception.class})
    @GetMapping(value={"/oauth/fii/callback"}, produces={"application/json; charset=utf-8"})
    public void fiiCallBack(@RequestParam String code) {
        System.out.println(code);
    }
}

