/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.api.AppController;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.app.SysCascadeVO;
import com.digiwin.dap.middleware.iam.domain.app.SysVO;
import com.digiwin.dap.middleware.iam.domain.authorization.AuthCategory;
import com.digiwin.dap.middleware.iam.domain.ground.dto.PurchaseTicketDTO;
import com.digiwin.dap.middleware.iam.domain.ground.dto.RegisterDTO;
import com.digiwin.dap.middleware.iam.domain.ground.dto.RegisterDmcDirectoryDTO;
import com.digiwin.dap.middleware.iam.domain.ground.dto.RegisterGoodsInfoDTO;
import com.digiwin.dap.middleware.iam.domain.ground.dto.RegisterLicenseDTO;
import com.digiwin.dap.middleware.iam.domain.ground.vo.RegisterInfoVO;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.service.tenant.PurchaseApplicationService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.support.remote.CacService;
import com.digiwin.dap.middleware.iam.support.remote.DmcService;
import com.digiwin.dap.middleware.iam.support.remote.OmcService;
import com.digiwin.dap.middleware.iam.support.remote.domain.AuthorizationModuleVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.CacAuth;
import com.digiwin.dap.middleware.iam.support.remote.domain.gmc.CustomAttributes;
import com.digiwin.dap.middleware.iam.support.remote.domain.gmc.Goods;
import com.digiwin.dap.middleware.iam.support.remote.domain.gmc.SellingStrategyVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.ground.PurchaseRegisterDMCBucketDTO;
import com.digiwin.dap.middleware.iam.support.remote.domain.ground.PurchaseRegisterDMCUserDTO;
import com.digiwin.dap.middleware.iam.support.remote.domain.ground.PurchaseRegisterDmcDirectoryDTO;
import com.digiwin.dap.middleware.iam.support.remote.domain.ground.PurchaseRegisterInfoDTO;
import com.digiwin.dap.middleware.util.DateUtils;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import com.fasterxml.jackson.core.type.TypeReference;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/api/iam/v2/ground"})
public class GroundController {
    private static final Logger logger = LoggerFactory.getLogger(GroundController.class);
    @Autowired
    private CacService cacService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private PurchaseApplicationService purchaseApplicationService;
    @Autowired
    private OmcService omcService;
    @Autowired
    private DmcService dmcService;
    @Autowired
    private ApplicationContext applicationContext;

    @PostMapping(value={"/parse/file"})
    public StdData parseFile(@RequestPart(value="fpxFile") MultipartFile fpxFile, @RequestPart(value="ticketFile") MultipartFile ticketFile) {
        try {
            byte[] fpxByte = fpxFile.getBytes();
            String salt = Base64.getEncoder().encodeToString(fpxByte);
            byte[] buffer = Base64.getDecoder().decode(ticketFile.getBytes());
            byte[] contentBytes = GroundController.decrypt((byte[])buffer, (String)salt);
            String content = new String(contentBytes);
            PurchaseTicketDTO purchaseTicketDTO = (PurchaseTicketDTO)JsonUtils.jsonToObj((String)content, PurchaseTicketDTO.class);
            Long registerId = purchaseTicketDTO.getPurchaseId();
            RegisterDTO registerDTO = this.buildRegisterDTO(purchaseTicketDTO);
            String registerCode = Base64.getEncoder().encodeToString(JsonUtils.objToJson((Object)registerDTO).getBytes(StandardCharsets.UTF_8));
            return StdData.ok((Object)new RegisterInfoVO(registerCode, registerId));
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
    }

    private RegisterDTO buildRegisterDTO(PurchaseTicketDTO purchaseTicketDTO) {
        if (purchaseTicketDTO == null) {
            return null;
        }
        RegisterDTO registerDTO = new RegisterDTO();
        registerDTO.setPurchaseTicketId(purchaseTicketDTO.getSid());
        registerDTO.setPurchaseId(purchaseTicketDTO.getPurchaseId());
        registerDTO.setCustomerId(purchaseTicketDTO.getCustomerId());
        registerDTO.setPurchaseType(purchaseTicketDTO.getPurchaseType());
        registerDTO.setProductName(purchaseTicketDTO.getProductName());
        registerDTO.setProductVersion(purchaseTicketDTO.getProductVersion());
        registerDTO.setPurchaseMemo(purchaseTicketDTO.getPurchaseMemo());
        return registerDTO;
    }

    @PostMapping(value={"/auth"})
    public StdData auth(@RequestPart(value="fpxFile") MultipartFile fpxFile, @RequestPart(value="licenseFile") MultipartFile licenseFile, @RequestPart(value="tenantId") String tenantId, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Tenant tenant = (Tenant)this.tenantCrudService.findById(tenantId);
        if (Objects.isNull(tenant)) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{tenantId});
        }
        try {
            byte[] fpxByte = fpxFile.getBytes();
            String salt = Base64.getEncoder().encodeToString(fpxByte);
            byte[] licenseBuffer = Base64.getDecoder().decode(licenseFile.getBytes());
            byte[] licenseContentBytes = GroundController.decrypt((byte[])licenseBuffer, (String)salt);
            String licenseContent = new String(licenseContentBytes);
            RegisterLicenseDTO registerLicenseDTO = (RegisterLicenseDTO)JsonUtils.jsonToObj((String)licenseContent, RegisterLicenseDTO.class);
            logger.info("\u8bc1\u4e66\u5185\u5bb9:{}", (Object)JsonUtils.objToJson((Object)registerLicenseDTO));
            AppController appController = (AppController)this.applicationContext.getBean(AppController.class);
            registerLicenseDTO.getPurchaseGoodInfo().forEach(purchaseGoodInfo -> {
                logger.info("\u51fa\u8d27\u4fe1\u606f:{}", (Object)JsonUtils.objToJson((Object)purchaseGoodInfo));
                if (purchaseGoodInfo.getCategoryId().equals("app")) {
                    SysCascadeVO sysCascadeVO = this.buildSysCascadeVO(purchaseGoodInfo);
                    logger.info("\u540c\u6b65\u5e94\u7528\u4fe1\u606f\u53c2\u6570:{}", (Object)JsonUtils.objToJson((Object)sysCascadeVO));
                    appController.updateLanguageApplication(sysCascadeVO);
                    ArrayList<SysVO> sysVOS = new ArrayList<SysVO>();
                    SysVO sysVO = new SysVO();
                    sysVO.setId(purchaseGoodInfo.getProductId());
                    sysVOS.add(sysVO);
                    logger.info("\u540c\u6b65\u5e94\u7528\u79df\u6237\u5173\u7cfb\u4fe1\u606f\u53c2\u6570:{}", (Object)JsonUtils.objToJson(sysVOS));
                    this.purchaseApplicationService.purchaseApplicationList(tenantId, authoredUser.getUserId(), sysVOS, Boolean.valueOf(false));
                    CacAuth cacAuth = this.buildCacAuth(purchaseGoodInfo, tenant);
                    logger.info("\u6ce8\u518c\u5e94\u7528\u6388\u6743\u4fe1\u606f\u53c2\u6570:{}", (Object)JsonUtils.objToJson((Object)cacAuth));
                    this.cacService.purchaseOrUpdateApp(cacAuth);
                }
                if (purchaseGoodInfo.getCategoryId().equals("device")) {
                    List<PurchaseRegisterInfoDTO> purchaseRegisterInfoDTOList = Collections.singletonList(this.buildPurchaseRegisterInfoDTO(tenant, registerLicenseDTO, purchaseGoodInfo));
                    logger.info("\u5f00\u901a\u8bbe\u5907\u6570\u636e\u53c2\u6570:{}", (Object)JsonUtils.objToJson(purchaseRegisterInfoDTOList));
                    this.omcService.registerDevice(purchaseRegisterInfoDTOList);
                }
                try {
                    if (StringUtils.hasLength((String)purchaseGoodInfo.getDmcUser()) && StringUtils.hasLength((String)purchaseGoodInfo.getDmcPassword())) {
                        this.dmcService.createUser(this.buildPurchaseRegisterDMCUserDTO(purchaseGoodInfo));
                        if (StringUtils.hasLength((String)purchaseGoodInfo.getDmcBucket())) {
                            this.dmcService.createBucket(this.buildPurchaseRegisterDMCBucketDTO(purchaseGoodInfo));
                            if (!CollectionUtils.isEmpty((Collection)purchaseGoodInfo.getDirectories())) {
                                purchaseGoodInfo.getDirectories().forEach(directory -> this.dmcService.createDirectory(purchaseGoodInfo.getDmcBucket(), this.buildPurchaseRegisterDmcDirectoryDTO(directory)));
                            }
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("dmc\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
                }
            });
            return StdData.ok().build();
        }
        catch (Exception e) {
            logger.error("\u6388\u6743\u5f02\u5e38", (Throwable)e);
            throw new BusinessException(e.getMessage());
        }
    }

    private PurchaseRegisterDmcDirectoryDTO buildPurchaseRegisterDmcDirectoryDTO(RegisterDmcDirectoryDTO registerDmcDirectoryDTO) {
        PurchaseRegisterDmcDirectoryDTO dto = new PurchaseRegisterDmcDirectoryDTO();
        dto.setId(registerDmcDirectoryDTO.getId());
        dto.setName(registerDmcDirectoryDTO.getName());
        dto.setParentId(registerDmcDirectoryDTO.getParentId());
        dto.setRemark(registerDmcDirectoryDTO.getRemark());
        return dto;
    }

    private PurchaseRegisterDMCBucketDTO buildPurchaseRegisterDMCBucketDTO(RegisterGoodsInfoDTO registerGoodsInfoDTO) {
        PurchaseRegisterDMCBucketDTO dto = new PurchaseRegisterDMCBucketDTO();
        dto.setOwner(registerGoodsInfoDTO.getDmcUser());
        dto.setName(registerGoodsInfoDTO.getDmcBucket());
        return dto;
    }

    private PurchaseRegisterDMCUserDTO buildPurchaseRegisterDMCUserDTO(RegisterGoodsInfoDTO registerGoodsInfoDTO) {
        if (!(StringUtils.hasLength((String)registerGoodsInfoDTO.getDmcUser()) && StringUtils.hasLength((String)registerGoodsInfoDTO.getDmcPassword()) && StringUtils.hasLength((String)registerGoodsInfoDTO.getDmcBucket()))) {
            return null;
        }
        PurchaseRegisterDMCUserDTO dto = new PurchaseRegisterDMCUserDTO();
        dto.setPwdHash(registerGoodsInfoDTO.getDmcPassword());
        dto.setName(registerGoodsInfoDTO.getDmcUser());
        return dto;
    }

    private PurchaseRegisterInfoDTO buildPurchaseRegisterInfoDTO(Tenant tenant, RegisterLicenseDTO registerLicenseDTO, RegisterGoodsInfoDTO registerGoodsInfoDTO) {
        PurchaseRegisterInfoDTO purchaseRegisterInfoDTO = new PurchaseRegisterInfoDTO();
        purchaseRegisterInfoDTO.setTenantSid(Long.valueOf(tenant.getSid()));
        purchaseRegisterInfoDTO.setTenantId(tenant.getId());
        purchaseRegisterInfoDTO.setCustomerId(registerLicenseDTO.getCustomerSerial());
        purchaseRegisterInfoDTO.setTenantName(registerLicenseDTO.getCustomerName());
        purchaseRegisterInfoDTO.setPurchaseId(String.valueOf(registerLicenseDTO.getPurchaseId()));
        purchaseRegisterInfoDTO.setPurchaseUserCount(registerGoodsInfoDTO.getPurchaseUserCount());
        purchaseRegisterInfoDTO.setPurchaseDetail(registerGoodsInfoDTO.getPurchaseDetail());
        purchaseRegisterInfoDTO.setProductId(registerGoodsInfoDTO.getProductId());
        purchaseRegisterInfoDTO.setProductName(registerGoodsInfoDTO.getProductName());
        purchaseRegisterInfoDTO.setExpiredTime(registerGoodsInfoDTO.getExpiredTime());
        purchaseRegisterInfoDTO.setPurchaseModuleName(registerGoodsInfoDTO.getPurchaseModuleName());
        purchaseRegisterInfoDTO.setPlatformInfos(registerGoodsInfoDTO.getPlatformInfos());
        purchaseRegisterInfoDTO.setPaymentType(registerGoodsInfoDTO.getPaymentType());
        purchaseRegisterInfoDTO.setCustomUnit(registerGoodsInfoDTO.getCustomUnit());
        purchaseRegisterInfoDTO.setCategoryId(registerGoodsInfoDTO.getCategoryId());
        purchaseRegisterInfoDTO.setCloud(registerGoodsInfoDTO.getCloud());
        return purchaseRegisterInfoDTO;
    }

    private CacAuth buildCacAuth(RegisterGoodsInfoDTO registerGoodsInfoDTO, Tenant tenant) {
        CacAuth cacAuth = new CacAuth();
        cacAuth.setTenantSid(Long.valueOf(tenant.getSid()));
        cacAuth.setTenantId(tenant.getId());
        cacAuth.setTenantName(tenant.getName());
        ArrayList<Goods> authorizations = new ArrayList<Goods>();
        Goods goods = new Goods();
        goods.setId(Long.valueOf(SnowFlake.getInstance().newId()));
        goods.setCode(registerGoodsInfoDTO.getProductId());
        goods.setItemId(registerGoodsInfoDTO.getProductId());
        goods.setDisplayName(registerGoodsInfoDTO.getProductName());
        goods.setPaymentType(Integer.valueOf(registerGoodsInfoDTO.getPaymentType()));
        goods.setVersion("1.0.0.0");
        goods.setMultiLogin(Boolean.valueOf(false));
        goods.setGround(Boolean.valueOf(false));
        goods.setOverlayTenancyPeriod(Boolean.valueOf(false));
        goods.setOrderSource(AuthCategory.BossManualAuthorization.name());
        goods.setCategoryId(registerGoodsInfoDTO.getCategoryId());
        goods.setCloud(registerGoodsInfoDTO.getCloud());
        goods.setCustomUnit(registerGoodsInfoDTO.getCustomUnit());
        goods.setTotalCount(Long.valueOf(registerGoodsInfoDTO.getPurchaseUserCount().longValue()));
        goods.setOrderNumber(Integer.valueOf(1));
        goods.setTotalUsage(Long.valueOf(registerGoodsInfoDTO.getPurchaseUserCount().longValue()));
        goods.setRemainingUsage(registerGoodsInfoDTO.getPurchaseUserCount());
        goods.setCategory(Integer.valueOf(3));
        if (Objects.nonNull(registerGoodsInfoDTO.getExpiredTime())) {
            goods.setExpiredTime(registerGoodsInfoDTO.getExpiredTime());
        } else {
            goods.setExpiredTime(DateUtils.parseLocalTime((String)"9999-12-31 00:00:00"));
        }
        SellingStrategyVO sellingStrategyVO = new SellingStrategyVO();
        sellingStrategyVO.setId(Long.valueOf(SnowFlake.getInstance().newId()));
        sellingStrategyVO.setCode(registerGoodsInfoDTO.getProductId());
        sellingStrategyVO.setGoodsCode(registerGoodsInfoDTO.getProductId());
        sellingStrategyVO.setName(registerGoodsInfoDTO.getProductName());
        sellingStrategyVO.setDescription(registerGoodsInfoDTO.getProductName());
        if (Objects.nonNull(registerGoodsInfoDTO.getPurchaseUserCount())) {
            sellingStrategyVO.setUsersNumber(Long.valueOf(registerGoodsInfoDTO.getPurchaseUserCount().intValue()));
        }
        ArrayList enabledModules = new ArrayList();
        registerGoodsInfoDTO.getPurchaseModule().forEach(module -> {
            if (Objects.nonNull(module.getEnable()) && module.getEnable().booleanValue()) {
                AuthorizationModuleVO enabledModule = new AuthorizationModuleVO();
                enabledModule.setId(module.getId());
                enabledModule.setName(module.getName());
                enabledModules.add(enabledModule);
            }
        });
        sellingStrategyVO.setEnabledModules(enabledModules);
        ArrayList customAttributes = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)registerGoodsInfoDTO.getPurchaseDetail())) {
            registerGoodsInfoDTO.getPurchaseDetail().forEach(purchaseDetail -> {
                for (AuthorizationModuleVO authorizationModule : enabledModules) {
                    if (!Objects.equals(authorizationModule.getId(), purchaseDetail.getModuleId())) continue;
                    CustomAttributes customAttribute = new CustomAttributes();
                    customAttribute.setId(purchaseDetail.getId());
                    customAttribute.setName(purchaseDetail.getName());
                    customAttribute.setModuleId(purchaseDetail.getModuleId());
                    customAttribute.setValue(purchaseDetail.getValue());
                    customAttributes.add(customAttribute);
                }
            });
        }
        sellingStrategyVO.setCustomAttributes(customAttributes);
        goods.setSellingStrategy(sellingStrategyVO);
        authorizations.add(goods);
        cacAuth.setAuthorizations(authorizations);
        return cacAuth;
    }

    private SysCascadeVO buildSysCascadeVO(RegisterGoodsInfoDTO dto) {
        try {
            if (dto == null) {
                return null;
            }
            Map purchaseModuleNameMap = (Map)JsonUtils.createObjectMapper().convertValue(dto.getPurchaseModuleName(), Map.class);
            String appToken = purchaseModuleNameMap.getOrDefault("appToken", "");
            String app = JsonUtils.createObjectMapper().writeValueAsString(purchaseModuleNameMap.getOrDefault("app", new HashMap()));
            String modules = JsonUtils.createObjectMapper().writeValueAsString((Object)purchaseModuleNameMap.getOrDefault("modules", "[]"));
            String actions = JsonUtils.createObjectMapper().writeValueAsString((Object)purchaseModuleNameMap.getOrDefault("actions", "[]"));
            SysCascadeVO vo = new SysCascadeVO();
            vo.setAppToken(appToken);
            SysVO sysVO = (SysVO)JsonUtils.jsonToObj((String)app, SysVO.class);
            sysVO.setAppToken(appToken);
            sysVO.setLinked(dto.getLinked());
            sysVO.setShowEntry(dto.getShowEntry());
            sysVO.setShowConsolePolicy(dto.getShowConsolePolicy());
            sysVO.setActionFilterUrl(dto.getActionFilterUrl());
            vo.setApp(sysVO);
            List moduleList = (List)JsonUtils.jsonToObj((String)modules, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            vo.setModules(moduleList);
            List actionList = (List)JsonUtils.jsonToObj((String)actions, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            vo.setActions(actionList);
            return vo;
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
    }

    private static byte[] decrypt(byte[] content, String salt) {
        if (salt == null) {
            salt = System.getProperty("AES_SYS_KEY");
        }
        if (salt == null || salt.trim().length() == 0) {
            salt = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz";
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-512");
            byte[] generatedKeys = messageDigest.digest(salt.getBytes("UTF-8"));
            byte[] key = new byte[32];
            byte[] iv = new byte[16];
            System.arraycopy(generatedKeys, 0, key, 0, key.length);
            System.arraycopy(generatedKeys, key.length, iv, 0, iv.length);
            SecretKeySpec secretKeySpec = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
            cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
            return cipher.doFinal(content);
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
    }
}

