/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import com.digiwin.dap.middle.encrypt.domain.annotation.DapSign;
import com.digiwin.dap.middle.kms.constants.KeyConstant;
import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.AuthoredDevice;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middleware.commons.crypto.PwdUtils;
import com.digiwin.dap.middleware.commons.crypto.RSA;
import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.domain.ComeFromEnum;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.cache.UserTempTokenCacheVO;
import com.digiwin.dap.middleware.iam.domain.login.CrossRegionLoginInnerRequest;
import com.digiwin.dap.middleware.iam.domain.login.CrossRegionLoginRequest;
import com.digiwin.dap.middleware.iam.domain.login.EncryptAesDTO;
import com.digiwin.dap.middleware.iam.domain.login.IdentityInfo;
import com.digiwin.dap.middleware.iam.domain.login.IdentityType;
import com.digiwin.dap.middleware.iam.domain.login.LoginSource;
import com.digiwin.dap.middleware.iam.domain.login.LoginUser;
import com.digiwin.dap.middleware.iam.domain.login.OauthLoginRequest;
import com.digiwin.dap.middleware.iam.domain.login.SsoLoginInfo;
import com.digiwin.dap.middleware.iam.domain.logout.LogoutInfo;
import com.digiwin.dap.middleware.iam.domain.token.AgentUserTokenVo;
import com.digiwin.dap.middleware.iam.domain.token.ChangedTokenVO;
import com.digiwin.dap.middleware.iam.domain.token.GrantTypeInfo;
import com.digiwin.dap.middleware.iam.domain.token.LoginAuthInfo;
import com.digiwin.dap.middleware.iam.domain.token.OtaResultVO;
import com.digiwin.dap.middleware.iam.domain.token.UserTokenVo;
import com.digiwin.dap.middleware.iam.domain.user.DingTalkImportInfo;
import com.digiwin.dap.middleware.iam.domain.user.DingTalkUserInfo;
import com.digiwin.dap.middleware.iam.domain.user.LoginByTempTokenVO;
import com.digiwin.dap.middleware.iam.domain.usermapping.UserMappingQueryResultVO;
import com.digiwin.dap.middleware.iam.entity.OtaToken;
import com.digiwin.dap.middleware.iam.entity.SyncTenantAuthScope;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserInTenant;
import com.digiwin.dap.middleware.iam.mapper.LoginMapper;
import com.digiwin.dap.middleware.iam.repository.SyncTenantAuthScopeRepository;
import com.digiwin.dap.middleware.iam.repository.UserRepository;
import com.digiwin.dap.middleware.iam.service.WhiteListService;
import com.digiwin.dap.middleware.iam.service.login.AuthoredUserService;
import com.digiwin.dap.middleware.iam.service.login.IdentityService;
import com.digiwin.dap.middleware.iam.service.login.LoginFailureHandlingService;
import com.digiwin.dap.middleware.iam.service.notice.SysNoticeService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.token.AppSSOService;
import com.digiwin.dap.middleware.iam.service.token.OtaTokenCrudService;
import com.digiwin.dap.middleware.iam.service.token.OtaTokenService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import com.digiwin.dap.middleware.iam.service.usermapping.UserMappingCrudService;
import com.digiwin.dap.middleware.iam.service.usermapping.UserMappingService;
import com.digiwin.dap.middleware.iam.support.auth.domain.IamAuthoredUser;
import com.digiwin.dap.middleware.iam.support.cache.CommonCacheService;
import com.digiwin.dap.middleware.iam.support.exception.IncorrectUsernameOrPasswordException;
import com.digiwin.dap.middleware.iam.support.initialize.ImportDataService;
import com.digiwin.dap.middleware.iam.support.oauth.ThirdOauthService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteIamService;
import com.digiwin.dap.middleware.iam.support.remote.domain.cac.CountResultVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.huawei.OAuthLoginInfo;
import com.digiwin.dap.middleware.iam.support.validate.AuthValidateService;
import com.digiwin.dap.middleware.iam.support.validate.LoginCheckService;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import eu.bitwalker.useragentutils.DeviceType;
import io.github.resilience4j.ratelimiter.annotation.RateLimiter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2/identity"})
public class IdentityController {
    private static final Logger logger = LoggerFactory.getLogger(IdentityController.class);
    @Autowired
    private LoginMapper loginMapper;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private UserMappingService userMappingService;
    @Autowired
    @Qualifier(value="defaultIdentityService")
    private IdentityService defaultIdentityService;
    @Autowired
    @Qualifier(value="faceRecognitionKeyIdentityService")
    private IdentityService faceRecognitionIdentityService;
    @Autowired
    @Qualifier(value="internalIdentityService")
    private IdentityService internalIdentityService;
    @Autowired
    @Qualifier(value="adIdentityService")
    private IdentityService adIdentityService;
    @Autowired
    private List<IdentityService> identityServices;
    @Autowired
    private AuthoredUserService authoredUserService;
    @Autowired
    private LoginFailureHandlingService loginFailureHandlingService;
    @Autowired
    private OtaTokenService otaTokenService;
    @Autowired
    private OtaTokenCrudService otaTokenCrudService;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    @Qualifier(value="oauthIdentityService")
    private IdentityService oauthIdentityService;
    @Autowired
    private List<ThirdOauthService> thirdOauthServices;
    @Autowired
    @Qualifier(value="agentIdentityService")
    private IdentityService agentIdentityService;
    @Autowired
    @Qualifier(value="tempUserTokenService")
    private IdentityService tempUserTokenService;
    @Autowired
    private SyncTenantAuthScopeRepository syncTenantAuthScopeRepository;
    @Autowired
    private ImportDataService importDataService;
    @Autowired
    private UserMappingCrudService userMappingCrudService;
    @Autowired
    private AppSSOService appSSOService;
    @Autowired
    private LoginCheckService loginCheckService;
    @Autowired
    private AuthValidateService authValidateService;
    @Autowired
    private SysNoticeService sysNoticeService;
    @Autowired
    private RemoteIamService remoteIamService;
    @Autowired
    private CommonCacheService commonCacheService;
    @Autowired
    private WhiteListService whiteListService;
    @Autowired
    private UserInTenantCrudService userInTenantCrudService;

    @PostMapping(value={"/aeskey"})
    @RateLimiter(name="/api/iam/v2/identity/aeskey")
    public ResponseEntity<?> getEncryptAesKey(@Valid @RequestBody EncryptAesDTO input) throws Exception {
        String clientPublicKey = RSA.decrypt((String)input.getClientEncryptPublicKey(), (String)KeyConstant.BASE64_PRIVATE_KEY);
        String aesKey = PwdUtils.getAesKey((String)clientPublicKey);
        String encryptAesKey = RSA.encrypt((String)aesKey, (String)clientPublicKey);
        return ResponseEntity.ok(Collections.singletonMap("encryptAesKey", encryptAesKey));
    }

    @PostMapping(value={"/login"}, produces={"application/json; charset=utf-8"})
    @RateLimiter(name="/api/iam/v2/identity/login")
    public ResponseEntity<?> login(@RequestBody LoginUser loginUser, @RequestAttribute(value="digi-middleware-auth-app-data", required=false) AuthoredSys sys, @RequestAttribute(value="digi-middleware-device-id-data", required=false) AuthoredDevice device, HttpServletRequest request) {
        loginUser.setDevice(device);
        if (Strings.isNotBlank((String)loginUser.getUserId()) && !IdentityType.secretKey.equals((Object)loginUser.getIdentityType()) && !IdentityType.verificationCode.equals((Object)loginUser.getIdentityType())) {
            User user;
            this.loginFailureHandlingService.checkFrozen(loginUser.getUserId(), loginUser.getCode(), loginUser.getValue());
            if (!this.envProperties.getPasswordOpen().booleanValue()) {
                boolean checkAuth;
                boolean bl = checkAuth = this.authValidateService.checkAccessPermission(TargetType.Sys.name(), "POST", "/api/iam/v2/identity/login", sys.getId()) == false;
                if (ObjectUtils.isEmpty((Object)loginUser.getPasswordHash()) && checkAuth) {
                    logger.error(I18nError.IAM_LOGIN_PARAM_MISS.getMessage(new Object[]{"passwordHash", JsonUtils.objToJson((Object)loginUser)}));
                    throw new BusinessException((ErrorHandler)I18nError.LOGIN_USERNAME_PASSWORD_ENCRYPT_ERROR);
                }
                if (Strings.isBlank((String)loginUser.getClientEncryptPublicKey()) && checkAuth) {
                    logger.error(I18nError.IAM_LOGIN_PARAM_MISS.getMessage(new Object[]{"clientEncryptPublicKey", JsonUtils.objToJson((Object)loginUser)}));
                    throw new BusinessException((ErrorHandler)I18nError.IAM_PARAM_FIELD_MISS, new Object[]{"clientEncryptPublicKey"});
                }
            }
            if (IdentityType.service.equals((Object)loginUser.getIdentityType()) && "digiwin".equals(loginUser.getServiceName())) {
                if (!loginUser.getUserId().toLowerCase().endsWith("@digiwin.com")) {
                    String userId = String.format("%s@digiwin.com", loginUser.getUserId());
                    user = this.userCrudService.queryUserByIdOrEmailOrTelephoneAndType(userId, userId, userId, Integer.valueOf(0));
                } else {
                    user = this.userCrudService.queryUserByIdOrEmailOrTelephoneAndType(loginUser.getUserId(), loginUser.getUserId(), loginUser.getUserId(), Integer.valueOf(0));
                }
            } else {
                user = this.userCrudService.queryUserByIdOrEmailOrTelephoneAndType(loginUser.getUserId(), loginUser.getUserId(), loginUser.getUserId(), Integer.valueOf(0));
            }
            if (user != null) {
                if ("virtual".equals(user.getId())) {
                    throw new BusinessException((ErrorHandler)I18nError.LOGIN_VIRTUAL_LOGIN_ERROR, new Object[]{user.getId()});
                }
                loginUser.setUser(user);
                loginUser.setUserId(user.getId());
            }
            if (0 == this.envProperties.getCloud()) {
                boolean cloudAd;
                boolean bl = cloudAd = user != null && (user.getId().toLowerCase().endsWith("@digiwin.com") || "digiwin-ad".equalsIgnoreCase(user.getComeFrom())) || user == null && loginUser.getUserId().toLowerCase().endsWith("@digiwin.com");
                if (cloudAd) {
                    loginUser.setIdentityType(IdentityType.service);
                    loginUser.setServiceName("digiwin");
                }
            }
            if (sys != null) {
                loginUser.setApp(new Sys(sys));
            }
        }
        if (IdentityType.verificationCode.equals((Object)loginUser.getIdentityType())) {
            String userToken = request.getHeader(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY);
            if (!ObjectUtils.isEmpty((Object)userToken)) {
                loginUser.setUserToken(userToken);
            }
            if (sys != null) {
                loginUser.setApp(new Sys(sys));
            }
        }
        for (IdentityService identityService : this.identityServices) {
            if (!identityService.support(loginUser)) continue;
            try {
                IamAuthoredUser authoredUser = identityService.login(loginUser);
                return ResponseEntity.ok((Object)authoredUser);
            }
            catch (IncorrectUsernameOrPasswordException e) {
                this.loginFailureHandlingService.frozen(loginUser.getUserId(), Integer.valueOf(0), e.getMessage());
            }
        }
        throw new BusinessException((ErrorHandler)I18nError.LOGIN_TYPE_NO_SUPPORT, new Object[]{loginUser.getIdentityType(), loginUser.getServiceName()});
    }

    @PostMapping(value={"/login/internal"})
    @RateLimiter(name="/api/iam/v2/identity/login/internal")
    public ResponseEntity<?> loginInternal(@RequestBody LoginUser loginUser, @RequestAttribute(value="digi-middleware-auth-app-data") AuthoredSys sys) {
        loginUser.setApp(sys == null ? null : new Sys(sys));
        loginUser.setIdentityType(IdentityType.internal);
        IamAuthoredUser authoredUser = this.internalIdentityService.login(loginUser);
        return ResponseEntity.ok((Object)authoredUser);
    }

    @PostMapping(value={"/internal/login"})
    public ResponseEntity<?> internalLogin(@RequestBody LoginUser loginUser, @RequestAttribute(value="digi-middleware-auth-app-data", required=false) AuthoredSys sys, @RequestAttribute(value="digi-middleware-device-id-data", required=false) AuthoredDevice device, HttpServletRequest request) {
        loginUser.setDevice(device);
        if (loginUser.getIdentityType() == null) {
            loginUser.setIdentityType(IdentityType.token);
        }
        if (Strings.isEmpty((CharSequence)loginUser.getUserId())) {
            throw new BusinessException((ErrorHandler)I18nError.LOGIN_USER_ID_NOT_EMPTY);
        }
        if (!this.envProperties.getPasswordOpen().booleanValue() && ObjectUtils.isEmpty((Object)loginUser.getPasswordHash())) {
            throw new BusinessException((ErrorHandler)I18nError.LOGIN_USERNAME_PASSWORD_ENCRYPT_ERROR);
        }
        Tenant tenant = loginUser.getTenant();
        if (Strings.isEmpty((CharSequence)loginUser.getTenantId())) {
            if (loginUser.getTenantSid() > 0L && (tenant = (Tenant)this.tenantCrudService.findBySid(loginUser.getTenantSid())) != null) {
                loginUser.setTenant(tenant);
                loginUser.setTenantId(tenant.getId());
            }
            if (ObjectUtils.isEmpty((Object)loginUser.getTenantId())) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_TENANT_ID_EMPTY);
            }
        }
        if (null == tenant) {
            tenant = (Tenant)this.tenantCrudService.findById(loginUser.getTenantId());
        }
        if (null == tenant) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{loginUser.getTenantId()});
        }
        loginUser.setTenant(tenant);
        if (sys != null && "ISV".equals(sys.getId()) && !tenant.isIsv()) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_TYPE_NOT_SERVICER, new Object[]{loginUser.getTenantId()});
        }
        loginUser.setApp(new Sys(sys));
        this.loginCheckService.checkIP(loginUser.getIdentityType(), tenant, loginUser.getApp());
        String userId = String.format("%s$%s", loginUser.getTenantId(), loginUser.getUserId());
        User user = this.loginMapper.findInnerUserByIdOrEmailOrTel(userId, loginUser.getUserId(), loginUser.getUserId(), loginUser.getTenantId());
        loginUser.setUser(user);
        if (IdentityType.ad.equals((Object)loginUser.getIdentityType())) {
            if (user != null) {
                loginUser.setUserId(user.getId().split("\\$")[1]);
            }
        } else {
            if (user == null) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_GROUND_LOGIN_21001, new Object[]{loginUser.getTenantId(), loginUser.getUserId()});
            }
            if (IdentityType.ad.name().equals(user.getComeFrom()) && tenant.isAdLogin()) {
                throw new BusinessException((ErrorHandler)I18nError.IAM_LOGIN_USER_AD_DOMAIN_TYPE_SUPPORT_ERROR);
            }
            loginUser.setUserId(user.getId());
            this.loginFailureHandlingService.checkFrozenInner(loginUser.getUserId(), loginUser.getCode(), loginUser.getValue());
        }
        IamAuthoredUser authoredUser = null;
        if (this.defaultIdentityService.support(loginUser)) {
            try {
                authoredUser = this.defaultIdentityService.login(loginUser);
            }
            catch (IncorrectUsernameOrPasswordException e) {
                this.loginFailureHandlingService.freezeInner(loginUser.getUserId(), tenant);
            }
        } else if (this.faceRecognitionIdentityService.support(loginUser)) {
            authoredUser = this.faceRecognitionIdentityService.login(loginUser);
        } else if (this.adIdentityService.support(loginUser)) {
            authoredUser = this.adIdentityService.login(loginUser);
        }
        if (authoredUser != null) {
            RedisUtils.delete((String)("iam:failure:login:" + userId.toLowerCase()));
            return ResponseEntity.ok((Object)authoredUser);
        }
        throw new BusinessException((ErrorHandler)I18nError.LOGIN_TYPE_NO_SUPPORT, new Object[]{loginUser.getIdentityType()});
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/logout"}, produces={"application/json; charset=utf-8"})
    public StdData<?> logout(@RequestAttribute(value="digi-middleware-auth-user-data") IamAuthoredUser authoredUser, @RequestAttribute(value="digi-middleware-auth-app-data", required=false) AuthoredSys sys, @RequestBody(required=false) LogoutInfo logoutInfo) {
        List whiteApps;
        String sysId;
        if (!StringUtils.hasText((String)authoredUser.getToken())) {
            return StdData.ok().build();
        }
        boolean clearAll = false;
        if (Objects.nonNull(logoutInfo) && Boolean.TRUE.equals(logoutInfo.getClearAll())) {
            clearAll = true;
        }
        String string = sysId = sys == null ? "" : sys.getId();
        if ("virtual".equalsIgnoreCase(authoredUser.getUserId()) || "integration".equalsIgnoreCase(authoredUser.getUserId())) {
            return StdData.ok().build();
        }
        if (!clearAll && !DeviceType.MOBILE.equals((Object)authoredUser.getDeviceType()) && !CollectionUtils.isEmpty((Collection)(whiteApps = this.whiteListService.getWhiteList("SINGLE_LOGOUT_WHITE_APPS"))) && whiteApps.contains(sysId)) {
            return StdData.ok().build();
        }
        logger.info("\u7528\u6237[{}]\u767b\u51fa\u5e94\u7528[{}]\uff01", (Object)authoredUser.getUserId(), (Object)sysId);
        this.authoredUserService.logout(authoredUser, sysId, clearAll);
        return StdData.ok().build();
    }

    @RequestMapping(value={"/publickey"}, method={RequestMethod.GET})
    @RateLimiter(name="/api/iam/v2/identity/publickey")
    public ResponseEntity<?> getPublicKey() {
        return ResponseEntity.ok(Collections.singletonMap("publicKey", KeyConstant.BASE64_PUBLIC_KEY));
    }

    @PostMapping(value={"/token/analyze"}, produces={"application/json; charset=utf-8"})
    @RateLimiter(name="/api/iam/v2/identity/token/analyze")
    public ResponseEntity<?> analyzeAccessToken(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        return ResponseEntity.ok((Object)new UserTokenVo((IamAuthoredUser)authoredUser));
    }

    @PostMapping(value={"/token/analyze/get/agent"}, produces={"application/json; charset=utf-8"})
    public ResponseEntity<?> analyzeAgentAccessToken(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        AgentUserTokenVo userTokenVo = new AgentUserTokenVo((IamAuthoredUser)authoredUser);
        if (ObjectUtils.isEmpty((Object)userTokenVo.getAgentUserId())) {
            throw new BusinessException((ErrorHandler)I18nError.AGENT_USER_ID_EMPTY);
        }
        User user = (User)this.userRepository.findById(userTokenVo.getAgentUserId());
        if (null == user) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST, new Object[]{userTokenVo.getAgentUserId()});
        }
        userTokenVo.setAgentUserName(user.getName());
        return ResponseEntity.ok((Object)userTokenVo);
    }

    @GetMapping(value={"/token/analyze/internal"})
    @RateLimiter(name="/api/iam/v2/identity/token/analyze/internal")
    public ResponseEntity<?> analyzeToken(@RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser authoredUser, @RequestAttribute(value="digi-middleware-auth-app-data", required=false) AuthoredSys authoredSys) {
        UserTokenVo loginUser = authoredUser != null ? new UserTokenVo((IamAuthoredUser)authoredUser) : new UserTokenVo();
        loginUser.setSys(authoredSys);
        return ResponseEntity.ok((Object)loginUser);
    }

    @PostMapping(value={"/login/info"}, produces={"application/json; charset=utf-8"})
    public ResponseEntity<?> getAuthoredUser(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        IamAuthoredUser iamAuthoredUser = (IamAuthoredUser)authoredUser;
        this.authoredUserService.resetUserMetadata(iamAuthoredUser);
        return ResponseEntity.ok((Object)iamAuthoredUser);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/token/grant/access"}, produces={"application/json; charset=utf-8"})
    @RateLimiter(name="/api/iam/v2/identity/token/grant/access")
    public ResponseEntity<?> createAccessToken(@RequestBody GrantTypeInfo grantTypeInfo, HttpServletRequest request) {
        if ("verifyUser_credentials".equals(grantTypeInfo.getGrantType())) {
            if (request.getRequestURI().contains("/api/v1/iam") && ObjectUtils.isEmpty((Object)grantTypeInfo.getTenantId())) {
                grantTypeInfo.setTenantId("default");
            }
            IamAuthoredUser iamAuthoredUser = this.authoredUserService.getByGrantTypeInfo(grantTypeInfo);
            return ResponseEntity.ok((Object)iamAuthoredUser);
        }
        throw new BusinessException((ErrorHandler)I18nError.ACCESS_TOKEN_GRANT_TYPE_ERROR);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/token/refresh/tenant"}, produces={"application/json; charset=utf-8"})
    public ResponseEntity<?> refreshUserTokenWithTenant(HttpServletRequest request, @RequestBody LoginUser loginUser, @RequestAttribute(value="digi-middleware-auth-app-data", required=false) AuthoredSys sys) {
        String userToken = request.getHeader(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY);
        if (ObjectUtils.isEmpty((Object)userToken)) {
            userToken = request.getHeader(GlobalConstants.HTTP_HEADER_ACCESS_TOKEN_KEY);
        }
        if (userToken == null) {
            throw new IllegalArgumentException("\u9700\u8981\u5728header\u4e2d\u4f20\u5165\u53c2\u6570digi-middleware-auth-user");
        }
        Tenant tenant = null;
        if (loginUser.getTenantSid() > 0L) {
            tenant = (Tenant)this.tenantCrudService.findBySid(loginUser.getTenantSid());
        } else if (!Strings.isBlank((String)loginUser.getTenantId())) {
            tenant = (Tenant)this.tenantCrudService.findById(loginUser.getTenantId());
        }
        loginUser.setApp(new Sys(sys));
        IamAuthoredUser authoredUser = this.authoredUserService.refreshUserTokenInTenant(userToken, tenant, loginUser.getApp());
        return ResponseEntity.ok((Object)new ChangedTokenVO(tenant, authoredUser));
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/token/refresh/user"}, produces={"application/json; charset=utf-8"})
    @RateLimiter(name="/api/iam/v2/identity/token/refresh/user")
    public ResponseEntity<?> refreshUserToken(HttpServletRequest request, @RequestAttribute(value="digi-middleware-auth-app-data", required=false) AuthoredSys sys) {
        String userToken = request.getHeader(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY);
        if (ObjectUtils.isEmpty((Object)userToken)) {
            userToken = request.getHeader(GlobalConstants.HTTP_HEADER_ACCESS_TOKEN_KEY);
        }
        if (userToken == null) {
            throw new IllegalArgumentException("\u9700\u8981\u5728header\u4e2d\u4f20\u5165\u53c2\u6570digi-middleware-auth-user");
        }
        IamAuthoredUser authoredUser = this.authoredUserService.refreshUserToken(userToken, new Sys(sys));
        return ResponseEntity.ok(Collections.singletonMap("user_token", authoredUser.getToken()));
    }

    @PostMapping(value={""}, produces={"application/json; charset=utf-8"})
    public ResponseEntity<?> getUserInfoByToken(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, HttpServletRequest request) {
        AuthoredSys authoredSys = AppAuthContextHolder.getContext().getAuthoredSys();
        if (request.getRequestURI().contains("/api/v1/iam") && authoredUser.getTenantSid() == 0L) {
            authoredUser.setTenantSid(1L);
            authoredUser.setTenantId("default");
        }
        List result = authoredSys != null ? this.userMappingService.getMappedByUserAndApp(authoredUser.getTenantSid(), authoredUser.getSid(), authoredSys.getId()) : this.userMappingService.getMappedByUser(authoredUser.getTenantSid(), authoredUser.getSid());
        IdentityInfo identityInfo = new IdentityInfo();
        identityInfo.setUserSid(authoredUser.getSid());
        identityInfo.setUserId(authoredUser.getUserId());
        identityInfo.setTenantId(authoredUser.getTenantId());
        identityInfo.setTenantSid(authoredUser.getTenantSid());
        identityInfo.setMapping(result);
        return ResponseEntity.ok((Object)identityInfo);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/token/refresh/app"}, produces={"application/json; charset=utf-8"})
    public ResponseEntity<?> refreshAppUserToken(HttpServletRequest request, @RequestAttribute(value="digi-middleware-auth-app-data", required=false) AuthoredSys sys, @RequestAttribute(value="digi-middleware-device-id-data", required=false) AuthoredDevice device) {
        if (sys == null) {
            throw new IllegalArgumentException("\u5207\u6362\u5e94\u7528\u7684token\u9700\u8981\u5728header\u4e2d\u4f20\u5165\u53c2\u6570digi-middleware-auth-app");
        }
        String userToken = request.getHeader(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY);
        if (ObjectUtils.isEmpty((Object)userToken)) {
            userToken = request.getHeader(GlobalConstants.HTTP_HEADER_ACCESS_TOKEN_KEY);
        }
        if (userToken == null) {
            throw new IllegalArgumentException("\u9700\u8981\u5728header\u4e2d\u4f20\u5165\u53c2\u6570digi-middleware-auth-user");
        }
        IamAuthoredUser iamAuthoredUser = this.authoredUserService.refreshUserTokenInSys(userToken, new Sys(sys), device);
        return ResponseEntity.ok((Object)new ChangedTokenVO(iamAuthoredUser));
    }

    @PostMapping(value={"/ota"}, produces={"application/json; charset=utf-8"})
    public ResponseEntity<?> loginByOta(@RequestBody GrantTypeInfo body, HttpServletRequest request, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Assert.hasText((String)body.getTenantId(), (String)"\u79df\u6237Id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isTrue((boolean)"onetimeauth_credentials".equalsIgnoreCase(body.getGrantType()), (String)"grant_type\u53ea\u80fd\u4e3aonetimeauth_credentials\uff01");
        String otaToken = body.getOtaToken();
        if (Strings.isEmpty((CharSequence)otaToken)) {
            otaToken = request.getHeader(GlobalConstants.HTTP_HEADER_OTA_TOKEN_KEY);
        }
        Assert.hasText((String)otaToken, (String)"otaToken\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        OtaToken otaTokenObj = this.otaTokenCrudService.findByToken(otaToken);
        Assert.notNull((Object)otaTokenObj, (String)"OtaToken\u4e0d\u5b58\u5728\uff01");
        OtaResultVO resultVO = this.otaTokenService.checkOtaToken((IamAuthoredUser)authoredUser, body, otaTokenObj);
        return ResponseEntity.ok((Object)resultVO);
    }

    @PostMapping(value={"/oauth/token/grant/access"})
    public ResponseEntity<?> loginByOauth(@RequestBody @Valid OauthLoginRequest oauthLoginRequest) {
        AuthoredDevice device = null;
        if (ComeFromEnum.WECHAT.getId().equals(oauthLoginRequest.getType()) || ComeFromEnum.LINE.getId().equals(oauthLoginRequest.getType())) {
            Assert.hasText((String)oauthLoginRequest.getUnionid(), (String)"unionid\u4e0d\u80fd\u4e3a\u7a7a");
            try {
                String unionId = AES.decryptHex((String)oauthLoginRequest.getUnionid(), (String)KeyConstant.WECHAT_UNION_ID);
                oauthLoginRequest.setUnionid(unionId);
                device = new AuthoredDevice("applet", oauthLoginRequest.getAppId(), oauthLoginRequest.getType(), unionId, AppAuthContextHolder.getContext().getClientIP());
            }
            catch (Exception ex) {
                throw new BusinessException((ErrorHandler)I18nError.ENCRYPTED_INCORRECTLY_AND_CANNOT_BE_DECRYPTED);
            }
        } else {
            Assert.hasText((String)oauthLoginRequest.getAccessToken(), (String)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.hasText((String)oauthLoginRequest.getCallBackUri(), (String)"callBackUri\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.hasText((String)oauthLoginRequest.getMethod(), (String)"method\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LoginUser loginUser = new LoginUser();
        loginUser.setDevice(device);
        loginUser.setIdentityType(IdentityType.oauth);
        loginUser.setOauthLoginRequest(oauthLoginRequest);
        IamAuthoredUser authoredUser = this.oauthIdentityService.login(loginUser);
        return ResponseEntity.ok((Object)authoredUser);
    }

    @PostMapping(value={"/oauth/token/access/token"})
    public ResponseEntity<?> login2ThirdPlatform(@RequestBody @Valid OauthLoginRequest oauthLoginRequest) {
        SyncTenantAuthScope tenantAuthScope;
        List notSyncAdminTenants;
        if (null == oauthLoginRequest.getAutoRegister()) {
            oauthLoginRequest.setAutoRegister(Boolean.valueOf(true));
        }
        Assert.hasText((String)oauthLoginRequest.getUnionid(), (String)"unionid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)oauthLoginRequest.getTenantId(), (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)oauthLoginRequest.getUserId(), (String)"userId:\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        Tenant tenant = (Tenant)this.tenantCrudService.findById(oauthLoginRequest.getTenantId());
        if (null == tenant) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21018);
        }
        if (Boolean.TRUE.equals(oauthLoginRequest.getAdmin()) && (notSyncAdminTenants = this.whiteListService.getWhiteList("THIRD_NOT_SYNC_ADMIN_TENANTS")).contains(oauthLoginRequest.getTenantId())) {
            oauthLoginRequest.setAdmin(Boolean.valueOf(false));
        }
        DingTalkImportInfo dingTalkImportInfo = new DingTalkImportInfo(oauthLoginRequest);
        DingTalkUserInfo dingTalkUserInfo = new DingTalkUserInfo(oauthLoginRequest);
        List userByMappings = this.userMappingService.getMappings(Long.valueOf(tenant.getSid()), oauthLoginRequest.getType(), oauthLoginRequest.getUnionid());
        if (!userByMappings.isEmpty()) {
            UserMappingQueryResultVO matchResult = userByMappings.stream().filter(u -> u.getProviderId().equals(oauthLoginRequest.getAppId())).findFirst().orElse(null);
            if (null == matchResult) {
                matchResult = (UserMappingQueryResultVO)userByMappings.get(0);
            }
            logger.info("\u7b2c\u4e09\u65b9\u96c6\u6210{} \u83b7\u53d6\u4e09\u65b9\u8d26\u53f7{}\u5728\u79df\u6237\u4e0b{}\u7ed1\u5b9a\u5e94\u7528{}\u7684\u5f52\u6237\u7528\u6237\u4e3a:[{}]", new Object[]{oauthLoginRequest.getType(), oauthLoginRequest.getUnionid(), oauthLoginRequest.getTenantId(), oauthLoginRequest.getAppId(), matchResult.getUserId()});
            User user = this.userRepository.findById((Object)matchResult.getUserSid()).orElse(null);
            UserInTenant userInTenant = this.userInTenantCrudService.findByUnionKey(tenant.getSid(), matchResult.getUserSid());
            if (user != null && userInTenant != null) {
                dingTalkUserInfo = new DingTalkUserInfo(user, oauthLoginRequest.getUserId(), oauthLoginRequest.getUnionid(), oauthLoginRequest.getDeptId(), oauthLoginRequest.getThirdUserId(), oauthLoginRequest.getTelephone());
                if (!oauthLoginRequest.getAppId().equalsIgnoreCase(matchResult.getProviderId())) {
                    dingTalkUserInfo.setNeedMapping(Boolean.valueOf(true));
                }
            } else {
                logger.error("\u7b2c\u4e09\u65b9\u96c6\u6210{} \u83b7\u53d6\u4e09\u65b9\u8d26\u53f7{}\u5728\u79df\u6237\u4e0b{}\u7ed1\u5b9a\u5e94\u7528{}\u7684\u5f52\u6237\u7528\u6237\u4e3a:[{}]\u4e0d\u5b58\u5728", new Object[]{oauthLoginRequest.getType(), oauthLoginRequest.getUnionid(), oauthLoginRequest.getTenantId(), oauthLoginRequest.getAppId(), matchResult.getUserId()});
                this.userMappingCrudService.deleteByUnionKey(tenant.getSid(), matchResult.getUserSid(), oauthLoginRequest.getAppId(), oauthLoginRequest.getType());
            }
        }
        if (null != (tenantAuthScope = this.syncTenantAuthScopeRepository.findByTenantSidAndPlatformAndAuthApp(Long.valueOf(tenant.getSid()), oauthLoginRequest.getType(), oauthLoginRequest.getAppId()))) {
            if (!tenantAuthScope.getAuthUserIds().contains(oauthLoginRequest.getUserId()) && !oauthLoginRequest.getOrgs().stream().anyMatch(o -> tenantAuthScope.getAuthOrgs().contains(o))) {
                logger.error("\u7528\u6237{}({})\u672a\u88ab\u79df\u6237{}\u6388\u6743\u4f7f\u7528\u8be5\u5e94\u7528{},\u6388\u6743\u8303\u56f4\u5bf9\u8c61\u4e0d\u5305\u62ec\u8be5\u7528\u6237\uff0c\u6388\u6743\u8303\u56f4{}", new Object[]{oauthLoginRequest.getUserName(), oauthLoginRequest.getUserId(), oauthLoginRequest.getTenantId(), oauthLoginRequest.getAppId(), JsonUtils.writeValue((Object)tenantAuthScope)});
            }
        } else {
            logger.error("\u7528\u6237{}({})\u672a\u88ab\u79df\u6237{}\u6388\u6743\u4f7f\u7528\u8be5\u5e94\u7528{},\u6388\u6743\u8303\u56f4\u5bf9\u8c61\u4e3a\u7a7a", new Object[]{oauthLoginRequest.getUserName(), oauthLoginRequest.getUserId(), oauthLoginRequest.getTenantId(), oauthLoginRequest.getAppId()});
        }
        dingTalkImportInfo.getUsers().add(dingTalkUserInfo);
        CountResultVO authResultInfo = null;
        if (oauthLoginRequest.getAutoRegister().booleanValue()) {
            authResultInfo = this.importDataService.importDingTalkUser(dingTalkImportInfo, tenant);
        }
        LoginUser loginUser = new LoginUser();
        loginUser.setDevice(new AuthoredDevice("applet", oauthLoginRequest.getAppId(), oauthLoginRequest.getType(), oauthLoginRequest.getUnionid(), AppAuthContextHolder.getContext().getClientIP()));
        loginUser.setIdentityType(IdentityType.oauth);
        oauthLoginRequest.setVerified(Boolean.valueOf(false));
        loginUser.setOauthLoginRequest(oauthLoginRequest);
        IamAuthoredUser authoredUser = this.oauthIdentityService.login(loginUser);
        if (authResultInfo != null && 1 <= authResultInfo.getCurrentCount()) {
            this.sysNoticeService.authUser(tenant, oauthLoginRequest.getAppId(), authResultInfo.getArgument().get("strategyId"), (AuthoredUser)authoredUser);
        }
        return ResponseEntity.ok((Object)authoredUser);
    }

    @PostMapping(value={"/oauth/token/grant/access/internal"})
    public ResponseEntity<?> loginByOauthInternal(@RequestBody @Valid OauthLoginRequest oauthLoginRequest) {
        AuthoredDevice device;
        Assert.hasText((String)oauthLoginRequest.getUnionid(), (String)"unionid\u4e0d\u80fd\u4e3a\u7a7a");
        try {
            String unionId = AES.decryptHex((String)oauthLoginRequest.getUnionid(), (String)KeyConstant.WECHAT_UNION_ID);
            oauthLoginRequest.setUnionid(unionId);
            device = new AuthoredDevice("applet", oauthLoginRequest.getAppId(), oauthLoginRequest.getType(), unionId, AppAuthContextHolder.getContext().getClientIP());
        }
        catch (Exception ex) {
            throw new BusinessException((ErrorHandler)I18nError.ENCRYPTED_INCORRECTLY_AND_CANNOT_BE_DECRYPTED);
        }
        LoginUser loginUser = new LoginUser();
        loginUser.setDevice(device);
        loginUser.setIdentityType(IdentityType.oauth);
        oauthLoginRequest.setVerified(Boolean.valueOf(false));
        loginUser.setOauthLoginRequest(oauthLoginRequest);
        IamAuthoredUser authoredUser = this.oauthIdentityService.login(loginUser);
        return ResponseEntity.ok((Object)authoredUser);
    }

    @PostMapping(value={"/oauth/token/access"})
    public ResponseEntity<?> loginByOauthToAccessTokenInWeb(@RequestBody OAuthLoginInfo loginUser) {
        for (ThirdOauthService thirdOauthService : this.thirdOauthServices) {
            if (!thirdOauthService.support(loginUser)) continue;
            return ResponseEntity.ok((Object)thirdOauthService.getWebAccessToken(loginUser));
        }
        return ResponseEntity.ok(null);
    }

    @PostMapping(value={"/oauth/token/access/app"})
    public ResponseEntity<?> loginByOauthToAccessToken(@RequestBody OAuthLoginInfo loginUser) {
        for (ThirdOauthService thirdOauthService : this.thirdOauthServices) {
            if (!thirdOauthService.support(loginUser)) continue;
            return ResponseEntity.ok((Object)thirdOauthService.getAppAccessToken(loginUser));
        }
        return ResponseEntity.ok(null);
    }

    @PostMapping(value={"/token/change/user"})
    public ResponseEntity<?> changeUser(@RequestAttribute(value="digi-middleware-auth-user-data") IamAuthoredUser authoredUser, @RequestAttribute(value="digi-middleware-auth-app-data", required=false) AuthoredSys sys, @RequestBody LoginUser loginUser) {
        if (ObjectUtils.isEmpty((Object)loginUser.getUserId()) || ObjectUtils.isEmpty((Object)loginUser.getClientEncryptPublicKey())) {
            throw new BusinessException((ErrorHandler)I18nError.USER_ID_AND_PUBLIC_KEY_NOT_NULL);
        }
        if (0L == authoredUser.getTenantSid()) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_ID_NOT_NULL);
        }
        IamAuthoredUser iamAuthoredUser = this.authoredUserService.changeUserToken(authoredUser, loginUser, new Sys(sys));
        return ResponseEntity.ok((Object)iamAuthoredUser);
    }

    @PostMapping(value={"/login/proxy/users"})
    public ResponseEntity<?> getProxyUsers(@RequestAttribute(value="digi-middleware-auth-app-data", required=false) AuthoredSys sys, @RequestBody LoginUser loginUser) {
        Assert.hasText((String)loginUser.getUserId(), (String)"\u4ee3\u7406\u7528\u6237\u7684id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)loginUser.getPasswordHash(), (String)"\u4ee3\u7406\u7528\u6237\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)loginUser.getAgentAuthorizationCode(), (String)"\u4ee3\u7406\u6388\u6743\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)loginUser.getClientEncryptPublicKey(), (String)"\u52a0\u5bc6\u516c\u94a5\u4e0d\u80fd\u4e3a\u7a7a");
        loginUser.setApp(sys == null ? null : new Sys(sys));
        IamAuthoredUser iamAuthoredUser = this.agentIdentityService.login(loginUser);
        return ResponseEntity.ok((Object)iamAuthoredUser);
    }

    @PostMapping(value={"/login/proxy"})
    public ResponseEntity<?> loginInProxy(@RequestAttribute(value="digi-middleware-auth-app-data", required=false) AuthoredSys sys, @RequestAttribute(value="digi-middleware-device-id-data", required=false) AuthoredDevice device, @RequestBody LoginUser loginUser) {
        Assert.hasText((String)loginUser.getUserId(), (String)"\u7528\u6237\u7684id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)loginUser.getAgentToken(), (String)"\u4ee3\u7406token\u4e0d\u80fd\u4e3a\u7a7a");
        loginUser.setIdentityType(IdentityType.agent);
        try {
            String userId = AES.decryptHex((String)loginUser.getUserId(), (String)KeyConstant.LOGIN_AGENT);
            loginUser.setUserId(userId);
        }
        catch (Exception ex) {
            throw new BusinessException((ErrorHandler)I18nError.ENCRYPTED_INCORRECTLY_AND_CANNOT_BE_DECRYPTED);
        }
        loginUser.setApp(sys == null ? null : new Sys(sys));
        loginUser.setDevice(device);
        IamAuthoredUser iamAuthoredUser = this.agentIdentityService.login(loginUser);
        return ResponseEntity.ok((Object)iamAuthoredUser);
    }

    @PostMapping(value={"/token/temp/access"})
    public StdData<?> loginByTempToken(@RequestBody LoginByTempTokenVO loginByTempTokenVO) {
        LoginUser loginUser = new LoginUser();
        loginUser.setIdentityType(IdentityType.tempUserToken);
        loginUser.setUserId(loginByTempTokenVO.getUserId());
        loginUser.setTenantId(loginByTempTokenVO.getTenantId());
        loginUser.setSysId(loginByTempTokenVO.getAppId());
        loginUser.setTempUserToken(loginByTempTokenVO.getTempToken().toLowerCase());
        IamAuthoredUser authoredUser = this.tempUserTokenService.login(loginUser);
        return StdData.ok(Collections.singletonMap("token", authoredUser.getToken()));
    }

    @PostMapping(value={"/sso/auth/code"})
    public StdData<?> getAuthCode(@RequestBody LoginAuthInfo authInfo) {
        if (ObjectUtils.isEmpty((Object)authInfo.getTargetAppId())) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_PARAM_EMPTY_ERROR, new Object[]{"targetAppId"});
        }
        String authCode = this.appSSOService.getAuthCode(authInfo.getTargetAppId());
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("authCode", authCode);
        return StdData.ok(result);
    }

    @PostMapping(value={"/sso/accesstoken"})
    public StdData<?> getAccessTokenByAuthCode(@RequestBody LoginAuthInfo authInfo, @RequestAttribute(value="digi-middleware-device-id-data", required=false) AuthoredDevice device) {
        if (ObjectUtils.isEmpty((Object)authInfo.getAuthCode())) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_PARAM_EMPTY_ERROR, new Object[]{"authCode"});
        }
        if (ObjectUtils.isEmpty((Object)authInfo.getSourceAppId())) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_PARAM_EMPTY_ERROR, new Object[]{"sourceAppId"});
        }
        return StdData.ok((Object)this.appSSOService.getUserTokenByAuthCode(authInfo.getSourceAppId(), authInfo.getAuthCode(), device));
    }

    @PostMapping(value={"/token/saml/access", "/token/sso/access"})
    public StdData<?> loginBySsoToken(@RequestBody SsoLoginInfo ssoLoginInfo, @RequestAttribute(value="digi-middleware-device-id-data", required=false) AuthoredDevice device) {
        String ssoTokenKey = String.format("iam:sso:token:%s:%s", StringUtils.hasText((String)ssoLoginInfo.getSsoType()) ? ssoLoginInfo.getSsoType() : "saml", ssoLoginInfo.getCode());
        UserTempTokenCacheVO cacheVO = (UserTempTokenCacheVO)RedisUtils.get((Object)ssoTokenKey, UserTempTokenCacheVO.class);
        if (Objects.isNull(cacheVO)) {
            throw new BusinessException((ErrorHandler)I18nError.TEMP_TOKEN_INVALID, new Object[]{ssoLoginInfo.getCode()});
        }
        RedisUtils.delete((String)ssoTokenKey);
        String ssoTokenValue = cacheVO.getValue();
        String[] ssoTokenArr = ssoTokenValue.split(":_");
        Tenant tenant = (Tenant)this.tenantCrudService.findById(ssoTokenArr[1]);
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{ssoTokenArr[1]});
        }
        String userId = ssoTokenArr[0];
        User user = (User)this.userCrudService.findById(userId);
        if (user == null) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST, new Object[]{userId});
        }
        LoginUser loginUser = new LoginUser();
        loginUser.setIdentityType(IdentityType.tempUserToken);
        loginUser.setUser(user);
        loginUser.setTenant(tenant);
        loginUser.setApp(new Sys(UserUtils.getAuthoredSys()));
        loginUser.setDevice(device);
        IamAuthoredUser iamAuthoredUser = this.authoredUserService.generate(loginUser, Boolean.valueOf(true), Boolean.valueOf(false));
        return StdData.ok(Collections.singletonMap("token", iamAuthoredUser.getToken()));
    }

    @DapSign
    @PostMapping(value={"/cross/region/login"})
    public StdData<?> crossRegionLogin(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestAttribute(value="digi-middleware-auth-app-data") AuthoredSys sys, @RequestBody @Valid CrossRegionLoginRequest crossRegionLoginRequest) {
        String tenantId = crossRegionLoginRequest.getTenantId();
        if (!StringUtils.hasText((String)tenantId)) {
            tenantId = authoredUser.getTenantId();
        }
        String customerId = null;
        if (!Objects.equals(authoredUser.getTenantId(), tenantId)) {
            Tenant tenant = (Tenant)this.tenantCrudService.findById(authoredUser.getTenantId());
            if (!StringUtils.hasText((String)tenant.getCustomerId())) {
                throw new BusinessException((ErrorHandler)I18nError.CUSTOMER_CODE_OF_TENANT_NOT_EMPTY, new Object[]{authoredUser.getTenantId()});
            }
            customerId = tenant.getCustomerId();
        }
        IamAuthoredUser iamAuthoredUser = this.remoteIamService.crossRegionLogin(crossRegionLoginRequest.getCloud(), crossRegionLoginRequest.getArea(), tenantId, sys.getId(), customerId);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("token", iamAuthoredUser.getToken());
        result.put("tokenExpiresIn", iamAuthoredUser.getTokenExpiresIn());
        return StdData.ok(result);
    }

    @DapSign
    @PostMapping(value={"/cross/region/login/inner"})
    public StdData<?> crossRegionLoginInner(@RequestBody @Valid CrossRegionLoginInnerRequest crossRegionLoginInnerRequest) {
        Tenant tenant = (Tenant)this.tenantCrudService.findById(crossRegionLoginInnerRequest.getTenantId());
        if (tenant == null) {
            return StdData.of((int)500, (String)I18nError.TENANT_NOT_EXISTED.getErrorMessage(new Object[]{crossRegionLoginInnerRequest.getTenantId()}));
        }
        String customerId = crossRegionLoginInnerRequest.getCustomerId();
        if (StringUtils.hasText((String)customerId) && !Objects.equals(customerId, tenant.getCustomerId())) {
            return StdData.of((int)500, (String)I18nError.CUSTOMER_ID_NOT_SAME.getErrorMessage());
        }
        Sys sys = this.commonCacheService.getSysById(crossRegionLoginInnerRequest.getSysId());
        if (sys == null) {
            return StdData.of((int)500, (String)I18nError.SYS_NOT_EXISTED.getErrorMessage(new Object[]{crossRegionLoginInnerRequest.getSysId()}));
        }
        User user = (User)this.userCrudService.findById("integration");
        LoginUser loginUser = new LoginUser();
        loginUser.setIdentityType(IdentityType.crossRegion);
        loginUser.setUser(user);
        loginUser.setTenant(tenant);
        loginUser.setApp(sys);
        loginUser.setLoginSource(LoginSource.crossRegion);
        IamAuthoredUser iamAuthoredUser = this.authoredUserService.generate(loginUser, Boolean.valueOf(false), Boolean.valueOf(false));
        return StdData.ok((Object)iamAuthoredUser);
    }
}

