/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantInfoVO;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.support.dump.extract.BaseExtractService;
import com.digiwin.dap.middleware.iam.support.dump.extract.domain.BaseSysExcel;
import com.digiwin.dap.middleware.iam.support.dump.extract.domain.BaseSysExcelReadListener;
import com.digiwin.dap.middleware.iam.support.initialize.AsscInitializeService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEocService;
import com.digiwin.dap.middleware.iam.support.validate.AuthValidateService;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class InitializeController {
    private static final Logger logger = LoggerFactory.getLogger(InitializeController.class);
    @Autowired
    private RemoteEocService remoteEocService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private AsscInitializeService asscInitializeService;
    @Autowired
    private BaseExtractService baseExtractService;
    @Autowired
    private AuthValidateService authValidateService;

    @PostMapping(value={"/api/app/initialize"})
    public StdData<?> initialize(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (authoredUser == null || StringUtils.isEmpty((Object)authoredUser.getToken())) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_INFO_EMPTY);
        }
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(authoredUser.getTenantSid());
        if (!tenant.isEoc()) {
            tenant.setEoc(true);
            this.tenantCrudService.update((BaseEntity)tenant);
        }
        TenantInfoVO tenantInfoVO = new TenantInfoVO();
        tenantInfoVO.setSid(Long.valueOf(authoredUser.getTenantSid()));
        tenantInfoVO.setId(authoredUser.getTenantId());
        tenantInfoVO.setName(authoredUser.getTenantName());
        this.remoteEocService.initialize(tenantInfoVO);
        return StdData.ok().build();
    }

    @PostMapping(value={"/api/app/initialize/role/permission"})
    public StdData<?> accsInitialize(@RequestBody Map<String, Object> map) {
        Assert.notNull((Object)map.get("tenantSid"), (String)"tenantSid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)map.get("appId"), (String)"appId\u4e0d\u80fd\u4e3a\u7a7a");
        List data = null;
        if (map.containsKey("data") && null != map.get("data")) {
            try {
                data = (List)JsonUtils.createObjectMapper().readValue(JsonUtils.writeValue((Object)map.get("data")), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (IOException e) {
                logger.error("\u683c\u5f0f\u5316data:{}\u6570\u636e\u51fa\u9519,{}", (Object)JsonUtils.writeValue(map), (Object)e);
            }
        }
        if (!ObjectUtils.nullSafeEquals((Object)UserUtils.getTenantSid(), (Object)map.get("tenantSid")) && !this.authValidateService.checkAccessPermission(TargetType.Sys.name(), "POST", AppAuthContextHolder.getContext().getRequestInfo().getPath(), UserUtils.getSysId()).booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        String backUri = map.containsKey("backUri") && map.get("backUri") != null ? (String)map.get("backUri") : null;
        this.asscInitializeService.initializeAsscPermission((Long)map.get("tenantSid"), (String)map.get("appId"), backUri, data);
        return StdData.ok().build();
    }

    @PostMapping(value={"/api/app/batch/initialize/role/permission"})
    public StdData batchInitializeRolePolicy(@RequestBody Map<String, Object> map) {
        Assert.notNull((Object)map.get("tenantSid"), (String)"tenantSid\u4e0d\u80fd\u4e3a\u7a7a");
        logger.info("\u521d\u59cb\u5316\u89d2\u8272\u6743\u9650\u6570\u636e\uff1a{}", (Object)JsonUtils.writeValue(map));
        if (!ObjectUtils.nullSafeEquals((Object)UserUtils.getTenantSid(), (Object)map.get("tenantSid")) && !this.authValidateService.checkAccessPermission(TargetType.Sys.name(), "POST", AppAuthContextHolder.getContext().getRequestInfo().getPath(), UserUtils.getSysId()).booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        List datas = null;
        if (null != map.get("apps")) {
            try {
                datas = (List)JsonUtils.createObjectMapper().readValue(JsonUtils.writeValue((Object)map.get("apps")), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (IOException e) {
                logger.error("\u683c\u5f0f\u5316data:{}\u6570\u636e\u51fa\u9519,{}", (Object)JsonUtils.writeValue(map), (Object)e);
            }
            if (!CollectionUtils.isEmpty(datas)) {
                datas.forEach(d -> {
                    Assert.hasText((String)d.getAppId(), (String)"\u5e94\u7528id\u4e0d\u80fd\u4e3a\u7a7a");
                    this.asscInitializeService.initializeAsscPermission((Long)map.get("tenantSid"), d.getAppId(), d.getBackUri(), d.getData());
                });
            }
        }
        return StdData.ok().build();
    }

    @PostMapping(value={"/api/app/auth/data/migration1"})
    public StdData<?> syncAuthForCommonApp(@RequestPart(value="file") MultipartFile file, @RequestParam(required=false, defaultValue="true") boolean policy) {
        BaseSysExcelReadListener appListener = new BaseSysExcelReadListener();
        BaseSysExcelReadListener tenantListener = new BaseSysExcelReadListener();
        BaseSysExcelReadListener oldAppActionListener = new BaseSysExcelReadListener();
        try {
            ReadSheet readSheet1 = ((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcel.readSheet((Integer)0).head(BaseSysExcel.class)).registerReadListener((ReadListener)appListener)).build();
            ReadSheet readSheet2 = ((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcel.readSheet((Integer)1).head(BaseSysExcel.class)).registerReadListener((ReadListener)tenantListener)).build();
            ReadSheet readSheet3 = ((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcel.readSheet((Integer)2).head(BaseSysExcel.class)).registerReadListener((ReadListener)oldAppActionListener)).build();
            EasyExcel.read((InputStream)file.getInputStream()).build().read(new ReadSheet[]{readSheet1, readSheet2, readSheet3}).finish();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        this.baseExtractService.migrationAuth1(appListener.getIds(), tenantListener.getIds(), oldAppActionListener.getList(), policy);
        return StdData.ok().build();
    }

    @PostMapping(value={"/api/app/auth/data/migration2"})
    public StdData<?> syncAuth2(@RequestPart(value="file") MultipartFile file) {
        BaseSysExcelReadListener appListener = new BaseSysExcelReadListener();
        BaseSysExcelReadListener tenantListener = new BaseSysExcelReadListener();
        BaseSysExcelReadListener moduleListener = new BaseSysExcelReadListener();
        try {
            ReadSheet readSheet1 = ((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcel.readSheet((Integer)0).head(BaseSysExcel.class)).registerReadListener((ReadListener)appListener)).build();
            ReadSheet readSheet2 = ((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcel.readSheet((Integer)1).head(BaseSysExcel.class)).registerReadListener((ReadListener)tenantListener)).build();
            ReadSheet readSheet3 = ((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcel.readSheet((Integer)2).head(BaseSysExcel.class)).registerReadListener((ReadListener)moduleListener)).build();
            EasyExcel.read((InputStream)file.getInputStream()).build().read(new ReadSheet[]{readSheet1, readSheet2, readSheet3}).finish();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        this.baseExtractService.migrationAuth2(appListener.getList(), tenantListener.getIds(), moduleListener.getList());
        return StdData.ok().build();
    }
}

