/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.Page;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.form.CurrentIntellyVO;
import com.digiwin.dap.middleware.iam.domain.form.IntellyExperiencePageVO;
import com.digiwin.dap.middleware.iam.domain.form.IntellyExperienceStatRequest;
import com.digiwin.dap.middleware.iam.domain.form.IntellyExperienceVO;
import com.digiwin.dap.middleware.iam.domain.form.IntellyFormGroupListVO;
import com.digiwin.dap.middleware.iam.domain.form.IntellyFormGroupVO;
import com.digiwin.dap.middleware.iam.domain.form.IntellyFormListVO;
import com.digiwin.dap.middleware.iam.domain.form.IntellyFormVO;
import com.digiwin.dap.middleware.iam.domain.form.IntellyIdentityIdSearchVO;
import com.digiwin.dap.middleware.iam.domain.form.IntellyIdentityIdVO;
import com.digiwin.dap.middleware.iam.domain.form.IntellyIdentityVO;
import com.digiwin.dap.middleware.iam.domain.form.IntellyRelationPageVO;
import com.digiwin.dap.middleware.iam.domain.form.IntellyRelationStatExcelVO;
import com.digiwin.dap.middleware.iam.domain.form.IntellyRelationStatVO;
import com.digiwin.dap.middleware.iam.domain.form.IntellyRelationTenantExportExcelVO;
import com.digiwin.dap.middleware.iam.domain.form.IntellyRelationVO;
import com.digiwin.dap.middleware.iam.entity.IntellyExperienceApplication;
import com.digiwin.dap.middleware.iam.entity.IntellyForm;
import com.digiwin.dap.middleware.iam.entity.IntellyFormGroup;
import com.digiwin.dap.middleware.iam.entity.IntellyRelation;
import com.digiwin.dap.middleware.iam.mapper.IntellyMapper;
import com.digiwin.dap.middleware.iam.service.intelly.IntellyFormCrudService;
import com.digiwin.dap.middleware.iam.service.intelly.IntellyFormGroupCrudService;
import com.digiwin.dap.middleware.iam.service.intelly.IntellyRelationCrudService;
import com.digiwin.dap.middleware.iam.service.intelly.IntellyService;
import com.digiwin.dap.middleware.iam.support.remote.DmcService;
import com.digiwin.dap.middleware.iam.support.remote.MessageService;
import com.digiwin.dap.middleware.util.UserUtils;
import com.digiwin.dmc.sdk.entity.FileInfo;
import com.github.pagehelper.PageSerializable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2/intelly"})
public class IntellyController {
    private static final Logger logger = LoggerFactory.getLogger(IntellyController.class);
    @Autowired
    private IntellyFormGroupCrudService intellyFormGroupCrudService;
    @Autowired
    private IntellyFormCrudService intellyFormCrudService;
    @Autowired
    private IntellyRelationCrudService intellyRelationCrudService;
    @Autowired
    private IntellyService intellyService;
    @Autowired
    private DmcService dmcService;
    @Autowired
    private IntellyMapper intellyMapper;
    @Autowired
    private MessageService messageService;

    @PostMapping(value={"/form/add"})
    public StdData<Long> add(@RequestBody IntellyFormVO body) {
        return StdData.ok((Object)this.intellyFormCrudService.create((BaseEntity)body.doForward()));
    }

    @PostMapping(value={"/form/mod"})
    public StdData<?> mod(@RequestBody IntellyFormVO body) {
        IntellyForm entity = (IntellyForm)this.intellyFormCrudService.findBySid(body.getSid().longValue());
        if (entity != null) {
            entity.setName(body.getName());
            this.intellyFormCrudService.update((BaseEntity)entity);
        }
        return StdData.ok().build();
    }

    @GetMapping(value={"/form/del/check"})
    public StdData<?> delCheck(@RequestParam Long sid) {
        this.intellyService.checkFormDel(sid.longValue());
        return StdData.ok().build();
    }

    @PostMapping(value={"/form/del"})
    public StdData<?> del(@RequestBody IntellyFormVO body) {
        this.intellyService.checkFormDel(body.getSid().longValue());
        if (this.intellyFormCrudService.exists(body.getSid().longValue())) {
            this.intellyFormCrudService.deleteById(body.getSid().longValue());
        }
        return StdData.ok().build();
    }

    @PostMapping(value={"/form/group/add"})
    public StdData<Long> groupAdd(@RequestBody IntellyFormGroupVO body) {
        return StdData.ok((Object)this.intellyFormGroupCrudService.create((BaseEntity)body.doForward()));
    }

    @PostMapping(value={"/form/group/mod"})
    public StdData<?> groupMod(@RequestBody IntellyFormGroupVO body) {
        IntellyFormGroup entity = (IntellyFormGroup)this.intellyFormGroupCrudService.findBySid(body.getSid().longValue());
        if (entity != null) {
            entity.setName(body.getName());
            this.intellyFormGroupCrudService.update((BaseEntity)entity);
        }
        return StdData.ok().build();
    }

    @GetMapping(value={"/form/group/del/check"})
    public StdData<?> groupDelCheck(@RequestParam Long sid) {
        this.intellyService.checkFormGroupDel(sid.longValue());
        return StdData.ok().build();
    }

    @PostMapping(value={"/form/group/del"})
    public StdData<?> groupDel(@RequestBody IntellyFormGroupVO body) {
        this.intellyService.checkFormGroupDel(body.getSid().longValue());
        if (this.intellyFormGroupCrudService.exists(body.getSid().longValue())) {
            this.intellyFormGroupCrudService.deleteById(body.getSid().longValue());
        }
        return StdData.ok().build();
    }

    @PostMapping(value={"/form/list"})
    public StdData<?> list(@RequestBody IntellyFormGroupVO body) {
        List all = this.intellyFormGroupCrudService.findAll();
        ArrayList<IntellyFormGroupListVO> result = new ArrayList<IntellyFormGroupListVO>();
        for (IntellyFormGroup formGroup : all) {
            IntellyFormGroupListVO groupVO = new IntellyFormGroupListVO();
            result.add(groupVO);
            BeanUtils.copyProperties((Object)formGroup, (Object)groupVO);
            List intelly = this.intellyFormCrudService.findByGroupSid(groupVO.getSid());
            groupVO.setForms(intelly.stream().map(a -> {
                IntellyFormListVO intellyVO = new IntellyFormListVO();
                BeanUtils.copyProperties((Object)a, (Object)intellyVO);
                return intellyVO;
            }).collect(Collectors.toList()));
        }
        return StdData.ok(result);
    }

    @PostMapping(value={"/relation/add"})
    public StdData<Long> add(@RequestBody IntellyRelationVO body) {
        return StdData.ok((Object)this.intellyService.createIntelly(body));
    }

    @PostMapping(value={"/relation/mod"})
    public StdData<?> mod(@RequestBody IntellyRelationVO body) {
        IntellyRelation entity = (IntellyRelation)this.intellyRelationCrudService.findBySid(body.getSid().longValue());
        if (entity != null) {
            IntellyRelation existRelation = this.intellyRelationCrudService.findByRelationSidAndFormSid(entity.getRelationSid(), body.getFormSid().longValue());
            if (Objects.nonNull(existRelation) && !Objects.equals(existRelation.getSid(), entity.getSid())) {
                throw new BusinessException((ErrorHandler)I18nError.IAM_INTELLY_EXIST);
            }
            entity.setFormSid(body.getFormSid().longValue());
            entity.setProof(body.getProof());
            entity.setRemark(body.getRemark());
            this.intellyRelationCrudService.update((BaseEntity)entity);
        }
        return StdData.ok().build();
    }

    @PostMapping(value={"/relation/del"})
    public StdData<?> del(@RequestBody IntellyRelationVO body) {
        if (this.intellyRelationCrudService.exists(body.getSid().longValue())) {
            this.intellyRelationCrudService.deleteById(body.getSid().longValue());
        }
        return StdData.ok().build();
    }

    @PostMapping(value={"/relation/search"})
    public StdData<?> relationSearch(@RequestBody IntellyRelationPageVO body) {
        body.setOrderBy(Optional.ofNullable(body.getOrderBy()).orElse("r.sid desc"));
        List result = this.intellyService.queryPage(body);
        return StdData.ok((Object)new PageSerializable(result));
    }

    @PostMapping(value={"/relation/export"})
    public void relationExport(@RequestBody IntellyRelationPageVO body, HttpServletResponse response) throws IOException {
        body.setOrderBy(Optional.ofNullable(body.getOrderBy()).orElse("r.sid desc"));
        List result = this.intellyService.queryPageExport(body);
        List excelList = result.stream().map(IntellyRelationTenantExportExcelVO::new).collect(Collectors.toList());
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("UTF-8");
        String encodedFileName = URLEncoder.encode("intelly_tenant", "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + encodedFileName + ".xlsx");
        InputStream inputStream = new DefaultResourceLoader().getResource("classpath:/static/templates/Intelly_tenant_export_template.xlsx").getInputStream();
        ExcelWriter excelWriter = EasyExcel.write((OutputStream)response.getOutputStream()).withTemplate(inputStream).build();
        WriteSheet writeSheet = EasyExcel.writerSheet((Integer)0).build();
        excelWriter.write(excelList, writeSheet);
        excelWriter.finish();
    }

    @PostMapping(value={"/user/check"})
    public StdData<?> check() {
        this.intellyService.checkUser();
        return StdData.ok().build();
    }

    @PostMapping(value={"/stat/search"})
    public StdData<?> stat(@RequestBody IntellyRelationStatVO body) {
        return StdData.ok((Object)this.intellyService.queryStat(body));
    }

    @PostMapping(value={"/stat/export"})
    public StdData<?> statExport(@RequestBody IntellyRelationStatVO body) throws Exception {
        List result = this.intellyMapper.queryIntellyStatExcel(body);
        result.forEach(IntellyRelationStatExcelVO::processFields);
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        String localTime = df.format(LocalDateTime.now());
        String fileName = URLEncoder.encode(String.format("Intelly_%s.xlsx", localTime), "UTF-8");
        File file = new File(fileName);
        InputStream inputStream = new DefaultResourceLoader().getResource("classpath:/static/templates/intelly_stat.xlsx").getInputStream();
        ExcelWriter excelWriter = EasyExcel.write((File)file).withTemplate(inputStream).build();
        WriteSheet writeSheet = EasyExcel.writerSheet((Integer)0).build();
        excelWriter.write(result, writeSheet);
        excelWriter.finish();
        FileInfo fileInfo = new FileInfo();
        fileInfo.setFileName(fileName);
        fileInfo.setExtension("xlsx");
        try (InputStream input = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            byte[] bytes = new byte[input.available()];
            int read = input.read(bytes);
            if (read <= 0) {
                logger.error("nothing to read");
            }
            StdData stdData = StdData.ok((Object)this.dmcService.getShareFile(bytes, (com.digiwin.dap.middleware.dmc.model.FileInfo)fileInfo));
            return stdData;
        }
    }

    @PostMapping(value={"/identity/add"})
    public StdData<Long> completeApplicationAdd(@RequestBody IntellyIdentityVO body) {
        body.setUserSid(Long.valueOf(UserUtils.getUserSid()));
        return StdData.ok((Object)this.intellyService.createIdentityApplication(body));
    }

    @GetMapping(value={"/current"})
    public StdData<CurrentIntellyVO> checkCurrent() {
        return StdData.ok((Object)this.intellyService.checkIntelly(UserUtils.getUserSid()));
    }

    @PostMapping(value={"/experience/add"})
    public StdData<Long> queryCurrentExperienceApplication(@RequestBody IntellyExperienceVO body) {
        body.setUserSid(Long.valueOf(UserUtils.getUserSid()));
        IntellyExperienceApplication application = this.intellyService.createExperienceApplication(body);
        this.messageService.sendExperienceApplyEmail(application);
        return StdData.ok((Object)application.getSid());
    }

    @PostMapping(value={"/experience/current"})
    public StdData<?> queryCurrentExperienceApplication(@RequestBody IntellyExperiencePageVO vo) {
        vo.setUserSid(Long.valueOf(UserUtils.getUserSid()));
        vo.setOrderBy(Optional.ofNullable(vo.getOrderBy()).orElse("a.sid desc"));
        List resultVOS = this.intellyService.queryExperienceApplications(vo);
        return StdData.ok((Object)new PageSerializable(resultVOS));
    }

    @PostMapping(value={"/experience/extension/add"})
    public StdData<?> experienceExtensionAdd(@RequestBody IntellyExperienceVO body) {
        this.intellyService.createExperienceExtension(body);
        return StdData.ok().build();
    }

    @GetMapping(value={"/experience/stat/head"})
    public StdData<?> experienceStat(IntellyExperienceStatRequest cond) {
        return StdData.ok((Object)this.intellyService.getExperienceStatHead(cond));
    }

    @PostMapping(value={"/experience/stat/body"})
    public StdData<?> experienceStatBody(@RequestBody IntellyExperienceStatRequest input) {
        return StdData.ok((Object)this.intellyService.getExperienceStatBody(input));
    }

    @GetMapping(value={"/experience/stat/body/page"})
    public StdData<?> experienceStatBody(Page page, IntellyExperienceStatRequest input) {
        return StdData.ok((Object)this.intellyService.getExperienceStatBodyPage(input, page));
    }

    @GetMapping(value={"/identity/id"})
    public StdData<PageSerializable<IntellyIdentityIdVO>> completeApplicationAdd(IntellyIdentityIdSearchVO body) {
        if (CollectionUtils.isEmpty((Collection)body.getUserIds()) && ObjectUtils.isEmpty((Object)body.getIdCode())) {
            return StdData.ok((Object)PageSerializable.of(new ArrayList()));
        }
        return StdData.ok((Object)this.intellyService.findIdentityOfId(body));
    }

    @GetMapping(value={"/experience/applied/goods"})
    public StdData<?> getExperienceAppliedGoods(IntellyExperienceStatRequest cond) {
        return StdData.ok((Object)this.intellyService.getExperienceAppliedGoods(cond));
    }
}

