/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.invite.InviteUserLinkPageVO;
import com.digiwin.dap.middleware.iam.domain.invite.InviteUserLinkVO;
import com.digiwin.dap.middleware.iam.entity.InvitedUserLink;
import com.digiwin.dap.middleware.iam.service.invite.InviteUserLinkCrudService;
import com.digiwin.dap.middleware.iam.service.invite.InviteUserLinkService;
import com.digiwin.dap.middleware.iam.support.validate.AuthValidateService;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v1/invite/link"})
public class InviteLinkController {
    @Resource
    private InviteUserLinkService inviteUserLinkService;
    @Resource
    private InviteUserLinkCrudService inviteUserLinkCrudService;
    @Autowired
    private AuthValidateService authValidateService;

    @PostMapping(value={"/add"})
    public StdData<?> add(@RequestBody InviteUserLinkVO body) {
        if (UserUtils.getTenantSid() != body.getTenantSid() && !this.authValidateService.checkAccessPermission(TargetType.Sys.name(), "POST", "/api/iam/v1/invite/link/add", UserUtils.getSysId()).booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        InvitedUserLink entity = (InvitedUserLink)body.doForward();
        this.inviteUserLinkCrudService.create((BaseEntity)entity);
        return StdData.ok((Object)entity.getSid());
    }

    @PostMapping(value={"/search"})
    public StdData<?> search(@RequestBody InviteUserLinkPageVO body) {
        return StdData.ok((Object)this.inviteUserLinkService.search(body));
    }

    @PostMapping(value={"/disable"})
    public StdData<?> disable(@RequestBody InviteUserLinkPageVO body) {
        this.inviteUserLinkService.disable(body);
        return StdData.ok().build();
    }

    @PostMapping(value={"/agree"})
    public StdData<?> agree(@RequestBody InviteUserLinkPageVO body) {
        body.setUserSid(Optional.ofNullable(body.getUserSid()).orElse(UserUtils.getUserSid()));
        this.inviteUserLinkService.agree(body);
        return StdData.ok().build();
    }
}

