/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import com.digiwin.dap.middle.encrypt.domain.annotation.DapEncrypt;
import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.invoiceinfo.InvoiceExistVO;
import com.digiwin.dap.middleware.iam.domain.invoiceinfo.InvoiceInfoVO;
import com.digiwin.dap.middleware.iam.domain.invoiceinfo.InvoiceReceiversVO;
import com.digiwin.dap.middleware.iam.domain.user.TenantRelationWithUserWithStatusVO;
import com.digiwin.dap.middleware.iam.entity.InvoiceInfo;
import com.digiwin.dap.middleware.iam.entity.InvoiceReceivers;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.mapper.InvoiceInfoMapper;
import com.digiwin.dap.middleware.iam.mapper.TenantMapper;
import com.digiwin.dap.middleware.iam.repository.InvoiceInfoRepository;
import com.digiwin.dap.middleware.iam.service.invoiceinfo.InvoiceInfoCrudService;
import com.digiwin.dap.middleware.iam.service.invoiceinfo.InvoiceInfoService;
import com.digiwin.dap.middleware.iam.service.invoiceinfo.InvoiceReceiversCrudService;
import com.digiwin.dap.middleware.iam.service.invoiceinfo.InvoiceReceiversService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantQueryService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleService;
import com.digiwin.dap.middleware.iam.support.validate.AuthValidateService;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v3/invoice"})
public class InvoiceController {
    @Autowired
    private InvoiceInfoService invoiceInfoService;
    @Autowired
    private InvoiceReceiversCrudService invoiceReceiversCrudService;
    @Autowired
    private InvoiceReceiversService invoiceReceiversService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private InvoiceInfoMapper invoiceInfoMapper;
    @Autowired
    private InvoiceInfoRepository invoiceInfoRepository;
    @Autowired
    private InvoiceInfoCrudService invoiceInfoCrudService;
    @Autowired
    private AuthValidateService authValidateService;
    @Autowired
    private TenantQueryService tenantQueryService;
    @Autowired
    private UserInRoleService userInRoleService;

    @GetMapping(value={"/{tenantSid}/{invoiceSid}/receiver"})
    public ResponseEntity<?> getInvoiceReceivers(@PathVariable(value="tenantSid") long tenantSid, @PathVariable long invoiceSid, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        if (tenantSid != UserUtils.getTenantSid()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        if (!this.checkTenantInUserTenants(tenantSid, user)) {
            throw new BusinessException((ErrorHandler)I18nError.INVOICE_TENANT_NO_AUTH, new Object[]{tenantSid, user.getUserId()});
        }
        if (!this.invoiceInfoService.checkTenantHavePermission(invoiceSid, tenantSid)) {
            throw new BusinessException((ErrorHandler)I18nError.INVOICE_TENANT_NO_AUTH_1, new Object[]{invoiceSid, tenantSid});
        }
        List invoiceReceiversVOS = this.invoiceReceiversService.getInvoiceReceiversVOs(invoiceSid);
        return ResponseEntity.ok((Object)invoiceReceiversVOS);
    }

    @DapEncrypt(force=false, response=true)
    @GetMapping(value={"/{tenantSid}/containreceiver"})
    public ResponseEntity<?> getInvoiceInfoContainReceiver(@PathVariable(value="tenantSid") long tenantSid, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_INVITED_USER_TENANT_EXISTED, new Object[]{tenantSid});
        }
        if (!this.checkTenantInUserTenants(tenantSid, user)) {
            throw new BusinessException((ErrorHandler)I18nError.INVOICE_TENANT_NO_AUTH, new Object[]{tenantSid, user.getUserId()});
        }
        if (tenantSid != UserUtils.getTenantSid() && !this.authValidateService.checkAccessPermission(TargetType.Sys.toString(), "GET", "/api/iam/v3/invoice/{tenantSid}/containreceiver", UserUtils.getSysId()).booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        InvoiceInfoVO invoiceInfoVO = this.invoiceInfoService.getInvoiceInfoContainReceiver(tenantSid);
        return ResponseEntity.ok((Object)invoiceInfoVO);
    }

    @GetMapping(value={"/containreceiver"})
    public ResponseEntity<?> getInvoiceInfoContainReceiver(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        InvoiceInfoVO invoiceInfoVO = this.invoiceInfoService.getInvoiceInfoContainReceiver(user.getTenantSid());
        return ResponseEntity.ok((Object)invoiceInfoVO);
    }

    @PostMapping(value={"/{tenantSid}/receiver"})
    public ResponseEntity<?> saveInvoiceInfo(@PathVariable long tenantSid, @RequestBody InvoiceReceiversVO invoiceReceiversVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_INVITED_USER_TENANT_EXISTED, new Object[]{tenantSid});
        }
        if (tenant.getOwnerUserSid() != authoredUser.getSid() && !this.userInRoleService.checkSuperAdmin(Long.valueOf(tenantSid), Long.valueOf(authoredUser.getSid()))) {
            throw new BusinessException((ErrorHandler)I18nError.INVOICE_NO_AUTHORITY_FOR_MAINTAIN_INVOICE, new Object[]{tenant.getId(), authoredUser.getUserId()});
        }
        if (!this.invoiceInfoService.checkTenantHavePermission(invoiceReceiversVO.getInvoiceSid().longValue(), tenantSid)) {
            throw new BusinessException((ErrorHandler)I18nError.INVOICE_TENANT_NO_AUTH_1, new Object[]{tenantSid});
        }
        if (StringUtils.isEmpty((Object)invoiceReceiversVO.getSid()) || invoiceReceiversVO.getSid() == 0L) {
            this.invoiceReceiversCrudService.create((BaseEntity)invoiceReceiversVO.generateInvoiceReceivers());
        } else {
            this.invoiceReceiversCrudService.update((BaseEntity)invoiceReceiversVO.generateInvoiceReceivers(), true);
        }
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @PostMapping(value={"/receiver"})
    public ResponseEntity<?> saveInvoiceInfo(@RequestBody InvoiceReceiversVO invoiceReceiversVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(user.getTenantSid());
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_INVITED_USER_TENANT_EXISTED, new Object[]{user.getTenantId()});
        }
        if (!this.invoiceInfoService.checkTenantHavePermission(invoiceReceiversVO.getInvoiceSid().longValue(), user.getTenantSid())) {
            throw new BusinessException((ErrorHandler)I18nError.INVOICE_TENANT_NO_AUTH_1, new Object[]{user.getTenantId()});
        }
        if (StringUtils.isEmpty((Object)invoiceReceiversVO.getSid()) || invoiceReceiversVO.getSid() == 0L) {
            this.invoiceReceiversCrudService.create((BaseEntity)invoiceReceiversVO.generateInvoiceReceivers());
        } else {
            this.invoiceReceiversCrudService.update((BaseEntity)invoiceReceiversVO.generateInvoiceReceivers(), true);
        }
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @PostMapping(value={"/taxno/{taxNo}"})
    public ResponseEntity<?> exitInvoiceInfo(@PathVariable String taxNo, @RequestParam(required=false, defaultValue="true") Boolean allChecked) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List existedInvoiceInfoTenants = this.invoiceInfoMapper.getTenantByInvoiceTaxCode(taxNo, allChecked, null);
        if (existedInvoiceInfoTenants.isEmpty()) {
            result.put("exit", "false");
        } else {
            InvoiceExistVO vo = (InvoiceExistVO)existedInvoiceInfoTenants.get(0);
            result.put("exit", "true");
            result.put("tenantSid", vo.getTenantSid());
            result.put("tenantId", vo.getTenantId());
            result.put("tenantName", vo.getTenantName());
            result.put("all", existedInvoiceInfoTenants);
        }
        return ResponseEntity.ok((Object)StdData.ok(result));
    }

    @GetMapping(value={"/taxno/isv"})
    public StdData<?> exitInvoiceInfo(@RequestParam String taxNo) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        List existedInvoiceInfoTenants = this.invoiceInfoMapper.getTenantByInvoiceTaxCode(taxNo, null, null);
        result.put("exist", !existedInvoiceInfoTenants.isEmpty());
        result.put("hasIsv", existedInvoiceInfoTenants.stream().anyMatch(a -> Boolean.TRUE.equals(a.getIsv())));
        if (!existedInvoiceInfoTenants.isEmpty()) {
            existedInvoiceInfoTenants.sort((o1, o2) -> Long.compare(Long.parseLong(o2.getTenantSid()), Long.parseLong(o1.getTenantSid())));
            long tenantSid = Long.parseLong(((InvoiceExistVO)existedInvoiceInfoTenants.get(0)).getTenantSid());
            result.put("recentTenant", (Boolean)this.tenantQueryService.findTenantInfo(tenantSid));
        }
        return StdData.ok(result);
    }

    private boolean checkTenantInUserTenants(long tenantSid, AuthoredUser user) {
        List tenants = this.tenantMapper.getTenantBasicInfoWithUserByJoinedUserSid(user.getSid());
        boolean existInTenant = false;
        for (TenantRelationWithUserWithStatusVO tenantVO : tenants) {
            if (tenantVO.getSid() != tenantSid) continue;
            existInTenant = true;
            break;
        }
        return existInTenant;
    }

    @PostMapping(value={"/{tenantSid}/receiver/{receiverSid}/setpreset"})
    public ResponseEntity<?> setPresetReceiver(@PathVariable long tenantSid, @PathVariable long receiverSid, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21005, new Object[]{tenantSid});
        }
        if (UserUtils.getTenantSid() != tenantSid && !this.authValidateService.checkAccessPermission(TargetType.Sys.toString(), "POST", "/api/iam/v3/invoice/{tenantSid}/receiver/{receiverSid}/setpreset", UserUtils.getSysId()).booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        if (tenant.getOwnerUserSid() != authoredUser.getSid() && !this.userInRoleService.checkSuperAdmin(Long.valueOf(tenantSid), Long.valueOf(authoredUser.getSid()))) {
            throw new BusinessException((ErrorHandler)I18nError.INVOICE_NO_AUTHORITY_FOR_MAINTAIN_INVOICE, new Object[]{tenant.getId(), authoredUser.getUserId()});
        }
        InvoiceReceivers invoiceReceivers = (InvoiceReceivers)this.invoiceReceiversCrudService.findBySid(receiverSid);
        if (invoiceReceivers == null) {
            throw new BusinessException((ErrorHandler)I18nError.INVOICE_RECEIVER_NOT_EXISTED, new Object[]{receiverSid});
        }
        if (!this.invoiceInfoService.checkTenantHavePermission(invoiceReceivers.getInvoiceSid(), tenantSid)) {
            throw new BusinessException((ErrorHandler)I18nError.INVOICE_TENANT_NO_AUTH_1, new Object[]{invoiceReceivers.getInvoiceSid(), tenantSid});
        }
        this.invoiceReceiversService.setPresetReceiver(receiverSid, invoiceReceivers.getInvoiceSid());
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @PostMapping(value={"/{tenantSid}/receiver/{receiverSid}"})
    public ResponseEntity<?> deleteReceiver(@PathVariable long tenantSid, @PathVariable long receiverSid, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21005, new Object[]{tenantSid});
        }
        if (tenant.getOwnerUserSid() != authoredUser.getSid() && !this.userInRoleService.checkSuperAdmin(Long.valueOf(tenantSid), Long.valueOf(authoredUser.getSid()))) {
            throw new BusinessException((ErrorHandler)I18nError.INVOICE_NO_AUTHORITY_FOR_MAINTAIN_INVOICE, new Object[]{tenant.getId(), authoredUser.getUserId()});
        }
        InvoiceReceivers invoiceReceivers = (InvoiceReceivers)this.invoiceReceiversCrudService.findBySid(receiverSid);
        if (invoiceReceivers == null) {
            throw new BusinessException((ErrorHandler)I18nError.INVOICE_RECEIVER_NOT_EXISTED, new Object[]{receiverSid});
        }
        if (!this.invoiceInfoService.checkTenantHavePermission(invoiceReceivers.getInvoiceSid(), tenantSid)) {
            throw new BusinessException((ErrorHandler)I18nError.INVOICE_TENANT_NO_AUTH_1, new Object[]{invoiceReceivers.getInvoiceSid(), authoredUser.getTenantId()});
        }
        this.invoiceReceiversCrudService.deleteById(receiverSid);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @PostMapping(value={"/receiver/{receiverSid}"})
    public ResponseEntity<?> deleteReceiver(@PathVariable long receiverSid, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        InvoiceReceivers invoiceReceivers = (InvoiceReceivers)this.invoiceReceiversCrudService.findBySid(receiverSid);
        if (invoiceReceivers == null) {
            throw new BusinessException((ErrorHandler)I18nError.INVOICE_RECEIVER_NOT_EXISTED, new Object[]{receiverSid});
        }
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(authoredUser.getTenantSid());
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21005, new Object[]{authoredUser.getTenantSid()});
        }
        if (tenant.getOwnerUserSid() != authoredUser.getSid() && !this.userInRoleService.checkSuperAdmin(Long.valueOf(authoredUser.getTenantSid()), Long.valueOf(authoredUser.getSid()))) {
            throw new BusinessException((ErrorHandler)I18nError.INVOICE_NO_AUTHORITY_FOR_MAINTAIN_INVOICE, new Object[]{tenant.getId(), authoredUser.getUserId()});
        }
        if (!this.invoiceInfoService.checkTenantHavePermission(invoiceReceivers.getInvoiceSid(), authoredUser.getTenantSid())) {
            throw new BusinessException((ErrorHandler)I18nError.INVOICE_TENANT_NO_AUTH_1, new Object[]{invoiceReceivers.getInvoiceSid(), authoredUser.getTenantId()});
        }
        this.invoiceReceiversCrudService.deleteById(receiverSid);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @DeleteMapping(value={"/{tenantSid}"})
    public ResponseEntity<?> deleteInvoice(@PathVariable long tenantSid, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (authoredUser.getTenantSid() != tenantSid && !this.authValidateService.checkAccessPermission(TargetType.Sys.toString(), "DELETE", "/api/iam/v3/invoice/{tenantSid}", UserUtils.getSysId()).booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21005, new Object[]{tenantSid});
        }
        if (tenant.getOwnerUserSid() != authoredUser.getSid() && !this.userInRoleService.checkSuperAdmin(Long.valueOf(tenantSid), Long.valueOf(authoredUser.getSid()))) {
            throw new BusinessException((ErrorHandler)I18nError.INVOICE_NO_AUTHORITY_FOR_MAINTAIN_INVOICE, new Object[]{tenant.getId(), authoredUser.getUserId()});
        }
        InvoiceInfo invoiceInfo = this.invoiceInfoRepository.getByTenantSid(Long.valueOf(tenantSid));
        if (invoiceInfo != null) {
            this.invoiceInfoCrudService.deleteById(invoiceInfo.getSid());
            return ResponseEntity.ok((Object)HttpStatus.OK);
        }
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @PostMapping(value={""})
    public ResponseEntity<?> saveInvoiceInfo(@RequestBody InvoiceInfo invoiceInfo, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(invoiceInfo.getTenantSid().longValue());
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21005, new Object[]{invoiceInfo.getTenantSid()});
        }
        if (authoredUser.getTenantSid() > 0L && invoiceInfo.getTenantSid().longValue() != authoredUser.getTenantSid() && !this.authValidateService.checkAccessPermission(TargetType.Sys.toString(), "POST", "/api/iam/v3/invoice", UserUtils.getSysId()).booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        if (tenant.getOwnerUserSid() != authoredUser.getSid() && !this.userInRoleService.checkSuperAdmin(invoiceInfo.getTenantSid(), Long.valueOf(authoredUser.getSid()))) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_USER_OWNER_SUPERADMIN_PERMISSION_ERROR);
        }
        if (StringUtils.isEmpty((Object)invoiceInfo.getSid()) || invoiceInfo.getSid() == 0L) {
            InvoiceInfo info = this.invoiceInfoRepository.getByTenantSid(invoiceInfo.getTenantSid());
            if (info == null) {
                this.invoiceInfoCrudService.create((BaseEntity)invoiceInfo);
                return ResponseEntity.ok((Object)HttpStatus.OK);
            }
            invoiceInfo.setSid(info.getSid());
        }
        this.invoiceInfoCrudService.update((BaseEntity)invoiceInfo, true);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }
}

