/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.dev.AppSecretVO;
import com.digiwin.dap.middleware.iam.domain.enumeration.ChangeTypeEnum;
import com.digiwin.dap.middleware.iam.domain.tenant.isv.credential.IsvCredentialListVO;
import com.digiwin.dap.middleware.iam.domain.tenant.isv.credential.IsvCredentialVO;
import com.digiwin.dap.middleware.iam.domain.tenant.isv.credential.VerifyLog;
import com.digiwin.dap.middleware.iam.entity.IsvCredential;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.mapper.IsvCredentialMapper;
import com.digiwin.dap.middleware.iam.service.servicer.IsvCredentialCrudService;
import com.digiwin.dap.middleware.iam.service.servicer.IsvCredentialService;
import com.digiwin.dap.middleware.iam.service.sys.SysCrudService;
import com.digiwin.dap.middleware.iam.support.log.ChangeLogService;
import com.digiwin.dap.middleware.iam.support.validate.AuthValidateService;
import com.digiwin.dap.middleware.util.UserUtils;
import com.github.pagehelper.PageSerializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v1/isv/credential"})
public class IsvCredentialController {
    private static final String ISV_CREDENTIAL = "entity:isv:credential:key:%s:%s";
    private static final String ISV_CREDENTIAL_RECORD = "ram:api:sign:verify:%s:%s";
    private static final long INTERVAL_HOUR = 1L;
    @Autowired
    private IsvCredentialCrudService isvCredentialCrudService;
    @Autowired
    private IsvCredentialService isvCredentialService;
    @Autowired
    private IsvCredentialMapper isvCredentialMapper;
    @Autowired
    private SysCrudService sysCrudService;
    @Autowired
    private ChangeLogService changeLogService;
    @Autowired
    private AuthValidateService authValidateService;

    @PostMapping(value={"/add"})
    public StdData<Long> add(@RequestBody IsvCredentialVO body) {
        return StdData.ok((Object)this.isvCredentialService.add(body));
    }

    @PostMapping(value={"/del"})
    public StdData<?> del(@RequestBody IsvCredentialVO body) {
        IsvCredential credential = (IsvCredential)this.isvCredentialCrudService.findBySid(body.getSid().longValue());
        if (credential != null) {
            if (UserUtils.getTenantSid() != credential.getTenantSid() && !this.authValidateService.checkAccessPermission(TargetType.Sys.name(), "POST", AppAuthContextHolder.getContext().getRequestInfo().getPath(), UserUtils.getSysId()).booleanValue()) {
                throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
            }
            this.isvCredentialCrudService.deleteById(body.getSid().longValue());
            RedisUtils.delete((String)String.format(ISV_CREDENTIAL, credential.getTenantSid(), credential.getDevKey()));
            this.changeLogService.createChangeLog(ChangeTypeEnum.ISV_CREDENTIAL_DEL.getName(), (Object)credential, ChangeTypeEnum.ISV_CREDENTIAL_DEL.getPrimaryKey(), credential.getId());
        }
        return StdData.ok().build();
    }

    @PostMapping(value={"/mod"})
    public StdData<?> mod(@RequestBody IsvCredentialVO body) {
        IsvCredential credential = this.isvCredentialService.mod(body);
        if (credential != null) {
            if (UserUtils.getTenantSid() != credential.getTenantSid() && !this.authValidateService.checkAccessPermission(TargetType.Sys.name(), "POST", AppAuthContextHolder.getContext().getRequestInfo().getPath(), UserUtils.getSysId()).booleanValue()) {
                throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
            }
            RedisUtils.delete((String)String.format(ISV_CREDENTIAL, credential.getTenantSid(), credential.getDevKey()));
        }
        return StdData.ok().build();
    }

    @PostMapping(value={"/search"})
    public StdData<?> find(@RequestBody IsvCredentialVO body) {
        body.setOrderBy(Optional.ofNullable(body.getOrderBy()).orElse("i.sid desc"));
        List result = this.isvCredentialMapper.findPage(body);
        this.updateCredentialVerifyDate(result);
        return StdData.ok((Object)new PageSerializable(result));
    }

    @PostMapping(value={"/tenant/search"})
    public StdData<?> findTenant(@RequestBody(required=false) IsvCredentialVO body) {
        IsvCredentialVO condition = Optional.ofNullable(body).orElse(new IsvCredentialVO());
        condition.setTenantSid(Long.valueOf(UserUtils.getTenantSid()));
        List result = this.isvCredentialMapper.findPage(condition);
        this.updateCredentialVerifyDate(result);
        return StdData.ok((Object)new PageSerializable(result));
    }

    @PostMapping(value={"/export"})
    public void export(@RequestBody IsvCredentialVO body, HttpServletResponse response) {
        this.isvCredentialService.export(Long.valueOf(UserUtils.getTenantSid()), body.getSid() == null ? 0L : body.getSid(), response);
    }

    @PostMapping(value={"/secret/current"})
    public StdData<?> secret(@RequestBody(required=false) IsvCredential body) {
        IsvCredential isvCredential = this.isvCredentialCrudService.findByDevKey(body.getDevKey());
        if (isvCredential == null) {
            return StdData.ok((Object)new AppSecretVO(body.getDevKey()));
        }
        if (isvCredential.isDisabled()) {
            throw new BusinessException("\u8bbf\u95ee\u51ed\u8bc1[" + isvCredential.getDevKey() + "]\u5df2\u7ecf\u505c\u7528");
        }
        return StdData.ok((Object)new AppSecretVO(isvCredential.getDevKey(), isvCredential.getDevSecret()));
    }

    private void updateCredentialVerifyDate(List<IsvCredentialListVO> credentials) {
        credentials.stream().filter(p -> p.getVerifyDate() == null || LocalDateTime.now().isAfter(p.getVerifyDate().plusHours(1L))).forEach(credentialVO -> {
            IsvCredential credential = (IsvCredential)this.isvCredentialCrudService.findBySid(credentialVO.getSid());
            VerifyLog verifyLog = (VerifyLog)RedisUtils.get((Object)String.format(ISV_CREDENTIAL_RECORD, credential.getTenantSid(), credential.getDevKey()), VerifyLog.class);
            if (verifyLog != null && !Objects.equals(verifyLog.getVerifyDate(), credential.getVerifyDate())) {
                credentialVO.setVerifyDate(verifyLog.getVerifyDate());
                credentialVO.setSysId(verifyLog.getSysId());
                Sys sys = (Sys)this.sysCrudService.findById(verifyLog.getSysId());
                credentialVO.setSysName(sys == null ? null : sys.getName());
                credential.setVerifyDate(verifyLog.getVerifyDate());
                credential.setSysId(verifyLog.getSysId());
                this.isvCredentialCrudService.update((BaseEntity)credential);
            }
        });
    }
}

