/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.tenant.IsvRankCompromiseVO;
import com.digiwin.dap.middleware.iam.entity.IsvRank;
import com.digiwin.dap.middleware.iam.mapper.IsvRankMapper;
import com.digiwin.dap.middleware.iam.service.servicer.IsvRankCrudService;
import com.github.pagehelper.PageSerializable;
import com.github.pagehelper.page.PageMethod;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v1/isv/rank"})
public class IsvRankController {
    @Autowired
    private IsvRankCrudService isvRankCrudService;
    @Autowired
    private IsvRankMapper isvRankMapper;

    @PostMapping(value={"/add"})
    public StdData<Long> add(@RequestBody IsvRankCompromiseVO body) {
        IsvRank exist = this.isvRankCrudService.findById(body.getDictKey());
        if (exist != null) {
            throw new BusinessException((ErrorHandler)I18nError.DICT_KEY_HAS_EXIST, new Object[]{body.getDictKey()});
        }
        IsvRank isvRank = new IsvRank();
        isvRank.setId(body.getDictKey());
        isvRank.setName(body.getDictValue());
        isvRank.setAppSharePercentage(body.getAppSharePercentage());
        isvRank.setServiceSharePercentage(body.getServiceSharePercentage());
        isvRank.setRemark(body.getRemark());
        this.isvRankCrudService.create((BaseEntity)isvRank);
        return StdData.ok((Object)isvRank.getSid());
    }

    @PostMapping(value={"/del"})
    public StdData<?> del(@RequestBody IsvRankCompromiseVO body) {
        this.isvRankCrudService.deleteById(body.getSid().longValue());
        return StdData.ok().build();
    }

    @PostMapping(value={"/mod"})
    public StdData<?> mod(@RequestBody IsvRankCompromiseVO body) {
        IsvRank isvRank = (IsvRank)this.isvRankCrudService.findBySid(body.getSid().longValue());
        if (isvRank != null) {
            isvRank.setId(body.getDictKey());
            isvRank.setName(body.getDictValue());
            isvRank.setAppSharePercentage(body.getAppSharePercentage());
            isvRank.setServiceSharePercentage(body.getServiceSharePercentage());
            isvRank.setRemark(body.getRemark());
            this.isvRankCrudService.update((BaseEntity)isvRank);
        }
        return StdData.ok().build();
    }

    @PostMapping(value={"/search"})
    public StdData<?> find(@RequestBody IsvRankCompromiseVO body) {
        PageMethod.startPage((int)body.getPageNum(), (int)body.getPageSize());
        List result = this.isvRankMapper.findPage(body);
        return StdData.ok((Object)new PageSerializable(result));
    }
}

