/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.ComeFromEnum;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.metadata.MetadaVO;
import com.digiwin.dap.middleware.iam.domain.metadata.MetadataBatchQueryVO;
import com.digiwin.dap.middleware.iam.domain.metadata.MetadataColumnVO;
import com.digiwin.dap.middleware.iam.domain.metadata.MetadataInfoVO;
import com.digiwin.dap.middleware.iam.domain.org.RequestParameterVO;
import com.digiwin.dap.middleware.iam.domain.user.BatchQueryUserMetadataVO;
import com.digiwin.dap.middleware.iam.domain.user.QueryParameterInfoVO;
import com.digiwin.dap.middleware.iam.domain.user.UserMetadataVO;
import com.digiwin.dap.middleware.iam.domain.user.UserWithMetadataVO;
import com.digiwin.dap.middleware.iam.domain.usermapping.IntegrationQueryRequestVO;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserMapping;
import com.digiwin.dap.middleware.iam.service.metadata.MetadataColumnCrudService;
import com.digiwin.dap.middleware.iam.service.metadata.MetadataColumnUpdateService;
import com.digiwin.dap.middleware.iam.service.metadata.MetadataCrudService;
import com.digiwin.dap.middleware.iam.service.metadata.MetadataQueryService;
import com.digiwin.dap.middleware.iam.service.metadata.MetadataUpdateService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.usermapping.UserMappingCrudService;
import com.digiwin.dap.middleware.iam.service.usermapping.UserMappingService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEMCService;
import com.digiwin.dap.middleware.iam.support.remote.domain.ThirdUserVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.WeComUserVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.emc.AppConfigVO;
import com.digiwin.dap.middleware.iam.support.validate.AuthValidateService;
import com.digiwin.dap.middleware.iam.util.StringUtil;
import com.digiwin.dap.middleware.util.UserUtils;
import io.github.resilience4j.ratelimiter.annotation.RateLimiter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.util.Strings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2/usermetadata"})
public class MetadataController {
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private MetadataCrudService metadataCrudService;
    @Autowired
    private MetadataQueryService metadataQueryService;
    @Autowired
    private MetadataUpdateService metadataUpdateService;
    @Autowired
    private MetadataColumnCrudService metadataColumnCrudService;
    @Autowired
    private MetadataColumnUpdateService metadataColumnUpdateService;
    @Autowired
    private AuthValidateService authValidateService;
    @Autowired
    private RemoteEMCService remoteEMCService;
    @Autowired
    private UserMappingService userMappingService;
    @Autowired
    private UserMappingCrudService userMappingCrudService;

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={""})
    public ResponseEntity<?> getUserMetadataByTenant(@RequestBody RequestParameterVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (authoredUser.getTenantSid() == 0L) {
            throw new IllegalArgumentException("\u5f53\u524d\u767b\u5f55\u7528\u6237\u6ca1\u6709\u79df\u6237\u4fe1\u606f\uff01");
        }
        if (body.getSid() == 0L && Strings.isEmpty((CharSequence)body.getId())) {
            throw new IllegalArgumentException("\u7528\u6237Id\u548cSid\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        if (body.getSid() == 0L) {
            body.setSid(this.userCrudService.getSidById(body.getId()));
            Assert.isTrue((body.getSid() != 0L ? 1 : 0) != 0, (String)String.format("\u7528\u6237[%s]\u4e0d\u5b58\u5728\uff01", body.getId()));
        }
        User user = (User)this.userCrudService.findBySid(body.getSid());
        Assert.notNull((Object)user, (String)String.format("\u7528\u6237[%s]\u4e0d\u5b58\u5728\uff01", body.getSid()));
        if (!user.getId().equalsIgnoreCase(authoredUser.getUserId()) && !this.authValidateService.checkAccessPermission(TargetType.Sys.toString(), "POST", "/api/iam/v2/usermetadata", UserUtils.getSysId()).booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_USER_PERMISSION_ERROR);
        }
        List userMetadataVOList = this.metadataQueryService.queryUserMetadataByTenantSidAndUserSid(Long.valueOf(authoredUser.getTenantSid()), Long.valueOf(user.getSid()));
        UserWithMetadataVO userWithMetadataVO = new UserWithMetadataVO(user.getSid(), user.getId(), user.getName(), user.getHash(), userMetadataVOList);
        return new ResponseEntity((Object)userWithMetadataVO, HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/current"})
    public ResponseEntity<?> getCurrentUserMetadata(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        User user = (User)this.userCrudService.findById(authoredUser.getUserId());
        Assert.notNull((Object)user, (String)"\u7528\u6237[%s]\u4e0d\u5b58\u5728\uff01");
        List userMetadataVOList = this.metadataQueryService.queryUserMetadataByUserSid(Long.valueOf(user.getSid()));
        UserWithMetadataVO userWithMetadataVO = new UserWithMetadataVO(user.getSid(), user.getId(), user.getName(), user.getHash(), userMetadataVOList);
        return new ResponseEntity((Object)userWithMetadataVO, HttpStatus.OK);
    }

    @PostMapping(value={"/all"})
    public ResponseEntity<?> getUserMetadata(@RequestBody RequestParameterVO body) {
        if (ObjectUtils.isEmpty((Object)body.getId())) {
            throw new IllegalArgumentException("user id is null");
        }
        User user = (User)this.userCrudService.findById(body.getId());
        Assert.notNull((Object)user, (String)"\u7528\u6237[%s]\u4e0d\u5b58\u5728\uff01");
        List userMetadataVOList = this.metadataQueryService.queryUserMetadataByUserSid(Long.valueOf(user.getSid()));
        ArrayList matchUserMetaDataList = new ArrayList();
        if (!this.authValidateService.checkAccessPermission(TargetType.Sys.name(), "POST", "/api/iam/v2/usermetadata/all", UserUtils.getSysId()).booleanValue()) {
            userMetadataVOList.forEach(u -> {
                if (0L != u.getTenantSid() && UserUtils.getTenantSid() == u.getTenantSid()) {
                    matchUserMetaDataList.add(u);
                }
            });
        }
        UserWithMetadataVO userWithMetadataVO = new UserWithMetadataVO(user.getSid(), user.getId(), user.getName(), user.getHash(), matchUserMetaDataList);
        return new ResponseEntity((Object)userWithMetadataVO, HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/update"})
    public ResponseEntity<?> updateUserMetadata(@RequestBody UserWithMetadataVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        List appConfigList;
        Assert.isTrue((authoredUser.getTenantSid() != 0L ? 1 : 0) != 0, (String)"\u5f53\u524d\u767b\u5f55\u7528\u6237\u6ca1\u6709\u79df\u6237\u4fe1\u606f\uff01");
        if (body.getSid() == 0L && Strings.isEmpty((CharSequence)body.getId())) {
            throw new IllegalArgumentException("\u7528\u6237Sid\u548c\u7528\u6237Id\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (body.getSid() == 0L) {
            body.setSid(this.userCrudService.getSidById(body.getId()));
        }
        User user = (User)this.userCrudService.findBySid(body.getSid());
        Assert.notNull((Object)user, (String)String.format("\u8be5\u7528\u6237[%s]\u4e0d\u5b58\u5728\uff01", body.getSid()));
        Assert.notNull((Object)body.getMetadata(), (String)"\u9644\u52a0\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        UserMetadataVO openWeComMetadata = null;
        String dingdingUnionId = null;
        for (UserMetadataVO metadataVO : body.getMetadata()) {
            Assert.hasText((String)metadataVO.getKey(), (String)"\u9644\u52a0\u5c5e\u6027key\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            Assert.hasText((String)metadataVO.getValue(), (String)"\u9644\u52a0\u5c5e\u6027value\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            Assert.hasText((String)metadataVO.getCatalogId(), (String)"\u9644\u52a0\u5c5e\u6027catalogId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            if ("contact".equals(metadataVO.getCatalogId()) && "wechat".equals(metadataVO.getKey())) {
                if (StringUtils.hasText((String)metadataVO.getValue())) {
                    WeComUserVO weComUserVO = this.remoteEMCService.checkWechatExistReturnOpenUserId(null, authoredUser.getTenantId(), metadataVO.getValue(), body.getId());
                    if (Objects.isNull(weComUserVO)) {
                        throw new BusinessException((ErrorHandler)I18nError.USER_WECHAT_EXIST_ERROR);
                    }
                    if (StringUtils.hasText((String)weComUserVO.getOpen_userid())) {
                        openWeComMetadata = new UserMetadataVO("contact", "open_wecom", weComUserVO.getOpen_userid(), Long.valueOf(authoredUser.getTenantSid()), Long.valueOf(body.getSid()));
                    }
                } else {
                    openWeComMetadata = new UserMetadataVO("contact", "open_wecom", "", Long.valueOf(authoredUser.getTenantSid()), Long.valueOf(body.getSid()));
                }
            }
            if (!"integrationUserId".equals(metadataVO.getCatalogId()) || !ComeFromEnum.DINGDING.getId().equals(metadataVO.getKey()) || !StringUtils.hasText((String)metadataVO.getValue())) continue;
            ThirdUserVO dingdingUserVO = this.remoteEMCService.checkDingdingExist(null, authoredUser.getTenantId(), metadataVO.getValue(), body.getId());
            if (Objects.isNull(dingdingUserVO)) {
                throw new BusinessException((ErrorHandler)I18nError.USER_DINGDING_EXIST_ERROR);
            }
            dingdingUnionId = dingdingUserVO.getUnionId();
        }
        if (Objects.nonNull(openWeComMetadata)) {
            body.getMetadata().add(openWeComMetadata);
        }
        this.metadataUpdateService.updateMetadataByTenant(authoredUser.getTenantSid(), user.getId(), body.getMetadata());
        if (StringUtils.hasText(dingdingUnionId) && !CollectionUtils.isEmpty((Collection)(appConfigList = this.remoteEMCService.findAppConfig(authoredUser.getTenantId(), "dingTalk", "")))) {
            String dingUnionId = dingdingUnionId;
            List sysIdList = appConfigList.stream().map(AppConfigVO::getSysId).filter(StringUtils::hasLength).collect(Collectors.toList());
            List userMappings = this.userMappingCrudService.findByTenantSidAndUserSidAndAccount(authoredUser.getTenantSid(), user.getSid(), ComeFromEnum.DINGDING.getId());
            if (!CollectionUtils.isEmpty((Collection)userMappings)) {
                userMappings.forEach(e -> {
                    e.setVerifyUserId(dingUnionId);
                    sysIdList.remove(e.getAppId());
                });
                this.userMappingCrudService.saveAll((Iterable)userMappings);
            }
            List userMappingList = sysIdList.stream().map(e -> {
                UserMapping userMapping = new UserMapping();
                userMapping.setTenantSid(authoredUser.getTenantSid());
                userMapping.setUserSid(user.getSid());
                userMapping.setAccount(ComeFromEnum.DINGDING.getId());
                userMapping.setAppId(e);
                userMapping.setVerifyUserId(dingUnionId);
                return userMapping;
            }).collect(Collectors.toList());
            this.userMappingCrudService.saveAll(userMappingList);
        }
        return new ResponseEntity(HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/remove"})
    public ResponseEntity<?> removeUserMetadata(@RequestBody MetadataInfoVO body) {
        Tenant tenant;
        Assert.hasText((String)body.getKey(), (String)"\u9644\u52a0\u5c5e\u6027key\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)body.getCatalogId(), (String)"\u9644\u52a0\u5c5e\u6027catalogId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        long tenantSid = 0L;
        boolean isCorpDingTalk = false;
        if (StringUtils.hasText((String)body.getTenantId()) && (tenant = (Tenant)this.tenantCrudService.findById(body.getTenantId())) != null) {
            tenantSid = tenant.getSid();
            isCorpDingTalk = tenant.isCorpDingTalk();
        }
        Assert.hasText((String)body.getUserId(), (String)"\u7528\u6237Id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        long userSid = this.userCrudService.getSidById(body.getUserId());
        Assert.isTrue((userSid != 0L ? 1 : 0) != 0, (String)String.format("\u8be5\u7528\u6237[%s]\u4e0d\u5b58\u5728\uff01", body.getUserId()));
        this.metadataCrudService.removeMetadata(tenantSid, userSid, body.getCatalogId(), body.getKey());
        if ("contact".equals(body.getCatalogId()) && "wechat".equals(body.getKey())) {
            this.metadataCrudService.removeMetadata(tenantSid, userSid, "contact", "open_wecom");
        }
        if ("integrationUserId".equals(body.getCatalogId()) && ComeFromEnum.DINGDING.getId().equals(body.getKey()) && isCorpDingTalk) {
            this.userMappingService.deleteAccountMapping(tenantSid, body.getUserId(), Collections.singletonList(ComeFromEnum.DINGDING.getId()));
        }
        return new ResponseEntity(HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/current/tenant/remove"})
    public StdData removeUserMetadataCurrentTenant(@RequestBody MetadataInfoVO body) {
        body.setTenantId(UserUtils.getTenantId());
        this.removeUserMetadata(body);
        return StdData.ok().build();
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/column"})
    public ResponseEntity<?> getUserMetadataColumn(@RequestBody QueryParameterInfoVO body) {
        List metadataColumnVOList;
        if (body.getQueryParameter().getType() == null) {
            throw new IllegalArgumentException("\u67e5\u8be2\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        switch (body.getQueryParameter().getType()) {
            case "catalog": {
                metadataColumnVOList = this.metadataColumnCrudService.getMetadataColumnByCatalogId(body.getQueryParameter().getId());
                break;
            }
            case "all": {
                metadataColumnVOList = this.metadataColumnCrudService.getAllMetadataColumn();
                break;
            }
            default: {
                throw new IllegalArgumentException("\u67e5\u8be2\u7c7b\u578b\u4e0d\u89c4\u8303\uff01");
            }
        }
        return new ResponseEntity((Object)metadataColumnVOList, HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/column/update"})
    public ResponseEntity<?> updateMetadataColumn(@RequestBody MetadataColumnVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Assert.isTrue((authoredUser.getTenantSid() != 0L ? 1 : 0) != 0, (String)"\u5f53\u524d\u767b\u5f55\u7528\u6237\u6ca1\u6709\u79df\u6237\u4fe1\u606f\uff01");
        Assert.hasText((String)body.getKey(), (String)"\u9644\u52a0\u5c5e\u6027key\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)body.getName(), (String)"\u9644\u52a0\u5c5e\u6027name\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)body.getCatalogId(), (String)"\u9644\u52a0\u5c5e\u6027CatalogId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)body.getType(), (String)"\u9644\u52a0\u5c5e\u6027Type\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)body.getTypeParameter(), (String)"\u9644\u52a0\u5c5e\u6027TypeParameter\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        body.setTenantSid(authoredUser.getTenantSid());
        this.metadataColumnUpdateService.updateMetadataColumn(body);
        return new ResponseEntity(HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/updateMedataInfo"})
    public ResponseEntity<?> updateMedataInfo(@RequestBody MetadaVO metadaVO) {
        Assert.hasText((String)metadaVO.getUserId(), (String)"userId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)metadaVO.getTenantId(), (String)"tenantId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)metadaVO.getParameter(), (String)"parameter\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.metadataUpdateService.updateMetadata(metadaVO);
        return new ResponseEntity(HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/user/language"})
    public StdData updateMetadata(@RequestBody UserMetadataVO userMetadataVO) {
        try {
            if (userMetadataVO == null || StringUtils.isEmpty((Object)userMetadataVO.getKey()) || StringUtils.isEmpty((Object)userMetadataVO.getCatalogId()) || StringUtils.isEmpty((Object)userMetadataVO.getUserSid())) {
                throw new BusinessException((ErrorHandler)I18nError.PARAM_ERROR);
            }
            String key = userMetadataVO.getKey();
            if ("dapAcceptLanguage".equals(key) && !StringUtil.checkMetaLanguage((String)userMetadataVO.getValue())) {
                throw new BusinessException((ErrorHandler)I18nError.PARAM_ERROR);
            }
            if (userMetadataVO.getUserSid() != UserUtils.getUserSid() && !this.authValidateService.checkAccessPermission(TargetType.Sys.toString(), "POST", "/api/iam/v2/usermetadata/user/language", UserUtils.getSysId()).booleanValue()) {
                throw new BusinessException((ErrorHandler)I18nError.IAM_USER_PERMISSION_ERROR);
            }
            this.metadataUpdateService.updateMetadataValue(userMetadataVO);
            return StdData.ok().build();
        }
        catch (Exception ex) {
            return StdData.of((int)500, (String)ex.getMessage());
        }
    }

    @PostMapping(value={"/value/user/list"})
    public StdData<?> getMetadataByValue(@RequestBody UserMetadataVO metadataVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        return StdData.ok((Object)this.metadataQueryService.queryUserMetadataByValue(authoredUser.getTenantSid(), metadataVO.getValue(), metadataVO.getCatalogId(), metadataVO.getKey()));
    }

    @PostMapping(value={"/user/acceptcontacts/get"})
    public StdData getMetadataAcceptContacts(@RequestBody UserMetadataVO metadataVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        try {
            metadataVO.setCatalogId("contact");
            metadataVO.setKey("acceptContacts");
            UserMetadataVO userMetadataVO = this.getMetaDataValue(metadataVO);
            return StdData.ok((Object)userMetadataVO);
        }
        catch (Exception ex) {
            return StdData.of((int)500, (String)ex.getMessage());
        }
    }

    @PostMapping(value={"/user/get"})
    @RateLimiter(name="/api/iam/v2/usermetadata/user/get")
    public StdData getMetadataValue(@RequestBody UserMetadataVO metadataVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        try {
            if (StringUtils.isEmpty((Object)metadataVO.getCatalogId())) {
                throw new BusinessException((ErrorHandler)I18nError.PARAM_MISS);
            }
            if (StringUtils.isEmpty((Object)metadataVO.getKey())) {
                throw new BusinessException((ErrorHandler)I18nError.PARAM_MISS);
            }
            UserMetadataVO userMetadataVO = this.getMetaDataValue(metadataVO);
            return StdData.ok((Object)userMetadataVO);
        }
        catch (Exception ex) {
            return StdData.of((int)500, (String)ex.getMessage());
        }
    }

    @PostMapping(value={"/user/get/batch"})
    @RateLimiter(name="/api/iam/v2/usermetadata/user/get")
    public StdData batchGetMetadataValue(@RequestBody BatchQueryUserMetadataVO metadataVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        try {
            if (!StringUtils.hasLength((String)metadataVO.getCatalogId())) {
                throw new BusinessException((ErrorHandler)I18nError.PARAM_MISS);
            }
            if (!StringUtils.hasLength((String)metadataVO.getKey())) {
                throw new BusinessException((ErrorHandler)I18nError.PARAM_MISS);
            }
            if (CollectionUtils.isEmpty((Collection)metadataVO.getUserSidList()) && CollectionUtils.isEmpty((Collection)metadataVO.getUserIdList())) {
                throw new BusinessException((ErrorHandler)I18nError.PARAM_MISS);
            }
            if (!CollectionUtils.isEmpty((Collection)metadataVO.getUserSidList()) && metadataVO.getUserSidList().size() > 500) {
                throw new BusinessException((ErrorHandler)I18nError.PARAM_ERROR);
            }
            if (!CollectionUtils.isEmpty((Collection)metadataVO.getUserIdList()) && metadataVO.getUserIdList().size() > 500) {
                throw new BusinessException((ErrorHandler)I18nError.PARAM_ERROR);
            }
            List userMetadataVOList = this.metadataQueryService.batchGetUserMetadataValue(metadataVO.getTenantSid().longValue(), metadataVO.getUserSidList(), metadataVO.getUserIdList(), metadataVO.getCatalogId(), metadataVO.getKey());
            return StdData.ok((Object)userMetadataVOList);
        }
        catch (Exception ex) {
            return StdData.of((int)500, (String)ex.getMessage());
        }
    }

    private UserMetadataVO getMetaDataValue(UserMetadataVO metadataVO) {
        Assert.isTrue((metadataVO.getUserSid() != null || !StringUtils.isEmpty((Object)metadataVO.getUserId()) ? 1 : 0) != 0, (String)"userSid\u3001userId\u4e0d\u80fd\u5168\u4e3a\u7a7a\uff01");
        if (metadataVO.getUserSid() == null && !StringUtils.isEmpty((Object)metadataVO.getUserId())) {
            User user = (User)this.userCrudService.findById(metadataVO.getUserId());
            if (user == null) {
                throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST, new Object[]{metadataVO.getUserId()});
            }
            metadataVO.setUserSid(Long.valueOf(user.getSid()));
        }
        Assert.notNull((Object)metadataVO.getTenantSid(), (String)"tenantSid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        return this.metadataQueryService.getUserMetadataValue(metadataVO.getTenantSid().longValue(), metadataVO.getUserSid().longValue(), metadataVO.getCatalogId(), metadataVO.getKey());
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/user/acceptcontacts"})
    public StdData updateMetadataAcceptContacts(@RequestBody UserMetadataVO userMetadataVO) {
        try {
            if (userMetadataVO == null || StringUtils.isEmpty((Object)userMetadataVO.getKey()) || StringUtils.isEmpty((Object)userMetadataVO.getCatalogId()) || userMetadataVO.getUserSid() == null && StringUtils.isEmpty((Object)userMetadataVO.getUserId())) {
                throw new BusinessException((ErrorHandler)I18nError.PARAM_MISS);
            }
            if (userMetadataVO.getUserSid() == null && !StringUtils.isEmpty((Object)userMetadataVO.getUserId())) {
                User user = (User)this.userCrudService.findById(userMetadataVO.getUserId());
                if (user == null) {
                    throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST, new Object[]{userMetadataVO.getUserId()});
                }
                userMetadataVO.setUserSid(Long.valueOf(user.getSid()));
            }
            this.metadataUpdateService.updateMetadataValue(userMetadataVO);
            return StdData.ok().build();
        }
        catch (Exception ex) {
            return StdData.of((int)500, (String)ex.getMessage());
        }
    }

    @PostMapping(value={"/user/integration/id"})
    public StdData<?> getMetadataAcceptContacts(@RequestBody IntegrationQueryRequestVO vo) {
        return StdData.ok((Object)this.metadataQueryService.getIntegrationUserId(vo));
    }

    @PostMapping(value={"/user/list"})
    public StdData<?> batchQueryUserMetadata(@RequestBody MetadataBatchQueryVO vo, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        long tenantSid = 0L;
        if (vo.isDistinguishTenant()) {
            tenantSid = authoredUser.getTenantSid();
        }
        return StdData.ok((Object)this.metadataQueryService.queryUserMetadata(tenantSid, vo.getUserIds(), vo.getCatalogId(), vo.getKey()));
    }
}

