/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.iam.api.base.AppBaseController;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.app.ModuleQueryResultVO;
import com.digiwin.dap.middleware.iam.domain.app.ModuleVO;
import com.digiwin.dap.middleware.iam.service.app.ModuleCrudService;
import com.digiwin.dap.middleware.iam.service.app.ModuleQueryService;
import com.digiwin.dap.middleware.iam.service.app.ModuleService;
import com.digiwin.dap.middleware.iam.service.sys.SysCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2/app"})
public class ModuleController
extends AppBaseController {
    @Autowired
    private SysCrudService sysCrudService;
    @Autowired
    private ModuleCrudService moduleCrudService;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private ModuleQueryService moduleQueryService;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private UserInRoleService userInRoleService;

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/module/update"})
    public ResponseEntity<?> updateModule(@RequestBody ModuleVO moduleVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        this.checkAuth(authoredUser, this.envProperties, this.userInRoleService);
        long appSid = this.getAppSid(this.sysCrudService, moduleVO.getAppSid(), moduleVO.getAppId());
        moduleVO.setAppSid(appSid);
        long oldModuleSid = this.moduleCrudService.getSidByUnionKey(new Object[]{moduleVO.getId(), moduleVO.getAppSid()});
        if (oldModuleSid == 0L) {
            long moduleSid = this.moduleService.addModule(moduleVO);
            return ResponseEntity.ok((Object)moduleSid);
        }
        this.moduleService.modifyModule(moduleVO);
        return ResponseEntity.ok((Object)oldModuleSid);
    }

    @PostMapping(value={"/module"})
    public ResponseEntity<?> getModule(@RequestBody ModuleVO moduleVO) {
        long appSid = this.getAppSid(this.sysCrudService, moduleVO.getAppSid(), moduleVO.getAppId());
        long moduleSid = this.getModuleSid(this.moduleCrudService, appSid, moduleVO.getSid(), moduleVO.getId());
        ModuleQueryResultVO moduleQueryResultVO = this.moduleQueryService.getModuleBySysSidAndModuleSid(appSid, moduleSid);
        return ResponseEntity.ok((Object)moduleQueryResultVO);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/module/disable"})
    public ResponseEntity<?> disModule(@RequestBody ModuleVO moduleVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        this.checkAuth(authoredUser, this.envProperties, this.userInRoleService);
        long appSid = this.getAppSid(this.sysCrudService, moduleVO.getAppSid(), moduleVO.getAppId());
        long moduleSid = this.getModuleSid(this.moduleCrudService, appSid, moduleVO.getSid(), moduleVO.getId());
        this.moduleService.disModule(0L, appSid, moduleSid);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @PostMapping(value={"/module/cascade"})
    public ResponseEntity<?> getModuleCascade(@RequestBody ModuleVO moduleVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        long appSid = this.getAppSid(this.sysCrudService, moduleVO.getAppSid(), moduleVO.getAppId());
        long moduleSid = this.getModuleSid(this.moduleCrudService, appSid, moduleVO.getSid(), moduleVO.getId());
        ModuleQueryResultVO moduleQueryResultVO = this.moduleQueryService.getModuleCascade(authoredUser.getTenantSid(), appSid, moduleSid);
        return ResponseEntity.ok((Object)moduleQueryResultVO);
    }
}

