/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.oauth.OauthAccessToken;
import com.digiwin.dap.middleware.iam.domain.oauth.OauthAccessTokenRequest;
import com.digiwin.dap.middleware.iam.domain.oauth.OauthAppVO;
import com.digiwin.dap.middleware.iam.domain.oauth.OauthAuthCode;
import com.digiwin.dap.middleware.iam.domain.oauth.OauthAuthRequest;
import com.digiwin.dap.middleware.iam.domain.oauth.OauthRefreshTokenRequest;
import com.digiwin.dap.middleware.iam.domain.oauth.OauthScopeApiVO;
import com.digiwin.dap.middleware.iam.entity.OauthApi;
import com.digiwin.dap.middleware.iam.entity.OauthApp;
import com.digiwin.dap.middleware.iam.entity.OauthScope;
import com.digiwin.dap.middleware.iam.entity.OauthScopeApi;
import com.digiwin.dap.middleware.iam.repository.OauthApiRepository;
import com.digiwin.dap.middleware.iam.repository.OauthAppRepository;
import com.digiwin.dap.middleware.iam.repository.OauthScopeApiRepository;
import com.digiwin.dap.middleware.iam.repository.OauthScopeRepository;
import com.digiwin.dap.middleware.iam.service.oauth.OauthAppCrudService;
import com.digiwin.dap.middleware.iam.service.oauth.OauthService;
import com.digiwin.dap.middleware.iam.support.validate.AuthValidateService;
import com.digiwin.dap.middleware.util.SnowFlake;
import com.digiwin.dap.middleware.util.UserUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2"})
public class OauthController {
    private Logger logger = LoggerFactory.getLogger(OauthController.class);
    @Autowired
    private OauthService oauthService;
    @Autowired
    private OauthAppCrudService oauthAppCrudService;
    @Autowired
    private OauthAppRepository oauthAppRepository;
    @Autowired
    private OauthScopeRepository oauthScopeRepository;
    @Autowired
    private OauthApiRepository oauthApiRepository;
    @Autowired
    private OauthScopeApiRepository oauthScopeApiRepository;
    @Autowired
    private AuthValidateService authValidateService;

    @PostMapping(value={"/oauth2/app/register"})
    public StdData addOauthApp(@RequestBody @Valid OauthAppVO oauthAppVO, @RequestAttribute(name="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (authoredUser.getTenantSid() == 0L || authoredUser.getSid() == 0L) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_ID_AND_USER_NOT_NULL);
        }
        oauthAppVO.setTenantSid(authoredUser.getTenantSid());
        oauthAppVO.setOwnerUserSid(authoredUser.getSid());
        long sid = this.oauthService.registerApp(oauthAppVO);
        return StdData.ok((Object)sid);
    }

    @GetMapping(value={"/oauth2/app/{appSid}"})
    public StdData getOauthApp(@PathVariable(value="appSid") long appSid, @RequestAttribute(name="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (authoredUser.getTenantSid() == 0L || authoredUser.getSid() == 0L) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_ID_AND_USER_NOT_NULL);
        }
        OauthApp oauthApp = (OauthApp)this.oauthAppCrudService.findBySid(appSid);
        if (oauthApp != null) {
            if (authoredUser.getTenantSid() != oauthApp.getTenantSid()) {
                return StdData.of((int)500, (String)String.format("\u79df\u6237%s\u4e0b\u4e0d\u5b58\u5728\u5e94\u7528%s", authoredUser.getTenantId(), oauthApp.getName()));
            }
            if (authoredUser.getSid() != oauthApp.getOwnerUserSid()) {
                return StdData.of((int)500, (String)String.format("\u7528\u6237%s\u6ca1\u6709\u6743\u9650\u67e5\u770b\u5e94\u7528%s", authoredUser.getUserId(), oauthApp.getName()));
            }
        }
        return StdData.ok((Object)oauthApp);
    }

    @PostMapping(value={"/oauth2/app/{appSid}"})
    public StdData updateOauthApp(@PathVariable(value="appSid") long appSid, @RequestBody @Valid OauthAppVO oauthAppVO, @RequestAttribute(name="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (authoredUser.getTenantSid() == 0L || authoredUser.getSid() == 0L) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_ID_AND_USER_NOT_NULL);
        }
        OauthApp oauthApp = (OauthApp)this.oauthAppCrudService.findBySid(appSid);
        if (oauthApp != null) {
            if (authoredUser.getTenantSid() != oauthApp.getTenantSid() && !this.authValidateService.checkAccessPermission(TargetType.Sys.name(), "POST", "/api/iam/v2/oauth2/app/{appSid}", UserUtils.getSysId()).booleanValue()) {
                throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
            }
            oauthApp.setName(oauthAppVO.getName());
            oauthApp.setDescription(oauthAppVO.getDescription());
            oauthApp.setCallbackUrl(oauthAppVO.getCallbackUrl());
            oauthApp.setLogoImage(oauthAppVO.getLogoImage());
            this.oauthAppCrudService.update((BaseEntity)oauthApp);
        }
        return StdData.ok((Object)appSid);
    }

    @GetMapping(value={"/oauth2/apps"})
    public StdData getOauthApps(@RequestAttribute(name="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (authoredUser.getTenantSid() == 0L || authoredUser.getSid() == 0L) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_ID_AND_USER_NOT_NULL);
        }
        ArrayList<OauthAppVO> oauthAppVOS = new ArrayList<OauthAppVO>();
        List apps = this.oauthAppRepository.findByTenantSidAndOwnerUserSid(authoredUser.getTenantSid(), authoredUser.getSid());
        for (Object[] app : apps) {
            OauthAppVO oauthAppVO = new OauthAppVO();
            oauthAppVO.setSid(((Long)app[0]).longValue());
            oauthAppVO.setId((String)app[1]);
            oauthAppVO.setName((String)app[2]);
            oauthAppVO.setLogoImage((String)app[3]);
            oauthAppVO.setCallbackUrl((String)app[4]);
            oauthAppVO.setDescription((String)app[5]);
            oauthAppVOS.add(oauthAppVO);
        }
        return StdData.ok(oauthAppVOS);
    }

    @PostMapping(value={"/oauth2/app"})
    public StdData updateOauthApp(@RequestBody @Valid OauthAppVO oauthAppVO) {
        long sid = this.oauthService.updateApp(oauthAppVO);
        return StdData.ok((Object)sid);
    }

    @PostMapping(value={"/oauth2/authorize"})
    public StdData getAuthCode(@RequestBody @Valid OauthAuthRequest oauthAuthRequest, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        OauthAuthCode oauthAuthCode = this.oauthService.getAuthCode(oauthAuthRequest, authoredUser);
        return StdData.ok((Object)oauthAuthCode);
    }

    @PostMapping(value={"/oauth2/accesstoken"})
    public StdData getAccessToken(@RequestBody @Valid OauthAccessTokenRequest oauthAccessTokenRequest) {
        OauthAccessToken accessToken = this.oauthService.getAccessToken(oauthAccessTokenRequest);
        return StdData.ok((Object)accessToken);
    }

    @PostMapping(value={"/oauth2/refreshtoken"})
    public StdData refreshAccessToken(@RequestBody @Valid OauthRefreshTokenRequest oauthRefreshTokenRequest) {
        OauthAccessToken accessToken = this.oauthService.refreshAccessToken(oauthRefreshTokenRequest);
        return StdData.ok((Object)accessToken);
    }

    @GetMapping(value={"/oauth2/scope"})
    public StdData getScope(@RequestParam(required=false) String scope) {
        ArrayList<OauthScope> oauthScopes = new ArrayList<OauthScope>();
        if (StringUtils.isEmpty((Object)scope)) {
            OauthScope oauthScope = this.oauthScopeRepository.findById("user_read");
            oauthScopes.add(oauthScope);
        } else {
            String[] scopes = scope.split(",");
            List scopeIds = this.oauthScopeRepository.findAllIds();
            StringBuilder notExistedScope = new StringBuilder();
            for (String scopeId : scopes) {
                if (!scopeIds.contains(scopeId)) {
                    notExistedScope.append(scopeId).append(";");
                    continue;
                }
                OauthScope oauthScope = this.oauthScopeRepository.findById(scopeId);
                if (oauthScope == null) continue;
                oauthScopes.add(oauthScope);
            }
            if (notExistedScope.length() > 0) {
                this.logger.error(String.format("%s\u6388\u6743\u8303\u56f4\u4e0d\u5b58\u5728", notExistedScope.toString()));
            }
        }
        return StdData.ok(oauthScopes);
    }

    @GetMapping(value={"/oauth2/get/name"})
    public StdData getAppName(@RequestParam String appId) {
        OauthApp oauthApp = this.oauthAppRepository.findById(appId);
        if (null != oauthApp) {
            return StdData.ok((Object)oauthApp.getName());
        }
        throw new BusinessException((ErrorHandler)I18nError.SYS_NOT_EXISTED);
    }

    @GetMapping(value={"/oauth/authorize"})
    public void getCommonAuthCode(@RequestParam String client_id, @RequestParam String state, @RequestParam String redirect_uri, @RequestParam(required=false) String scope, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, HttpServletResponse response) throws IOException {
        OauthAuthCode oauthAuthCode = this.oauthService.getCommonAuthCode(client_id, redirect_uri, scope, authoredUser);
        String url = String.format("%s?state=%s&code=%s", redirect_uri, state, oauthAuthCode.getCode());
        response.sendRedirect(url);
    }

    @PostMapping(value={"/oauth/accesstoken"})
    public ResponseEntity<?> getCommonAccessToken(@RequestParam Map<String, Object> requestMap) {
        ObjectMapper mapper = new ObjectMapper();
        OauthAccessTokenRequest oauthAccessTokenRequest = null;
        try {
            oauthAccessTokenRequest = (OauthAccessTokenRequest)mapper.readValue(mapper.writeValueAsString(requestMap), OauthAccessTokenRequest.class);
        }
        catch (IOException e) {
            throw new BusinessException((ErrorHandler)I18nError.ACCESS_TOKEN_DECRYPTION_FAILED);
        }
        if (requestMap.containsKey("client_id") && StringUtils.isEmpty((Object)oauthAccessTokenRequest.getClient_id())) {
            throw new IllegalArgumentException("client_id");
        }
        if (StringUtils.isEmpty((Object)oauthAccessTokenRequest.getRedirect_uri())) {
            throw new IllegalArgumentException("redirect_uri");
        }
        if (StringUtils.isEmpty((Object)oauthAccessTokenRequest.getCode())) {
            throw new IllegalArgumentException("code");
        }
        if (StringUtils.isEmpty((Object)oauthAccessTokenRequest.getGrant_type())) {
            throw new IllegalArgumentException("grant_type");
        }
        Map accessToken = this.oauthService.getCommonAccessToken(oauthAccessTokenRequest);
        return ResponseEntity.ok((Object)accessToken);
    }

    @PostMapping(value={"/oauth/refreshtoken"})
    public StdData refreshCommonAccessToken(@RequestBody @Valid OauthRefreshTokenRequest oauthRefreshTokenRequest) {
        OauthAccessToken accessToken = this.oauthService.refreshAccessToken(oauthRefreshTokenRequest);
        return StdData.ok((Object)accessToken);
    }

    @GetMapping(value={"/oauth/user/info"})
    public Map getUserInfo(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("name", authoredUser.getUserName());
        result.put("email", authoredUser.getUserId());
        return result;
    }

    @GetMapping(value={"/oauth/tenant/info"})
    public Map getTenantInfo(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("name", authoredUser.getTenantName());
        result.put("email", authoredUser.getTenantId());
        return result;
    }

    @PostMapping(value={"/oauth2/api"})
    public StdData addOauthApi(@RequestBody List<OauthScopeApiVO> oauthApis) {
        List oauthScopes = this.oauthScopeRepository.findAll();
        oauthApis.forEach(o -> {
            OauthApi oauthApi = new OauthApi();
            oauthApi.setSid(o.getSid() == null ? SnowFlake.getInstance().newId() : o.getSid().longValue());
            oauthApi.setApi(o.getApi());
            oauthApi.setMethod(o.getMethod());
            oauthApi.setModule(o.getModule());
            this.oauthApiRepository.save((Object)oauthApi);
            o.getScopes().forEach(s -> {
                OauthScope scope = oauthScopes.stream().filter(c -> s.equals(c.getId())).findFirst().orElse(null);
                if (scope != null) {
                    OauthScopeApi oauthScopeApi = new OauthScopeApi();
                    oauthScopeApi.setScopeSid(scope.getSid());
                    oauthScopeApi.setApiSid(oauthApi.getSid());
                    this.oauthScopeApiRepository.save((Object)oauthScopeApi);
                }
            });
        });
        return StdData.ok().build();
    }

    @PostMapping(value={"/oauth2/sync"})
    public StdData syncOauthApp(@RequestBody List<OauthAppVO> oauthAppVOs) {
        oauthAppVOs.forEach(a -> {
            Assert.hasText((String)a.getSysId(), (String)"\u5e94\u7528id\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.hasText((String)a.getId(), (String)"\u5e94\u7528key\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.hasText((String)a.getSecret(), (String)"\u5e94\u7528\u79d8\u94a5\u4e0d\u80fd\u4e3a\u7a7a");
        });
        this.oauthService.syncOauthApp(oauthAppVOs);
        return StdData.ok().build();
    }
}

