/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.iam.api.base.OrgBaseController;
import com.digiwin.dap.middleware.iam.domain.org.OrgTypeResultVO;
import com.digiwin.dap.middleware.iam.domain.org.RequestParameterVO;
import com.digiwin.dap.middleware.iam.entity.OrgCatalog;
import com.digiwin.dap.middleware.iam.entity.OrgType;
import com.digiwin.dap.middleware.iam.repository.OrgAspectRepository;
import com.digiwin.dap.middleware.iam.repository.OrgCatalogRepository;
import com.digiwin.dap.middleware.iam.service.org.OrgCatalogCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgTypeQueryService;
import com.digiwin.dap.middleware.iam.util.StringUtil;
import com.digiwin.dap.middleware.language.service.LanguageService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2/org"})
public class OrgCatalogController
extends OrgBaseController {
    @Autowired
    private OrgCatalogCrudService orgCatalogCrudService;
    @Autowired
    private OrgTypeQueryService orgTypeQueryService;
    @Autowired
    private LanguageService languageService;
    @Autowired
    private OrgCatalogRepository orgCatalogRepository;
    @Autowired
    private OrgAspectRepository orgAspectRepository;

    @PostMapping(value={"/catalog/query/type"})
    public ResponseEntity<?> queryTypeByCatalog(@RequestBody RequestParameterVO requestParameterVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        long orgCatalogSid = this.getOrgCatalogSid(this.orgCatalogCrudService, requestParameterVO.getSid(), requestParameterVO.getId(), authoredUser.getTenantSid());
        List orgTypeResultVOS = this.orgTypeQueryService.findOrgTypeInOrgCatalog(orgCatalogSid);
        this.languageService.parse(orgTypeResultVOS, OrgTypeResultVO.class, OrgType.class);
        return ResponseEntity.ok((Object)orgTypeResultVOS);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/catalog/update"})
    public ResponseEntity<?> updateCatalog(@RequestBody OrgCatalog orgCatalog, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        long tenantSid = authoredUser.getTenantSid();
        if (!StringUtil.checkSpecialId((String)orgCatalog.getId())) {
            throw new IllegalArgumentException("\u4f20\u5165orgCatalogId\u4e3a\u7a7a\u6216\u8005\u542b\u6709\u7279\u6b8a\u5b57\u7b26\uff1a\u53f7\uff01");
        }
        long sid = this.orgCatalogCrudService.getSidByTenantAndId(tenantSid, orgCatalog.getId());
        if (orgCatalog.getSid() > 0L && sid != orgCatalog.getSid()) {
            throw new IllegalArgumentException("\u4f20\u5165\u7684\u6570\u636e\u548c\u5df2\u7ecf\u5b58\u5728\u7684sid\u51b2\u7a81");
        }
        if (orgCatalog.getSid() == 0L && sid > 0L) {
            orgCatalog.setSid(sid);
        }
        orgCatalog.setTenantSid(tenantSid);
        if (orgCatalog.getSid() > 0L) {
            this.orgCatalogCrudService.update((BaseEntity)orgCatalog);
        } else {
            this.orgCatalogCrudService.create((BaseEntity)orgCatalog);
        }
        return ResponseEntity.ok((Object)orgCatalog.getSid());
    }

    @PostMapping(value={"/catalog"})
    @GetMapping(value={"/catalog"})
    public ResponseEntity<?> getOrgCatalogs(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        List orgCatalogs = this.orgCatalogRepository.findByTenantSid(authoredUser.getTenantSid());
        return ResponseEntity.ok((Object)orgCatalogs);
    }

    @PostMapping(value={"/catalog/query/aspect"})
    public ResponseEntity<?> getOrgAspectInCatalog(@RequestBody RequestParameterVO requestParameterVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        long orgCatalogSid = this.getOrgCatalogSid(this.orgCatalogCrudService, requestParameterVO.getSid(), requestParameterVO.getId(), authoredUser.getTenantSid());
        List orgAspects = this.orgAspectRepository.findOrgAspectsByOrgCatalogSid(orgCatalogSid);
        return ResponseEntity.ok((Object)orgAspects);
    }
}

