/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.api.base.OrgBaseController;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.constant.enums.UserStatusEnum;
import com.digiwin.dap.middleware.iam.domain.org.BatchReplaceVO;
import com.digiwin.dap.middleware.iam.domain.org.ImportOrgExcelVO;
import com.digiwin.dap.middleware.iam.domain.org.OrgAncestor;
import com.digiwin.dap.middleware.iam.domain.org.OrgAspectVO;
import com.digiwin.dap.middleware.iam.domain.org.OrgBean;
import com.digiwin.dap.middleware.iam.domain.org.OrgCascadeResultVO;
import com.digiwin.dap.middleware.iam.domain.org.OrgImportContext;
import com.digiwin.dap.middleware.iam.domain.org.OrgListRequest;
import com.digiwin.dap.middleware.iam.domain.org.OrgPath;
import com.digiwin.dap.middleware.iam.domain.org.OrgVO;
import com.digiwin.dap.middleware.iam.domain.org.RequestParameterVO;
import com.digiwin.dap.middleware.iam.domain.tenant.ImportResultVO;
import com.digiwin.dap.middleware.iam.domain.user.BatchQueryUserInOrgResultVO;
import com.digiwin.dap.middleware.iam.domain.user.BatchQueryUserInOrgVO;
import com.digiwin.dap.middleware.iam.domain.user.BatchUserInOrgVO;
import com.digiwin.dap.middleware.iam.domain.user.QueryUserInOrgResultVO;
import com.digiwin.dap.middleware.iam.domain.user.QueryUserOrgPageVO;
import com.digiwin.dap.middleware.iam.domain.user.UserSimpleVO;
import com.digiwin.dap.middleware.iam.entity.Org;
import com.digiwin.dap.middleware.iam.entity.OrgAspect;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.mapper.OrgMapper;
import com.digiwin.dap.middleware.iam.repository.OrgRepository;
import com.digiwin.dap.middleware.iam.service.org.EnableOrgService;
import com.digiwin.dap.middleware.iam.service.org.OrgAspectCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgCatalogCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgPathService;
import com.digiwin.dap.middleware.iam.service.org.OrgQueryService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInOrgQueryService;
import com.digiwin.dap.middleware.iam.service.user.UserInOrgUpdateService;
import com.digiwin.dap.middleware.iam.support.validate.OrgValidateService;
import com.digiwin.dap.middleware.iam.util.SpringBeanUtils;
import com.digiwin.dap.middleware.iam.util.StringUtil;
import com.digiwin.dap.middleware.util.AssertUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import com.github.pagehelper.PageSerializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/api/iam/v2/org"})
public class OrgController
extends OrgBaseController {
    @Autowired
    private OrgPathService orgPathService;
    @Autowired
    private OrgCatalogCrudService orgCatalogCrudService;
    @Autowired
    private OrgAspectCrudService orgAspectCrudService;
    @Autowired
    private OrgCrudService orgCrudService;
    @Autowired
    private OrgQueryService orgQueryService;
    @Autowired
    private OrgValidateService orgValidateService;
    @Autowired
    private OrgMapper orgMapper;
    @Autowired
    private EnableOrgService enableOrgService;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private UserInOrgQueryService userInOrgQueryService;
    @Autowired
    private UserInOrgUpdateService userInOrgUpdateService;
    @Autowired
    private OrgRepository orgRepository;

    @GetMapping(value={"/cascade"})
    public ResponseEntity<?> getOrgCascadeInTenant(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Assert.isTrue((authoredUser.getTenantSid() > 0L ? 1 : 0) != 0, (String)String.format("\u65e0\u6cd5\u5f97\u5230\u5f53\u524d\u7528\u6237[%s]\u7684\u79df\u6237\u4fe1\u606f\uff01", authoredUser.getUserId()));
        Map orgRoleTrees = this.orgQueryService.findOrgRoleTreeByTenantSid(authoredUser.getTenantSid());
        return ResponseEntity.ok((Object)orgRoleTrees);
    }

    @PostMapping(value={"/del"})
    public ResponseEntity<?> deleteOrg(@RequestBody RequestParameterVO body) {
        this.orgCrudService.deleteOrgBySid(body.getSid());
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/update"})
    public ResponseEntity<?> updateOrg(@RequestBody OrgVO orgVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        long tenantSid = authoredUser.getTenantSid();
        if (!StringUtil.checkSpecialId((String)orgVO.getLabel())) {
            throw new BusinessException((ErrorHandler)I18nError.ORG_ID_ERROR);
        }
        this.orgValidateService.checkParameters(orgVO, authoredUser, tenantSid);
        orgVO.setTenantSid(tenantSid);
        Org org = orgVO.convertToOrg();
        OrgPath orgPath = this.orgPathService.getOrgPath(orgVO.getOrgCatalogSid(), orgVO.getOrgAspectSid(), orgVO.getParentSid().longValue(), orgVO.getLabel(), orgVO.getName());
        org.setUri(orgPath.getOrgUri());
        org.setUrn(orgPath.getOrgUrn());
        if (orgVO.getSid() > 0L) {
            long oldOrgParentSid = ((Org)this.orgCrudService.findBySid(orgVO.getSid())).getParentSid();
            this.orgCrudService.update((BaseEntity)org);
            if (org.getParentSid() != oldOrgParentSid) {
                List childOrgs = this.orgMapper.findChildOrgsById(orgVO.getOrgCatalogSid(), orgVO.getOrgAspectSid(), org.getTenantSid(), org.getId());
                if (orgVO.getParentSid().longValue() == orgVO.getSid() || !childOrgs.isEmpty() && childOrgs.stream().anyMatch(co -> co.getSid() == orgVO.getParentSid().longValue())) {
                    throw new BusinessException((ErrorHandler)I18nError.ORG_UPDATE_PARENT_ORG_ERROR, new Object[]{org.getId()});
                }
                if (!childOrgs.isEmpty()) {
                    childOrgs.forEach(childOrg -> {
                        Org updateChildOrg = (Org)this.orgCrudService.findBySid(childOrg.getSid());
                        OrgPath childOrgPath = this.orgPathService.getOrgPath(orgVO.getOrgCatalogSid(), orgVO.getOrgAspectSid(), childOrg.getParentSid(), childOrg.getLabel(), childOrg.getName());
                        updateChildOrg.setUri(childOrgPath.getOrgUri());
                        updateChildOrg.setUrn(childOrgPath.getOrgUrn());
                        this.orgCrudService.update((BaseEntity)updateChildOrg);
                    });
                }
            }
        } else {
            this.orgCrudService.create((BaseEntity)org);
        }
        return ResponseEntity.ok((Object)org.getSid());
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/import"})
    public StdData<ImportResultVO<List<ImportOrgExcelVO>>> importOrg(@Valid @RequestBody List<ImportOrgExcelVO> orgVOs) {
        OrgImportContext orgImportContext = (OrgImportContext)SpringBeanUtils.getBean(OrgImportContext.class);
        orgImportContext.checkImport(orgVOs);
        if (!orgImportContext.getCheckFailure().isEmpty()) {
            return StdData.ok((Object)orgImportContext.getImportResult());
        }
        orgImportContext.doImport();
        return StdData.ok((Object)orgImportContext.getImportResult());
    }

    @PostMapping(value={"/aspect"})
    public ResponseEntity<?> getOrgAspect(@RequestBody OrgAspectVO orgAspectVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        long tenantSid = authoredUser.getTenantSid();
        long aspectSid = this.getAspectSid(this.orgCatalogCrudService, this.orgAspectCrudService, orgAspectVO.getCatalogSid(), orgAspectVO.getCatalogId(), orgAspectVO.getSid(), orgAspectVO.getId(), tenantSid);
        List orgResultVOS = this.orgQueryService.getAspect(Long.valueOf(tenantSid), aspectSid);
        return ResponseEntity.ok((Object)orgResultVOS);
    }

    @PostMapping(value={"/list"})
    public StdData<?> listOrg(@RequestBody OrgListRequest req, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        AssertUtils.paramNotNull((Object)req.getSids(), (String)"org sids");
        List list = this.orgQueryService.listOrg(Long.valueOf(authoredUser.getTenantSid()), req.getSids());
        return StdData.ok((Object)list);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/aspect/update"})
    public ResponseEntity<?> updateAspect(@RequestBody OrgAspectVO orgAspectVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        long tenantSid = authoredUser.getTenantSid();
        if (!StringUtil.checkSpecialId((String)orgAspectVO.getId())) {
            throw new IllegalArgumentException("\u4f20\u5165orgCatalogId\u4e3a\u7a7a\u6216\u8005\u542b\u6709\u7279\u6b8a\u5b57\u7b26\uff1a\u53f7\uff01");
        }
        long orgCatalogSid = this.getOrgCatalogSid(this.orgCatalogCrudService, orgAspectVO.getCatalogSid(), orgAspectVO.getCatalogId(), tenantSid);
        long sid = this.orgAspectCrudService.getSidByUnionKey(new Object[]{tenantSid, orgCatalogSid, orgAspectVO.getId()});
        if (orgAspectVO.getSid() > 0L && sid != orgAspectVO.getSid()) {
            throw new IllegalArgumentException("\u4f20\u5165\u7684\u6570\u636e\u548c\u5df2\u7ecf\u5b58\u5728\u7684sid\u51b2\u7a81");
        }
        if (orgAspectVO.getSid() == 0L && sid > 0L) {
            orgAspectVO.setSid(sid);
        }
        orgAspectVO.setCatalogSid(orgCatalogSid);
        orgAspectVO.setTenantSid(tenantSid);
        OrgAspect orgAspect = orgAspectVO.convertToOrgAspect();
        if (orgAspectVO.getSid() > 0L) {
            this.orgAspectCrudService.update((BaseEntity)orgAspect);
        } else {
            this.orgAspectCrudService.create((BaseEntity)orgAspect);
        }
        return ResponseEntity.ok((Object)orgAspect.getSid());
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/enable"})
    public ResponseEntity<?> enableOrg(@RequestBody OrgVO orgVO) {
        this.enableOrgService.enable(orgVO.getSid());
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/disable"})
    public ResponseEntity<?> disableOrg(@RequestBody RequestParameterVO requestParameterVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        long tenantSid = authoredUser.getTenantSid();
        if (requestParameterVO.getSid() == 0L && requestParameterVO.getUri() != null) {
            long sid = this.orgQueryService.getOrgSidByUri(tenantSid, requestParameterVO.getUri());
            requestParameterVO.setSid(sid);
        }
        this.enableOrgService.disable(requestParameterVO.getSid());
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/disable/force"})
    public ResponseEntity<?> forceDissableOrg(@RequestBody RequestParameterVO requestParameterVO) {
        this.enableOrgService.forceDisable(requestParameterVO.getSid());
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @PostMapping(value={"/query/ancestor"})
    public ResponseEntity<?> getOrgAncestor(@RequestBody RequestParameterVO requestParameterVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        long tenantSid = authoredUser.getTenantSid();
        long orgSid = this.orgQueryService.getOrgSidByUri(tenantSid, requestParameterVO.getUri());
        OrgAncestor orgAncestor = this.orgQueryService.getOrgAncestor(orgSid);
        return ResponseEntity.ok((Object)orgAncestor);
    }

    @PostMapping(value={"/query/disabled"})
    public ResponseEntity<?> getOrgDisabled(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        long tenantSid = authoredUser.getTenantSid();
        List orgResultVOS = this.orgQueryService.getDisOrg(tenantSid);
        return ResponseEntity.ok((Object)orgResultVOS);
    }

    @PostMapping(value={"/query/cascade"})
    public ResponseEntity<?> getOrgCascade(@RequestBody OrgBean orgBean, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        long tenantSid = authoredUser.getTenantSid();
        long sid = orgBean.getSid();
        String uri = orgBean.getUri();
        if (sid == 0L && uri == null) {
            throw new IllegalArgumentException("sid or uri \u4e3a\u7a7a");
        }
        if (sid == 0L && uri != null) {
            sid = this.orgQueryService.getOrgSidByUri(tenantSid, uri);
            orgBean.setSid(sid);
        }
        OrgCascadeResultVO orgCascadeResultVO = this.orgQueryService.getOrgCascade(orgBean, tenantSid);
        return ResponseEntity.ok((Object)orgCascadeResultVO);
    }

    @PostMapping(value={"/userinorg"})
    public ResponseEntity<?> getUserInOrg(@RequestBody QueryUserInOrgResultVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        long orgSid = this.getExistOrgSid(Long.valueOf(authoredUser.getTenantSid()), Long.valueOf(body.getOrgSid()), body.getOrgUri());
        List queryUserInOrgResultVOList = this.userInOrgQueryService.queryUserInOrgByOrg(authoredUser.getTenantSid(), orgSid);
        return new ResponseEntity((Object)queryUserInOrgResultVOList, HttpStatus.OK);
    }

    @PostMapping(value={"/userinorg/cascade"})
    public ResponseEntity<?> getUserInOrgCascade(@RequestBody QueryUserInOrgResultVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        long orgSid = this.getExistOrgSid(Long.valueOf(authoredUser.getTenantSid()), Long.valueOf(body.getOrgSid()), body.getOrgUri());
        List orgSids = this.orgQueryService.getChildrenOrgSids(Long.valueOf(orgSid));
        orgSids.add(orgSid);
        ArrayList queryUserInOrgResultVOList = new ArrayList();
        for (Long sid : orgSids) {
            queryUserInOrgResultVOList.addAll(this.userInOrgQueryService.queryUserInOrgByOrg(authoredUser.getTenantSid(), sid.longValue()));
        }
        return new ResponseEntity(queryUserInOrgResultVOList, HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/userinorg/disable"})
    public ResponseEntity<?> disableUserInOrg(@RequestBody QueryUserInOrgResultVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        User user = (User)this.userCrudService.findById(body.getUserId());
        Assert.notNull((Object)user, (String)String.format("\u6b64\u7528\u6237[%s]\u4e0d\u5b58\u5728\uff01", body.getUserId()));
        long orgSid = this.getExistOrgSid(Long.valueOf(authoredUser.getTenantSid()), Long.valueOf(body.getOrgSid()), body.getOrgUri());
        this.userInOrgUpdateService.disableUserInOrgByOrg(authoredUser.getTenantSid(), orgSid, user.getSid());
        return new ResponseEntity(HttpStatus.OK);
    }

    private long getExistOrgSid(Long tenantSid, Long orgSid, String uri) {
        if (orgSid == 0L && uri == null) {
            throw new IllegalArgumentException("\u7ec4\u7ec7Sid\u548c\u7ec4\u7ec7uri\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        if (orgSid == 0L) {
            orgSid = this.orgQueryService.getOrgSidByUri(tenantSid.longValue(), uri);
        }
        Org org = (Org)this.orgCrudService.findBySid(orgSid.longValue());
        Assert.notNull((Object)org, (String)String.format("\u6b64\u7ec4\u7ec7[%s]\u4e0d\u5b58\u5728\uff01", orgSid));
        return orgSid;
    }

    @PostMapping(value={"/userinorg/batch/add"})
    public StdData<?> batchAdd(@RequestBody BatchUserInOrgVO body) {
        this.userInOrgUpdateService.batchAdd(body);
        return StdData.ok().build();
    }

    @PostMapping(value={"/userinorg/batch/del"})
    public StdData<?> batchDel(@RequestBody BatchUserInOrgVO body) {
        this.userInOrgUpdateService.batchDel(body);
        return StdData.ok().build();
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/userinorg/not"})
    public StdData<PageSerializable<QueryUserInOrgResultVO>> getUserNotInOrg(@RequestBody QueryUserOrgPageVO body) {
        body.setTenantSid(Long.valueOf(UserUtils.getTenantSid()));
        PageSerializable result = this.orgQueryService.getUserNotInOrg(body);
        return StdData.ok((Object)result);
    }

    @PostMapping(value={"/userinorg/list/simple"})
    public StdData<?> batchGetUserInOrg(@RequestBody @Valid BatchQueryUserInOrgVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        List userInOrgList = this.userInOrgQueryService.batchQueryUserInOrgByOrg(authoredUser.getTenantSid(), body.getOrgSids());
        Map<Long, List<QueryUserInOrgResultVO>> orgSidUserMap = Optional.ofNullable(userInOrgList).orElse(Collections.emptyList()).stream().collect(Collectors.groupingBy(QueryUserInOrgResultVO::getOrgSid));
        List resultList = orgSidUserMap.entrySet().stream().map(e -> {
            BatchQueryUserInOrgResultVO resultVO = new BatchQueryUserInOrgResultVO();
            resultVO.setOrgSid(((Long)e.getKey()).longValue());
            resultVO.setUsers(((List)e.getValue()).stream().map(u -> {
                UserSimpleVO user = new UserSimpleVO();
                user.setSid(u.getUserSid());
                user.setId(u.getUserId());
                user.setName(u.getUserName());
                user.setStatus(Integer.valueOf(u.isRelationDisabled() ? UserStatusEnum.DISABLE.getCode() : UserStatusEnum.ACTIVE.getCode()));
                return user;
            }).collect(Collectors.toList()));
            return resultVO;
        }).collect(Collectors.toList());
        return StdData.ok(resultList);
    }

    @PostMapping(value={"/batch/replace"})
    public StdData<?> batchReplaceRole(@Validated @RequestBody BatchReplaceVO vo) {
        Org oldOrg = this.orgRepository.findByTenantSidAndSid(UserUtils.getTenantSid(), vo.getOldSid());
        Org newOrg = this.orgRepository.findByTenantSidAndSid(UserUtils.getTenantSid(), vo.getNewSid());
        if (oldOrg == null) {
            throw new BusinessException((ErrorHandler)I18nError.ORG_NOT_EXIST, new Object[]{vo.getOldSid()});
        }
        if (newOrg == null) {
            throw new BusinessException((ErrorHandler)I18nError.ORG_NOT_EXIST, new Object[]{vo.getNewSid()});
        }
        this.userInOrgUpdateService.batchReplaceOrg(vo);
        return StdData.ok().build();
    }
}

