/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.api.base.OrgBaseController;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.org.OrgTypeCascade;
import com.digiwin.dap.middleware.iam.domain.org.OrgTypePath;
import com.digiwin.dap.middleware.iam.domain.org.OrgTypeVO;
import com.digiwin.dap.middleware.iam.domain.org.RequestParameterVO;
import com.digiwin.dap.middleware.iam.entity.OrgType;
import com.digiwin.dap.middleware.iam.service.org.EnableOrgTypeService;
import com.digiwin.dap.middleware.iam.service.org.OrgCatalogCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgTypeCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgTypePathService;
import com.digiwin.dap.middleware.iam.service.org.OrgTypeQueryService;
import com.digiwin.dap.middleware.language.service.LanguageCrudService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2/org"})
public class OrgTypeController
extends OrgBaseController {
    @Autowired
    private OrgTypeCrudService orgTypeCrudService;
    @Autowired
    private OrgTypePathService orgTypePathService;
    @Autowired
    private OrgCatalogCrudService orgCatalogCrudService;
    @Autowired
    private LanguageCrudService languageCrudService;
    @Autowired
    private EnableOrgTypeService enableOrgTypeService;
    @Autowired
    private OrgTypeQueryService orgTypeQueryService;

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/type/update"})
    public ResponseEntity<?> updateType(@RequestBody OrgTypeVO orgTypeVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        long tenantSid = authoredUser.getTenantSid();
        long orgCatalogSid = this.getOrgCatalogSid(this.orgCatalogCrudService, orgTypeVO.getCatalogSid(), orgTypeVO.getCatalogId(), tenantSid);
        long orgTypeSid = this.orgTypeCrudService.getSidByUnionKey(tenantSid, orgCatalogSid, orgTypeVO.getId());
        if (orgTypeVO.getSid() > 0L && orgTypeSid != orgTypeVO.getSid()) {
            throw new IllegalArgumentException("\u4f20\u5165\u7684\u6570\u636e\u548c\u5df2\u7ecf\u5b58\u5728\u7684sid\u51b2\u7a81");
        }
        if (orgTypeVO.getSid() == 0L && orgTypeSid > 0L) {
            orgTypeVO.setSid(orgTypeSid);
        }
        orgTypeVO.setCatalogSid(orgCatalogSid);
        orgTypeVO.setTenantSid(tenantSid);
        OrgType orgType = orgTypeVO.convertToOrgType();
        OrgTypePath orgTypePath = this.orgTypePathService.getOrgTypePath(Long.valueOf(tenantSid), orgTypeVO.getParentSid().longValue(), orgCatalogSid, orgTypeVO.getId(), orgTypeVO.getName());
        orgType.setUri(orgTypePath.getOrgTypeUri());
        orgType.setUrn(orgTypePath.getOrgTypeUrn());
        long sid = orgTypeVO.getSid();
        if (orgTypeVO.getSid() > 0L) {
            this.orgTypeCrudService.update((BaseEntity)orgType);
        } else {
            sid = this.orgTypeCrudService.create((BaseEntity)orgType);
        }
        this.languageCrudService.save(sid, "name", orgType.getName());
        return ResponseEntity.ok((Object)orgType.getSid());
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/type/disable"})
    public ResponseEntity<?> disableType(@RequestBody OrgTypeVO orgTypeVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        long orgTypeSid = this.getOrgTypeSid(this.orgCatalogCrudService, this.orgTypeCrudService, orgTypeVO.getCatalogSid(), orgTypeVO.getCatalogId(), orgTypeVO.getSid(), orgTypeVO.getId(), authoredUser.getTenantSid());
        this.enableOrgTypeService.disable(Long.valueOf(authoredUser.getTenantSid()), orgTypeSid);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/type/enable"})
    public ResponseEntity<?> enableType(@RequestBody OrgTypeVO orgTypeVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        long orgTypeSid = this.getOrgTypeSid(this.orgCatalogCrudService, this.orgTypeCrudService, orgTypeVO.getCatalogSid(), orgTypeVO.getCatalogId(), orgTypeVO.getSid(), orgTypeVO.getId(), authoredUser.getTenantSid());
        this.enableOrgTypeService.enable(Long.valueOf(authoredUser.getTenantSid()), orgTypeSid);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/type/del"})
    public ResponseEntity<?> deleteOrgType(@RequestBody RequestParameterVO requestParameterVO) {
        try {
            this.orgTypeCrudService.deleteById(requestParameterVO.getSid());
        }
        catch (BusinessException ex) {
            throw new BusinessException((ErrorHandler)I18nError.ORG_TYPE_DELETE_ERROR);
        }
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @PostMapping(value={"/type/query/cascade"})
    public ResponseEntity<?> queryCascadeType(@RequestBody OrgTypeVO orgTypeVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        long tenantSid = authoredUser.getTenantSid();
        long orgCatalogSid = this.getOrgCatalogSid(this.orgCatalogCrudService, orgTypeVO.getCatalogSid(), orgTypeVO.getCatalogId(), tenantSid);
        long orgTypeSid = orgTypeVO.getSid();
        if (orgTypeVO.getSid() == 0L && orgTypeVO.getId() != null) {
            orgTypeSid = this.orgTypeCrudService.getSidByUnionKey(tenantSid, orgCatalogSid, orgTypeVO.getId());
        }
        OrgTypeCascade orgTypeCascade = this.orgTypeQueryService.getCascadeType(orgCatalogSid, orgTypeSid);
        return ResponseEntity.ok((Object)orgTypeCascade);
    }
}

