/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.datapolicy.DataTargetVO;
import com.digiwin.dap.middleware.iam.domain.login.LoginUser;
import com.digiwin.dap.middleware.iam.domain.permission.AllPermissionQueryVO;
import com.digiwin.dap.middleware.iam.domain.permission.ApiPermissionQueryVO;
import com.digiwin.dap.middleware.iam.domain.permission.CalcUser;
import com.digiwin.dap.middleware.iam.domain.permission.DataPermission;
import com.digiwin.dap.middleware.iam.domain.permission.PermissionLastModified;
import com.digiwin.dap.middleware.iam.domain.permission.UserDataPermissionResult;
import com.digiwin.dap.middleware.iam.domain.permission.UserDataPermissionResultVO;
import com.digiwin.dap.middleware.iam.domain.permission.UserFunPermission;
import com.digiwin.dap.middleware.iam.domain.permission.UserFunctionalPermissionResult;
import com.digiwin.dap.middleware.iam.domain.permission.UserFunctionalPermissionResultVO;
import com.digiwin.dap.middleware.iam.domain.permission.UserPermissionResult;
import com.digiwin.dap.middleware.iam.domain.permission.UserPermissionResultVO;
import com.digiwin.dap.middleware.iam.domain.permission.UserPermissionVO;
import com.digiwin.dap.middleware.iam.domain.permission.v2.MenuEffect;
import com.digiwin.dap.middleware.iam.domain.policy.ConsolePolicyExportScopeRequest;
import com.digiwin.dap.middleware.iam.domain.policy.PolicyPermission;
import com.digiwin.dap.middleware.iam.domain.policy.v2.TargetPolicy;
import com.digiwin.dap.middleware.iam.domain.sys.tree.SysNode;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.repository.TenantDataExportRecordRepository;
import com.digiwin.dap.middleware.iam.service.permission.ApiPermissionService;
import com.digiwin.dap.middleware.iam.service.permission.AuthActionService;
import com.digiwin.dap.middleware.iam.service.permission.AuthService;
import com.digiwin.dap.middleware.iam.service.policy.PolicyCalcService;
import com.digiwin.dap.middleware.iam.service.policy.PolicyHandleService;
import com.digiwin.dap.middleware.iam.support.auth.domain.IamAuthoredUser;
import com.digiwin.dap.middleware.iam.support.excel.PermissionExcelService;
import com.digiwin.dap.middleware.iam.support.obsolete.service.DataPermissionService;
import com.digiwin.dap.middleware.iam.support.validate.AuthValidateService;
import com.digiwin.dap.middleware.util.AssertUtils;
import io.github.resilience4j.ratelimiter.annotation.RateLimiter;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2/permission"})
public class PermissionController {
    @Autowired
    private AuthService authService;
    @Autowired
    private AuthActionService authActionService;
    @Autowired
    private PolicyCalcService policyCalcService;
    @Autowired
    private AuthValidateService authValidateService;
    @Autowired
    private ApiPermissionService apiPermissionService;
    @Autowired
    private DataPermissionService dataPermissionService;
    @Autowired
    private PermissionExcelService permissionExcelService;
    @Autowired
    private TenantDataExportRecordRepository tenantDataExportRecordRepository;
    @Autowired
    private PolicyHandleService policyHandleService;

    @PostMapping(value={"/last/modified"})
    public StdData<?> getLastModified(@RequestBody(required=false) UserPermissionVO input, @RequestAttribute(value="digi-middleware-auth-user-data") IamAuthoredUser authoredUser, @RequestAttribute(value="digi-middleware-auth-app-data") AuthoredSys sys) {
        String key;
        PermissionLastModified lastModified;
        PermissionLastModified result = new PermissionLastModified(input);
        if (result.getUserId() == null) {
            result.setUserId(authoredUser.getUserId());
        }
        result.setTenantId(authoredUser.getTenantId());
        if (result.getSysId() == null) {
            result.setSysId(sys.getId());
        }
        if ((lastModified = (PermissionLastModified)RedisUtils.get((Object)(key = String.format("iam:permission:last:modified:%s::%s::%s", result.getUserId(), result.getTenantId(), result.getSysId())), PermissionLastModified.class)) == null) {
            result.setLastModified(LocalDateTime.now());
            RedisUtils.set((String)key, (Object)result);
        } else {
            result.setLastModified(lastModified.getLastModified());
        }
        return StdData.ok((Object)result);
    }

    @PostMapping(value={"/user/all", "/user/all/realtime"}, produces={"application/json; charset=utf-8"})
    @RateLimiter(name="/api/iam/v2/permission/user/all")
    public ResponseEntity<?> getUserActionAllow(@RequestBody(required=false) UserPermissionVO input, @RequestAttribute(value="digi-middleware-auth-user-data") IamAuthoredUser authoredUser, @RequestAttribute(value="digi-middleware-auth-app-data", required=false) AuthoredSys sys) {
        CalcUser calcUser = this.authValidateService.checkPermission(input, authoredUser, new Sys(sys));
        SysNode sysData = this.authActionService.getSysData(calcUser);
        UserPermissionResult userPermission = this.authService.getUserPermission(calcUser, sysData);
        userPermission.setPermissions(this.authService.fillAction(calcUser, sysData, userPermission, MenuEffect.allow));
        return ResponseEntity.ok((Object)new UserPermissionResultVO(input, userPermission));
    }

    @PostMapping(value={"/user/functional"}, produces={"application/json; charset=utf-8"})
    @RateLimiter(name="/api/iam/v2/permission/user/functional")
    public ResponseEntity<?> getUserFunctional(@RequestBody UserPermissionVO input, @RequestAttribute(value="digi-middleware-auth-user-data") IamAuthoredUser authoredUser) {
        CalcUser calcUser = this.authValidateService.checkPermission(input, authoredUser, null);
        SysNode sysData = this.authActionService.getSysData(calcUser);
        UserPermissionResult userPermission = this.authService.getUserPermission(calcUser, sysData);
        userPermission.setPermissions(this.authService.fillAction(calcUser, sysData, userPermission, MenuEffect.allow));
        UserFunctionalPermissionResult functionalPermission = new UserFunctionalPermissionResult(userPermission.getRoles(), userPermission.getOrg(), userPermission.getPermissions());
        return ResponseEntity.ok((Object)new UserFunctionalPermissionResultVO(input, functionalPermission));
    }

    @PostMapping(value={"/user"})
    @RateLimiter(name="/api/iam/v2/permission/user")
    public StdData<?> getUserAction(@RequestBody(required=false) UserPermissionVO input, @RequestAttribute(value="digi-middleware-auth-user-data") IamAuthoredUser authoredUser, @RequestAttribute(value="digi-middleware-auth-app-data", required=false) AuthoredSys sys) {
        if (input == null) {
            input = new UserPermissionVO();
        }
        CalcUser calcUser = this.authValidateService.checkPermission(input.puzzle(), authoredUser, new Sys(sys));
        SysNode sysData = this.authActionService.getSysData(calcUser);
        UserPermissionResult userPermission = this.authService.getUserPermission(calcUser, sysData);
        List actions = this.authService.fillAction(calcUser, sysData, userPermission, MenuEffect.of((String)input.getEffect()));
        return StdData.ok((Object)actions);
    }

    @PostMapping(value={"/user/module"})
    @RateLimiter(name="/api/iam/v2/permission/user")
    public StdData<?> getUserActionModule(@RequestBody(required=false) UserPermissionVO input, @RequestAttribute(value="digi-middleware-auth-user-data") IamAuthoredUser authoredUser, @RequestAttribute(value="digi-middleware-auth-app-data", required=false) AuthoredSys sys) {
        if (input == null) {
            input = new UserPermissionVO();
        }
        CalcUser calcUser = this.authValidateService.checkPermission(input.puzzle(), authoredUser, new Sys(sys));
        SysNode sysData = this.authActionService.getSysData(calcUser);
        UserPermissionResult userPermission = this.authService.getUserPermission(calcUser, sysData);
        UserFunPermission actionAndModules = this.authService.fillActionModule(calcUser, sysData, userPermission, MenuEffect.of((String)input.getEffect()));
        return StdData.ok((Object)actionAndModules);
    }

    @PostMapping(value={"/users/apps/all"})
    public ResponseEntity<?> getUserActionBatch(@RequestBody UserPermissionVO input, @RequestAttribute(value="digi-middleware-auth-user-data") IamAuthoredUser authoredUser) {
        if (authoredUser.getTenantSid() == 0L) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_ID_NOT_NULL);
        }
        if (input.getUserIds().isEmpty() || input.getSysIds().isEmpty()) {
            return ResponseEntity.ok(Collections.emptyList());
        }
        List userPermissions = this.authService.getUserPermissionBatch(input.getUserIds(), input.getSysIds(), MenuEffect.of((String)input.getEffect()), authoredUser);
        return ResponseEntity.ok((Object)userPermissions);
    }

    @PostMapping(value={"/user/details"}, produces={"application/json; charset=utf-8"})
    @com.digiwin.dap.middle.cache.limiter.RateLimiter(burstCapacity=3600, requestedTokens=720)
    public ResponseEntity<?> getAllPermissionDetails(@RequestBody(required=false) AllPermissionQueryVO input, @RequestAttribute(value="digi-middleware-auth-user-data") IamAuthoredUser authoredUser, @RequestAttribute(value="digi-middleware-auth-app-data", required=false) AuthoredSys sys) {
        return ResponseEntity.ok((Object)this.permissionExcelService.getAllPermissionDetails(input, authoredUser, sys));
    }

    @PostMapping(value={"/user/details/export"})
    @com.digiwin.dap.middle.cache.limiter.RateLimiter(burstCapacity=3600, requestedTokens=720)
    public void permissionExport(@RequestBody(required=false) AllPermissionQueryVO input, @RequestAttribute(value="digi-middleware-auth-user-data") IamAuthoredUser authoredUser, @RequestAttribute(value="digi-middleware-auth-app-data", required=false) AuthoredSys sys, HttpServletResponse response) throws Exception {
        this.permissionExcelService.getPermissionExcels(input, authoredUser, sys, response);
    }

    @PostMapping(value={"/apply/export"})
    @com.digiwin.dap.middle.cache.limiter.RateLimiter(burstCapacity=3600, requestedTokens=3600)
    public ResponseEntity applyExportAllPermission(@RequestBody AllPermissionQueryVO input, @RequestAttribute(value="digi-middleware-auth-user-data") IamAuthoredUser user) {
        this.permissionExcelService.exportAllPermission(input, user);
        return new ResponseEntity(HttpStatus.OK);
    }

    @PostMapping(value={"/apply/scope/export"})
    public StdData applyExportAllPermissionV2(@RequestBody ConsolePolicyExportScopeRequest input, @RequestAttribute(value="digi-middleware-auth-user-data") IamAuthoredUser user) {
        Assert.notEmpty((Collection)input.getAppIds(), (String)"\u5e94\u7528\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notEmpty((Collection)input.getActualSids(), (String)"\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)input.getScope(), (String)"\u7ef4\u5ea6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        input.setTenantSid(Long.valueOf(user.getTenantSid()));
        this.permissionExcelService.exportAllPermissionV2(input.toVO());
        return StdData.ok().build();
    }

    @PostMapping(value={"/cancel/scope/export"})
    public StdData cancelExportAllPermissionV2(@RequestParam Long sid) {
        this.permissionExcelService.cancelExportTask(sid);
        return StdData.ok().build();
    }

    @GetMapping(value={"/export/check"})
    public StdData<?> checkPermissionExport(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        Assert.isTrue((user.getTenantSid() > 0L ? 1 : 0) != 0, (String)"\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u79df\u6237\u4fe1\u606f\uff01");
        if (this.tenantDataExportRecordRepository.existsByTenantSidAndCreateByAndPermAndState(user.getTenantSid(), user.getSid(), true, 0)) {
            throw new BusinessException((ErrorHandler)I18nError.PERMISSION_EXPORT_DATA_GENERATING);
        }
        return StdData.ok().build();
    }

    @PostMapping(value={"/user/actions"}, produces={"application/json; charset=utf-8"})
    public ResponseEntity<?> getUserModuleActions(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestBody Sys sys) {
        PolicyPermission policyPermission = this.policyCalcService.getUserModuleActions(authoredUser.getTenantSid(), authoredUser.getTenantId(), authoredUser.getUserId(), sys.getId());
        return ResponseEntity.ok((Object)policyPermission);
    }

    @PostMapping(value={"/data"})
    @RateLimiter(name="/api/iam/v2/permission/data")
    public ResponseEntity<?> getData(@RequestBody @Valid DataTargetVO input, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestAttribute(value="digi-middleware-auth-app-data", required=false) AuthoredSys sys) {
        this.authValidateService.checkDataPermission(input, authoredUser, new Sys(sys), Boolean.valueOf(true));
        DataPermission dataPermission = this.authService.getDataPermission(input);
        return ResponseEntity.ok((Object)dataPermission);
    }

    @PostMapping(value={"/data/row"})
    public ResponseEntity<?> getDataRow(@RequestBody @Valid DataTargetVO input, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestAttribute(value="digi-middleware-auth-app-data", required=false) AuthoredSys sys) {
        this.authValidateService.checkDataPermission(input, authoredUser, new Sys(sys), Boolean.valueOf(true));
        DataPermission dataPermission = this.authService.getDataPermission(input);
        dataPermission.setColPermission(null);
        return ResponseEntity.ok((Object)dataPermission);
    }

    @PostMapping(value={"/data/dev/row"})
    public StdData getDevDataRow(@RequestBody @Valid DataTargetVO input, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestAttribute(value="digi-middleware-auth-app-data", required=false) AuthoredSys sys) {
        this.authValidateService.checkDataPermission(input, authoredUser, new Sys(sys), Boolean.valueOf(true));
        List map = this.authService.getDataPermissionRow(input);
        return StdData.ok((Object)map);
    }

    @PostMapping(value={"/data/dev/role"})
    public StdData getDevDataRowByValue(@RequestBody @Valid DataTargetVO input, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestAttribute(value="digi-middleware-auth-app-data", required=false) AuthoredSys sys) {
        this.authValidateService.checkDataPermission(input, authoredUser, new Sys(sys), Boolean.valueOf(false));
        List roleInfos = this.authService.getDataPermissionRoles(input);
        return StdData.ok((Object)roleInfos);
    }

    @PostMapping(value={"/data/col"})
    @RateLimiter(name="/api/iam/v2/permission/data/col")
    public ResponseEntity<?> getDataCol(@RequestBody @Valid DataTargetVO input, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestAttribute(value="digi-middleware-auth-app-data", required=false) AuthoredSys sys) {
        this.authValidateService.checkDataPermission(input, authoredUser, new Sys(sys), Boolean.valueOf(true));
        DataPermission dataPermission = this.authService.getDataPermission(input);
        dataPermission.setRowPermission(null);
        return ResponseEntity.ok((Object)dataPermission);
    }

    @PostMapping(value={"/data/tempuser"})
    public ResponseEntity<?> getApiDataPermission(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestAttribute(value="digi-middleware-auth-app-data") AuthoredSys sys) {
        LoginUser loginUser = new LoginUser();
        loginUser.setUserId(authoredUser.getUserId());
        loginUser.setTenantId(authoredUser.getTenantId());
        loginUser.setApp(new Sys(sys));
        ApiPermissionQueryVO input = this.apiPermissionService.getApiPermissionQueryVOByUser(loginUser);
        List result = this.apiPermissionService.getApiPermission(input);
        return ResponseEntity.ok((Object)result);
    }

    @PostMapping(value={"/user/data"}, produces={"application/json; charset=utf-8"})
    public ResponseEntity<?> getUserDataPermission(@RequestBody UserPermissionVO input, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        UserDataPermissionResult userDataPermission = this.dataPermissionService.getUserDataPermission(input, authoredUser);
        return ResponseEntity.ok((Object)new UserDataPermissionResultVO(input, userDataPermission));
    }

    @PostMapping(value={"/query/action/condition"})
    public ResponseEntity<?> getPolicyActionCondition(@RequestBody @Valid TargetPolicy input, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        AssertUtils.paramNotNull((Object)input.getActionSid(), (String)"actionSid");
        input.setTenantSid(Long.valueOf(authoredUser.getTenantSid()));
        this.policyHandleService.queryMergeConditionValue(input);
        return ResponseEntity.ok((Object)input);
    }
}

