/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import com.digiwin.dap.middle.cache.lock.CacheLock;
import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.commons.core.codec.Base64;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.app.SysCascade;
import com.digiwin.dap.middleware.iam.domain.dataplus.ActionPlusPermission;
import com.digiwin.dap.middleware.iam.domain.policy.BatchSaveTargetPolicyRequestVO;
import com.digiwin.dap.middleware.iam.domain.policy.CopyPermissionVO;
import com.digiwin.dap.middleware.iam.domain.policy.v2.TargetPolicy;
import com.digiwin.dap.middleware.iam.domain.request.QueryTargetActionRequest;
import com.digiwin.dap.middleware.iam.domain.request.QueryTargetConditionRequest;
import com.digiwin.dap.middleware.iam.entity.Policy;
import com.digiwin.dap.middleware.iam.mapper.DataPlusOperationUnitMapper;
import com.digiwin.dap.middleware.iam.service.datapolicy.CopyDataPolicyService;
import com.digiwin.dap.middleware.iam.service.policy.PolicyCopyService;
import com.digiwin.dap.middleware.iam.service.policy.PolicyHandleService;
import com.digiwin.dap.middleware.iam.service.sys.SysQueryService;
import com.digiwin.dap.middleware.iam.support.auth.domain.IamAuthoredUser;
import com.digiwin.dap.middleware.iam.support.validate.AuthValidateService;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import io.github.resilience4j.ratelimiter.annotation.RateLimiter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/api/iam/v2/policy"})
public class PolicyController {
    @Autowired
    private PolicyCopyService policyCopyService;
    @Autowired
    private PolicyHandleService policyHandleService;
    @Autowired
    private CopyDataPolicyService copyDataPolicyService;
    @Autowired
    private AuthValidateService authValidateService;
    @Autowired
    private SysQueryService sysQueryService;
    @Autowired
    private DataPlusOperationUnitMapper dataPlusOperationUnitMapper;

    @GetMapping(value={"/action"})
    @RateLimiter(name="/api/iam/v2/policy/action")
    public ResponseEntity<?> getPolicyAction(@NotBlank @RequestParam String type, @NotNull @RequestParam Long targetSid, @NotNull @RequestParam Long sysSid, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        List lists = this.policyHandleService.getPolicyActionAndModule(authoredUser.getTenantSid(), sysSid.longValue(), targetSid.longValue(), type);
        return ResponseEntity.ok((Object)lists);
    }

    @GetMapping(value={"/action/excluded"})
    public ResponseEntity<?> getPolicyActionExcluded(@NotBlank @RequestParam String type, @NotNull @RequestParam Long targetSid, @NotNull @RequestParam Long sysSid) {
        List lists = this.policyHandleService.getPolicyActionExcluded(Long.valueOf(UserUtils.getTenantSid()), sysSid, targetSid, type);
        return ResponseEntity.ok((Object)lists);
    }

    @PostMapping(value={"/action/actual"})
    public StdData<?> getAction(@RequestBody @Valid TargetPolicy input, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (input.getTenantSid() == null) {
            input.setTenantSid(Long.valueOf(authoredUser.getTenantSid()));
        }
        if (authoredUser.getTenantSid() != input.getTenantSid().longValue() && !this.authValidateService.checkAccessPermission(TargetType.Tenant.name(), "POST", "/api/iam/v2/policy/action/actual", authoredUser.getTenantId()).booleanValue() && !this.authValidateService.checkAccessPermission(TargetType.Sys.name(), "POST", "/api/iam/v2/policy/action/actual", UserUtils.getSysId()).booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        return StdData.ok((Object)this.policyHandleService.getPolicyActionActual(input.getTenantSid().longValue(), input.getSysSid().longValue(), input.getTargetSid().longValue(), input.getType()));
    }

    @GetMapping(value={"/query/condition"})
    public StdData<?> getCondition(QueryTargetConditionRequest body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        TargetPolicy condition = body.toCondition();
        condition.setTenantSid(Long.valueOf(authoredUser.getTenantSid()));
        return StdData.ok((Object)this.policyHandleService.queryConditionValueActual(condition));
    }

    @PostMapping(value={"/query/action"})
    public StdData<?> queryActionTree(@RequestBody @Valid QueryTargetActionRequest input, @RequestAttribute(value="digi-middleware-auth-user-data") IamAuthoredUser authoredUser) {
        List allowActions = this.policyHandleService.getPolicyAllowActionActual(authoredUser.getTenantSid(), input.getSysSid().longValue(), input.getTargetSid().longValue(), input.getType());
        SysCascade sysCascade = this.sysQueryService.getSysCascade(authoredUser.getTenantSid(), input.getSysSid().longValue(), allowActions);
        Map<Long, ActionPlusPermission> actionResourceMap = this.dataPlusOperationUnitMapper.findByResourceId(authoredUser.getTenantSid(), input.getSysSid().longValue(), input.getType(), input.getTargetSid().longValue()).stream().collect(Collectors.toMap(ActionPlusPermission::getActionSid, a -> a, (k1, k2) -> k1));
        sysCascade.getModules().forEach(module -> module.getActions().forEach(action -> {
            ActionPlusPermission permission;
            if (action.getPath() != null) {
                action.setPaths(Arrays.asList(action.getPath().split(",")));
            }
            if ((permission = (ActionPlusPermission)actionResourceMap.get(action.getSid())) != null) {
                action.setResourceId(permission.getResourceId());
                action.setResourceType(permission.getResourceType());
            }
        }));
        return StdData.ok((Object)sysCascade);
    }

    @Transactional(rollbackFor={Exception.class})
    @DeleteMapping(value={"/data"}, produces={"application/json; charset=utf-8"})
    public ResponseEntity<?> deletePolicy(@NotBlank @RequestParam String type, @NotNull @RequestParam Long targetSid, @NotNull @RequestParam Long sysSid, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        this.policyHandleService.delete(authoredUser.getTenantSid(), sysSid.longValue(), targetSid.longValue(), type);
        return new ResponseEntity(HttpStatus.OK);
    }

    @PostMapping(value={"/action"}, produces={"application/json; charset=utf-8"})
    public ResponseEntity<?> addActionPolicy(@RequestBody @Valid TargetPolicy input, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (input.getTenantSid() == null) {
            input.setTenantSid(Long.valueOf(authoredUser.getTenantSid()));
        }
        if (authoredUser.getTenantSid() != input.getTenantSid().longValue() && !this.authValidateService.checkAccessPermission(TargetType.Sys.name(), "POST", "/api/iam/v2/policy/action", UserUtils.getSysId()).booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        this.policyHandleService.update(input.getTenantSid().longValue(), input);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @PostMapping(value={"/action/batch"}, produces={"application/json; charset=utf-8"})
    public StdData<?> addActionPolicy(@RequestBody @Valid BatchSaveTargetPolicyRequestVO input) {
        if (input.getTenantSid() == null) {
            input.setTenantSid(Long.valueOf(UserUtils.getTenantSid()));
        }
        if (UserUtils.getTenantSid() != input.getTenantSid() && !this.authValidateService.checkAccessPermission(TargetType.Sys.name(), "POST", "/api/iam/v2/policy/action/batch", UserUtils.getSysId()).booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_USER_PERMISSION_COMMON_ERROR, new Object[]{UserUtils.getUserName(), UserUtils.getUserId(), AppAuthContextHolder.getContext().getClientIP(), Base64.encode((String)JsonUtils.writeValue((Object)input))});
        }
        this.policyHandleService.batchUpdate(input);
        return StdData.ok().build();
    }

    private void checkSubAdminOverreach(BatchSaveTargetPolicyRequestVO input) {
        List operatorAllowActions = this.policyHandleService.getPolicyActionAndModule(UserUtils.getTenantSid(), input.getSysSid().longValue(), UserUtils.getUserSid(), "user");
        List targetOldActions = this.policyHandleService.getPolicyActionAndModule(input.getTenantSid().longValue(), input.getSysSid().longValue(), input.getTargetSid().longValue(), input.getType());
        Set savedActions = input.getTargets().stream().map(TargetPolicy::getActionSid).filter(Objects::nonNull).collect(Collectors.toSet());
        HashSet changedActions = new HashSet(savedActions);
        targetOldActions.forEach(changedActions::remove);
        changedActions.addAll(targetOldActions.stream().filter(action -> !savedActions.contains(action)).collect(Collectors.toList()));
        if (changedActions.stream().anyMatch(action -> !operatorAllowActions.contains(action))) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_PERMISSION_OVEREACH);
        }
    }

    @CacheLock
    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/action/condition"}, produces={"application/json; charset=utf-8"})
    public ResponseEntity<?> savePolicyActionCondition(@RequestBody @Valid TargetPolicy input, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (input.getTenantSid() == null) {
            input.setTenantSid(Long.valueOf(authoredUser.getTenantSid()));
        }
        if (authoredUser.getTenantSid() != input.getTenantSid().longValue() && !this.authValidateService.checkAccessPermission(TargetType.Sys.name(), "POST", "/api/iam/v2/policy/action/condition", UserUtils.getSysId()).booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        if (input.getConditionValue() != null && !input.getConditionValue().isEmpty()) {
            Policy policy = this.policyHandleService.savePolicy(input.getTenantSid().longValue(), input.getSysSid().longValue(), input.getTargetSid().longValue(), input.getType());
            this.policyHandleService.saveConditionValue(policy.getSid(), input);
        }
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @PostMapping(value={"/query/action/condition"}, produces={"application/json; charset=utf-8"})
    public ResponseEntity<?> getPolicyActionCondition(@RequestBody @Valid TargetPolicy input, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Assert.notNull((Object)input.getActionSid(), (String)"\u53c2\u6570\u9519\u8bef: actionSid\u4e0d\u80fd\u4e3a\u7a7a");
        if (input.getTenantSid() == null) {
            input.setTenantSid(Long.valueOf(authoredUser.getTenantSid()));
        }
        if (authoredUser.getTenantSid() != input.getTenantSid().longValue() && !this.authValidateService.checkAccessPermission(TargetType.Sys.name(), "POST", "/api/iam/v2/policy/query/action/condition", UserUtils.getSysId()).booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        this.policyHandleService.queryConditionValue(input);
        return ResponseEntity.ok((Object)input);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/copy"}, produces={"application/json; charset=utf-8"})
    public ResponseEntity<?> copyPolicy(@RequestBody CopyPermissionVO copyPermissionVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        long tenantSid = authoredUser.getTenantSid();
        if (copyPermissionVO.getType().isEmpty()) {
            throw new BusinessException((ErrorHandler)I18nError.POLICY_COPY_TYPE_EMPTY);
        }
        if (copyPermissionVO.getType().contains("data")) {
            this.copyDataPolicyService.copyDataPolicy(copyPermissionVO, tenantSid);
        }
        if (copyPermissionVO.getType().contains("functional")) {
            this.policyCopyService.copyPolicy(tenantSid, copyPermissionVO);
        }
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }
}

