/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import com.digiwin.dap.middle.cache.lock.CacheLock;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.constant.enums.TenantEnterpriseTypeEnum;
import com.digiwin.dap.middleware.iam.domain.permission.v2.TargetType;
import com.digiwin.dap.middleware.iam.domain.policy.PolicyTargetAction;
import com.digiwin.dap.middleware.iam.domain.policy.PolicyTargetVO;
import com.digiwin.dap.middleware.iam.entity.Policy;
import com.digiwin.dap.middleware.iam.entity.Role;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.service.policy.PolicyHandleOldService;
import com.digiwin.dap.middleware.iam.service.role.RoleCrudService;
import com.digiwin.dap.middleware.iam.service.sys.SysCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.support.validate.AuthValidateService;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/api/iam/v2/policy"})
public class PolicyOldController {
    @Autowired
    private SysCrudService sysCrudService;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private RoleCrudService roleCrudService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private PolicyHandleOldService policyHandleOldService;
    @Autowired
    private AuthValidateService authValidateService;

    @PostMapping(value={""}, produces={"application/json; charset=utf-8"})
    public ResponseEntity<?> getPolicyBySid(@RequestBody Policy input) {
        PolicyTargetVO policyResult = this.policyHandleOldService.getPolicyBySid(input.getSid());
        if (UserUtils.getTenantSid() != policyResult.getTenantSid() && !this.authValidateService.checkAccessPermission(com.digiwin.dap.middle.ram.domain.enums.TargetType.Sys.name(), "POST", "/api/iam/v2/policy", UserUtils.getSysId()).booleanValue() && !this.authValidateService.checkAccessPermission(com.digiwin.dap.middle.ram.domain.enums.TargetType.TenantSys.name(), "POST", "/api/iam/v2/policy", String.format("%s-%s", UserUtils.getTenantId(), UserUtils.getSysId())).booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        return ResponseEntity.ok((Object)policyResult);
    }

    @CacheLock
    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/update"}, produces={"application/json; charset=utf-8"})
    public ResponseEntity<?> updatePolicy(@Valid @RequestBody PolicyTargetVO input, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestAttribute(value="digi-middleware-auth-app-data") AuthoredSys sys) {
        if (!TargetType.user.name().equals(input.getAttachment().getType()) && !TargetType.role.name().equals(input.getAttachment().getType())) {
            throw new BusinessException((ErrorHandler)I18nError.POLICY_TYPE_ERROR);
        }
        this.policyHandleOldService.updatePolicyTarget(authoredUser.getTenantSid(), sys.getSid(), sys.getId(), input);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/batch/add"}, produces={"application/json; charset=utf-8"})
    public ResponseEntity<?> batchUpdatePolicy(@RequestBody PolicyTargetVO input, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestAttribute(value="digi-middleware-auth-app-data", required=false) AuthoredSys authoredSys) {
        long tenantSid;
        if (!StringUtils.isEmpty((Object)input.getTenantId())) {
            Tenant tenant = this.check(authoredUser.getTenantId(), input.getTenantId());
            tenantSid = tenant.getSid();
        } else {
            Assert.hasText((String)authoredUser.getTenantId(), (String)"\u5f53\u524d\u767b\u5f55\u79df\u6237\u4e0d\u80fd\u4e3a\u7a7a");
            Tenant currentTenant = (Tenant)this.tenantCrudService.findById(authoredUser.getTenantId());
            if (currentTenant == null) {
                throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{authoredUser.getTenantId()});
            }
            tenantSid = currentTenant.getSid();
        }
        Sys sys = !StringUtils.isEmpty((Object)input.getAppId()) ? (Sys)this.sysCrudService.findById(input.getAppId()) : new Sys(authoredSys);
        if (sys == null || StringUtils.isEmpty((Object)sys.getId())) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_NOT_EXISTED);
        }
        this.policyHandleOldService.updatePolicyTargetBatch(tenantSid, sys.getSid(), sys.getId(), input);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    private Tenant check(String tenantId, String targetTenantId) {
        Assert.hasText((String)targetTenantId, (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)tenantId, (String)"\u5f53\u524d\u767b\u5f55\u79df\u6237\u4e0d\u80fd\u4e3a\u7a7a");
        Tenant currentTenant = (Tenant)this.tenantCrudService.findById(tenantId);
        if (currentTenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{tenantId});
        }
        if (!Objects.equals(TenantEnterpriseTypeEnum.INDIVIDUAL_TENANT.getValue(), currentTenant.getEnterpriseType()) && !StringUtils.hasLength((String)currentTenant.getCustomerId())) {
            throw new BusinessException((ErrorHandler)I18nError.CUSTOMER_CODE_OF_TENANT_NOT_EMPTY, new Object[]{tenantId});
        }
        Tenant tenant = (Tenant)this.tenantCrudService.findById(targetTenantId);
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{targetTenantId});
        }
        if (!Objects.equals(TenantEnterpriseTypeEnum.INDIVIDUAL_TENANT.getValue(), currentTenant.getEnterpriseType()) && !currentTenant.getCustomerId().equals(tenant.getCustomerId())) {
            throw new BusinessException((ErrorHandler)I18nError.CUSTOMER_CODE_OF_TENANT_NOT_SAME, new Object[]{tenant.getId(), tenant.getCustomerId(), currentTenant.getId(), currentTenant.getCustomerId()});
        }
        return tenant;
    }

    @PostMapping(value={"/query/action/user"}, produces={"application/json; charset=utf-8"})
    public ResponseEntity<?> getUserByAction(@RequestBody PolicyTargetAction input, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestAttribute(value="digi-middleware-auth-app-data") AuthoredSys sys) {
        List users = this.policyHandleOldService.getUsersByAction(authoredUser.getTenantSid(), sys.getSid(), input);
        return ResponseEntity.ok((Object)users);
    }

    @PostMapping(value={"/query/action/role"}, produces={"application/json; charset=utf-8"})
    public ResponseEntity<?> getRoleByAction(@RequestBody PolicyTargetAction input, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestAttribute(value="digi-middleware-auth-app-data") AuthoredSys sys) {
        List roles = this.policyHandleOldService.getRolesByAction(authoredUser.getTenantSid(), sys.getSid(), input);
        return ResponseEntity.ok((Object)roles);
    }

    @PostMapping(value={"/attach/user/app"}, produces={"application/json; charset=utf-8"})
    public ResponseEntity<?> getPolicyUserApp(@RequestBody User input, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestAttribute(value="digi-middleware-auth-app-data") AuthoredSys sys) {
        if (input.getSid() == 0L) {
            User user = (User)this.userCrudService.findById(input.getId());
            Assert.notNull((Object)user, (String)("\u7528\u6237[" + input.getId() + "]\u4e0d\u5b58\u5728"));
            input.setSid(user.getSid());
        }
        Assert.notNull((Object)sys.getId(), (String)"\u5e94\u7528id\u4e0d\u80fd\u4e3a\u7a7a");
        PolicyTargetVO policyResult = this.policyHandleOldService.getPolicyByUserId(authoredUser.getTenantSid(), sys.getSid(), input.getSid());
        return ResponseEntity.ok((Object)policyResult.getTargets());
    }

    @PostMapping(value={"/attach/role/app"}, produces={"application/json; charset=utf-8"})
    public ResponseEntity<?> getPolicyRoleApp(@RequestBody Role input, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestAttribute(value="digi-middleware-auth-app-data") AuthoredSys sys) {
        if (input.getSid() == 0L) {
            long roleSid = this.roleCrudService.getSidByTenantAndId(authoredUser.getTenantSid(), input.getId());
            Assert.isTrue((roleSid > 0L ? 1 : 0) != 0, (String)("\u89d2\u8272[" + input.getId() + "]\u4e0d\u5b58\u5728"));
            input.setSid(roleSid);
        }
        Assert.notNull((Object)sys.getId(), (String)"\u5e94\u7528id\u4e0d\u80fd\u4e3a\u7a7a");
        PolicyTargetVO policyResult = this.policyHandleOldService.getPolicyByRoleId(authoredUser.getTenantSid(), sys.getSid(), input.getSid());
        return ResponseEntity.ok((Object)policyResult.getTargets());
    }
}

