/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.commons.core.codec.Base64;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.tenant.UserInTenantDTO;
import com.digiwin.dap.middleware.iam.domain.user.QueryAuthUserPageVO;
import com.digiwin.dap.middleware.iam.domain.user.QueryPageVO;
import com.digiwin.dap.middleware.iam.domain.user.QueryUserAllInfoByOrgVO;
import com.digiwin.dap.middleware.iam.domain.user.QueryUserAllInfoVO;
import com.digiwin.dap.middleware.iam.domain.user.UserBasicInfoResultVO;
import com.digiwin.dap.middleware.iam.domain.user.UserBasicInfoVO;
import com.digiwin.dap.middleware.iam.domain.user.UserCondition;
import com.digiwin.dap.middleware.iam.entity.Org;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.mapper.UserMapper;
import com.digiwin.dap.middleware.iam.service.org.OrgCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgQueryService;
import com.digiwin.dap.middleware.iam.service.user.UserBasicInfoQueryService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserQueryService;
import com.digiwin.dap.middleware.iam.service.user.UserWholeService;
import com.digiwin.dap.middleware.iam.support.remote.CacService;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import com.github.pagehelper.PageSerializable;
import io.github.resilience4j.ratelimiter.annotation.RateLimiter;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2/query"})
public class QueryController {
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private CacService cacService;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private UserWholeService userWholeService;
    @Autowired
    private UserBasicInfoQueryService userBasicInfoQueryService;
    @Autowired
    private OrgCrudService orgCrudService;
    @Autowired
    private OrgQueryService orgQueryService;
    @Autowired
    private UserQueryService userQueryService;

    @PostMapping(value={"/user"})
    public ResponseEntity<?> queryUserAllInformation(@RequestBody QueryUserAllInfoVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        List users;
        Assert.isTrue((authoredUser.getTenantSid() > 0L ? 1 : 0) != 0, (String)"\u5f53\u524d\u767b\u9646\u7528\u6237\u5fc5\u987b\u643a\u5e26\u79df\u6237\u4fe1\u606f\uff01");
        String type = body.getType();
        if (type == null) {
            type = "";
        }
        switch (type) {
            case "all": {
                users = this.userBasicInfoQueryService.getUserBasicInfosByTenant(authoredUser.getTenantSid(), "");
                break;
            }
            case "org": {
                if (body.getUri() == null) {
                    throw new IllegalArgumentException("\u5f53\u67e5\u8be2\u7c7b\u578b\u4e3aorg\u65f6\uff0curi\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                users = this.userBasicInfoQueryService.getUserBasicInfosByOrg(authoredUser.getTenantSid(), body.getUri());
                break;
            }
            case "users": {
                if (body.getUserIds() == null) {
                    throw new IllegalArgumentException("\u5f53\u67e5\u8be2\u7c7b\u578b\u4e3ausers\u65f6\uff0cuserIds\u4e0euserSids\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                users = this.userBasicInfoQueryService.getUserBasicInfosByUserIds(authoredUser.getTenantSid(), body.getUserIds());
                break;
            }
            default: {
                if (body.getUserId() == null && body.getUserSid() == 0L) {
                    throw new IllegalArgumentException("\u5f53\u67e5\u8be2\u7c7b\u578b\u4e3a\u9ed8\u8ba4\u7c7b\u578b\u65f6,userIds\u4e0euserSids\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                long userSid = body.getUserSid() > 0L ? body.getUserSid() : this.userCrudService.getSidById(body.getUserId());
                if (userSid == 0L) {
                    throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST, new Object[]{StringUtils.hasText((String)body.getUserId()) ? body.getUserId() : Long.valueOf(body.getUserSid())});
                }
                UserCondition userCondition = new UserCondition.Builder().sid(Long.valueOf(userSid)).build();
                User user = this.userCrudService.queryUserByTenantSidAndCondition(Long.valueOf(authoredUser.getTenantSid()), userCondition);
                if (user == null) {
                    throw new BusinessException((ErrorHandler)I18nError.IAM_USER_PERMISSION_COMMON_ERROR, new Object[]{UserUtils.getUserName(), UserUtils.getUserId(), AppAuthContextHolder.getContext().getClientIP(), Base64.encode((String)JsonUtils.writeValue((Object)body))});
                }
                UserBasicInfoVO userBasicInfoVO = this.userBasicInfoQueryService.getUserBasicInfo(authoredUser.getTenantSid(), user);
                return new ResponseEntity((Object)userBasicInfoVO, HttpStatus.OK);
            }
        }
        return new ResponseEntity((Object)users, HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.REPEATABLE_READ)
    @PostMapping(value={"/user/allinfo"})
    public ResponseEntity<?> queryUserAllInformationWithPage(@RequestBody QueryUserAllInfoVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Assert.isTrue((authoredUser.getTenantSid() > 0L ? 1 : 0) != 0, (String)"\u5f53\u524d\u767b\u9646\u7528\u6237\u5fc5\u987b\u643a\u5e26\u79df\u6237\u4fe1\u606f\uff01");
        UserBasicInfoResultVO resultVO = new UserBasicInfoResultVO();
        if (body.getQueryPage() == null) {
            QueryPageVO queryPageVO = new QueryPageVO();
            queryPageVO.setPageCount(Long.valueOf(10L));
            queryPageVO.setPageNumber(Long.valueOf(1L));
            body.setQueryPage(queryPageVO);
        }
        if (body.getType() == null) {
            body.setType("");
        }
        switch (body.getType()) {
            case "total": {
                resultVO = this.userBasicInfoQueryService.getUserBasicInfosByTenantWithPage(authoredUser.getTenantSid(), body.getQueryPage());
                break;
            }
            case "all": {
                resultVO = this.userBasicInfoQueryService.getUserBasicInfosByTenantWithPage(authoredUser.getTenantSid(), body.getQueryPage());
                break;
            }
            case "enabled": {
                resultVO = this.userBasicInfoQueryService.getEnableUserBasicInfosByTenantWithPage(authoredUser.getTenantSid(), body.getQueryPage());
                break;
            }
            case "disabled": {
                resultVO = this.userBasicInfoQueryService.getDisableUserBasicInfosByTenantWithPage(authoredUser.getTenantSid(), body.getQueryPage());
                break;
            }
            case "org": {
                resultVO = this.userBasicInfoQueryService.getUserBasicInfosByOrgWithPage(authoredUser.getTenantSid(), body.getOrgSids(), body.getQueryPage());
                break;
            }
        }
        return new ResponseEntity((Object)resultVO, HttpStatus.OK);
    }

    @PostMapping(value={"/{appId}/authorized/user"})
    public ResponseEntity<?> queryAuthorizedUser(@PathVariable(value="appId") String appId, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Assert.hasText((String)authoredUser.getTenantId(), (String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u643a\u5e26\u79df\u6237\u4fe1\u606f\uff01");
        List userIds = this.cacService.getAuthorizedUserIds(authoredUser.getTenantId(), appId);
        List users = this.userWholeService.getUsersWhole(authoredUser.getTenantSid(), userIds);
        return ResponseEntity.ok((Object)users);
    }

    @PostMapping(value={"/user/authorized/find"})
    @RateLimiter(name="/api/iam/v2/query/user/authorized/find")
    public ResponseEntity<?> queryAuthorizedUserList(@RequestBody UserInTenantDTO dto, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Assert.hasText((String)authoredUser.getTenantId(), (String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u643a\u5e26\u79df\u6237\u4fe1\u606f\uff01");
        Assert.hasText((String)dto.getAppId(), (String)"\u5e94\u7528id\u4e0d\u80fd\u4e3a\u7a7a");
        PageSerializable page = this.userQueryService.queryAuthorizedUserList(dto, dto.getPageNum(), dto.getPageSize(), dto.getOrderBy());
        return ResponseEntity.ok((Object)page);
    }

    @PostMapping(value={"/user/authorized/list"})
    public ResponseEntity<?> queryAuthorizedUser(@RequestBody UserInTenantDTO dto, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Assert.hasText((String)authoredUser.getTenantId(), (String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u643a\u5e26\u79df\u6237\u4fe1\u606f\uff01");
        Assert.hasText((String)dto.getAppId(), (String)"\u5e94\u7528id\u4e0d\u80fd\u4e3a\u7a7a");
        List page = this.userQueryService.queryAuthorizedUserList(dto);
        return ResponseEntity.ok((Object)page);
    }

    @PostMapping(value={"/user/byorg"})
    public ResponseEntity<?> queryUserAllInformationByOrg(@RequestBody QueryUserAllInfoByOrgVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Assert.isTrue((authoredUser.getTenantSid() > 0L ? 1 : 0) != 0, (String)"\u5f53\u524d\u767b\u9646\u7528\u6237\u5fc5\u987b\u643a\u5e26\u79df\u6237\u4fe1\u606f\uff01");
        Assert.isTrue((body.getOrgSid() != null || body.getOrgUri() != null ? 1 : 0) != 0, (String)"\u7ec4\u7ec7Sid\u548c\u7ec4\u7ec7uri\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        long orgSid = body.getOrgSid() == null ? this.orgQueryService.getOrgSidByUri(authoredUser.getTenantSid(), body.getOrgUri()) : body.getOrgSid();
        Org org = (Org)this.orgCrudService.findBySid(orgSid);
        Assert.notNull((Object)org, (String)String.format("\u6b64\u7ec4\u7ec7[%s]\u4e0d\u5b58\u5728\uff01", orgSid));
        List orgSids = this.orgQueryService.getChildrenOrgSids(Long.valueOf(orgSid));
        orgSids.add(orgSid);
        UserBasicInfoResultVO userBasicInfoResultVO = this.userBasicInfoQueryService.getUserBasicInfosByOrgWithPage(authoredUser.getTenantSid(), orgSids, body.getQueryPage());
        return new ResponseEntity((Object)userBasicInfoResultVO, HttpStatus.OK);
    }

    @PostMapping(value={"/authorized/user"})
    public StdData<?> queryAuthorizedUserPage(@RequestBody QueryAuthUserPageVO body) {
        List userIds = this.cacService.getAuthedUserInfo(UserUtils.getTenantId(), body.getAppId(), body.getStart(), body.getEnd());
        PageSerializable users = this.userWholeService.getAuthUsers(UserUtils.getTenantSid(), userIds, body);
        return StdData.ok((Object)users);
    }

    @PostMapping(value={"/user/auth"})
    public StdData<?> queryUserWithAuthPage(@RequestBody QueryAuthUserPageVO body) {
        PageSerializable users = this.userWholeService.getUsersWithAuth(UserUtils.getTenantSid(), body);
        return StdData.ok((Object)users);
    }
}

