/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.iam.domain.ram.RamAccessCheckInfoVO;
import com.digiwin.dap.middleware.iam.domain.ram.RamUpgradePolicyDTO;
import com.digiwin.dap.middleware.iam.support.auth.RamService;
import com.digiwin.dap.middleware.iam.support.validate.AuthValidateService;
import com.digiwin.dap.middleware.util.UserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2/ram"})
public class RamAccessController {
    private static final Logger LOGGER = LoggerFactory.getLogger(RamAccessController.class);
    @Autowired
    private AuthValidateService authValidateService;
    @Autowired
    private RamService ramService;

    @PostMapping(value={"/access/check"})
    public ResponseEntity<?> checkAccessPermission(@RequestBody RamAccessCheckInfoVO checkInfoVO) {
        return ResponseEntity.ok((Object)this.authValidateService.checkAccessPermission(checkInfoVO.getTargetType(), checkInfoVO.getMethod(), checkInfoVO.getPath(), checkInfoVO.getTargetId()));
    }

    @PostMapping(value={"/policy/cloud/area/upgrade"})
    public StdData<?> upgradeCloudAreaPolicy(@RequestBody RamUpgradePolicyDTO dto) {
        Assert.hasLength((String)dto.getSourceCloudArea(), (String)"\u6765\u6e90\u4e91\u533a\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasLength((String)dto.getUserToken(), (String)"\u6765\u6e90\u4e91\u533a\u7528\u6237token\u4e0d\u80fd\u4e3a\u7a7a");
        LOGGER.info("{} \u6267\u884c\u5347\u7ea7iam-ram\u7b56\u7565\u6743\u9650 {}", (Object)UserUtils.getUserId(), (Object)dto);
        this.ramService.upgradeCloudAreaPolicy(dto);
        return StdData.ok((Object)"\u5347\u7ea7\u5b8c\u6210");
    }
}

