/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.exception.OperateException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.enumeration.ChangeTypeEnum;
import com.digiwin.dap.middleware.iam.domain.org.BatchReplaceVO;
import com.digiwin.dap.middleware.iam.domain.org.RequestParameterVO;
import com.digiwin.dap.middleware.iam.domain.role.RoleCatalogResultVO;
import com.digiwin.dap.middleware.iam.domain.role.RoleCatalogVO;
import com.digiwin.dap.middleware.iam.domain.role.RoleVO;
import com.digiwin.dap.middleware.iam.domain.role.rolebean.RoleBean;
import com.digiwin.dap.middleware.iam.domain.role.rolebean.RoleQueryParameter;
import com.digiwin.dap.middleware.iam.entity.Role;
import com.digiwin.dap.middleware.iam.entity.RoleCatalog;
import com.digiwin.dap.middleware.iam.mapper.UserInRoleMapper;
import com.digiwin.dap.middleware.iam.service.role.RoleCatalogCrudService;
import com.digiwin.dap.middleware.iam.service.role.RoleCatalogQueryService;
import com.digiwin.dap.middleware.iam.service.role.RoleCatalogService;
import com.digiwin.dap.middleware.iam.service.role.RoleCrudService;
import com.digiwin.dap.middleware.iam.service.role.RoleQueryService;
import com.digiwin.dap.middleware.iam.service.role.RoleService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleService;
import com.digiwin.dap.middleware.iam.support.clean.PolicyCascadeDeleteService;
import com.digiwin.dap.middleware.iam.support.log.ChangeLogService;
import com.digiwin.dap.middleware.iam.support.validate.AuthValidateService;
import com.digiwin.dap.middleware.iam.util.StringUtil;
import com.digiwin.dap.middleware.language.service.LanguageCrudService;
import com.digiwin.dap.middleware.util.UserUtils;
import io.github.resilience4j.ratelimiter.annotation.RateLimiter;
import java.util.Collection;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2/role"})
public class RoleController {
    @Autowired
    private RoleService roleService;
    @Autowired
    private RoleCrudService roleCrudService;
    @Autowired
    private RoleQueryService roleQueryService;
    @Autowired
    private RoleCatalogCrudService roleCatalogCrudService;
    @Autowired
    private UserInRoleMapper userInRoleMapper;
    @Autowired
    private PolicyCascadeDeleteService policyCascadeDeleteService;
    @Autowired
    private LanguageCrudService languageCrudService;
    @Autowired
    private RoleCatalogService roleCatalogService;
    @Autowired
    private RoleCatalogQueryService roleCatalogQueryService;
    @Autowired
    private UserInRoleService userInRoleService;
    @Autowired
    private ChangeLogService changeLogService;
    @Autowired
    private AuthValidateService authValidateService;

    @PostMapping
    public ResponseEntity<?> getRole(@RequestBody RequestParameterVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (body.getSid() == 0L && body.getId() == null) {
            throw new BusinessException((ErrorHandler)I18nError.PARAM_MISS);
        }
        if (body.getSid() > 0L) {
            return ResponseEntity.ok((Object)this.roleQueryService.getRoleBySid(body.getSid()));
        }
        return ResponseEntity.ok((Object)this.roleQueryService.getRoleByTenantSidAndId(authoredUser.getTenantSid(), body.getId()));
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/del"})
    public ResponseEntity<?> deleteRole(@RequestBody RequestParameterVO body) {
        List users = this.userInRoleMapper.queryUserInRole(body.getSid());
        if (!CollectionUtils.isEmpty((Collection)users)) {
            throw new BusinessException((ErrorHandler)I18nError.ROLE_DELETE_ERROR, new Object[]{body.getSid()});
        }
        Role role = this.roleCrudService.findByTenantSidAndSid(UserUtils.getTenantSid(), body.getSid());
        if (role != null) {
            if (role.getTenantSid() != UserUtils.getTenantSid()) {
                throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
            }
            this.roleCrudService.deleteBySidAndTenantSid(role.getSid(), role.getTenantSid());
            this.changeLogService.createChangeLog(ChangeTypeEnum.ROLE_DEL.getName(), (Object)role, ChangeTypeEnum.ROLE_DEL.getPrimaryKey(), String.valueOf(role.getSid()));
            this.policyCascadeDeleteService.deleteRole(role.getTenantSid(), body.getSid());
        }
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @PostMapping(value={"/list/byuser/tenant/{tenantId:.+}"})
    @RateLimiter(name="/api/iam/v2/role/list/byuser/tenant/{tenantId}")
    public ResponseEntity<?> getRolesByUserIds(@RequestBody List<String> userIds, @PathVariable(value="tenantId") String tenantId) {
        if (!tenantId.equalsIgnoreCase(UserUtils.getTenantId()) && !this.authValidateService.checkAccessPermission(TargetType.Sys.name(), "POST", "/api/iam/v2/role/list/byuser/tenant/{tenantId:.+}", UserUtils.getSysId()).booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        List userAllRoleVOS = this.roleQueryService.getRolesByUserIds(userIds, tenantId);
        return ResponseEntity.ok((Object)userAllRoleVOS);
    }

    @PostMapping(value={"/query"})
    public ResponseEntity<?> getRoleInCatalog(@RequestBody @Valid RoleBean roleBean, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        long tenantSid = authoredUser.getTenantSid();
        Assert.isTrue((tenantSid > 0L ? 1 : 0) != 0, (String)String.format("\u65e0\u6cd5\u5f97\u5230\u5f53\u524d\u7528\u6237[%s]\u7684\u79df\u6237\u4fe1\u606f\uff01", authoredUser.getUserId()));
        RoleQueryParameter roleQueryParameter = roleBean.getQueryParameter();
        String disabledParameter = "disabled";
        boolean isDisable = disabledParameter.equals(roleQueryParameter.getType());
        List roleQueryResultVOS = this.roleQueryService.getRoleQueryResultVosByType(isDisable, tenantSid);
        return ResponseEntity.ok((Object)roleQueryResultVOS);
    }

    @GetMapping(value={"/simple"})
    public ResponseEntity<?> getRoleInTenant(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Assert.isTrue((authoredUser.getTenantSid() > 0L ? 1 : 0) != 0, (String)String.format("\u65e0\u6cd5\u5f97\u5230\u5f53\u524d\u7528\u6237[%s]\u7684\u79df\u6237\u4fe1\u606f\uff01", authoredUser.getUserId()));
        return ResponseEntity.ok((Object)this.roleQueryService.getRoleQueryResultVosByTenant(authoredUser.getTenantSid()));
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/update"})
    public ResponseEntity<?> updateRole(@RequestBody @Valid RoleVO roleVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        long tenantSid = authoredUser.getTenantSid();
        Assert.isTrue((tenantSid > 0L ? 1 : 0) != 0, (String)String.format("\u65e0\u6cd5\u5f97\u5230\u5f53\u524d\u7528\u6237[%s]\u7684\u79df\u6237\u4fe1\u606f\uff01", authoredUser.getUserId()));
        if (roleVO.getCatalogId() == null && roleVO.getCatalogSid() == 0L) {
            throw new OperateException("\u89d2\u8272\u5206\u7c7bid\u548c\u89d2\u8272\u5206\u7c7bSid\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        if (roleVO.getCatalogId() != null) {
            long roleCatalogSid = this.getCatalogSid(roleVO.getCatalogId(), tenantSid);
            roleVO.setCatalogSid(Long.valueOf(roleCatalogSid));
        }
        if (StringUtils.hasLength((String)roleVO.getHash()) || roleVO.getSid() != 0L) {
            this.roleService.modifyRole(roleVO, tenantSid);
        } else {
            long roleSid = this.roleService.addRole(roleVO, tenantSid);
            roleVO.setSid(roleSid);
        }
        this.languageCrudService.save(roleVO.getSid(), "roleName", roleVO.getName());
        return ResponseEntity.ok((Object)roleVO.getSid());
    }

    private long getCatalogSid(String roleCatalogId, long tenantSid) {
        long sid = 0L;
        if (roleCatalogId != null) {
            if (!StringUtil.checkId((String)roleCatalogId)) {
                throw new BusinessException((ErrorHandler)I18nError.PARAM_ERROR);
            }
            RoleCatalog roleCatalog = this.roleCatalogCrudService.findByTenantSidAndId(tenantSid, roleCatalogId);
            if (roleCatalog != null) {
                sid = roleCatalog.getSid();
            } else {
                throw new BusinessException((ErrorHandler)I18nError.ROLE_CATALOG_NOT_EXISTED, new Object[]{roleCatalogId});
            }
        }
        return sid;
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/catalog/update"})
    public ResponseEntity<?> updateRoleCatalog(@RequestBody RoleCatalogVO roleCatalogVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        long teantSid = authoredUser.getTenantSid();
        if (StringUtils.hasLength((String)roleCatalogVO.getHash()) || roleCatalogVO.getSid() != 0L) {
            this.roleCatalogService.modifyRoleCatalog(roleCatalogVO, teantSid);
            return ResponseEntity.ok((Object)HttpStatus.OK);
        }
        long roleCatalogSid = this.roleCatalogService.addRoleCatalog(roleCatalogVO, teantSid);
        return ResponseEntity.ok((Object)roleCatalogSid);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/catalog/disable"})
    public ResponseEntity<?> disableRoleCatalog(@RequestBody RequestParameterVO requestParameterVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (!this.userInRoleService.checkSuperAdmin(Long.valueOf(authoredUser.getTenantSid()), Long.valueOf(authoredUser.getSid()))) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_USER_NOT_SUPER_ADMIN, new Object[]{authoredUser.getUserId()});
        }
        long roleCatalogSid = this.getRoleCatalogSid(requestParameterVO, authoredUser);
        this.roleCatalogService.disableRoleCatalog(Long.valueOf(authoredUser.getTenantSid()), roleCatalogSid);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    private long getRoleCatalogSid(RequestParameterVO requestParameterVO, AuthoredUser authoredUser) {
        long tenantSid = authoredUser.getTenantSid();
        String roleCatalogId = requestParameterVO.getId();
        long roleCatalogSid = requestParameterVO.getSid();
        if (roleCatalogId == null && roleCatalogSid == 0L) {
            throw new OperateException("roleCatalogId or roleCatalogSid is null");
        }
        if (roleCatalogSid == 0L && roleCatalogId != null) {
            roleCatalogSid = this.getCatalogSid(roleCatalogId, tenantSid);
        }
        return roleCatalogSid;
    }

    @Transactional(readOnly=true, rollbackFor={Exception.class})
    @PostMapping(value={"/catalog"})
    public ResponseEntity<?> getRoleCatalog(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        long tenantSid = authoredUser.getTenantSid();
        List roleCatalogQueryResuleVOS = this.roleCatalogQueryService.getByTenantSid(tenantSid);
        return ResponseEntity.ok((Object)roleCatalogQueryResuleVOS);
    }

    @Transactional(readOnly=true, rollbackFor={Exception.class})
    @PostMapping(value={"/catalog/query"})
    public ResponseEntity<?> getRoleByCatalog(@RequestBody RequestParameterVO requestParameterVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        long roleCatalogSid = this.getRoleCatalogSid(requestParameterVO, authoredUser);
        List roleQueryResultVOS = this.roleQueryService.getRoleQueryResultVosByCatalogSid(authoredUser.getTenantSid(), roleCatalogSid);
        return ResponseEntity.ok((Object)roleQueryResultVOS);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/disable"})
    public ResponseEntity<?> disableRole(@RequestBody RequestParameterVO requestParameterVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        long roleSid = this.getRoleSid(requestParameterVO, authoredUser);
        this.roleService.disableRole(roleSid, authoredUser.getTenantSid());
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    private long getRoleSid(@RequestBody RequestParameterVO requestParameterVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        long tenantSid = authoredUser.getTenantSid();
        String roleId = requestParameterVO.getId();
        long roleSid = requestParameterVO.getSid();
        if (roleId == null && roleSid == 0L) {
            throw new OperateException("roleId or roleSid is null");
        }
        if (roleSid == 0L && roleId != null) {
            roleSid = this.getRoleSid(roleId, tenantSid);
        }
        return roleSid;
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/enable"})
    public ResponseEntity<?> enableRole(@RequestBody RequestParameterVO requestParameterVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        long roleSid = this.getRoleSid(requestParameterVO, authoredUser);
        this.roleCrudService.enable(roleSid, authoredUser.getTenantSid());
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @Transactional(readOnly=true, rollbackFor={Exception.class})
    @PostMapping(value={"/query/cascade"})
    public ResponseEntity<?> getCatalogRoleCascade(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        RoleCatalogResultVO roleCatalogResultVO = this.roleCatalogQueryService.getRoleCatalogResultVO(authoredUser.getTenantSid());
        return new ResponseEntity((Object)roleCatalogResultVO, HttpStatus.OK);
    }

    private long getRoleSid(String roleId, long tenantSid) {
        long sid = 0L;
        if (roleId != null) {
            if (!StringUtil.checkId((String)roleId)) {
                throw new OperateException("roleId\u586b\u5199\u9519\u8bef");
            }
            Role role = this.roleCrudService.findByTenantSidAndId(tenantSid, roleId);
            if (role != null) {
                sid = role.getSid();
            } else {
                throw new OperateException("\u6ca1\u6709" + roleId + "\u89d2\u8272\u5206\u7c7b");
            }
        }
        return sid;
    }

    @PostMapping(value={"/batch/replace"})
    public StdData<?> batchReplaceRole(@Validated @RequestBody BatchReplaceVO vo) {
        this.roleService.batchReplaceRole(vo, UserUtils.getTenantSid());
        return StdData.ok().build();
    }
}

