/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import com.alibaba.nacos.common.utils.CollectionUtils;
import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.commons.core.codec.Base64;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.constant.IamConstants;
import com.digiwin.dap.middleware.iam.constant.enums.SsoTypeEnum;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.cache.UserTempTokenCacheVO;
import com.digiwin.dap.middleware.iam.domain.tenant.metadata.TenantMetadataSAMLVO;
import com.digiwin.dap.middleware.iam.domain.usermapping.UserMappingQueryResultVO;
import com.digiwin.dap.middleware.iam.entity.SysSsoUrlConfig;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.service.sso.SysSsoUrlConfigCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.tenantmetadata.TenantMetadataCrudService;
import com.digiwin.dap.middleware.iam.service.usermapping.UserMappingService;
import com.digiwin.dap.middleware.iam.util.IDPCredentialsUtil;
import com.digiwin.dap.middleware.iam.util.SAMLUtil;
import com.digiwin.dap.middleware.iam.util.SPCredentialsUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.apache.velocity.app.VelocityEngine;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.config.InitializationService;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallerFactory;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.messaging.context.SAMLEndpointContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.saml2.binding.decoding.impl.HTTPRedirectDeflateDecoder;
import org.opensaml.saml.saml2.binding.encoding.impl.HTTPPostEncoder;
import org.opensaml.saml.saml2.binding.encoding.impl.HTTPRedirectDeflateEncoder;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.NameIDFormat;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.opensaml.saml.security.impl.SAMLSignatureProfileValidator;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.config.JavaCryptoValidationInitializer;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.opensaml.xmlsec.keyinfo.KeyInfoGenerator;
import org.opensaml.xmlsec.keyinfo.impl.X509KeyInfoGeneratorFactory;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@ConditionalOnProperty(prefix="dap.middleware.iam.saml", value={"enabled"}, havingValue="true")
@RestController
@RequestMapping(value={"/api/iam/v2/saml"})
public class SAMLController {
    private static final Logger logger = LoggerFactory.getLogger(SAMLController.class);
    @Autowired
    private TenantMetadataCrudService tenantMetadataCrudService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private UserMappingService userMappingService;
    @Autowired
    private SysSsoUrlConfigCrudService sysSsoUrlConfigCrudService;

    @GetMapping(value={"/login"})
    public void login(@RequestParam(value="tenantId", required=false) String tenantId, @RequestParam(value="sysId", required=false) String sysId, HttpServletRequest request, HttpServletResponse response) {
        block16: {
            SysSsoUrlConfig sysSsoUrlConfig;
            try {
                if (!StringUtils.hasText((String)tenantId) || !StringUtils.hasText((String)sysId)) {
                    throw new BusinessException((ErrorHandler)I18nError.PARAM_ERROR);
                }
                sysSsoUrlConfig = this.sysSsoUrlConfigCrudService.findBySysIdAndSsoType(sysId, SsoTypeEnum.SAML.getCode());
                if (Objects.isNull(sysSsoUrlConfig)) {
                    throw new BusinessException((ErrorHandler)I18nError.IAM_SAML_SYS_NOT_EXIST);
                }
            }
            catch (Exception e) {
                logger.error("\u3010saml\u3011 \u767b\u5f55\u5f02\u5e38", (Throwable)e);
                this.sendResponse(response, e.getMessage());
                return;
            }
            try {
                TenantMetadataSAMLVO samlVO = this.getTenantMetadataSAMLVO(tenantId);
                AuthnRequest authnRequest = SAMLUtil.buildAuthnRequest((String)tenantId, (TenantMetadataSAMLVO)samlVO, (SysSsoUrlConfig)sysSsoUrlConfig, (String)this.envProperties.getIamUri());
                MessageContext context = new MessageContext();
                context.setMessage((Object)authnRequest);
                SAMLPeerEntityContext peerEntityContext = (SAMLPeerEntityContext)context.getSubcontext(SAMLPeerEntityContext.class, true);
                SAMLEndpointContext endpointContext = (SAMLEndpointContext)peerEntityContext.getSubcontext(SAMLEndpointContext.class, true);
                endpointContext.setEndpoint(SAMLUtil.getIDPEndpoint((TenantMetadataSAMLVO)samlVO, (boolean)true));
                if ("REDIRECT".equals(samlVO.getBindType())) {
                    HTTPRedirectDeflateEncoder encoder = new HTTPRedirectDeflateEncoder();
                    encoder.setMessageContext(context);
                    encoder.setHttpServletResponse(response);
                    try {
                        encoder.initialize();
                    }
                    catch (ComponentInitializationException e) {
                        logger.error("\u3010saml\u3011 SAML\u7f16\u7801\u521d\u59cb\u5316\u5f02\u5e38", (Throwable)e);
                        throw new BusinessException((ErrorHandler)I18nError.IAM_SAML_ENCODE_ERROR);
                    }
                    try {
                        encoder.encode();
                        break block16;
                    }
                    catch (MessageEncodingException e) {
                        logger.error("\u3010saml\u3011 \u7f16\u7801\u5f02\u5e38", (Throwable)e);
                        throw new BusinessException((ErrorHandler)I18nError.IAM_SAML_ENCODE_ERROR);
                    }
                }
                VelocityEngine velocityEngine = new VelocityEngine();
                velocityEngine.setProperty("resource.loader", (Object)"classpath");
                velocityEngine.setProperty("classpath.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
                velocityEngine.init();
                HTTPPostEncoder encoder = new HTTPPostEncoder();
                encoder.setMessageContext(context);
                encoder.setHttpServletResponse(response);
                encoder.setVelocityEngine(velocityEngine);
                try {
                    encoder.initialize();
                }
                catch (ComponentInitializationException e) {
                    logger.error("\u3010saml\u3011 SAML\u7f16\u7801\u521d\u59cb\u5316\u5f02\u5e38", (Throwable)e);
                    throw new BusinessException((ErrorHandler)I18nError.IAM_SAML_ENCODE_ERROR);
                }
                logger.info("Sending auto-sumbitting form to receiver with AuthnRequest");
                try {
                    encoder.encode();
                }
                catch (MessageEncodingException e) {
                    logger.error("\u3010saml\u3011 \u7f16\u7801\u5f02\u5e38", (Throwable)e);
                    throw new BusinessException((ErrorHandler)I18nError.IAM_SAML_ENCODE_ERROR);
                }
            }
            catch (BusinessException e) {
                logger.error("\u3010saml\u3011 \u767b\u5f55\u5f02\u5e38", (Throwable)e);
                this.redirect(response, SAMLUtil.getFailCallbackUrl((String)sysSsoUrlConfig.getFailCallbackUrl(), (String)e.getMessage()));
            }
            catch (Exception e) {
                logger.error("\u3010saml\u3011 \u767b\u5f55\u5f02\u5e38", (Throwable)e);
                this.redirect(response, SAMLUtil.getFailCallbackUrl((String)sysSsoUrlConfig.getFailCallbackUrl(), (String)"\u7cfb\u7edf\u5f02\u5e38"));
            }
        }
    }

    @PostMapping(value={"/acs/{tenantId:.+}/{sysId}"})
    public void consumerAssertion(@PathVariable(value="tenantId") String tenantId, @PathVariable(value="sysId") String sysId, @RequestParam(value="SAMLResponse") String samlResponse, HttpServletResponse response) {
        SysSsoUrlConfig sysSsoUrlConfig;
        try {
            sysSsoUrlConfig = this.sysSsoUrlConfigCrudService.findBySysIdAndSsoType(sysId, SsoTypeEnum.SAML.getCode());
            if (Objects.isNull(sysSsoUrlConfig)) {
                throw new BusinessException((ErrorHandler)I18nError.IAM_SAML_SYS_NOT_EXIST);
            }
        }
        catch (Exception e) {
            logger.error("\u3010saml\u3011 \u767b\u5f55\u5f02\u5e38", (Throwable)e);
            this.sendResponse(response, e.getMessage());
            return;
        }
        try {
            Tenant tenant = (Tenant)this.tenantCrudService.findById(tenantId);
            if (Objects.isNull(tenant)) {
                throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{tenantId});
            }
            List tenantMetadataVOList = this.tenantMetadataCrudService.getTenantMetadataValue(tenant.getSid(), "saml", IamConstants.SAML_KEY_LIST);
            TenantMetadataSAMLVO samlVO = new TenantMetadataSAMLVO(tenantMetadataVOList);
            byte[] byteResponse = Base64.decode((byte[])samlResponse.getBytes(StandardCharsets.UTF_8));
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteResponse);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(byteArrayInputStream);
            Element element = document.getDocumentElement();
            UnmarshallerFactory unmarshallerFactory = XMLObjectProviderRegistrySupport.getUnmarshallerFactory();
            Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(Response.DEFAULT_ELEMENT_NAME);
            XMLObject responseXmlObj = unmarshaller.unmarshall(element);
            Response responseObj = (Response)responseXmlObj;
            Status status = responseObj.getStatus();
            if (!"urn:oasis:names:tc:SAML:2.0:status:Success".equals(status.getStatusCode().getValue())) {
                logger.error("IDP\u8ba4\u8bc1\u672a\u901a\u8fc7,tenantId:{},sysId:{},samlResponse:{}", new Object[]{tenant, sysId, samlResponse});
                throw new BusinessException((ErrorHandler)I18nError.IAM_SAML_IDP_VALIDATE_ERROR);
            }
            Assertion assertion = (Assertion)responseObj.getAssertions().get(0);
            if (assertion.isSigned()) {
                Signature signature = assertion.getSignature();
                SAMLSignatureProfileValidator profileValidator = new SAMLSignatureProfileValidator();
                try {
                    profileValidator.validate(signature);
                    BasicX509Credential x509Credential = IDPCredentialsUtil.getBasicX509CredentialFromString((String)samlVO.getCredentials());
                    SignatureValidator.validate((Signature)signature, (Credential)x509Credential);
                }
                catch (Exception e) {
                    logger.error("\u7b7e\u540d\u9a8c\u8bc1\u4e0d\u901a\u8fc7", (Throwable)e);
                    throw new BusinessException((ErrorHandler)I18nError.IAM_SAML_SIGNATURE_VALIDATE_ERROR);
                }
            } else {
                throw new BusinessException((ErrorHandler)I18nError.IAM_SAML_UNSIGNED_ASSERTION);
            }
            String id = responseObj.getID();
            logger.info("\u3010saml\u3011 id:{}", (Object)id);
            DateTime issueInstant = responseObj.getIssueInstant();
            logger.info("\u3010saml\u3011 issueInstant:{}", (Object)issueInstant);
            DateTime compareTime = new DateTime().minusMinutes(5);
            if (issueInstant.isBefore((ReadableInstant)compareTime)) {
                throw new BusinessException((ErrorHandler)I18nError.IAM_SAML_EXPIRED_ASSERTION);
            }
            if (!RedisUtils.setIfAbsent((String)String.format("iam:saml:lock:%s", id), (Object)System.currentTimeMillis(), (Duration)Duration.ofMinutes(5L))) {
                throw new BusinessException((ErrorHandler)I18nError.IAM_SAML_DUPLICATE_ASSERTION);
            }
            String sessionIndex = null;
            if (CollectionUtils.isNotEmpty((Collection)assertion.getAuthnStatements())) {
                sessionIndex = ((AuthnStatement)assertion.getAuthnStatements().get(0)).getSessionIndex();
            }
            logger.info("\u3010saml\u3011 sessionIndex:{}", sessionIndex);
            String nameId = assertion.getSubject().getNameID().getValue();
            logger.info("\u3010saml\u3011 nameId:{}", (Object)nameId);
            String verifyUserId = null;
            if ("NameID".equals(samlVO.getUserId())) {
                verifyUserId = nameId;
            } else {
                for (Attribute attribute : ((AttributeStatement)assertion.getAttributeStatements().get(0)).getAttributes()) {
                    logger.info("\u3010saml\u3011 Attribute name: " + attribute.getName());
                    if (!Objects.equals(attribute.getName(), samlVO.getUserId())) continue;
                    verifyUserId = ((XSString)attribute.getAttributeValues().get(0)).getValue();
                }
            }
            if (Objects.isNull(verifyUserId)) {
                throw new BusinessException((ErrorHandler)I18nError.IAM_USER_ID_MAPPING_ATTRIBUTE_NOT_EXIST);
            }
            UserMappingQueryResultVO userMappingInfo = this.userMappingService.getUserByMapping(Long.valueOf(tenant.getSid()), samlVO.getMappingAppId(), null, verifyUserId);
            if (Objects.isNull(userMappingInfo)) {
                throw new BusinessException((ErrorHandler)I18nError.IAM_USER_MAPPING_NOT_EXIST);
            }
            UserTempTokenCacheVO cacheVO = new UserTempTokenCacheVO();
            cacheVO.setValue(String.join((CharSequence)":_", userMappingInfo.getUserId(), tenantId, sysId));
            cacheVO.setCreateTime(Long.valueOf(System.currentTimeMillis()));
            String samlToken = UUID.randomUUID().toString().toLowerCase();
            String samlTokenKey = String.format("iam:sso:token:%s:%s", "saml", samlToken);
            RedisUtils.set((String)samlTokenKey, (Object)cacheVO, (Duration)Duration.ofMinutes(3L));
            this.redirect(response, SAMLUtil.getSuccessCallbackUrl((String)sysSsoUrlConfig.getSuccessCallbackUrl(), (String)samlToken, (String)nameId, (String)sessionIndex));
        }
        catch (BusinessException e) {
            logger.error("\u3010saml\u3011 \u6d88\u8d39\u65ad\u8a00\u5f02\u5e38", (Throwable)e);
            this.redirect(response, SAMLUtil.getFailCallbackUrl((String)sysSsoUrlConfig.getFailCallbackUrl(), (String)e.getMessage()));
        }
        catch (Exception e) {
            logger.error("\u3010saml\u3011 \u6d88\u8d39\u65ad\u8a00\u5f02\u5e38", (Throwable)e);
            this.redirect(response, SAMLUtil.getFailCallbackUrl((String)sysSsoUrlConfig.getFailCallbackUrl(), (String)"\u7cfb\u7edf\u5f02\u5e38"));
        }
    }

    @GetMapping(value={"/sp/metadata"})
    public void getSpMetadata(@RequestParam(value="tenantId", required=false) String tenantId, @RequestParam(value="sysId", required=false) String sysId, HttpServletResponse response) throws MarshallingException, SecurityException {
        try {
            if (!StringUtils.hasText((String)tenantId) || !StringUtils.hasText((String)sysId)) {
                throw new BusinessException((ErrorHandler)I18nError.PARAM_ERROR);
            }
        }
        catch (Exception e) {
            logger.error("\u3010saml\u3011 \u67e5\u8be2\u5143\u6570\u636e\u5f02\u5e38", (Throwable)e);
            this.sendResponse(response, e.getMessage());
            return;
        }
        EntityDescriptor entityDescriptor = (EntityDescriptor)SAMLUtil.buildSAMLObject(EntityDescriptor.class);
        entityDescriptor.setEntityID(this.envProperties.getIamUri() + "/sp/" + sysId);
        entityDescriptor.setID(SAMLUtil.generateSecureRandomId());
        entityDescriptor.setValidUntil(new DateTime().plusYears(1));
        entityDescriptor.setCacheDuration(Long.valueOf(86400000L));
        Credential credential = SPCredentialsUtil.getCredential();
        XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller((XMLObject)entityDescriptor).marshall((XMLObject)entityDescriptor);
        SPSSODescriptor spssoDescriptor = (SPSSODescriptor)SAMLUtil.buildSAMLObject(SPSSODescriptor.class);
        spssoDescriptor.addSupportedProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        spssoDescriptor.setWantAssertionsSigned(Boolean.valueOf(true));
        spssoDescriptor.setAuthnRequestsSigned(Boolean.valueOf(false));
        NameIDFormat nameIDFormat = (NameIDFormat)SAMLUtil.buildSAMLObject(NameIDFormat.class);
        nameIDFormat.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        spssoDescriptor.getNameIDFormats().add(nameIDFormat);
        AssertionConsumerService assertionConsumerService = (AssertionConsumerService)SAMLUtil.buildSAMLObject(AssertionConsumerService.class);
        assertionConsumerService.setLocation(String.format("%s/api/iam/v2/saml/acs/%s/%s", this.envProperties.getIamUri(), tenantId, sysId));
        assertionConsumerService.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        assertionConsumerService.setIndex(Integer.valueOf(1));
        spssoDescriptor.getAssertionConsumerServices().add(assertionConsumerService);
        SingleLogoutService singleLogoutService = (SingleLogoutService)SAMLUtil.buildSAMLObject(SingleLogoutService.class);
        singleLogoutService.setLocation(String.format("%s/api/iam/v2/saml/logout/acs/%s/%s", this.envProperties.getIamUri(), tenantId, sysId));
        singleLogoutService.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        spssoDescriptor.getSingleLogoutServices().add(singleLogoutService);
        X509KeyInfoGeneratorFactory keyInfoGeneratorFactory = new X509KeyInfoGeneratorFactory();
        keyInfoGeneratorFactory.setEmitEntityCertificate(true);
        KeyInfoGenerator keyInfoGenerator = keyInfoGeneratorFactory.newInstance();
        KeyDescriptor encKeyDescriptor = (KeyDescriptor)SAMLUtil.buildSAMLObject(KeyDescriptor.class);
        encKeyDescriptor.setUse(UsageType.SIGNING);
        encKeyDescriptor.setKeyInfo(keyInfoGenerator.generate(credential));
        spssoDescriptor.getKeyDescriptors().add(encKeyDescriptor);
        entityDescriptor.getRoleDescriptors().add(spssoDescriptor);
        this.postResponse(response, "UTF-8", "application/xml", this.writeEntityDescriptor(entityDescriptor));
    }

    @GetMapping(value={"/logout"})
    public void logout(@RequestParam(value="tenantId", required=false) String tenantId, @RequestParam(value="sysId", required=false) String sysId, @RequestParam(value="nameId", required=false) String nameId, @RequestParam(value="sessionIndex", required=false) String sessionIndex, HttpServletRequest request, HttpServletResponse response) {
        SysSsoUrlConfig sysSsoUrlConfig;
        try {
            if (!StringUtils.hasText((String)tenantId) || !StringUtils.hasText((String)sysId)) {
                throw new BusinessException((ErrorHandler)I18nError.PARAM_ERROR);
            }
            sysSsoUrlConfig = this.sysSsoUrlConfigCrudService.findBySysIdAndSsoType(sysId, SsoTypeEnum.SAML.getCode());
            if (Objects.isNull(sysSsoUrlConfig)) {
                throw new BusinessException((ErrorHandler)I18nError.IAM_SAML_SYS_NOT_EXIST);
            }
        }
        catch (Exception e) {
            logger.error("\u3010saml\u3011 \u767b\u51fa\u5f02\u5e38", (Throwable)e);
            this.sendResponse(response, e.getMessage());
            return;
        }
        try {
            TenantMetadataSAMLVO samlVO = this.getTenantMetadataSAMLVO(tenantId);
            if (!StringUtils.hasText((String)samlVO.getLogoutUrl()) || !StringUtils.hasText((String)nameId)) {
                this.redirect(response, sysSsoUrlConfig.getLogoutCallbackUrl());
                return;
            }
            LogoutRequest logoutRequest = SAMLUtil.buildLogoutRequest((TenantMetadataSAMLVO)samlVO, (String)this.envProperties.getIamUri(), (String)nameId, (String)sessionIndex);
            MessageContext context = new MessageContext();
            context.setMessage((Object)logoutRequest);
            SAMLPeerEntityContext peerEntityContext = (SAMLPeerEntityContext)context.getSubcontext(SAMLPeerEntityContext.class, true);
            SAMLEndpointContext endpointContext = (SAMLEndpointContext)peerEntityContext.getSubcontext(SAMLEndpointContext.class, true);
            endpointContext.setEndpoint(SAMLUtil.getIDPEndpoint((TenantMetadataSAMLVO)samlVO, (boolean)false));
            SignatureSigningParameters signingParameters = new SignatureSigningParameters();
            signingParameters.setSigningCredential(SPCredentialsUtil.getCredential());
            signingParameters.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
            signingParameters.setSignatureCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
            ((SecurityParametersContext)context.getSubcontext(SecurityParametersContext.class, true)).setSignatureSigningParameters(signingParameters);
            HTTPRedirectDeflateEncoder encoder = new HTTPRedirectDeflateEncoder();
            encoder.setMessageContext(context);
            encoder.setHttpServletResponse(response);
            try {
                encoder.initialize();
            }
            catch (ComponentInitializationException e) {
                logger.error("\u3010saml\u3011 SAML\u7f16\u7801\u521d\u59cb\u5316\u5f02\u5e38", (Throwable)e);
                throw new BusinessException((ErrorHandler)I18nError.IAM_SAML_ENCODE_ERROR);
            }
            try {
                encoder.encode();
            }
            catch (MessageEncodingException e) {
                logger.error("\u3010saml\u3011 \u7f16\u7801\u5f02\u5e38", (Throwable)e);
                throw new BusinessException((ErrorHandler)I18nError.IAM_SAML_ENCODE_ERROR);
            }
        }
        catch (BusinessException e) {
            logger.error("\u3010saml\u3011 \u767b\u51fa\u5f02\u5e38", (Throwable)e);
            this.redirect(response, SAMLUtil.getFailCallbackUrl((String)sysSsoUrlConfig.getFailCallbackUrl(), (String)e.getMessage()));
        }
        catch (Exception e) {
            logger.error("\u3010saml\u3011 \u767b\u51fa\u5f02\u5e38", (Throwable)e);
            this.redirect(response, SAMLUtil.getFailCallbackUrl((String)sysSsoUrlConfig.getFailCallbackUrl(), (String)"\u7cfb\u7edf\u5f02\u5e38"));
        }
    }

    @RequestMapping(value={"/logout/acs/{tenantId:.+}/{sysId}"})
    public void consumerLogout(@PathVariable(value="tenantId") String tenantId, @PathVariable(value="sysId") String sysId, HttpServletRequest request, HttpServletResponse response) {
        SysSsoUrlConfig sysSsoUrlConfig;
        try {
            sysSsoUrlConfig = this.sysSsoUrlConfigCrudService.findBySysIdAndSsoType(sysId, SsoTypeEnum.SAML.getCode());
            if (Objects.isNull(sysSsoUrlConfig)) {
                throw new BusinessException((ErrorHandler)I18nError.IAM_SAML_SYS_NOT_EXIST);
            }
        }
        catch (Exception e) {
            logger.error("\u3010saml\u3011 \u767b\u5f55\u5f02\u5e38", (Throwable)e);
            this.sendResponse(response, e.getMessage());
            return;
        }
        try {
            Tenant tenant = (Tenant)this.tenantCrudService.findById(tenantId);
            if (Objects.isNull(tenant)) {
                throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{tenantId});
            }
            HTTPRedirectDeflateDecoder httpRedirectDeflateDecoder = new HTTPRedirectDeflateDecoder();
            httpRedirectDeflateDecoder.setHttpServletRequest(request);
            httpRedirectDeflateDecoder.setParserPool(SAMLUtil.getParserPool());
            try {
                httpRedirectDeflateDecoder.initialize();
                httpRedirectDeflateDecoder.decode();
            }
            catch (Exception e) {
                logger.error("\u89e3\u6790\u5f02\u5e38", (Throwable)e);
            }
            MessageContext messageContext = httpRedirectDeflateDecoder.getMessageContext();
            Element element = ((SAMLObject)messageContext.getMessage()).getDOM();
            UnmarshallerFactory unmarshallerFactory = XMLObjectProviderRegistrySupport.getUnmarshallerFactory();
            Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(LogoutResponse.DEFAULT_ELEMENT_NAME);
            XMLObject responseXmlObj = unmarshaller.unmarshall(element);
            LogoutResponse responseObj = (LogoutResponse)responseXmlObj;
            Status status = responseObj.getStatus();
            if (!"urn:oasis:names:tc:SAML:2.0:status:Success".equals(status.getStatusCode().getValue())) {
                logger.error("IDP\u9000\u51fa\u672a\u6210\u529f,tenantId:{},sysId:{}", (Object)tenant, (Object)sysId);
                throw new BusinessException((ErrorHandler)I18nError.IAM_SAML_IDP_VALIDATE_ERROR);
            }
            String id = responseObj.getID();
            logger.info("\u3010saml\u3011 id:{}", (Object)id);
            DateTime issueInstant = responseObj.getIssueInstant();
            logger.info("\u3010saml\u3011 issueInstant:{}", (Object)issueInstant);
            DateTime compareTime = new DateTime().minusMinutes(5);
            if (issueInstant.isBefore((ReadableInstant)compareTime)) {
                throw new BusinessException((ErrorHandler)I18nError.IAM_SAML_EXPIRED_ASSERTION);
            }
            if (!RedisUtils.setIfAbsent((String)String.format("iam:saml:lock:%s", id), (Object)System.currentTimeMillis(), (Duration)Duration.ofMinutes(5L))) {
                throw new BusinessException((ErrorHandler)I18nError.IAM_SAML_DUPLICATE_ASSERTION);
            }
            this.redirect(response, sysSsoUrlConfig.getLogoutCallbackUrl());
        }
        catch (BusinessException e) {
            logger.error("\u3010saml\u3011 \u6d88\u8d39\u65ad\u8a00\u5f02\u5e38", (Throwable)e);
            this.redirect(response, SAMLUtil.getFailCallbackUrl((String)sysSsoUrlConfig.getFailCallbackUrl(), (String)e.getMessage()));
        }
        catch (Exception e) {
            logger.error("\u3010saml\u3011 \u6d88\u8d39\u65ad\u8a00\u5f02\u5e38", (Throwable)e);
            this.redirect(response, SAMLUtil.getFailCallbackUrl((String)sysSsoUrlConfig.getFailCallbackUrl(), (String)"\u7cfb\u7edf\u5f02\u5e38"));
        }
    }

    private String writeEntityDescriptor(EntityDescriptor entityDescriptor) throws MarshallingException {
        Marshaller marshaller = XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller((XMLObject)entityDescriptor);
        Element element = marshaller.marshall((XMLObject)entityDescriptor);
        return SerializeSupport.prettyPrintXML((Node)element);
    }

    private void postResponse(HttpServletResponse response, String characterEncoding, String contentType, String data) {
        try {
            response.reset();
            response.setCharacterEncoding(characterEncoding);
            response.setContentType(contentType);
            PrintWriter printWriter = response.getWriter();
            printWriter.write(data);
            printWriter.flush();
            printWriter.close();
        }
        catch (Exception ex) {
            logger.error("\u3010saml\u3011 \u8fd4\u56de\u9519\u8bef\u4fe1\u606f\u5f02\u5e38", (Throwable)ex);
        }
    }

    private TenantMetadataSAMLVO getTenantMetadataSAMLVO(String tenantId) {
        Tenant tenant = (Tenant)this.tenantCrudService.findById(tenantId);
        if (Objects.isNull(tenant)) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{tenantId});
        }
        List tenantMetadataVOList = this.tenantMetadataCrudService.getTenantMetadataValue(tenant.getSid(), "saml", IamConstants.SAML_KEY_LIST);
        return new TenantMetadataSAMLVO(tenantMetadataVOList);
    }

    private void redirect(HttpServletResponse response, String url) {
        try {
            response.sendRedirect(url);
        }
        catch (IOException ex) {
            logger.error("\u3010saml\u3011 \u8df3\u8f6c\u5931\u8d25\u9875\u9762\u5f02\u5e38", (Throwable)ex);
        }
    }

    private void sendResponse(HttpServletResponse response, String message) {
        try {
            response.reset();
            response.setCharacterEncoding("UTF-8");
            response.setContentType("text/plain; charset=UTF-8");
            PrintWriter printWriter = response.getWriter();
            printWriter.write(message);
            printWriter.flush();
            printWriter.close();
        }
        catch (Exception ex) {
            logger.error("\u3010saml\u3011 \u8fd4\u56de\u9519\u8bef\u4fe1\u606f\u5f02\u5e38", (Throwable)ex);
        }
    }

    static {
        JavaCryptoValidationInitializer javaCryptoValidationInitializer = new JavaCryptoValidationInitializer();
        try {
            logger.info("javaCryptoValidationInitializer.init");
            javaCryptoValidationInitializer.init();
        }
        catch (InitializationException e) {
            logger.error("\u3010saml\u3011 \u521d\u59cb\u5316\u914d\u7f6e\u5931\u8d25", (Throwable)e);
        }
        try {
            logger.info("InitializationService.initialize");
            InitializationService.initialize();
        }
        catch (InitializationException e) {
            logger.error("\u3010saml\u3011 \u521d\u59cb\u5316\u914d\u7f6e\u5931\u8d25", (Throwable)e);
        }
    }
}

