/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import com.digiwin.dap.middle.encrypt.domain.annotation.DapSign;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.iam.constant.enums.SsoTypeEnum;
import com.digiwin.dap.middleware.iam.domain.saml.SAMLSysDTO;
import com.digiwin.dap.middleware.iam.domain.sso.SysSsoUrlConfigDTO;
import com.digiwin.dap.middleware.iam.entity.SysSsoUrlConfig;
import com.digiwin.dap.middleware.iam.service.sso.SysSsoUrlConfigCrudService;
import com.digiwin.dap.middleware.iam.service.sso.SysSsoUrlConfigQueryService;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2/saml/sys"})
public class SAMLSysController {
    @Autowired
    private SysSsoUrlConfigCrudService sysSsoUrlConfigCrudService;
    @Autowired
    private SysSsoUrlConfigQueryService sysSsoUrlConfigQueryService;

    @PostMapping(value={"/search"})
    public StdData<?> search(@RequestBody SAMLSysDTO samlSysDTO) {
        List sysSsoUrlConfigList = this.sysSsoUrlConfigQueryService.findAllBySysContentAndSsoType(samlSysDTO.getSysContent(), SsoTypeEnum.SAML.getCode());
        return StdData.ok((Object)sysSsoUrlConfigList);
    }

    @PostMapping(value={"/find"})
    public StdData<?> find(@RequestAttribute(value="digi-middleware-auth-app-data") AuthoredSys sys) {
        SysSsoUrlConfig samlSys = this.sysSsoUrlConfigCrudService.findBySysIdAndSsoType(sys.getId(), SsoTypeEnum.SAML.getCode());
        return StdData.ok((Object)samlSys);
    }

    @PostMapping(value={"/exist"})
    public StdData<?> exist(@RequestAttribute(value="digi-middleware-auth-app-data") AuthoredSys sys) {
        SysSsoUrlConfig samlSys = this.sysSsoUrlConfigCrudService.findBySysIdAndSsoType(sys.getId(), SsoTypeEnum.SAML.getCode());
        return StdData.ok((Object)Objects.nonNull(samlSys));
    }

    @DapSign(response=true)
    @PostMapping(value={"/add"})
    public StdData<?> add(@RequestBody @Valid SAMLSysDTO samlSysDTO, @RequestAttribute(value="digi-middleware-auth-app-data") AuthoredSys sys) {
        SysSsoUrlConfig oldSysSsoUrlConfig = this.sysSsoUrlConfigCrudService.findBySysIdAndSsoType(sys.getId(), SsoTypeEnum.SAML.getCode());
        if (Objects.isNull(oldSysSsoUrlConfig)) {
            SysSsoUrlConfig sysSsoUrlConfig = new SysSsoUrlConfig();
            sysSsoUrlConfig.setSysId(sys.getId());
            sysSsoUrlConfig.setSysName(samlSysDTO.getSysName());
            sysSsoUrlConfig.setSuccessCallbackUrl(samlSysDTO.getSuccessCallbackUrl());
            sysSsoUrlConfig.setFailCallbackUrl(samlSysDTO.getFailCallbackUrl());
            sysSsoUrlConfig.setLogoutCallbackUrl(samlSysDTO.getLogoutCallbackUrl());
            sysSsoUrlConfig.setSsoType(SsoTypeEnum.SAML.getCode());
            this.sysSsoUrlConfigCrudService.create((BaseEntity)sysSsoUrlConfig);
        } else {
            SysSsoUrlConfigDTO oldSysSsoUrlConfigDTO = new SysSsoUrlConfigDTO(oldSysSsoUrlConfig);
            SysSsoUrlConfigDTO newSysSsoUrlConfigDTO = new SysSsoUrlConfigDTO(samlSysDTO);
            if (oldSysSsoUrlConfigDTO.equals((Object)newSysSsoUrlConfigDTO)) {
                return StdData.ok().build();
            }
            oldSysSsoUrlConfig.setSysName(newSysSsoUrlConfigDTO.getSysName());
            oldSysSsoUrlConfig.setSuccessCallbackUrl(newSysSsoUrlConfigDTO.getSuccessCallbackUrl());
            oldSysSsoUrlConfig.setFailCallbackUrl(newSysSsoUrlConfigDTO.getFailCallbackUrl());
            oldSysSsoUrlConfig.setLogoutCallbackUrl(newSysSsoUrlConfigDTO.getLogoutCallbackUrl());
            oldSysSsoUrlConfig.setSsoType(newSysSsoUrlConfigDTO.getSsoType());
            this.sysSsoUrlConfigCrudService.update((BaseEntity)oldSysSsoUrlConfig);
        }
        return StdData.ok().build();
    }
}

