/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.authorization.code.PageSearchParam;
import com.digiwin.dap.middleware.iam.domain.authorization.code.ServiceAuthorizationCodeDTO;
import com.digiwin.dap.middleware.iam.domain.enumeration.StopTypeEnum;
import com.digiwin.dap.middleware.iam.entity.ServiceAuthorizationCode;
import com.digiwin.dap.middleware.iam.mapper.ServiceAuthorizationCodeMapper;
import com.digiwin.dap.middleware.iam.repository.ServiceAuthorizationCodeRepository;
import com.digiwin.dap.middleware.iam.service.service.authorization.code.ServiceAuthorizationCodeService;
import com.digiwin.dap.middleware.iam.support.validate.AuthValidateService;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2/service/authorization"})
public class ServiceAuthorizationCodeController {
    @Autowired
    private ServiceAuthorizationCodeService serviceAuthorizationCodeService;
    @Autowired
    private ServiceAuthorizationCodeRepository serviceAuthorizationCodeRepository;
    @Autowired
    private ServiceAuthorizationCodeMapper serviceAuthorizationCodeMapper;
    @Autowired
    private AuthValidateService authValidateService;

    @PostMapping(value={"/code"})
    public StdData saveCode(@Valid @RequestBody ServiceAuthorizationCodeDTO dto, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (dto.getEndDate() == null) {
            throw new BusinessException((ErrorHandler)I18nError.EXPIRATION_TIME_CANNOT_BE_EMPTY);
        }
        if (authoredUser.getTenantSid() == 0L) {
            throw new BusinessException((ErrorHandler)I18nError.USER_TENANT_SID_EMPTY);
        }
        if (1 == dto.getType()) {
            if (dto.getStartDate() == null) {
                throw new BusinessException((ErrorHandler)I18nError.AUTHORIZATION_START_TIME_CANNOT_BE_EMPTY);
            }
            if (dto.getEndDate() == null) {
                throw new BusinessException((ErrorHandler)I18nError.AUTHORIZATION_END_TIME_CANNOT_BE_EMPTY);
            }
            if (!dto.getAccountAuthorizationAgreement().booleanValue()) {
                throw new BusinessException((ErrorHandler)I18nError.THE_ACCOUNT_AUTHORIZATION_AGREEMENT_HAS_NOT_BEEN_SIGNED);
            }
        }
        dto.setTenantSid(Long.valueOf(authoredUser.getTenantSid()));
        return StdData.ok((Object)this.serviceAuthorizationCodeService.save(dto));
    }

    @GetMapping(value={"/code/exists"})
    public StdData existsCode(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestParam(name="type", required=false, defaultValue="0") Integer type) {
        if (authoredUser.getTenantSid() == 0L) {
            throw new BusinessException((ErrorHandler)I18nError.USER_TENANT_SID_EMPTY);
        }
        return StdData.ok((Object)this.serviceAuthorizationCodeRepository.existsByTenantSidAndDisabledAndType(authoredUser.getTenantSid(), Boolean.FALSE, type));
    }

    @Deprecated
    @GetMapping(value={"/codes"})
    public StdData getCodes(@RequestParam(name="params", required=false) String params, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (authoredUser.getTenantSid() == 0L) {
            throw new BusinessException((ErrorHandler)I18nError.USER_TENANT_SID_EMPTY);
        }
        ServiceAuthorizationCodeDTO dto = ServiceAuthorizationCodeDTO.getSelf((String)params);
        dto.setTenantSid(Long.valueOf(authoredUser.getTenantSid()));
        dto.setType(Integer.valueOf(0));
        return StdData.ok((Object)this.serviceAuthorizationCodeMapper.selectServiceAuthorizationCodeList(dto));
    }

    @GetMapping(value={"/code"})
    public StdData getCode(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (authoredUser.getTenantSid() == 0L) {
            throw new BusinessException((ErrorHandler)I18nError.USER_TENANT_SID_EMPTY);
        }
        List authorizationCodes = this.serviceAuthorizationCodeRepository.getByTenantSidAndDisabledAndTypeOrderByCreateDateDesc(authoredUser.getTenantSid(), Boolean.FALSE, Integer.valueOf(0));
        return StdData.ok(authorizationCodes.isEmpty() ? null : (ServiceAuthorizationCode)authorizationCodes.get(0));
    }

    @PutMapping(value={"/code"})
    public StdData updateCode(@RequestBody ServiceAuthorizationCodeDTO dto, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (StringUtils.isEmpty((Object)dto.getCode())) {
            throw new BusinessException((ErrorHandler)I18nError.SERVICE_AUTH_CODE_EMPTY);
        }
        if (authoredUser.getTenantSid() == 0L) {
            throw new BusinessException((ErrorHandler)I18nError.USER_TENANT_SID_EMPTY);
        }
        dto.setTenantSid(Long.valueOf(authoredUser.getTenantSid()));
        dto.setStopType(StopTypeEnum.TENANT_STOP.getValue());
        this.serviceAuthorizationCodeService.stopCode(dto);
        return StdData.ok((Object)true);
    }

    @PostMapping(value={"/code/list"})
    public StdData getCodeList(@RequestBody PageSearchParam<ServiceAuthorizationCodeDTO> searchContent, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        if (0L == user.getTenantSid()) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_ID_NOT_NULL);
        }
        if (null == searchContent || null == searchContent.getParams() || null == ((ServiceAuthorizationCodeDTO)searchContent.getParams()).getType()) {
            throw new BusinessException((ErrorHandler)I18nError.AUTHORIZATION_CODE_TYPE_NOT_NULL);
        }
        if (StringUtils.isEmpty((Object)searchContent.getOrderBy())) {
            searchContent.setOrderBy("ac.create_date desc");
        }
        ((ServiceAuthorizationCodeDTO)searchContent.getParams()).setTenantSid(Long.valueOf(user.getTenantSid()));
        return StdData.ok((Object)this.serviceAuthorizationCodeService.getCodeList(searchContent));
    }

    @PostMapping(value={"/code/find"})
    public StdData getCodeDetail(@RequestBody ServiceAuthorizationCodeDTO detailInfo) {
        ServiceAuthorizationCode serviceAuthorizationCode;
        if (StringUtils.isEmpty((Object)detailInfo.getCode())) {
            if (null == detailInfo.getSid() || 0L == detailInfo.getSid()) {
                throw new BusinessException((ErrorHandler)I18nError.AGENT_AUTHORIZATION_CODE_TYPE_NOT_NULL);
            }
            serviceAuthorizationCode = this.serviceAuthorizationCodeRepository.findById((Object)detailInfo.getSid()).orElse(null);
        } else {
            serviceAuthorizationCode = this.serviceAuthorizationCodeRepository.findByCode(detailInfo.getCode());
        }
        return StdData.ok((Object)serviceAuthorizationCode);
    }

    @PostMapping(value={"/code/copy"})
    public StdData copyCodeWithRecords(@RequestBody ServiceAuthorizationCodeDTO copyServiceAuthCode) {
        Assert.hasText((String)copyServiceAuthCode.getCode(), (String)"\u590d\u5236\u6765\u6e90\u6388\u6743\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)copyServiceAuthCode.getStartDate(), (String)"");
        Assert.notNull((Object)copyServiceAuthCode.getEndDate(), (String)"\u6388\u6743\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)copyServiceAuthCode.getAccountAuthorizationAgreement(), (String)"\u6388\u6743\u540c\u610f\u534f\u8bae\u672a\u7b7e\u7f72");
        Assert.isTrue((1 == copyServiceAuthCode.getType() ? 1 : 0) != 0, (String)"\u6388\u6743\u7801\u7c7b\u578b\u4e0d\u6b63\u786e");
        if (UserUtils.getTenantSid() != copyServiceAuthCode.getTenantSid() && !this.authValidateService.checkAccessPermission(TargetType.Sys.name(), "POST", AppAuthContextHolder.getContext().getRequestInfo().getPath(), UserUtils.getSysId()).booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        ServiceAuthorizationCode serviceAuthorizationCode = this.serviceAuthorizationCodeService.copy(copyServiceAuthCode);
        return StdData.ok((Object)serviceAuthorizationCode);
    }
}

