/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.authorization.code.PageSearchParam;
import com.digiwin.dap.middleware.iam.domain.authorization.record.ServiceAuthorizationRecordDTO;
import com.digiwin.dap.middleware.iam.domain.authorization.record.ServiceAuthorizationRecordVO;
import com.digiwin.dap.middleware.iam.entity.ServiceAuthorizationRecord;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.service.service.authorization.record.ServiceAuthorizationRecordService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import com.digiwin.dap.middleware.iam.support.validate.AuthValidateService;
import com.digiwin.dap.middleware.util.UserUtils;
import com.github.pagehelper.PageSerializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2/service/authorization"})
public class ServiceAuthorizationRecordController {
    @Autowired
    private ServiceAuthorizationRecordService serviceAuthorizationRecordService;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private UserInTenantCrudService userInTenantCrudService;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private AuthValidateService authValidateService;

    @GetMapping(value={"/records"})
    public StdData getRecords(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orderBy", defaultValue="ar.create_date desc") String orderBy, @RequestParam(name="params", required=false) String params) {
        ServiceAuthorizationRecordDTO dto = ServiceAuthorizationRecordDTO.getSelf((String)params);
        if (!UserUtils.getTenantId().equalsIgnoreCase(this.envProperties.getManagerTenant()) && !this.authValidateService.checkAccessPermission(TargetType.Sys.name(), "GET", AppAuthContextHolder.getContext().getRequestInfo().getPath(), UserUtils.getSysId()).booleanValue()) {
            dto.setTenantSid(Long.valueOf(UserUtils.getTenantSid()));
        }
        List records = this.serviceAuthorizationRecordService.getRecords(dto, pageNum, pageSize, orderBy);
        return StdData.ok((Object)new PageSerializable(records));
    }

    @PostMapping(value={"/record/list"})
    public StdData getRecordListByCode(@RequestBody PageSearchParam<ServiceAuthorizationRecordDTO> searchContent, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        if (0L == user.getTenantSid()) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_ID_NOT_NULL);
        }
        if (null == searchContent || null == searchContent.getParams() || StringUtils.isEmpty((Object)((ServiceAuthorizationRecordDTO)searchContent.getParams()).getCode())) {
            throw new BusinessException((ErrorHandler)I18nError.AUTHORIZATION_CODE_CANNOT_EMPTY);
        }
        ((ServiceAuthorizationRecordDTO)searchContent.getParams()).setTenantSid(Long.valueOf(user.getTenantSid()));
        if (StringUtils.isEmpty((Object)searchContent.getOrderBy())) {
            searchContent.setOrderBy("ar.create_date desc");
        }
        List records = this.serviceAuthorizationRecordService.getRecords((ServiceAuthorizationRecordDTO)searchContent.getParams(), searchContent.getPageNum(), searchContent.getPageSize(), searchContent.getOrderBy());
        return StdData.ok((Object)new PageSerializable(records));
    }

    @PostMapping(value={"/record/all"})
    public StdData getRecordList(@RequestBody PageSearchParam<ServiceAuthorizationRecordDTO> searchContent, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        if (null == searchContent) {
            searchContent = new PageSearchParam();
            searchContent.setParams((Object)new ServiceAuthorizationRecordDTO());
        }
        if (null == searchContent.getParams()) {
            searchContent.setParams((Object)new ServiceAuthorizationRecordDTO());
        }
        if (StringUtils.isEmpty((Object)searchContent.getOrderBy())) {
            searchContent.setOrderBy("ar.create_date desc");
        }
        List records = this.serviceAuthorizationRecordService.getRecords((ServiceAuthorizationRecordDTO)searchContent.getParams(), searchContent.getPageNum(), searchContent.getPageSize(), searchContent.getOrderBy());
        return StdData.ok((Object)new PageSerializable(records));
    }

    @PostMapping(value={"/record/add"})
    public StdData addRecord(@RequestBody ServiceAuthorizationRecordDTO serviceAuthorizationRecordDTO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (0L == authoredUser.getTenantSid()) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_ID_NOT_NULL);
        }
        Assert.hasText((String)serviceAuthorizationRecordDTO.getCode(), (String)"\u4ee3\u7406\u6388\u6743\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)serviceAuthorizationRecordDTO.getAccountAuthorizationAgreement(), (String)"\u6388\u6743\u540c\u610f\u4e66\u672a\u7b7e\u7f72");
        Assert.notNull((Object)serviceAuthorizationRecordDTO.getEndDate(), (String)"\u4ee3\u7406\u6388\u6743\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        serviceAuthorizationRecordDTO.setTenantSid(Long.valueOf(authoredUser.getTenantSid()));
        ServiceAuthorizationRecord record = this.serviceAuthorizationRecordService.addAgent(serviceAuthorizationRecordDTO);
        return StdData.ok((Object)record.getSid());
    }

    @PostMapping(value={"/record/add/batch"})
    public StdData<Integer> batchAddRecord(@RequestBody ServiceAuthorizationRecordDTO serviceAuthorizationRecordDTO) {
        Assert.hasText((String)serviceAuthorizationRecordDTO.getCode(), (String)"\u4ee3\u7406\u6388\u6743\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)serviceAuthorizationRecordDTO.getAccountAuthorizationAgreement(), (String)"\u6388\u6743\u540c\u610f\u4e66\u672a\u7b7e\u7f72");
        Assert.notNull((Object)serviceAuthorizationRecordDTO.getEndDate(), (String)"\u4ee3\u7406\u6388\u6743\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        serviceAuthorizationRecordDTO.setTenantSid(Long.valueOf(UserUtils.getTenantSid()));
        int add = this.serviceAuthorizationRecordService.batchAddAgent(serviceAuthorizationRecordDTO);
        return StdData.ok((Object)add);
    }

    @PostMapping(value={"/record/mod"})
    public StdData modifyRecord(@RequestBody ServiceAuthorizationRecordDTO dto, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        if (0L == user.getTenantSid()) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_ID_NOT_NULL);
        }
        Assert.notNull((Object)dto.getSid(), (String)"\u4ee3\u7406\u7528\u6237\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        dto.setTenantSid(Long.valueOf(user.getTenantSid()));
        ServiceAuthorizationRecord record = this.serviceAuthorizationRecordService.modifyAgent(dto);
        return StdData.ok((Object)record.getSid());
    }

    @PostMapping(value={"/record/batch/mod"})
    public StdData batchModifyRecords(@RequestBody List<ServiceAuthorizationRecordDTO> dtoList, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        if (0L == user.getTenantSid()) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_ID_NOT_NULL);
        }
        this.serviceAuthorizationRecordService.batchModifyAgent(dtoList, Long.valueOf(user.getTenantSid()));
        return StdData.ok().build();
    }

    @PostMapping(value={"/user/records"})
    public StdData<?> getUserAgentLog(@RequestBody(required=false) PageSearchParam<ServiceAuthorizationRecordDTO> searchParam, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        User user;
        ServiceAuthorizationRecordDTO serviceAuthorizationRecordDTO;
        if (0L == authoredUser.getTenantSid()) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_ID_NOT_NULL);
        }
        String userId = authoredUser.getUserId();
        if (null == searchParam) {
            searchParam = new PageSearchParam();
            serviceAuthorizationRecordDTO = new ServiceAuthorizationRecordDTO();
            serviceAuthorizationRecordDTO.setUserId(userId);
            serviceAuthorizationRecordDTO.setTenantSid(Long.valueOf(authoredUser.getTenantSid()));
            searchParam.setParams((Object)serviceAuthorizationRecordDTO);
        } else if (null == searchParam.getParams()) {
            serviceAuthorizationRecordDTO = new ServiceAuthorizationRecordDTO();
            serviceAuthorizationRecordDTO.setUserId(userId);
            serviceAuthorizationRecordDTO.setTenantSid(Long.valueOf(authoredUser.getTenantSid()));
            searchParam.setParams((Object)serviceAuthorizationRecordDTO);
        } else if (StringUtils.isEmpty((Object)((ServiceAuthorizationRecordDTO)searchParam.getParams()).getUserId())) {
            ((ServiceAuthorizationRecordDTO)searchParam.getParams()).setUserId(userId);
        } else {
            userId = ((ServiceAuthorizationRecordDTO)searchParam.getParams()).getUserId();
        }
        if (StringUtils.isEmpty((Object)searchParam.getOrderBy())) {
            searchParam.setOrderBy("ar.create_date desc");
        }
        if (null == (user = (User)this.userCrudService.findById(userId))) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST, new Object[]{user.getId()});
        }
        if (!this.userInTenantCrudService.existsByUnionKey(authoredUser.getTenantSid(), user.getSid())) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_IN_TENANT, new Object[]{user.getId(), authoredUser.getTenantId()});
        }
        List records = this.serviceAuthorizationRecordService.getRecords((ServiceAuthorizationRecordDTO)searchParam.getParams(), searchParam.getPageNum(), searchParam.getPageSize(), searchParam.getOrderBy());
        return StdData.ok((Object)new PageSerializable(records));
    }

    @PostMapping(value={"/record/save"})
    public ResponseEntity<ServiceAuthorizationRecordVO> saveRecord(@RequestBody ServiceAuthorizationRecordDTO dto, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (StringUtils.isEmpty((Object)dto.getCode())) {
            throw new BusinessException((ErrorHandler)I18nError.SERVICE_AUTH_CODE_EMPTY);
        }
        if (authoredUser.getSid() == 0L) {
            throw new BusinessException((ErrorHandler)I18nError.USER_TENANT_SID_EMPTY);
        }
        dto.setUserSid(Long.valueOf(authoredUser.getSid()));
        dto.setUserId(authoredUser.getUserId());
        dto.setUserName(authoredUser.getUserName());
        return ResponseEntity.ok((Object)this.serviceAuthorizationRecordService.saveIam(dto));
    }
}

