/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import com.digiwin.dap.middle.encrypt.domain.annotation.DapEncrypt;
import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.servicer.ApplyStatusEnum;
import com.digiwin.dap.middleware.iam.domain.servicer.ServicerTenantVO;
import com.digiwin.dap.middleware.iam.domain.servicer.ServicerVO;
import com.digiwin.dap.middleware.iam.entity.DevCertificationDO;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.mapper.ServicerMapper;
import com.digiwin.dap.middleware.iam.service.servicer.ServicerService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantQueryService;
import com.digiwin.dap.middleware.iam.support.validate.AuthValidateService;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.HashMap;
import java.util.List;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Validated
@RequestMapping(value={"/api/iam/v2/servicer"})
public class ServicerController {
    @Autowired
    private ServicerMapper servicerMapper;
    @Autowired
    private ServicerService servicerService;
    @Autowired
    private TenantQueryService tenantQueryService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private AuthValidateService authValidateService;

    @PostMapping(value={""})
    @Transactional(rollbackOn={Exception.class})
    public StdData createServicer(@RequestBody ServicerVO servicerVO) {
        this.servicerService.createServicer(servicerVO);
        return StdData.ok().build();
    }

    @PostMapping(value={"status"})
    public StdData confirmServicer(@RequestBody ServicerVO servicerVO) {
        Integer operationType = servicerVO.getOperationType();
        if (operationType == null) {
            throw new BusinessException((ErrorHandler)I18nError.PARAM_ERROR);
        }
        if (ApplyStatusEnum.QUALIFIED.getCode() == operationType.intValue()) {
            this.servicerService.confirmServicer(servicerVO);
        } else if (ApplyStatusEnum.DISQUALIFIED.getCode() == operationType.intValue()) {
            this.servicerService.disqualifyServicer(servicerVO);
        } else if (ApplyStatusEnum.DENIED.getCode() == operationType.intValue()) {
            this.servicerService.denyServicer(servicerVO);
        }
        return StdData.ok().build();
    }

    @DeleteMapping(value={""})
    public StdData deleteServicer(@RequestParam Long tenantSid) {
        this.servicerService.deleteServicer(tenantSid);
        return StdData.ok().build();
    }

    @DapEncrypt(force=false, response=true)
    @GetMapping(value={"/{tenantSid}"})
    public StdData getServicerInfo(@PathVariable long tenantSid) {
        if (tenantSid != UserUtils.getTenantSid() && !this.authValidateService.checkAccessPermission(TargetType.Sys.name(), "GET", "/api/iam/v2/servicer/{tenantSid}", UserUtils.getSysId()).booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        ServicerVO servicerVO = this.servicerMapper.getServicerInfo(tenantSid);
        return StdData.ok((Object)servicerVO);
    }

    @DapEncrypt(force=false, response=true)
    @PostMapping(value={"/id"})
    public StdData getServicerById(@RequestBody ServicerTenantVO body) {
        Assert.hasLength((String)body.getId(), (String)"\u670d\u52a1\u5546id\u4e0d\u80fd\u4e3a\u7a7a");
        if (!body.getId().equals(UserUtils.getTenantId()) && !this.authValidateService.checkAccessPermission(TargetType.Sys.name(), "POST", "/api/iam/v2/servicer/id", UserUtils.getSysId()).booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        return StdData.ok((Object)this.servicerMapper.getServicerByTenantId(body.getId()));
    }

    @GetMapping(value={"/certification/licensenumber/{licenseNumber}"})
    public StdData<?> existServicerCertificationLicenseNumber(@PathVariable String licenseNumber) {
        List certifications = this.tenantQueryService.getByLicenseNumber(licenseNumber, null);
        HashMap<String, Object> mapResult = new HashMap<String, Object>();
        if (certifications.isEmpty()) {
            mapResult.put("exist", Boolean.FALSE);
        } else {
            long tenantSid = ((DevCertificationDO)certifications.get(0)).getTenantSid();
            Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
            mapResult.put("exist", Boolean.TRUE);
            mapResult.put("tenantSid", tenant.getSid());
            mapResult.put("tenantId", tenant.getId());
            mapResult.put("tenantName", tenant.getName());
        }
        return StdData.ok(mapResult);
    }
}

