/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.constant.IamConstants;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.app.SysCascade;
import com.digiwin.dap.middleware.iam.domain.app.SysVO;
import com.digiwin.dap.middleware.iam.domain.enumeration.ChangeTypeEnum;
import com.digiwin.dap.middleware.iam.domain.org.RequestParameterVO;
import com.digiwin.dap.middleware.iam.domain.request.MetaUriRequest;
import com.digiwin.dap.middleware.iam.domain.sys.SysProductCodeRequestVO;
import com.digiwin.dap.middleware.iam.domain.sys.SysProductCodeResultVO;
import com.digiwin.dap.middleware.iam.domain.sys.SysWithPlatformVO;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.SysInTenant;
import com.digiwin.dap.middleware.iam.entity.SysOnPlatform;
import com.digiwin.dap.middleware.iam.mapper.SysMapper;
import com.digiwin.dap.middleware.iam.repository.SysOnPlatformRepository;
import com.digiwin.dap.middleware.iam.service.sys.SysCrudService;
import com.digiwin.dap.middleware.iam.service.sys.SysInTenantCrudService;
import com.digiwin.dap.middleware.iam.service.sys.SysInTenantQueryService;
import com.digiwin.dap.middleware.iam.service.sys.SysQueryService;
import com.digiwin.dap.middleware.iam.service.sys.SysService;
import com.digiwin.dap.middleware.iam.support.auth.domain.IamAuthoredUser;
import com.digiwin.dap.middleware.iam.support.cache.CommonCacheService;
import com.digiwin.dap.middleware.iam.support.log.ChangeLogService;
import com.digiwin.dap.middleware.iam.support.validate.AuthValidateService;
import com.digiwin.dap.middleware.util.EntityUtils;
import com.digiwin.dap.middleware.util.StringUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import com.github.pagehelper.PageSerializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.util.Strings;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2/sys"})
public class SysController {
    @Autowired
    private SysMapper sysMapper;
    @Autowired
    private SysQueryService sysQueryService;
    @Autowired
    private SysCrudService sysCrudService;
    @Autowired
    private SysInTenantCrudService sysInTenantCrudService;
    @Autowired
    private SysOnPlatformRepository sysOnPlatformRepository;
    @Autowired
    private SysService sysService;
    @Autowired
    private CommonCacheService commonCacheService;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private SysInTenantQueryService sysInTenantQueryService;
    @Autowired
    private ChangeLogService changeLogService;
    @Autowired
    private AuthValidateService authValidateService;

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/backuri"})
    public ResponseEntity<?> backUri(@RequestBody SysWithPlatformVO sys) {
        if (null == sys.getType()) {
            throw new IllegalArgumentException("\u53c2\u6570type\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Sys oldSys = StringUtils.hasText((String)sys.getId()) ? (Sys)this.sysCrudService.findById(sys.getId()) : (Sys)this.sysCrudService.findBySid(sys.getSid().longValue());
        if (oldSys == null) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_IS_NOT_IN_DATABASE, new Object[]{StringUtils.hasText((String)sys.getId()) ? sys.getId() : sys.getSid()});
        }
        Sys newSys = new Sys();
        BeanUtils.copyProperties((Object)oldSys, (Object)newSys);
        newSys.setBackUri(sys.getBackUri());
        newSys.setEnableMultiRow(sys.isEnableMultiRow());
        this.sysCrudService.update((BaseEntity)newSys);
        this.changeLogService.updateCompareChangeLog(ChangeTypeEnum.SYS_UPDATE.getName(), (Object)oldSys, (Object)newSys, Collections.singletonList(ChangeTypeEnum.SYS_UPDATE.getPrimaryKey()), Arrays.asList("backUri", "enableMultiRow"));
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/metauri"})
    public StdData<?> metaUri(@RequestBody MetaUriRequest body) {
        this.sysService.updateMetaUri(body);
        return StdData.ok().build();
    }

    @PostMapping(value={"/tree"})
    public StdData<?> getSysTree(@RequestBody RequestParameterVO body, @RequestAttribute(value="digi-middleware-auth-user-data") IamAuthoredUser authoredUser) {
        SysCascade sysCascade = this.sysQueryService.getSysCascadeById(body.getId());
        return StdData.ok((Object)sysCascade);
    }

    @Transactional(rollbackFor={Exception.class})
    @RequestMapping(value={"/platform/backuri"}, method={RequestMethod.POST})
    public ResponseEntity<?> updateSysInfo(@RequestBody SysWithPlatformVO sys) {
        Sys oldSys = (Sys)this.sysCrudService.findById(sys.getId());
        if (oldSys == null) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_IS_NOT_IN_DATABASE, new Object[]{sys.getId()});
        }
        SysWithPlatformVO oldSysWithPlatform = new SysWithPlatformVO();
        BeanUtils.copyProperties((Object)sys, (Object)oldSysWithPlatform);
        oldSysWithPlatform.setBackUri(oldSys.getBackUri());
        oldSysWithPlatform.setPlatform(Boolean.valueOf(oldSys.isPlatform()));
        oldSysWithPlatform.setProductCode(oldSys.getProductCode());
        oldSysWithPlatform.setProductName(oldSys.getProductName());
        oldSys.setBackUri(sys.getBackUri());
        oldSys.setPlatform(sys.getPlatform().booleanValue());
        oldSys.setProductCode(sys.getProductCode());
        oldSys.setProductName(sys.getProductName());
        oldSys.setLinked(sys.getLinked());
        oldSys.setShowConsolePolicy(sys.getShowConsolePolicy());
        oldSys.setShowEntry(sys.getShowEntry());
        oldSys.setActionFilterUrl(sys.getActionFilterUrl());
        oldSys.setEnableFunctionControl(sys.getEnableFunctionControl());
        this.sysCrudService.update((BaseEntity)oldSys);
        List sysOnPlatforms = this.sysOnPlatformRepository.getBySysId(sys.getId());
        oldSysWithPlatform.setPlatformVOS(sysOnPlatforms.stream().map(SysOnPlatform::getPlatformSysId).collect(Collectors.toList()));
        ArrayList createSysOnPlatforms = new ArrayList();
        if (!sysOnPlatforms.isEmpty()) {
            this.sysOnPlatformRepository.deleteAll((Iterable)sysOnPlatforms);
            this.sysOnPlatformRepository.flush();
        }
        sys.getPlatformVOS().stream().distinct().forEach(p -> {
            if (Strings.isNotBlank((String)p)) {
                SysOnPlatform sysOnPlatform = new SysOnPlatform();
                sysOnPlatform.setSysId(sys.getId());
                sysOnPlatform.setPlatformSysId(p);
                EntityUtils.setCreateFields((BaseEntity)sysOnPlatform);
                createSysOnPlatforms.add(sysOnPlatform);
            }
        });
        if (!createSysOnPlatforms.isEmpty()) {
            this.sysOnPlatformRepository.saveAll(createSysOnPlatforms);
        }
        this.changeLogService.updateCompareChangeLog(ChangeTypeEnum.SYS_UPDATE.getName(), (Object)oldSysWithPlatform, (Object)sys, Arrays.asList(ChangeTypeEnum.SYS_UPDATE.getPrimaryKey()), Arrays.asList("backUri", "platform", "productCode", "productName", "platformVOS"));
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public StdData getSysList(@RequestParam(value="pageNum", defaultValue="1") int pageNum, @RequestParam(value="pageSize", defaultValue="10") int pageSize) {
        return StdData.ok((Object)new PageSerializable(this.sysMapper.getSysListWithPage(Integer.valueOf(pageNum), Integer.valueOf(pageSize))));
    }

    @GetMapping(value={"/{sysId}"})
    public StdData<?> getSysById(@PathVariable(value="sysId") String sysId) {
        Sys sys = (Sys)this.sysCrudService.findById(sysId);
        sys.setBackUri(sys.getMetaUri());
        return StdData.ok((Object)sys);
    }

    @GetMapping(value={"/{tenantId}/{sysId}"})
    public StdData<?> getSysById(@PathVariable(value="tenantId") String tenantId, @PathVariable(value="sysId") String sysId) {
        if (!tenantId.equalsIgnoreCase(UserUtils.getTenantId()) && !this.authValidateService.checkAccessPermission(TargetType.Sys.name(), "GET", "/api/iam/v2/sys/{tenantId}/{sysId}", UserUtils.getSysId()).booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        return StdData.ok((Object)this.sysQueryService.findByTenantIdAndId(tenantId, sysId));
    }

    @PostMapping(value={"/tenant/del"})
    public StdData<?> delSysInTenant(@RequestBody Map<String, String> body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        long sysSid = this.sysCrudService.getSidById(body.get("sysId"));
        this.sysInTenantCrudService.deleteByUnionKey(user.getTenantSid(), sysSid);
        return StdData.ok().build();
    }

    @PostMapping(value={"/product/id"})
    public StdData<List<SysProductCodeResultVO>> getSysProductCode(@RequestBody SysProductCodeRequestVO body) {
        List result = this.sysService.getSysProductCode(body);
        return StdData.ok((Object)result);
    }

    @PostMapping(value={"/platform/all"})
    public StdData<List<SysWithPlatformVO>> getSysProductCode(@RequestBody SysWithPlatformVO body) {
        return StdData.ok((Object)this.sysService.getPlatformSys(body));
    }

    @PostMapping(value={"/platform/ids"})
    public StdData<?> getSysIds(@RequestBody SysWithPlatformVO body) {
        List sysIds = body.getPlatform() != false ? this.commonCacheService.getSysByPlatformId(body.getId()) : this.commonCacheService.getPlatformSysBySysId(body.getId());
        return StdData.ok((Object)sysIds);
    }

    @PostMapping(value={"/platform/all/ids"})
    public StdData<?> batchGetSysIds(@RequestBody SysWithPlatformVO body) {
        if (!CollectionUtils.isEmpty((Collection)body.getAppIds())) {
            return StdData.ok((Object)this.commonCacheService.getPlatformSysInSysIds(body.getAppIds()));
        }
        return StdData.ok(null);
    }

    @PostMapping(value={"/token/info/update"})
    public StdData<?> updateSysTokenExpireInfo(@RequestBody SysVO sysVO) {
        Sys oldSys = (Sys)this.sysCrudService.findById(sysVO.getId());
        if (oldSys == null) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_IS_NOT_IN_DATABASE, new Object[]{sysVO.getId()});
        }
        if (Objects.isNull(sysVO.getTokenExpireHours()) || sysVO.getTokenExpireHours() < IamConstants.TOKEN_MIN_HOURS || sysVO.getTokenExpireHours() > IamConstants.TOKEN_MAX_HOURS) {
            throw new BusinessException((ErrorHandler)I18nError.PARAM_ERROR);
        }
        oldSys.setTokenExpire(sysVO.getTokenExpireHours() * 60L);
        oldSys.setAllowTenantAdjustTime(sysVO.isAllowTenantAdjustTime());
        oldSys.setCustomizeTokenExpired(sysVO.isCustomizeTokenExpired());
        this.sysCrudService.update((BaseEntity)oldSys);
        return StdData.ok().build();
    }

    @PostMapping(value={"tenant/token/info/update"})
    public StdData<?> updateSysInTenantTokenExpireInfo(@RequestBody SysVO sysVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        Sys sys = (Sys)this.sysCrudService.findById(sysVO.getId());
        if (sys == null) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_NOT_EXISTED, new Object[]{sysVO.getId()});
        }
        if (!sys.isCustomizeTokenExpired() || !sys.isAllowTenantAdjustTime()) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_NOT_SUPPORT, new Object[]{sysVO.getId()});
        }
        SysInTenant sysInTenant = this.sysInTenantCrudService.findByUnionKey(user.getTenantSid(), sys.getSid());
        if (sysInTenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_TENANT_NOT_EXIST, new Object[]{sysVO.getId(), user.getTenantId()});
        }
        if (Objects.isNull(sysVO.getTokenExpireHours()) || sysVO.getTokenExpireHours() < IamConstants.TOKEN_MIN_HOURS || sysVO.getTokenExpireHours() > IamConstants.TOKEN_MAX_HOURS) {
            throw new BusinessException((ErrorHandler)I18nError.PARAM_ERROR);
        }
        sysInTenant.setTokenExpire(sysVO.getTokenExpireHours() * 60L);
        sysInTenant.setTokenExpireAdjusted(true);
        this.sysInTenantCrudService.update((BaseEntity)sysInTenant);
        return StdData.ok().build();
    }

    @GetMapping(value={"tenant/token/list"})
    public StdData<?> getSysInTenantTokenExpireInfo(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        if (!this.envProperties.getCustomizeTokenExpired().booleanValue()) {
            return StdData.ok(Collections.emptyList());
        }
        List sysInTenantTokenVOList = this.sysInTenantQueryService.getSysInTenantTokenInfo(Long.valueOf(user.getTenantSid()), Boolean.valueOf(false));
        return StdData.ok((Object)sysInTenantTokenVOList);
    }
}

