/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import com.digiwin.dap.middle.encrypt.domain.annotation.DapSign;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.iam.domain.sso.SysSsoUrlConfigDTO;
import com.digiwin.dap.middleware.iam.entity.SysSsoUrlConfig;
import com.digiwin.dap.middleware.iam.service.sso.SysSsoUrlConfigCrudService;
import com.digiwin.dap.middleware.iam.service.sso.SysSsoUrlConfigQueryService;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2/sys/sso/url/cfg"})
public class SysSsoUrlConfigController {
    @Autowired
    private SysSsoUrlConfigCrudService sysSsoUrlConfigCrudService;
    @Autowired
    private SysSsoUrlConfigQueryService sysSsoUrlConfigQueryService;

    @PostMapping(value={"/search"})
    public StdData<?> search(@RequestBody SysSsoUrlConfigDTO sysSsoUrlConfigDTO) {
        List sysSsoUrlConfigList = this.sysSsoUrlConfigQueryService.findAllBySysContentAndSsoType(sysSsoUrlConfigDTO.getSysContent(), sysSsoUrlConfigDTO.getSsoType());
        return StdData.ok((Object)sysSsoUrlConfigList);
    }

    @DapSign(response=true)
    @PostMapping(value={"/add"})
    public StdData<?> add(@RequestBody @Valid SysSsoUrlConfigDTO sysSsoUrlConfigDTO, @RequestAttribute(value="digi-middleware-auth-app-data") AuthoredSys sys) {
        SysSsoUrlConfig oldSysSsoUrlConfig = this.sysSsoUrlConfigCrudService.findBySysIdAndSsoType(sys.getId(), sysSsoUrlConfigDTO.getSsoType());
        if (Objects.isNull(oldSysSsoUrlConfig)) {
            SysSsoUrlConfig sysSsoUrlConfig = new SysSsoUrlConfig();
            sysSsoUrlConfig.setSysId(sys.getId());
            sysSsoUrlConfig.setSysName(sysSsoUrlConfigDTO.getSysName());
            sysSsoUrlConfig.setSuccessCallbackUrl(sysSsoUrlConfigDTO.getSuccessCallbackUrl());
            sysSsoUrlConfig.setFailCallbackUrl(sysSsoUrlConfigDTO.getFailCallbackUrl());
            sysSsoUrlConfig.setLogoutCallbackUrl(sysSsoUrlConfigDTO.getLogoutCallbackUrl());
            sysSsoUrlConfig.setSsoType(sysSsoUrlConfigDTO.getSsoType());
            this.sysSsoUrlConfigCrudService.create((BaseEntity)sysSsoUrlConfig);
        } else {
            SysSsoUrlConfigDTO oldSysSsoUrlConfigDTO = new SysSsoUrlConfigDTO(oldSysSsoUrlConfig);
            if (oldSysSsoUrlConfigDTO.equals((Object)sysSsoUrlConfigDTO)) {
                return StdData.ok().build();
            }
            oldSysSsoUrlConfig.setSysName(sysSsoUrlConfigDTO.getSysName());
            oldSysSsoUrlConfig.setSuccessCallbackUrl(sysSsoUrlConfigDTO.getSuccessCallbackUrl());
            oldSysSsoUrlConfig.setFailCallbackUrl(sysSsoUrlConfigDTO.getFailCallbackUrl());
            oldSysSsoUrlConfig.setLogoutCallbackUrl(sysSsoUrlConfigDTO.getLogoutCallbackUrl());
            oldSysSsoUrlConfig.setSsoType(sysSsoUrlConfigDTO.getSsoType());
            this.sysSsoUrlConfigCrudService.update((BaseEntity)oldSysSsoUrlConfig);
        }
        return StdData.ok().build();
    }
}

