/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.team.TeamDTO;
import com.digiwin.dap.middleware.iam.entity.Team;
import com.digiwin.dap.middleware.iam.repository.TeamRepository;
import com.digiwin.dap.middleware.iam.support.obsolete.service.team.TeamService;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Deprecated
@RestController
@RequestMapping(value={"/api/iam/v2"})
public class TeamController {
    @Autowired
    private TeamService teamService;
    @Autowired
    private TeamRepository teamRepository;

    @PostMapping(value={"/team"})
    public StdData save(@Validated @RequestBody TeamDTO dto) {
        Assert.hasText((String)dto.getId(), (String)"\u56e2\u961fid\u4e0d\u80fd\u4e3a\u7a7a");
        Team team = this.teamRepository.findById(dto.getId());
        if (team != null) {
            throw new BusinessException((ErrorHandler)I18nError.TEAM_ID_HAS_EXIST, new Object[]{dto.getId()});
        }
        return StdData.ok((Object)this.teamService.create(dto));
    }

    @PutMapping(value={"/team"})
    public StdData update(@Validated @RequestBody TeamDTO dto) {
        Assert.notNull((Object)dto.getSid(), (String)"\u56e2\u961fsid\u4e0d\u80fd\u4e3a\u7a7a");
        return StdData.ok((Object)this.teamService.update(dto));
    }

    @GetMapping(value={"/team/id/{id}/exist"})
    public StdData delete(@PathVariable String id) {
        return StdData.ok((Object)Optional.ofNullable(this.teamRepository.findById(id)).isPresent());
    }

    @DeleteMapping(value={"/team/{sid}"})
    public StdData delete(@PathVariable Long sid) {
        this.teamRepository.deleteById((Object)sid);
        return StdData.ok((Object)Boolean.TRUE);
    }

    @GetMapping(value={"/teams"})
    public StdData getTeams(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orderBy", defaultValue="id") String orderBy, @RequestParam(name="params", required=false) String params) {
        return StdData.ok((Object)this.teamService.getTeams(TeamDTO.getSelf((String)params), pageNum, pageSize, orderBy));
    }
}

