/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import cn.hutool.core.util.StrUtil;
import com.digiwin.dap.middle.cache.lock.CacheLock;
import com.digiwin.dap.middle.encrypt.domain.annotation.DapEncrypt;
import com.digiwin.dap.middle.encrypt.domain.annotation.DapSign;
import com.digiwin.dap.middle.kms.constants.KeyConstant;
import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middleware.dict.domain.DictDataDTO;
import com.digiwin.dap.middleware.dict.service.DictDataService;
import com.digiwin.dap.middleware.domain.ComeFromEnum;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.entity.BaseEntityWithId;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.api.TenantController;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.constant.IamConstants;
import com.digiwin.dap.middleware.iam.constant.enums.BooleanStrEnum;
import com.digiwin.dap.middleware.iam.constant.enums.TenantConfirmEnum;
import com.digiwin.dap.middleware.iam.constant.enums.TenantDataExportRecordStateEnum;
import com.digiwin.dap.middleware.iam.constant.enums.TenantEnterpriseTypeEnum;
import com.digiwin.dap.middleware.iam.domain.CommonVO;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.MessageTargetVO;
import com.digiwin.dap.middleware.iam.domain.app.SysQueryResultVO;
import com.digiwin.dap.middleware.iam.domain.app.SysVO;
import com.digiwin.dap.middleware.iam.domain.authentication.AuthenticationInfoVO;
import com.digiwin.dap.middleware.iam.domain.authorization.DeletePurchaseGoods;
import com.digiwin.dap.middleware.iam.domain.datapolicy.ItemPage;
import com.digiwin.dap.middleware.iam.domain.enumeration.GoodsCategoryEnum;
import com.digiwin.dap.middleware.iam.domain.invoiceinfo.InvoiceInfoVO;
import com.digiwin.dap.middleware.iam.domain.org.RequestParameterVO;
import com.digiwin.dap.middleware.iam.domain.permission.ItemConditionRequest;
import com.digiwin.dap.middleware.iam.domain.request.QueryTenantThirdSyncInfoRequest;
import com.digiwin.dap.middleware.iam.domain.tenant.AppTenantAuthVO;
import com.digiwin.dap.middleware.iam.domain.tenant.CopyAppAuthVO;
import com.digiwin.dap.middleware.iam.domain.tenant.DevRegisterTenantVO;
import com.digiwin.dap.middleware.iam.domain.tenant.DevTenantCertificationVO;
import com.digiwin.dap.middleware.iam.domain.tenant.DevTenantInfoVO;
import com.digiwin.dap.middleware.iam.domain.tenant.GroundNoAuthUserVO;
import com.digiwin.dap.middleware.iam.domain.tenant.InvitedUserVO;
import com.digiwin.dap.middleware.iam.domain.tenant.MetadataOfTenant;
import com.digiwin.dap.middleware.iam.domain.tenant.QueryTenantByAppRequest;
import com.digiwin.dap.middleware.iam.domain.tenant.QueryTenantCountRequest;
import com.digiwin.dap.middleware.iam.domain.tenant.QueryTenantVO;
import com.digiwin.dap.middleware.iam.domain.tenant.QueryUserStatusVO;
import com.digiwin.dap.middleware.iam.domain.tenant.RegisterTenantVO;
import com.digiwin.dap.middleware.iam.domain.tenant.ServicerRegisterTenantDTO;
import com.digiwin.dap.middleware.iam.domain.tenant.ServicerTenantVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantAppDTO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantAuditVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantAuthQueryVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantBasicInfoWithStatusVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantBatchAuthVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantCompanyVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantContactInfoVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantDTO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantDoubleCheckVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantExpandInfoVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantExportDataVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantIdRequest;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantInfoVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantQueryCondition;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantQueryParamVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantSearchVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantSimpleVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantSysCascadeVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantTransferOwnerUserVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantVO;
import com.digiwin.dap.middleware.iam.domain.tenant.UpdateTenantInfoVO;
import com.digiwin.dap.middleware.iam.domain.tenant.UserStatusResultVO;
import com.digiwin.dap.middleware.iam.domain.tenant.metadata.TenantMetadataCasVO;
import com.digiwin.dap.middleware.iam.domain.tenant.metadata.TenantMetadataLdapDTO;
import com.digiwin.dap.middleware.iam.domain.tenant.metadata.TenantMetadataLdapVO;
import com.digiwin.dap.middleware.iam.domain.tenant.metadata.TenantMetadataSAMLVO;
import com.digiwin.dap.middleware.iam.domain.user.QueryPageVO;
import com.digiwin.dap.middleware.iam.domain.user.TenantRelationWithUserWithStatusVO;
import com.digiwin.dap.middleware.iam.domain.user.UserConditionVO;
import com.digiwin.dap.middleware.iam.domain.user.UserInfo;
import com.digiwin.dap.middleware.iam.domain.user.UserSimpleVO;
import com.digiwin.dap.middleware.iam.domain.user.UserTenantSimpleVO;
import com.digiwin.dap.middleware.iam.domain.user.UserWithRolesVO;
import com.digiwin.dap.middleware.iam.entity.DevCertificationDO;
import com.digiwin.dap.middleware.iam.entity.InvoiceInfo;
import com.digiwin.dap.middleware.iam.entity.SyncTenantAuthScope;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.TenantDataExportRecord;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserInTenant;
import com.digiwin.dap.middleware.iam.mapper.InvoiceInfoMapper;
import com.digiwin.dap.middleware.iam.mapper.SysMapper;
import com.digiwin.dap.middleware.iam.mapper.TenantMapper;
import com.digiwin.dap.middleware.iam.mapper.UserInOrgMapper;
import com.digiwin.dap.middleware.iam.mapper.UserInRoleMapper;
import com.digiwin.dap.middleware.iam.mapper.UserInTenantMapper;
import com.digiwin.dap.middleware.iam.mapper.UserMapper;
import com.digiwin.dap.middleware.iam.repository.CertificationRepository;
import com.digiwin.dap.middleware.iam.repository.SyncTenantAuthScopeRepository;
import com.digiwin.dap.middleware.iam.repository.SysRepository;
import com.digiwin.dap.middleware.iam.repository.TenantDataExportRecordRepository;
import com.digiwin.dap.middleware.iam.repository.TenantRepository;
import com.digiwin.dap.middleware.iam.repository.UserRepository;
import com.digiwin.dap.middleware.iam.service.authentication.TenantAuthenticationService;
import com.digiwin.dap.middleware.iam.service.metadata.MetadataQueryService;
import com.digiwin.dap.middleware.iam.service.org.OrgQueryService;
import com.digiwin.dap.middleware.iam.service.sys.SysCrudService;
import com.digiwin.dap.middleware.iam.service.sys.SysInTenantCrudService;
import com.digiwin.dap.middleware.iam.service.sys.SysInTenantQueryService;
import com.digiwin.dap.middleware.iam.service.tenant.IsvRelationDevCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.PurchaseApplicationService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantAuditService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantBatchService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCancelService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantDataExportRecordService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantQueryService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantRegisterService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantRelationWithUserService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantService;
import com.digiwin.dap.middleware.iam.service.tenant.UpdateTenantService;
import com.digiwin.dap.middleware.iam.service.tenantmetadata.TenantMetadataCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantQueryService;
import com.digiwin.dap.middleware.iam.service.user.UserService;
import com.digiwin.dap.middleware.iam.support.DeferredExecutionService;
import com.digiwin.dap.middleware.iam.support.auth.RamService;
import com.digiwin.dap.middleware.iam.support.auth.domain.IamAuthoredUser;
import com.digiwin.dap.middleware.iam.support.convertor.TenantApplicationSimpleVoConvertor;
import com.digiwin.dap.middleware.iam.support.initialize.TenantInitializeService;
import com.digiwin.dap.middleware.iam.support.log.ChangeLogService;
import com.digiwin.dap.middleware.iam.support.remote.CacService;
import com.digiwin.dap.middleware.iam.support.remote.LdapService;
import com.digiwin.dap.middleware.iam.support.remote.MessageService;
import com.digiwin.dap.middleware.iam.support.remote.MiswsService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEocService;
import com.digiwin.dap.middleware.iam.support.remote.domain.AuthorizationVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.GoodsAuthDO;
import com.digiwin.dap.middleware.iam.support.remote.domain.TenantAppConditionVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.TenantApplication;
import com.digiwin.dap.middleware.iam.support.remote.domain.TenantApplicationDTO;
import com.digiwin.dap.middleware.iam.support.remote.domain.cbm.TenantAppIamVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.message.MailTypeEnum;
import com.digiwin.dap.middleware.iam.support.validate.AuthValidateService;
import com.digiwin.dap.middleware.iam.support.validate.OtherValidateService;
import com.digiwin.dap.middleware.util.AssertUtils;
import com.digiwin.dap.middleware.util.EntityUtils;
import com.digiwin.dap.middleware.util.I18nUtils;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import com.github.pagehelper.PageSerializable;
import java.lang.constant.Constable;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.Transactional;
import javax.validation.Valid;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2/tenant"})
public class TenantController {
    private static final Logger logger = LoggerFactory.getLogger(TenantController.class);
    public static final int BATCH_TIMEOUT = 60;
    @Autowired
    private TenantQueryService tenantQueryService;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private TenantRepository tenantRepository;
    @Autowired
    private TenantRegisterService tenantRegisterService;
    @Autowired
    private UserInTenantCrudService userInTenantCrudService;
    @Autowired
    private PurchaseApplicationService purchaseApplicationService;
    @Autowired
    private TenantRelationWithUserService tenantRelationWithUserService;
    @Autowired
    private SysCrudService sysCrudService;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private RamService ramService;
    @Autowired
    private CacService cacService;
    @Autowired
    private RemoteEocService remoteEocService;
    @Autowired
    private TenantAuthenticationService tenantAuthenticationService;
    @Autowired
    private UserInTenantQueryService userInTenantQueryService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private TenantCancelService tenantCancelService;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private TenantMetadataCrudService tenantMetadataCrudService;
    @Autowired
    private SyncTenantAuthScopeRepository syncTenantAuthScopeRepository;
    @Autowired
    private TenantAuditService tenantAuditService;
    @Autowired
    private CertificationRepository certificationRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private SysMapper sysMapper;
    @Autowired
    private IsvRelationDevCrudService isvRelationDevCrudService;
    @Autowired
    private TenantDataExportRecordRepository tenantDataExportRecordRepository;
    @Autowired
    private TenantDataExportRecordService tenantDataExportRecordService;
    @Autowired
    private SysRepository sysRepository;
    @Autowired
    private SysInTenantCrudService sysInTenantCrudService;
    @Autowired
    private ChangeLogService changeLogService;
    @Autowired
    private SysInTenantQueryService sysInTenantQueryService;
    @Autowired
    private TenantService tenantService;
    @Autowired
    private UserInRoleMapper userInRoleMapper;
    @Autowired
    private UserInOrgMapper userInOrgMapper;
    @Autowired
    private AuthValidateService authValidateService;
    @Autowired
    private InvoiceInfoMapper invoiceInfoMapper;
    @Autowired
    private MetadataQueryService metadataQueryService;
    @Autowired
    private OrgQueryService orgQueryService;
    @Autowired
    private LdapService ldapService;
    @Autowired
    private UserService userService;
    @Autowired
    private UserInRoleService userInRoleService;
    @Autowired
    private DictDataService dictDataService;
    @Autowired
    private TenantBatchService tenantBatchService;
    @Autowired
    private MiswsService miswsService;
    @Autowired
    private OtherValidateService otherValidateService;
    @Autowired
    private UserInTenantMapper userInTenantMapper;
    @Autowired
    private UpdateTenantService updateTenantService;
    @Autowired
    private TenantInitializeService tenantInitializeService;
    @Autowired
    private DeferredExecutionService deferredExecutionService;

    @PostMapping(value={""})
    public ResponseEntity<?> getTenant(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestParam(name="appId", required=false) String appId, @RequestParam(required=false) Boolean excludeDigiwinTenant) {
        ArrayList<TenantExpandInfoVO> result = new ArrayList<TenantExpandInfoVO>();
        List tenants = this.userInTenantQueryService.queryUserJoinedTenantBasicInfo(Long.valueOf(user.getSid()));
        if (com.digiwin.dap.middleware.util.StringUtils.isEmpty((Object)appId)) {
            for (TenantRelationWithUserWithStatusVO item : tenants) {
                if (!TenantConfirmEnum.APPROVED.getValue().equals(item.getConfirm())) continue;
                result.add(new TenantExpandInfoVO(item));
            }
        } else {
            Sys sys = (Sys)this.sysCrudService.findById(appId);
            Assert.notNull((Object)sys, (String)String.format("\u5e94\u7528[%s]\u4e0d\u5b58\u5728\uff01", appId));
            if (sys.isInside()) {
                for (TenantRelationWithUserWithStatusVO item : tenants) {
                    if (!TenantConfirmEnum.APPROVED.getValue().equals(item.getConfirm())) continue;
                    result.add(new TenantExpandInfoVO(item));
                }
            } else {
                AuthoredSys authoredSys = Sys.loginSys((Sys)sys);
                AuthoredUser authoredUser = new AuthoredUser();
                authoredUser.setUserId(user.getUserId());
                List tenantIds = tenants.stream().filter(a -> TenantConfirmEnum.APPROVED.getValue().equals(a.getConfirm())).map(TenantVO::getId).collect(Collectors.toList());
                Map authResult = this.ramService.processAuth(user.getUserId(), tenantIds, authoredSys);
                for (TenantRelationWithUserWithStatusVO item : tenants) {
                    if (!authResult.getOrDefault(item.getId(), Boolean.FALSE).booleanValue()) continue;
                    result.add(new TenantExpandInfoVO(item));
                }
            }
        }
        if (ObjectUtils.nullSafeEquals((Object)Boolean.TRUE, (Object)excludeDigiwinTenant)) {
            result.removeIf(t -> "99990000".equals(t.getId()));
        }
        return ResponseEntity.ok(result);
    }

    @Transactional(rollbackOn={Exception.class})
    @PostMapping(value={"/agree/apply"})
    public StdData agreeUserApply(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestBody InvitedUserVO body) {
        Assert.isTrue((user.getTenantSid() > 0L ? 1 : 0) != 0, (String)"\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u79df\u6237\u4fe1\u606f\uff01");
        Assert.isTrue((body.getSid() > 0L ? 1 : 0) != 0, (String)"\u9080\u8bf7\u8bb0\u5f55sid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(user.getTenantSid());
        List authorizationFailureApps = this.tenantRelationWithUserService.tenantAgreeApply(tenant, body);
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        if (authorizationFailureApps.size() > 0) {
            result.put("success", false);
            result.put("authorizationFailureApps", authorizationFailureApps);
        } else {
            result.put("success", true);
        }
        return StdData.ok(result);
    }

    @Transactional(rollbackOn={Exception.class})
    @PostMapping(value={"/application/purchase"})
    public ResponseEntity<?> purchaseApplication(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestBody SysVO sysVO) {
        String userId = user.getUserId();
        if (com.digiwin.dap.middleware.util.StringUtils.isEmpty((Object)userId)) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST);
        }
        String tenantId = user.getTenantId();
        if (com.digiwin.dap.middleware.util.StringUtils.isEmpty((Object)tenantId)) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_ID_NOT_NULL);
        }
        this.purchaseApplicationService.purchaseApplication(tenantId, userId, sysVO, false);
        return new ResponseEntity(HttpStatus.CREATED);
    }

    @Transactional(rollbackOn={Exception.class})
    @PostMapping(value={"/cancel"})
    public ResponseEntity<?> cancelTenant(@RequestBody TenantVO tenantVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        long sid = tenantVO.getSid();
        if (sid == 0L) {
            throw new IllegalArgumentException("sid is 0");
        }
        this.tenantCancelService.cancelTenant(sid, user.getSid());
        this.messageService.sendCancelTenantMessage(sid);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @GetMapping(value={"/canpurchase"})
    public ResponseEntity<?> getHasPermissionTenant(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        List result = this.userInTenantQueryService.queryUserHasPermissionTenant(user.getSid());
        return ResponseEntity.ok((Object)result);
    }

    @PostMapping(value={"/check/userintenant"})
    public boolean checkUserInTenant(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestBody InvitedUserVO body) {
        Assert.notNull((Object)body.getUser(), (String)"\u9080\u8bf7\u7528\u6237\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        User user = this.userCrudService.queryUserByIdOrEmailOrTelephoneAndType(body.getUser(), body.getUser(), body.getUser(), null);
        return user != null && this.userInTenantCrudService.existsByUnionKey(authoredUser.getTenantSid(), user.getSid());
    }

    @GetMapping(value={"/check/userintenant"})
    public StdData checkUserInTenantByUserId(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestParam String userId) {
        boolean existed;
        Assert.notNull((Object)userId, (String)"\u7528\u6237Id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        User user = (User)this.userCrudService.findById(userId);
        boolean bl = existed = user != null && this.userInTenantCrudService.existsByUnionKey(authoredUser.getTenantSid(), user.getSid());
        if (existed) {
            return StdData.ok((Object)user);
        }
        return StdData.ok().build();
    }

    @GetMapping(value={"/contactinfo/{tenantId:.+}"})
    public ResponseEntity<?> getSimpleTenantInfo(@PathVariable(value="tenantId") String tenantId) {
        TenantContactInfoVO tenantContactInfoVO = this.tenantQueryService.getTenantContactInfoVO(tenantId);
        return ResponseEntity.ok((Object)tenantContactInfoVO);
    }

    @PostMapping(value={"/current"})
    public ResponseEntity<?> getAllCreatedTenant(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        AuthenticationInfoVO authenticationInfoVO;
        if (user.getTenantSid() == 0L) {
            logger.error("\u7528\u6237{}\u4e0b\u7684\u79df\u6237sid\u4e0d\u80fd\u4e3a\u7a7a", (Object)user.getUserId());
            return ResponseEntity.ok(null);
        }
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(user.getTenantSid());
        if (Objects.isNull(tenant)) {
            return ResponseEntity.ok(null);
        }
        TenantVO tenantVO = new TenantVO(tenant);
        String corpId = this.tenantMetadataCrudService.getTenantMetadataValue(user.getTenantSid(), "contact", "corpId");
        tenantVO.setCorpId(corpId);
        String dingTalkCorpId = this.tenantMetadataCrudService.getTenantMetadataValue(user.getTenantSid(), "corpId", ComeFromEnum.DINGDING.getId());
        tenantVO.setDingTalkCorpId(dingTalkCorpId);
        if (!Strings.isEmpty((CharSequence)this.envProperties.getTsignUri())) {
            authenticationInfoVO = this.tenantAuthenticationService.getAuthenticationInfo(user.getTenantSid());
        } else {
            logger.error("e\u7b7e\u5b9d\u5730\u5740\u914d\u7f6e\u4e3a\u7a7a\uff01");
            authenticationInfoVO = new AuthenticationInfoVO();
        }
        RegisterTenantVO registerTenantVO = new RegisterTenantVO(tenantVO, authenticationInfoVO);
        if (tenant.getOwnerUserSid() == user.getSid()) {
            registerTenantVO.setOwner(true);
        }
        return ResponseEntity.ok((Object)registerTenantVO);
    }

    @PostMapping(value={"/getname/{tenantSid}"})
    public ResponseEntity<?> getTenantName(@PathVariable(value="tenantSid") long tenantSid) {
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
        HashMap<String, String> map = new HashMap<String, String>();
        if (tenant != null) {
            map.put("tenantName", tenant.getName());
            map.put("tenantId", tenant.getId());
        }
        return ResponseEntity.ok(map);
    }

    @PostMapping(value={"/getname/list"})
    public ResponseEntity<?> getTenantIds(@RequestBody List<Long> tenantSids) {
        if (tenantSids.isEmpty()) {
            return ResponseEntity.ok(Collections.emptyList());
        }
        List tenantList = this.tenantRepository.findAllById(tenantSids);
        return ResponseEntity.ok(tenantList.stream().map(o -> new TenantContactInfoVO(Long.valueOf(o.getSid()), o.getId(), o.getName())).collect(Collectors.toList()));
    }

    @PostMapping(value={"/getname/list/info"})
    public StdData<?> getTenantInfos(@RequestBody TenantQueryParamVO tenantInfoVO) {
        if (!CollectionUtils.isEmpty((Collection)tenantInfoVO.getTenantIds())) {
            List tenants = this.tenantMapper.getTenantByTenantIds(tenantInfoVO.getTenantIds(), tenantInfoVO.getTestTenant());
            if (Boolean.TRUE.equals(tenantInfoVO.getWithTax()) && !CollectionUtils.isEmpty((Collection)tenants)) {
                List invoiceInfos = this.invoiceInfoMapper.getInTenantSids(tenants.stream().map(TenantVO::getSid).collect(Collectors.toList()));
                tenants.forEach(t -> {
                    InvoiceInfo matchInvoice = invoiceInfos.stream().filter(i -> Long.valueOf(t.getSid()).equals(i.getTenantSid()) && !StringUtils.isEmpty((Object)i.getTaxCode())).findFirst().orElse(null);
                    if (null != matchInvoice) {
                        t.setTaxCode(matchInvoice.getTaxCode());
                    }
                });
            }
            return StdData.ok((Object)tenants);
        }
        return StdData.ok(Collections.emptyList());
    }

    @PostMapping(value={"/exists"})
    public ResponseEntity<?> checkTenantIsExist(@RequestBody RequestParameterVO body) {
        Assert.notNull((Object)body.getId(), (String)"\u79df\u6237Id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("isExistId", this.tenantCrudService.existsById(body.getId()));
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @PostMapping(value={"/id/multi-areas/exists"})
    public StdData<Boolean> checkTenantIdIsExist(@RequestBody TenantIdRequest req) {
        AssertUtils.paramHasText((String)req.getId(), (String)"id");
        Assert.notEmpty((Collection)req.getDeployAreas(), (String)"\u90e8\u7f72\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        boolean exist = this.tenantQueryService.existsMultiAreas(req.toDTO(), null);
        return StdData.ok((Object)exist);
    }

    @PostMapping(value={"/query"})
    public ResponseEntity<?> queryTenant(@RequestBody QueryTenantVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        List tenants = this.tenantMapper.queryTenantByContent(body.getContent(), true);
        List userInTenants = this.userInTenantCrudService.queryUserJoinedTenant(user.getSid());
        ArrayList<TenantBasicInfoWithStatusVO> results = new ArrayList<TenantBasicInfoWithStatusVO>();
        for (Tenant tenant : tenants) {
            if (!TenantConfirmEnum.APPROVED.getValue().equals(tenant.getConfirm())) continue;
            TenantBasicInfoWithStatusVO result = new TenantBasicInfoWithStatusVO(tenant);
            for (UserInTenant userInTenant : userInTenants) {
                if (tenant.getSid() != userInTenant.getTenantSid()) continue;
                result.setStatus(IamConstants.AcceptedStatus.Joined.toString());
            }
            results.add(result);
        }
        return ResponseEntity.ok(results);
    }

    @Transactional(rollbackOn={Exception.class})
    @PostMapping(value={"/register/individual"})
    public ResponseEntity<?> registerIndividualTenant(@RequestBody TenantVO tenantVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Assert.notNull((Object)tenantVO.getName(), (String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)tenantVO.getEmail(), (String)"email\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)tenantVO.getAddress(), (String)"\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        if (!User.isADAccount((String)authoredUser.getUserId())) {
            Assert.notNull((Object)tenantVO.getTelephone(), (String)"\u8054\u7cfb\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        long tenantSid = this.tenantRegisterService.registerIndividualTenant(authoredUser.getSid(), authoredUser.getUserId(), tenantVO);
        return ResponseEntity.ok((Object)tenantSid);
    }

    @Transactional(rollbackOn={Exception.class})
    @PostMapping(value={"/remove/user"})
    public ResponseEntity<?> removeUser(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestBody RequestParameterVO body) {
        long userSid;
        Assert.isTrue((user.getTenantSid() > 0L ? 1 : 0) != 0, (String)"\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u79df\u6237\u4fe1\u606f\uff01");
        if (Strings.isNotBlank((String)body.getId())) {
            body.setSid(this.userCrudService.getSidById(body.getId()));
        }
        Assert.isTrue(((userSid = body.getSid()) > 0L ? 1 : 0) != 0, (String)"\u7528\u6237sid\u6216\u8005Id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.tenantService.delUserFromTenant(user, userSid);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @PostMapping(value={"/remove/user/batch"})
    public StdData<?> batchRemoveUser(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestBody RequestParameterVO body) {
        List userToDel = body.getUserSids();
        if (!CollectionUtils.isEmpty((Collection)userToDel)) {
            this.tenantBatchService.batchDelUserFromTenant(user, userToDel);
        }
        return StdData.ok().build();
    }

    @Transactional(rollbackOn={Exception.class})
    @PostMapping(value={"/user/ids/disable"})
    public StdData updateUserStatus(@RequestBody List<UserTenantSimpleVO> disableStatusInfoVOs) {
        if (disableStatusInfoVOs == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_USER_RELATION_NOT_NULL);
        }
        List userIds = disableStatusInfoVOs.stream().map(UserTenantSimpleVO::getUserId).collect(Collectors.toList());
        if (userIds.size() > 0) {
            List users = this.userMapper.findByIds(Long.valueOf(0L), userIds, new ArrayList());
            disableStatusInfoVOs.forEach(disableStatusInfoVO -> users.forEach(user -> {
                if (user.getId().equals(disableStatusInfoVO.getUserId())) {
                    this.userInTenantCrudService.disable(disableStatusInfoVO.getTenantSid().longValue(), user.getSid());
                }
            }));
        }
        return StdData.ok().build();
    }

    @PostMapping(value={"/simple", "/isv/simple"})
    public ResponseEntity<?> getTenantSimple(@RequestBody RequestParameterVO body) {
        if (!ObjectUtils.nullSafeEquals((Object)UserUtils.getTenantId(), (Object)body.getId()) && !this.authValidateService.checkAccessPermission(TargetType.Sys.toString(), "POST", "/api/iam/v2/tenant/simple", UserUtils.getSysId()).booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        TenantInfoVO tenant = this.tenantQueryService.getTenantSimpleInfo(body.getId());
        return ResponseEntity.ok((Object)tenant);
    }

    @PostMapping(value={"/simples"})
    public ResponseEntity<?> getTenantSimple(@RequestBody List<String> tenantIds) {
        if (tenantIds.isEmpty()) {
            return ResponseEntity.ok(Collections.emptyMap());
        }
        List tenants = this.tenantMapper.findTenants(tenantIds);
        this.populateMetadata(tenantIds, tenants);
        return ResponseEntity.ok((Object)tenants);
    }

    private void populateMetadata(List<String> tenantIds, List<CommonVO> tenants) {
        List allTenants = this.tenantMetadataCrudService.batchGetAllTenantMetadataValueWithTenantId(tenantIds);
        Map<String, List<MetadataOfTenant>> byTenant = allTenants.stream().collect(Collectors.groupingBy(MetadataOfTenant::getTenantId));
        for (Map.Entry<String, List<MetadataOfTenant>> entry : byTenant.entrySet()) {
            Optional<CommonVO> optionalTenant = tenants.stream().filter(tenant -> tenant.getId().equals(entry.getKey())).findFirst();
            optionalTenant.ifPresent(a -> {
                for (MetadataOfTenant meta : (List)entry.getValue()) {
                    String catalogId = meta.getCatalogId();
                    String key = meta.getKey();
                    if ("basic".equals(catalogId) && "defaultLanguage".equals(key)) {
                        a.setDefaultLanguage(meta.getValue());
                    }
                    if ("resourceCost".equals(catalogId) && "deptId".equals(key)) {
                        a.setCostDeptId(meta.getValue());
                    }
                    if ("resourceCost".equals(catalogId) && "deptName".equals(key)) {
                        a.setCostDeptName(meta.getValue());
                    }
                    if ("resourceCost".equals(catalogId) && "empId".equals(key)) {
                        a.setCostEmpId(meta.getValue());
                    }
                    if (!"resourceCost".equals(catalogId) || !"empName".equals(key)) continue;
                    a.setCostEmpName(meta.getValue());
                }
            });
        }
    }

    @GetMapping(value={"/current/simple"})
    public StdData<TenantInfoVO> getTenantSimple(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        TenantInfoVO tenant = this.tenantQueryService.getTenantSimpleInfo(Long.valueOf(authoredUser.getTenantSid()));
        return StdData.ok((Object)tenant);
    }

    @PostMapping(value={"/user/apply/query"})
    public ResponseEntity<?> queryNoConfirmApplied(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        List userList = this.tenantRelationWithUserService.tenantGetUnConfirmApplyList(user.getTenantSid());
        return ResponseEntity.ok((Object)userList);
    }

    @Transactional(rollbackOn={Exception.class})
    @PostMapping(value={"/user/invite/new"})
    public StdData<?> invitedRegisterUser(@RequestBody InvitedUserVO body) {
        HashMap resultMap = new HashMap();
        if (com.digiwin.dap.middleware.util.StringUtils.isEmpty((Object)body.getTenantId())) {
            throw new BusinessException("\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u79df\u6237\u4fe1\u606f\uff01");
        }
        if (com.digiwin.dap.middleware.util.StringUtils.isEmpty((Object)body.getUserEmail()) && com.digiwin.dap.middleware.util.StringUtils.isEmpty((Object)body.getUser())) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_INVITED_USER_EMPTY);
        }
        if (!com.digiwin.dap.middleware.util.StringUtils.isEmpty((Object)body.getUserEmail())) {
            body.setUser(body.getUserEmail());
        }
        if (!UserUtils.getTenantId().equalsIgnoreCase(body.getTenantId()) && !this.authValidateService.checkAccessPermission(TargetType.Sys.toString(), "POST", AppAuthContextHolder.getContext().getRequestInfo().getPath(), UserUtils.getSysId()).booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        Tenant tenant = (Tenant)this.tenantCrudService.findById(body.getTenantId());
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_INVITED_USER_TENANT_EXISTED, new Object[]{body.getTenantId()});
        }
        if (com.digiwin.dap.middleware.util.StringUtils.isEmpty((Object)body.getInviteApp())) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_NOT_EXISTED);
        }
        Sys sys = (Sys)this.sysRepository.findById(body.getInviteApp());
        if (null == sys) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_NOT_EXISTED);
        }
        this.tenantRelationWithUserService.invitedUserJoinNew(body, tenant, sys, resultMap);
        return StdData.ok(resultMap);
    }

    @Transactional(rollbackOn={Exception.class})
    @PostMapping(value={"/user/invite"})
    public ResponseEntity<?> invitedUserJoinTenant(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestBody InvitedUserVO body) {
        if (user.getTenantSid() == 0L) {
            throw new BusinessException("\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u79df\u6237\u4fe1\u606f\uff01");
        }
        if (com.digiwin.dap.middleware.util.StringUtils.isEmpty((Object)body.getUser())) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_INVITED_USER_EMPTY);
        }
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(user.getTenantSid());
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_INVITED_USER_TENANT_EXISTED, new Object[]{user.getSid()});
        }
        Long sid = this.tenantRelationWithUserService.invitedUserJoin(tenant.getSid(), body, Boolean.valueOf(false));
        return ResponseEntity.ok((Object)sid);
    }

    @PostMapping(value={"/user/invite/query"})
    public ResponseEntity<?> queryInvited(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        if (user.getTenantSid() == 0L) {
            throw new BusinessException("\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u79df\u6237\u4fe1\u606f\uff01");
        }
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(user.getTenantSid());
        List userList = this.tenantRelationWithUserService.tenantGetUserList("invited", user.getTenantSid());
        return ResponseEntity.ok((Object)userList);
    }

    @PostMapping(value={"/user/{userSid}/disable"})
    public ResponseEntity<?> disableUser(@PathVariable(value="userSid") long userSid, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        User user = (User)this.userCrudService.findBySid(userSid);
        if (user != null) {
            this.tenantRelationWithUserService.disableTenantUser(user, authoredUser);
        }
        return new ResponseEntity(HttpStatus.OK);
    }

    @PostMapping(value={"/user/id/{userId}/disable"})
    @Transactional
    public ResponseEntity<?> disableUser(@PathVariable(value="userId") String userId, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        User user = (User)this.userCrudService.findById(userId);
        if (user != null) {
            this.userInTenantCrudService.disable(authoredUser.getTenantSid(), user.getSid());
            if (user.getDefaultTenantSid() > 0L && user.getDefaultTenantSid() == authoredUser.getTenantSid()) {
                user.setDefaultTenantSid(0L);
                this.userCrudService.update((BaseEntity)user);
            }
            this.cacService.deleteUser(authoredUser.getTenantId(), user.getId());
        }
        return new ResponseEntity(HttpStatus.OK);
    }

    @PostMapping(value={"/user/{userSid}/enable"})
    public ResponseEntity<?> enableUser(@PathVariable(value="userSid") long userSid, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        User user = (User)this.userCrudService.findBySid(userSid);
        if (user != null) {
            this.tenantRelationWithUserService.enableTenantUser(user, authoredUser);
        }
        return new ResponseEntity(HttpStatus.OK);
    }

    @PostMapping(value={"/user/id/{userId}/enable"})
    public ResponseEntity<?> enableUser(@PathVariable(value="userId") String userId, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        User user = (User)this.userCrudService.findById(userId);
        if (user != null) {
            this.tenantRelationWithUserService.enableTenantUser(user, authoredUser);
        }
        return new ResponseEntity(HttpStatus.OK);
    }

    @PostMapping(value={"get/tenantid"})
    public StdData<?> getTenantIdByName(@RequestBody Map<String, String> map) {
        if (map.containsKey("tenantName")) {
            List tenants = this.tenantRepository.findByName(map.get("tenantName"));
            List tenantIds = tenants.stream().map(BaseEntityWithId::getId).collect(Collectors.toList());
            return StdData.ok(tenantIds);
        }
        return StdData.ok().build();
    }

    @Transactional(rollbackOn={Exception.class})
    @PostMapping(value={"/register"})
    public ResponseEntity<?> registerTenant(@RequestBody RegisterTenantVO registerTenantVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestAttribute(value="digi-middleware-auth-app-data") AuthoredSys sys) {
        boolean autoConfirm;
        Assert.notNull((Object)registerTenantVO.getTenant(), (String)"\u79df\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)registerTenantVO.getTenant().getId(), (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)registerTenantVO.getTenant().getName(), (String)"\u79df\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        this.tenantQueryService.checkExistsMuiltAreas(registerTenantVO.getTenant(), Long.valueOf(authoredUser.getSid()));
        this.tenantRegisterService.register(registerTenantVO, authoredUser.getSid());
        Tenant tenant = (Tenant)this.tenantCrudService.findById(registerTenantVO.getTenant().getId());
        boolean bl = autoConfirm = this.envProperties.isCloud() && this.miswsService.existInMisws(registerTenantVO.getTenant().getPotentialCustomerId());
        if (autoConfirm) {
            this.confirmTenant(registerTenantVO, tenant);
        }
        if (registerTenantVO.getIsvMailType() != null) {
            this.sendIsvMail(registerTenantVO.getIsvMailType(), tenant);
        } else {
            this.messageService.sendRegisterMessage(tenant, sys.getId());
        }
        HashMap<String, Constable> mapResult = new HashMap<String, Constable>();
        mapResult.put("sid", Long.valueOf(tenant.getSid()));
        mapResult.put("autoConfirm", Boolean.valueOf(autoConfirm));
        return ResponseEntity.ok((Object)StdData.ok(mapResult));
    }

    @GetMapping(value={"/next/id"})
    public ResponseEntity<?> tenantId() {
        return ResponseEntity.ok((Object)StdData.ok((Object)this.tenantRegisterService.tenantId()));
    }

    @DapSign(force=false)
    @DapEncrypt(force=false)
    @Transactional(rollbackOn={Exception.class})
    @PostMapping(value={"/register/without/conform"})
    public ResponseEntity<?> registerTenantNoConform(@RequestBody RegisterTenantVO registerTenantVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Assert.notNull((Object)registerTenantVO.getTenant(), (String)"\u79df\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)registerTenantVO.getTenant().getId(), (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)registerTenantVO.getTenant().getName(), (String)"\u79df\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        String tenantId = registerTenantVO.getTenant().getId();
        if (registerTenantVO.getTenant().getLanding().booleanValue()) {
            Tenant defaultTenant = this.tenantMapper.findDefaultTenant();
            if (defaultTenant == null) {
                throw new BusinessException((ErrorHandler)I18nError.SOURCE_TENANT_NOT_EXIST);
            }
            tenantId = String.format("%s_%s", defaultTenant.getId(), tenantId);
            registerTenantVO.getTenant().setId(tenantId);
            registerTenantVO.getTenant().setSourceTenantSid(defaultTenant.getSid());
        }
        this.tenantQueryService.checkExistsMuiltAreas(registerTenantVO.getTenant(), Long.valueOf(authoredUser.getSid()));
        this.tenantRegisterService.register(registerTenantVO, authoredUser.getSid());
        Tenant tenant = (Tenant)this.tenantCrudService.findById(registerTenantVO.getTenant().getId());
        this.confirmTenant(registerTenantVO, tenant);
        this.deferredExecutionService.runAfterCommitAsync(() -> this.tenantInitializeService.syncTenantToOtherAreas(Long.valueOf(tenant.getSid()), authoredUser.getUserId()));
        this.sendIsvMail(registerTenantVO.getIsvMailType(), tenant);
        HashMap<String, Long> mapResult = new HashMap<String, Long>();
        mapResult.put("sid", tenant.getSid());
        return ResponseEntity.ok((Object)StdData.ok(mapResult));
    }

    @Transactional
    @PostMapping(value={"/intelly/sync"})
    public StdData<?> syncIntellyTenant(@RequestBody RegisterTenantVO registerTenantVO) {
        Assert.notNull((Object)registerTenantVO.getTenant(), (String)"\u79df\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)registerTenantVO.getTenant().getId(), (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)registerTenantVO.getTenant().getName(), (String)"\u79df\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Tenant existed = (Tenant)this.tenantCrudService.findById(registerTenantVO.getTenant().getId());
        if (existed != null) {
            logger.info("\u667a\u5ba2\u79df\u6237\u540c\u6b65\uff0c\u79df\u6237\u5df2\u5b58\u5728\uff0c\u9000\u51fa\u540c\u6b65\uff0cid:{}", (Object)registerTenantVO.getTenant().getId());
            return StdData.ok(Collections.singletonMap("sid", existed.getSid()));
        }
        String ownerUserId = com.digiwin.dap.middleware.util.StringUtils.hasLength((String)registerTenantVO.getOwnerUserId()) ? registerTenantVO.getOwnerUserId() : "devAdmin";
        User user = (User)this.userCrudService.findById(ownerUserId);
        if (user == null && !"devAdmin".equals(ownerUserId)) {
            ownerUserId = "devAdmin";
            user = (User)this.userCrudService.findById(ownerUserId);
        }
        if (user == null) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST, new Object[]{ownerUserId});
        }
        AppAuthContextHolder.getContext().setAuthoredUser((AuthoredUser)IamAuthoredUser.createAuthoredUser((User)user));
        this.tenantRegisterService.register(registerTenantVO, user.getSid());
        Tenant tenant = (Tenant)this.tenantCrudService.findById(registerTenantVO.getTenant().getId());
        this.confirmTenant(registerTenantVO, tenant);
        return StdData.ok(Collections.singletonMap("sid", tenant.getSid()));
    }

    private void sendIsvMail(MailTypeEnum isvMailType, Tenant tenant) {
        if (isvMailType == null || tenant == null) {
            return;
        }
        switch (1.$SwitchMap$com$digiwin$dap$middleware$iam$support$remote$domain$message$MailTypeEnum[isvMailType.ordinal()]) {
            case 1: {
                this.messageService.sendIsvApplyMail(tenant);
                break;
            }
            case 2: {
                this.messageService.sendIsvSuccessMail(tenant);
                break;
            }
        }
    }

    private void confirmTenant(RegisterTenantVO registerTenantVO, Tenant tenant) {
        TenantAuditVO tenantAuditVO = new TenantAuditVO();
        tenantAuditVO.setSid(tenant.getSid());
        tenantAuditVO.setTestTenant(Optional.ofNullable(registerTenantVO.getTenant().getTestTenant()).orElse(false));
        tenantAuditVO.setEoc(Optional.ofNullable(registerTenantVO.getTenant().getEoc()).orElse(false));
        tenantAuditVO.setTenantPurpose(tenant.getTenantPurpose());
        this.tenantAuditService.confirm(tenantAuditVO);
    }

    @Transactional(rollbackOn={Exception.class})
    @PostMapping(value={"/register/dev/individual"})
    public StdData registerDevIndividualTenant(@RequestBody DevRegisterTenantVO registerTenantVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestAttribute(value="digi-middleware-auth-app-data") AuthoredSys sys) {
        Assert.hasText((String)registerTenantVO.getName(), (String)"\u5f00\u53d1\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)registerTenantVO.getId(), (String)"\u5f00\u53d1\u5546id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((authoredUser.getSid() > 0L ? 1 : 0) != 0, (String)"\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7684\u7528\u6237\u6d88\u606f");
        long tenantSid = this.tenantRegisterService.registerDevIndividualTenant(authoredUser.getSid(), registerTenantVO);
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
        this.messageService.sendRegisterMessage(tenant, sys.getId());
        return StdData.ok((Object)tenantSid);
    }

    @CacheLock
    @Transactional(rollbackOn={Exception.class})
    @PostMapping(value={"/register/dev"})
    public StdData registerDevTenant(@Valid @RequestBody DevRegisterTenantVO registerTenantVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestAttribute(value="digi-middleware-auth-app-data") AuthoredSys sys) {
        Assert.hasText((String)registerTenantVO.getId(), (String)"\u5f00\u53d1\u5546id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)registerTenantVO.getName(), (String)"\u5f00\u53d1\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((authoredUser.getSid() > 0L ? 1 : 0) != 0, (String)"\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7684\u7528\u6237\u6d88\u606f");
        long tenantSid = this.tenantRegisterService.registerDevTenant(authoredUser.getSid(), registerTenantVO);
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
        this.messageService.sendRegisterMessage(tenant, sys.getId());
        return StdData.ok((Object)tenantSid);
    }

    @CacheLock
    @Transactional(rollbackOn={Exception.class})
    @PostMapping(value={"/register/servicer"})
    public StdData registerServicerTenant(@Valid @RequestBody ServicerRegisterTenantDTO dto, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Assert.hasText((String)dto.getId(), (String)"\u4f01\u4e1a\u670d\u52a1\u5546id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)dto.getName(), (String)"\u4f01\u4e1a\u670d\u52a1\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        long tenantSid = this.tenantRegisterService.registerServicerTenant(authoredUser.getSid(), dto);
        return StdData.ok((Object)tenantSid);
    }

    @Transactional(rollbackOn={Exception.class})
    @PostMapping(value={"/confirm"})
    public ResponseEntity<?> confirmTenant(@RequestBody @Valid TenantAuditVO tenantAuditVO) {
        long sid = tenantAuditVO.getSid();
        if (sid == 0L) {
            throw new IllegalArgumentException("sid is 0");
        }
        this.tenantAuditService.confirm(tenantAuditVO);
        this.messageService.sendConfirmSuccessMessage(tenantAuditVO);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @Transactional(rollbackOn={Exception.class})
    @PostMapping(value={"/refuse"})
    public ResponseEntity<?> refuseTenant(@RequestBody @Valid TenantAuditVO tenantAuditVO) {
        long sid = tenantAuditVO.getSid();
        if (sid == 0L) {
            throw new IllegalArgumentException("sid is 0");
        }
        this.tenantAuditService.disConfirm(tenantAuditVO);
        this.messageService.sendConfirmFailMessage(tenantAuditVO);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @GetMapping(value={"/dev/info"})
    public StdData getDevInfo(@RequestAttribute(value="digi-middleware-auth-user-data") IamAuthoredUser authoredUser) {
        long tenantSid = this.getTenantSid((AuthoredUser)authoredUser);
        DevTenantInfoVO devTenantInfoVO = this.tenantQueryService.findTenantInfo(tenantSid);
        return StdData.ok((Object)devTenantInfoVO);
    }

    @GetMapping(value={"/dev/current/info"})
    public StdData getCurrentDevInfo(@RequestAttribute(value="digi-middleware-auth-user-data") IamAuthoredUser authoredUser) {
        long tenantSid = authoredUser.getTenantSid();
        DevTenantInfoVO devTenantInfoVO = this.tenantQueryService.findTenantInfo(tenantSid);
        return StdData.ok((Object)devTenantInfoVO);
    }

    @GetMapping(value={"/dev/current/user"})
    public StdData getCurrentUserDevInfo(@RequestAttribute(value="digi-middleware-auth-user-data") IamAuthoredUser authoredUser, @RequestParam Long tenantSid) {
        Assert.notNull((Object)tenantSid, (String)"\u79df\u6237sid\u4e0d\u80fd\u4e3a\u7a7a");
        long userSid = authoredUser.getSid();
        this.checkUserCreateTenant(tenantSid, userSid);
        DevTenantInfoVO devTenantInfoVO = this.tenantQueryService.findTenantInfo(tenantSid.longValue());
        return StdData.ok((Object)devTenantInfoVO);
    }

    private void checkUserCreateTenant(Long tenantSid, long userSid) {
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid.longValue());
        if (tenant != null && userSid != tenant.getOwnerUserSid()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
    }

    @PostMapping(value={"/dev/current/user/mod"})
    public StdData updateDevTenantInfo(@RequestBody DevTenantInfoVO devTenantInfoVO) {
        Assert.notNull((Object)devTenantInfoVO.getSid(), (String)"\u79df\u6237sid\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        this.checkUserCreateTenant(devTenantInfoVO.getSid(), UserUtils.getUserSid());
        Long tenantSid = this.updateTenantService.updateDevTenantInfo(devTenantInfoVO);
        this.sendIsvMail(devTenantInfoVO.getIsvMailType(), (Tenant)this.tenantCrudService.findBySid(devTenantInfoVO.getSid().longValue()));
        return StdData.ok((Object)tenantSid);
    }

    private Long getTenantSid(AuthoredUser authoredUser) {
        Tenant tenant = this.tenantRepository.findDevByOwnerUserSid(authoredUser.getSid());
        long tenantSid = tenant != null ? tenant.getSid() : 0L;
        return tenantSid;
    }

    @GetMapping(value={"/servicer/info"})
    public StdData getServicerInfo(@RequestAttribute(value="digi-middleware-auth-user-data") IamAuthoredUser authoredUser) {
        Tenant tenant = this.tenantRepository.findServicerByOwnerUserSid(authoredUser.getSid());
        if (tenant == null) {
            return StdData.ok().build();
        }
        ServicerTenantVO servicerTenantInfo = this.tenantQueryService.findServicerTenantInfo(tenant.getSid());
        return StdData.ok((Object)servicerTenantInfo);
    }

    @PostMapping(value={"/dev/{tenantSid}"})
    public StdData updateDevInfo(@PathVariable(value="tenantSid") Long tenantSid, @RequestBody DevRegisterTenantVO devRegisterTenantVO) {
        if (UserUtils.getTenantSid() != tenantSid && !this.authValidateService.checkAccessPermission(TargetType.TenantSys.toString(), "POST", "/api/iam/v2/tenant/dev/{tenantSid}", String.format("%s-%s", UserUtils.getTenantId(), UserUtils.getSysId())).booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid.longValue());
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{tenantSid});
        }
        this.checkDevWarehouse(devRegisterTenantVO.getWarehouseProjectName(), devRegisterTenantVO.getWarehouseAccount(), devRegisterTenantVO.getWarehousePassword(), tenantSid.longValue());
        DevCertificationDO devCertificationDO = this.certificationRepository.findByTenantSid(tenantSid.longValue());
        if (!com.digiwin.dap.middleware.util.StringUtils.isEmpty((Object)devRegisterTenantVO.getTeamId())) {
            tenant.setTeamId(devRegisterTenantVO.getTeamId());
        }
        tenant.setPreDeploy(devRegisterTenantVO.getPreDeploy().booleanValue());
        Optional.ofNullable(devRegisterTenantVO.getResAcquireMode()).ifPresent(arg_0 -> ((Tenant)tenant).setResAcquireMode(arg_0));
        this.tenantCrudService.update((BaseEntity)tenant);
        if (devCertificationDO == null) {
            logger.warn("\u4f01\u4e1a\u5f00\u53d1\u5546{}\u5b9e\u540d\u8ba4\u8bc1\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u521b\u5efa\u8d44\u6599", (Object)tenant.getId());
            devCertificationDO = new DevCertificationDO(devRegisterTenantVO);
            devCertificationDO.setTenantSid(tenantSid.longValue());
            EntityUtils.setCreateFields((BaseEntity)devCertificationDO);
            this.certificationRepository.save((Object)devCertificationDO);
        } else {
            if (!com.digiwin.dap.middleware.util.StringUtils.isEmpty((Object)devRegisterTenantVO.getLicenseNumber())) {
                devCertificationDO.setLicenseNumber(devRegisterTenantVO.getLicenseNumber());
            }
            if (!com.digiwin.dap.middleware.util.StringUtils.isEmpty((Object)devRegisterTenantVO.getLicenseNumberGroupImageUrl())) {
                devCertificationDO.setLicenseNumberGroupImageUrl(devRegisterTenantVO.getLicenseNumberGroupImageUrl());
            }
            if (!com.digiwin.dap.middleware.util.StringUtils.isEmpty((Object)devRegisterTenantVO.getLicenseNumberImageUrl())) {
                devCertificationDO.setLicenseNumberImageUrl(devRegisterTenantVO.getLicenseNumberImageUrl());
            }
            devCertificationDO.setLicenseNumberFrontImageUrl(devRegisterTenantVO.getLicenseNumberFrontImageUrl());
            devCertificationDO.setLicenseNumberBackImageUrl(devRegisterTenantVO.getLicenseNumberBackImageUrl());
            devCertificationDO.setSelfUploadImage(devRegisterTenantVO.getSelfUploadImage());
            devCertificationDO.setWarehouseProjectName(devRegisterTenantVO.getWarehouseProjectName());
            devCertificationDO.setWarehouseAccount(devRegisterTenantVO.getWarehouseAccount());
            devCertificationDO.setWarehousePassword(devRegisterTenantVO.getWarehousePassword());
            devCertificationDO.setPreTest(devRegisterTenantVO.getPreTest());
            devCertificationDO.setPrivateResource(Optional.ofNullable(devRegisterTenantVO.getPrivateResource()).orElse(false));
            devCertificationDO.setEditSalesItem(Optional.ofNullable(devRegisterTenantVO.getEditSalesItem()).orElse(false));
            devCertificationDO.setShareResource(Optional.ofNullable(devRegisterTenantVO.getShareResource()).orElse(false));
            EntityUtils.setModifyFields((BaseEntity)devCertificationDO);
            this.certificationRepository.save((Object)devCertificationDO);
        }
        return StdData.ok().build();
    }

    @PostMapping(value={"/dev/individual/{tenantSid}"})
    public StdData updateIndividualDevInfo(@PathVariable(value="tenantSid") Long tenantSid, @RequestBody DevRegisterTenantVO devRegisterTenantVO) {
        if (UserUtils.getTenantSid() != tenantSid && !this.authValidateService.checkAccessPermission(TargetType.TenantSys.toString(), "POST", "/api/iam/v2/tenant/dev/individual/{tenantSid}", String.format("%s-%s", UserUtils.getTenantId(), UserUtils.getSysId())).booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid.longValue());
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{tenantSid});
        }
        DevCertificationDO devCertificationDO = this.certificationRepository.findByTenantSid(tenantSid.longValue());
        if (!com.digiwin.dap.middleware.util.StringUtils.isEmpty((Object)devRegisterTenantVO.getTeamId())) {
            tenant.setTeamId(devRegisterTenantVO.getTeamId());
            this.tenantCrudService.update((BaseEntity)tenant);
        }
        if (devCertificationDO == null) {
            logger.warn("\u4e2a\u4eba\u5f00\u53d1\u5546{}\u5b9e\u540d\u8ba4\u8bc1\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u521b\u5efa\u8d44\u6599", (Object)tenant.getId());
            devCertificationDO = new DevCertificationDO(devRegisterTenantVO);
            devCertificationDO.setTenantSid(tenantSid.longValue());
            EntityUtils.setCreateFields((BaseEntity)devCertificationDO);
            this.certificationRepository.save((Object)devCertificationDO);
        } else {
            if (!com.digiwin.dap.middleware.util.StringUtils.isEmpty((Object)devRegisterTenantVO.getLicenseNumber())) {
                devCertificationDO.setLicenseNumber(devRegisterTenantVO.getLicenseNumber());
            }
            if (!com.digiwin.dap.middleware.util.StringUtils.isEmpty((Object)devRegisterTenantVO.getLicenseNumberFrontImageUrl())) {
                devCertificationDO.setLicenseNumberFrontImageUrl(devRegisterTenantVO.getLicenseNumberFrontImageUrl());
            }
            if (!com.digiwin.dap.middleware.util.StringUtils.isEmpty((Object)devRegisterTenantVO.getLicenseNumberBackImageUrl())) {
                devCertificationDO.setLicenseNumberBackImageUrl(devRegisterTenantVO.getLicenseNumberBackImageUrl());
            }
            if (!com.digiwin.dap.middleware.util.StringUtils.isEmpty((Object)devRegisterTenantVO.getLicenseNumberGroupImageUrl())) {
                devCertificationDO.setLicenseNumberGroupImageUrl(devRegisterTenantVO.getLicenseNumberGroupImageUrl());
            }
            if (!com.digiwin.dap.middleware.util.StringUtils.isEmpty((Object)devRegisterTenantVO.getSelfUploadImage())) {
                devCertificationDO.setSelfUploadImage(devRegisterTenantVO.getSelfUploadImage());
            }
            devCertificationDO.setWarehousePassword(devRegisterTenantVO.getWarehousePassword());
            devCertificationDO.setWarehouseAccount(devRegisterTenantVO.getWarehouseAccount());
            devCertificationDO.setWarehouseProjectName(devRegisterTenantVO.getWarehouseProjectName());
            devCertificationDO.setPreTest(devRegisterTenantVO.getPreTest());
            EntityUtils.setModifyFields((BaseEntity)devCertificationDO);
            this.certificationRepository.save((Object)devCertificationDO);
        }
        return StdData.ok().build();
    }

    @PostMapping(value={"/test"})
    public StdData isTestTenant(@RequestBody TenantSimpleVO tenantSimpleVO) {
        Tenant tenant = (Tenant)this.tenantCrudService.findById(tenantSimpleVO.getTenantId());
        if (tenant == null) {
            return StdData.of((int)20000, (String)String.format("\u79df\u6237%s\u4e0d\u5b58\u5728", tenantSimpleVO.getTenantId()));
        }
        TenantInfoVO tenantInfoVO = new TenantInfoVO();
        tenantInfoVO.setId(tenant.getId());
        tenantInfoVO.setTest(Boolean.valueOf(tenant.isTestTenant()));
        return StdData.ok((Object)tenantInfoVO);
    }

    @PostMapping(value={"/check/transferemail"})
    public StdData checkTransferEmail(@RequestBody Map emailMap) {
        boolean userExist = this.userRepository.existsByEmail(emailMap.get("email").toString());
        if (!userExist) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21101);
        }
        List userTenantSimpleVOS = this.userMapper.getUserTenantInfoByEmail(emailMap.get("email").toString());
        long enterpriseUserCount = userTenantSimpleVOS.stream().filter(userTenantSimpleVO -> userTenantSimpleVO.getType() == 1).count();
        if (enterpriseUserCount == (long)userTenantSimpleVOS.size()) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21102);
        }
        long devTenantCount = userTenantSimpleVOS.stream().filter(userTenantSimpleVO -> userTenantSimpleVO.getType() == 0 && userTenantSimpleVO.getEnterpriseType() != null && TenantEnterpriseTypeEnum.contains((Integer)userTenantSimpleVO.getEnterpriseType()) && userTenantSimpleVO.getUserSid().equals(userTenantSimpleVO.getOwnerUserSid())).count();
        if (devTenantCount > 0L) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21103);
        }
        return StdData.ok().build();
    }

    @PostMapping(value={"/transfer/owneruser"})
    @Transactional(rollbackOn={Exception.class})
    public StdData tenantTransferOwnerUser(@RequestBody Map emailMap, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        this.checkTransferEmail(emailMap);
        List userTenantSimpleVOS = this.userMapper.getUserTenantInfoByEmail(emailMap.get("email").toString());
        this.tenantRelationWithUserService.tenantTransferOwnerUser(authoredUser, (UserTenantSimpleVO)userTenantSimpleVOS.get(0));
        TenantTransferOwnerUserVO tenantTransferOwnerUserVO = new TenantTransferOwnerUserVO();
        tenantTransferOwnerUserVO.setUserId(((UserTenantSimpleVO)userTenantSimpleVOS.get(0)).getUserId());
        tenantTransferOwnerUserVO.setUserName(((UserTenantSimpleVO)userTenantSimpleVOS.get(0)).getUserName());
        tenantTransferOwnerUserVO.setTenantName(authoredUser.getTenantName());
        tenantTransferOwnerUserVO.setEmail(emailMap.get("email").toString());
        tenantTransferOwnerUserVO.setOldUserId(authoredUser.getUserId());
        tenantTransferOwnerUserVO.setOldUserName(authoredUser.getUserName());
        this.messageService.sendTenantTransferOwnerUserEmail(tenantTransferOwnerUserVO);
        return StdData.ok((Object)tenantTransferOwnerUserVO);
    }

    @GetMapping(value={"/isv/dev/exist"})
    public StdData<?> existDevByIsvTenantSid(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        return StdData.ok((Object)(!CollectionUtils.isEmpty((Collection)this.isvRelationDevCrudService.queryDevInfoByIsvTenantSid(authoredUser.getTenantSid())) ? 1 : 0));
    }

    @GetMapping(value={"/data/export/check"})
    public StdData<?> checkTenantExportData(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        if (this.tenantDataExportRecordRepository.existsByTenantSidAndCreateByAndState(user.getTenantSid(), user.getSid(), 0)) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_EXPORT_DATA_GENERATE);
        }
        if (this.tenantDataExportRecordRepository.existsByTenantSidAndCreateByAndState(user.getTenantSid(), user.getSid(), 1)) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_EXPORT_DATA_EXISTED);
        }
        List records = this.tenantDataExportRecordService.queryTenantDataExportRecordList(user.getTenantSid(), LocalDateTime.now().getMonthValue());
        if (null != records && records.size() >= 5) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_EXPORT_DATA_COUNT_EXCEED);
        }
        return StdData.ok().build();
    }

    @PostMapping(value={"/data/export"})
    @Transactional
    public StdData<?> saveExportTenantData(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestBody TenantExportDataVO tenantExportDataVO) {
        TenantDataExportRecord tenantDataExportRecord = new TenantDataExportRecord();
        tenantDataExportRecord.setEoc(tenantExportDataVO.getEoc());
        tenantDataExportRecord.setUser(tenantExportDataVO.getUser());
        tenantDataExportRecord.setState(TenantDataExportRecordStateEnum.IN_PROGRESS.getValue().intValue());
        tenantDataExportRecord.setTenantSid(user.getTenantSid());
        tenantDataExportRecord.setExpireDate(LocalDateTime.now().plusDays(4L));
        tenantDataExportRecord.setId(UUID.randomUUID().toString());
        this.tenantDataExportRecordService.create((BaseEntity)tenantDataExportRecord);
        return StdData.ok((Object)tenantDataExportRecord.getId());
    }

    @PostMapping(value={"/data/export/cancel"})
    @Transactional
    public StdData<?> cancelExportTenantData(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestBody TenantExportDataVO tenantExportDataVO) {
        if (null != tenantExportDataVO.getDataSid()) {
            TenantDataExportRecord tenantDataExportRecord = (TenantDataExportRecord)this.tenantDataExportRecordService.findBySid(tenantExportDataVO.getDataSid().longValue());
            tenantDataExportRecord.setState(TenantDataExportRecordStateEnum.CANCELLED.getValue().intValue());
            this.tenantDataExportRecordService.update((BaseEntity)tenantDataExportRecord);
        }
        return StdData.ok().build();
    }

    @PostMapping(value={"/data/export/query"})
    public StdData<?> queryExportTenantData(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestBody TenantExportDataVO tenantExportDataVO) {
        tenantExportDataVO.setTenantContent(user.getTenantId());
        List records = this.tenantDataExportRecordService.queryTenantDataExportRecordList(tenantExportDataVO);
        PageSerializable result = new PageSerializable(records);
        return StdData.ok((Object)result);
    }

    @DapSign(force=false)
    @DapEncrypt(force=false)
    @PostMapping(value={"/dev/warehouse"})
    @Transactional
    public StdData<?> saveDevWarehouse(@RequestBody DevTenantCertificationVO devTenantCertificationVO) {
        Assert.notNull((Object)devTenantCertificationVO.getTenantSid(), (String)"\u79df\u6237sid\u4e0d\u80fd\u4e3a\u7a7a");
        Tenant tenant = this.tenantRepository.findById((Object)devTenantCertificationVO.getTenantSid()).orElse(null);
        Assert.isTrue((!ObjectUtils.isEmpty((Object)tenant) ? 1 : 0) != 0, (String)String.format("\u79df\u6237%s\u4e0d\u5b58\u5728", devTenantCertificationVO.getTenantSid()));
        if (!this.authValidateService.checkAccessPermission(TargetType.TenantSys.toString(), "POST", "/api/iam/v2/tenant/dev/warehouse", String.format("%s-%s", UserUtils.getTenantId(), UserUtils.getSysId())).booleanValue() && !UserUtils.getTenantId().equalsIgnoreCase(tenant.getId())) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        this.checkDevWarehouse(devTenantCertificationVO.getWarehouseProjectName(), devTenantCertificationVO.getWarehouseAccount(), devTenantCertificationVO.getWarehousePassword(), devTenantCertificationVO.getTenantSid().longValue());
        DevCertificationDO devCertification = this.certificationRepository.findByTenantSid(devTenantCertificationVO.getTenantSid().longValue());
        if (null != devCertification) {
            devCertification.setWarehouseProjectName(devTenantCertificationVO.getWarehouseProjectName());
            devCertification.setWarehouseAccount(devTenantCertificationVO.getWarehouseAccount());
            devCertification.setWarehousePassword(devTenantCertificationVO.getWarehousePassword());
            this.certificationRepository.save((Object)devCertification);
        }
        return StdData.ok().build();
    }

    @PostMapping(value={"/dev/warehouse/check"})
    public StdData<?> checkDevWarehouse(@RequestBody DevTenantCertificationVO devTenantCertificationVO) {
        this.checkDevWarehouse(devTenantCertificationVO.getWarehouseProjectName(), devTenantCertificationVO.getWarehouseAccount(), devTenantCertificationVO.getWarehousePassword(), devTenantCertificationVO.getTenantSid().longValue());
        return StdData.ok().build();
    }

    public void checkDevWarehouse(String warehouseProjectName, String warehouseAccount, String warehousePassword, long tenantSid) {
        if (com.digiwin.dap.middleware.util.StringUtils.isNotEmpty((String)warehouseProjectName)) {
            if (!com.digiwin.dap.middleware.util.StringUtils.isLowerLetterOrNumber((String)warehouseProjectName)) {
                throw new BusinessException((ErrorHandler)I18nError.WAREHOUSE_PROJECT_NAME_FORMAT_ERROR);
            }
            DevCertificationDO certificationDO = this.certificationRepository.findByWarehouseProjectName(warehouseProjectName);
            if (null != certificationDO && tenantSid != certificationDO.getTenantSid()) {
                Tenant devTenant = (Tenant)this.tenantCrudService.findBySid(certificationDO.getTenantSid());
                throw new BusinessException((ErrorHandler)I18nError.WAREHOUSE_ACCOUNT_EXISTED, new Object[]{devTenant.getName() + "(" + devTenant.getId() + ")"});
            }
        }
    }

    @Deprecated
    @PostMapping(value={"/tenant/sRobot/auth"})
    public StdData<?> authTenantSrobot(@RequestBody UpdateTenantInfoVO updateTenantInfoVO) {
        CopyAppAuthVO copyAppAuthVO = new CopyAppAuthVO();
        copyAppAuthVO.setTenantId(updateTenantInfoVO.getTenantId());
        copyAppAuthVO.setCustomerId(updateTenantInfoVO.getCustomerId());
        copyAppAuthVO.setAppId("sRobot");
        copyAppAuthVO.setType(Integer.valueOf(0));
        this.tenantService.addOrDeleteAuth(copyAppAuthVO, Boolean.valueOf(true));
        return StdData.ok().build();
    }

    @Deprecated
    @Transactional
    @PostMapping(value={"/tenant/sRobot/auth/delete"})
    public StdData<?> deleteAuthTenantSrobot(@RequestBody DeletePurchaseGoods body) {
        if (com.digiwin.dap.middleware.util.StringUtils.isEmpty((Object)body.getTenantId()) && com.digiwin.dap.middleware.util.StringUtils.isEmpty((Object)body.getCustomerId())) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_ID_AND_CUSTOMER_ID_NOT_NULL);
        }
        Tenant tenant = null;
        if (com.digiwin.dap.middleware.util.StringUtils.isNotEmpty((String)body.getTenantId())) {
            tenant = (Tenant)this.tenantCrudService.findById(body.getTenantId());
        }
        if (com.digiwin.dap.middleware.util.StringUtils.isNotEmpty((String)body.getCustomerId())) {
            tenant = this.tenantRepository.findBycustomerId(body.getCustomerId());
        }
        if (null == tenant) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED);
        }
        body.setTenantSid(Long.valueOf(tenant.getSid()));
        body.setTenantName(tenant.getName());
        SysQueryResultVO sRobotApp = this.sysInTenantQueryService.getSysVOByIdAndTenantSid("sRobot", body.getTenantSid().longValue());
        if (null != sRobotApp) {
            TenantApplication tenantApplication = new TenantApplication(tenant, sRobotApp);
            long sysSid = this.sysCrudService.getSidById("sRobot");
            this.sysInTenantCrudService.deleteByUnionKey(body.getTenantSid().longValue(), sysSid);
            this.changeLogService.saveDeleteSrobotChangeLogs(body, tenantApplication);
        }
        return StdData.ok().build();
    }

    @DapSign(force=false)
    @DapEncrypt(force=false)
    @Transactional
    @PostMapping(value={"/auth/app"})
    public StdData<?> authApp(@RequestBody CopyAppAuthVO copyAppAuthVO) {
        this.tenantService.addOrDeleteAuth(copyAppAuthVO, Boolean.valueOf(false));
        return StdData.ok().build();
    }

    @Transactional
    @PostMapping(value={"/current/auth/app"})
    public StdData<?> authAppForCurrent(@RequestAttribute(value="digi-middleware-auth-user-data") IamAuthoredUser authoredUser, @RequestBody CopyAppAuthVO copyAppAuthVO) {
        copyAppAuthVO.setTenantId(authoredUser.getTenantId());
        this.tenantService.addOrDeleteAuth(copyAppAuthVO, Boolean.valueOf(false));
        return StdData.ok().build();
    }

    @GetMapping(value={"/tenants/by/customer"})
    public StdData getTenantsByCurrentCustomerId(@RequestParam(value="customerId", required=false) String customerId, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (authoredUser.getTenantSid() == 0L) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED);
        }
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(authoredUser.getTenantSid());
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED);
        }
        if (com.digiwin.dap.middleware.util.StringUtils.isEmpty((Object)customerId)) {
            if (com.digiwin.dap.middleware.util.StringUtils.isEmpty((Object)tenant.getCustomerId())) {
                throw new BusinessException((ErrorHandler)I18nError.CUSTOMER_CODE_OF_TENANT_NOT_EMPTY, new Object[]{authoredUser.getTenantId()});
            }
            customerId = tenant.getCustomerId();
        } else if (!customerId.equalsIgnoreCase(tenant.getCustomerId())) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        List tenants = this.tenantMapper.findTenantsByCustomerId(customerId);
        return StdData.ok((Object)tenants);
    }

    @PostMapping(value={"/query/secretkey"})
    public ResponseEntity<?> getTenantSecretkey(@RequestBody TenantAppDTO dto) {
        Assert.notNull((Object)dto.getTenantSid(), (String)String.format("\u79df\u6237[%s]\u4e0d\u80fd\u4e3a\u7a7a", dto.getTenantSid()));
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(dto.getTenantSid().longValue());
        Assert.notNull((Object)tenant, (String)String.format("\u8be5\u79df\u6237[%s]\u4e0d\u5b58\u5728\uff01", dto.getTenantSid()));
        ArrayList<Long> tenantSids = new ArrayList<Long>();
        tenantSids.add(tenant.getSid());
        List subTenants = this.tenantMapper.findSubTenantBySid(tenant.getSid(), true);
        subTenants.forEach(t -> tenantSids.add(t.getSid()));
        if (!CollectionUtils.isEmpty((Collection)dto.getAppIds())) {
            List sourceApps = this.sysMapper.queryAuthSysByIds(tenantSids, dto.getAppIds());
            return ResponseEntity.ok((Object)sourceApps);
        }
        return ResponseEntity.ok(Collections.emptyList());
    }

    @PostMapping(value={"/company"})
    public StdData<?> getTenant(@RequestBody TenantAppDTO body) {
        List tenantIds = this.cacService.findAuthTenant(body.getAppId());
        ArrayList<TenantCompanyVO> results = new ArrayList<TenantCompanyVO>();
        if (!tenantIds.isEmpty()) {
            List tenants = this.tenantRepository.findInIds(tenantIds);
            Map<Long, Tenant> tenantMap = tenants.stream().collect(Collectors.toMap(BaseEntity::getSid, a -> a, (k1, k2) -> k1));
            List companies = this.remoteEocService.findTenantsCompany(new ArrayList<Long>(tenantMap.keySet()));
            Map<Long, List<TenantCompanyVO>> companyMap = companies.stream().collect(Collectors.groupingBy(TenantCompanyVO::getTenantSid));
            for (Map.Entry<Long, Tenant> entry : tenantMap.entrySet()) {
                TenantCompanyVO company = new TenantCompanyVO(entry.getValue());
                company.setCompanies(companyMap.getOrDefault(entry.getKey(), Collections.emptyList()));
                results.add(company);
            }
        }
        return StdData.ok(results);
    }

    @PostMapping(value={"/user/list"})
    public ResponseEntity<?> getUsers(@RequestParam(value="pageNum", defaultValue="1") int pageNum, @RequestParam(value="pageSize", defaultValue="10") int pageSize, @RequestBody UserConditionVO userConditionVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        PageSerializable pageSerializable;
        Long tenantSid = UserUtils.getTenantSid();
        List<UserWithRolesVO> userWithRolesVOS = new ArrayList();
        if (null == userConditionVO.getSearchType() || 0 == userConditionVO.getSearchType()) {
            Tenant tenant = this.check(authoredUser.getTenantId(), userConditionVO.getTenantId());
            tenantSid = tenant.getSid();
            userWithRolesVOS = this.userMapper.getEnableUsersSimpleByTenantSidWithPage(tenantSid, userConditionVO.getUserContent(), pageNum, pageSize);
            pageSerializable = new PageSerializable(userWithRolesVOS);
        } else {
            List users = this.userMapper.getUsersByTenantWithPage(tenantSid.longValue(), userConditionVO, pageNum, pageSize);
            pageSerializable = new PageSerializable(users);
            for (User u2 : users) {
                UserWithRolesVO userWithRolesVO = new UserWithRolesVO(u2, Collections.emptyList());
                userWithRolesVOS.add(userWithRolesVO);
            }
        }
        if (userConditionVO.getWithRole().booleanValue() && !userWithRolesVOS.isEmpty()) {
            List userSids = userWithRolesVOS.stream().map(UserWithRolesVO::getSid).collect(Collectors.toList());
            List roles = this.userInRoleMapper.queryUserInRoleByUsers(tenantSid.longValue(), userSids, false);
            userWithRolesVOS.forEach(u -> {
                List matchRoles = roles.stream().filter(r -> u.getSid() == r.getUserSid().longValue()).collect(Collectors.toList());
                u.setRoles(matchRoles);
            });
        }
        pageSerializable.setList(userWithRolesVOS);
        return ResponseEntity.ok((Object)pageSerializable);
    }

    @PostMapping(value={"/auth/with/users"})
    public ResponseEntity<?> purchaseAuthWithUsers(@RequestBody GoodsAuthDO authDO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        logger.info("\u8c03\u7528\u3010\u7ed9\u6307\u5b9a\u79df\u6237\u5f00\u901a\u5e94\u7528\u6388\u6743\u5e76\u4e14\u6388\u6743\u6307\u5b9a\u7528\u6237\u5217\u8868\u3011\u63a5\u53e3\u7684\u5e94\u7528={}\uff0c\u79df\u6237={}\uff0c\u7528\u6237={}", new Object[]{UserUtils.getSysId(), authoredUser.getTenantId(), authoredUser.getUserId()});
        Tenant tenant = this.check(authoredUser.getTenantId(), authDO.getTenantId());
        this.tenantRegisterService.purchaseAuth(tenant, authDO);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    private Tenant check(String tenantId, String targetTenantId) {
        Assert.hasText((String)targetTenantId, (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)tenantId, (String)"\u5f53\u524d\u767b\u5f55\u79df\u6237\u4e0d\u80fd\u4e3a\u7a7a");
        Tenant currentTenant = (Tenant)this.tenantCrudService.findById(tenantId);
        if (currentTenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{tenantId});
        }
        if (!targetTenantId.equalsIgnoreCase(tenantId)) {
            if (com.digiwin.dap.middleware.util.StringUtils.isEmpty((Object)currentTenant.getCustomerId())) {
                throw new BusinessException((ErrorHandler)I18nError.CUSTOMER_CODE_OF_TENANT_NOT_EMPTY, new Object[]{tenantId});
            }
            Tenant tenant = (Tenant)this.tenantCrudService.findById(targetTenantId);
            if (tenant == null) {
                throw new BusinessException((ErrorHandler)I18nError.TARGET_TENANT_NOT_EXIST, new Object[]{targetTenantId});
            }
            if (!Objects.equals(currentTenant.getEnterpriseType(), TenantEnterpriseTypeEnum.INDIVIDUAL_TENANT.getValue()) && !currentTenant.getCustomerId().equals(tenant.getCustomerId())) {
                throw new BusinessException((ErrorHandler)I18nError.CUSTOMER_CODE_OF_TENANT_NOT_SAME, new Object[]{tenant.getId(), tenant.getCustomerId(), currentTenant.getId(), currentTenant.getCustomerId()});
            }
            return tenant;
        }
        return currentTenant;
    }

    @PostMapping(value={"/user/info"})
    public StdData<?> getUserStatusById(@RequestBody QueryUserStatusVO input) {
        ArrayList result = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)input.getUserIds())) {
            List userVOs = this.tenantMapper.queryUserStatusInTenant(UserUtils.getTenantSid(), input.getUserIds());
            result.addAll(userVOs);
            List language = this.metadataQueryService.queryUserMetadata(0L, input.getUserIds(), "basic", "dapAcceptLanguage");
            HashMap languageMap = language.stream().collect(HashMap::new, (m, v) -> m.put(v.getUserId(), v.getValue()), HashMap::putAll);
            for (UserStatusResultVO userVO : userVOs) {
                userVO.setLanguage((String)languageMap.get(userVO.getUserId()));
            }
        }
        return StdData.ok(result);
    }

    @PostMapping(value={"/platform/infos"})
    public ResponseEntity<?> getTenantInfos(@RequestBody TenantQueryCondition tenantQueryCondition) {
        return ResponseEntity.ok((Object)this.sysMapper.getTenantInfos(tenantQueryCondition));
    }

    @PostMapping(value={"/site"})
    public ResponseEntity<?> getSiteContacts(@RequestBody MessageTargetVO target) {
        List contact = this.tenantQueryService.getSiteContacts(target);
        return ResponseEntity.ok((Object)contact);
    }

    @PostMapping(value={"/users"})
    public StdData getUsersInTenant(@RequestBody QueryPageVO queryPageVO) {
        Tenant tenant;
        String tenantId = queryPageVO.getTenantId();
        if (com.digiwin.dap.middleware.util.StringUtils.isEmpty((Object)tenantId)) {
            if (com.digiwin.dap.middleware.util.StringUtils.isEmpty((Object)UserUtils.getTenantId())) {
                throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED);
            }
            tenantId = UserUtils.getTenantId();
        }
        if (null == (tenant = (Tenant)this.tenantCrudService.findById(tenantId))) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21005, new Object[]{tenantId});
        }
        List users = this.userMapper.getUserListInTenantWithPage(Long.valueOf(tenant.getSid()), queryPageVO.getPageNumber(), Long.valueOf(200L));
        if (Boolean.TRUE.equals(queryPageVO.getWithOrg()) && !CollectionUtils.isEmpty((Collection)users)) {
            List orgInUsers = this.userInOrgMapper.queryOrgInUsers(tenant.getSid(), users.stream().map(UserSimpleVO::getSid).collect(Collectors.toList()));
            users.forEach(u -> {
                List matchOrgs = orgInUsers.stream().filter(r -> u.getSid() == r.getUserSid()).collect(Collectors.toList());
                u.setUserInOrgs(matchOrgs);
            });
        }
        return StdData.ok((Object)PageSerializable.of((List)users));
    }

    @PostMapping(value={"/app/tenants"})
    public StdData<?> findSysTenant(@RequestParam(required=false, defaultValue="Athena") String sysId) {
        return StdData.ok((Object)this.tenantMapper.findSysTenants(sysId));
    }

    @GetMapping(value={"/service"})
    public ResponseEntity<?> getTenantService(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        String tenantId = authoredUser.getTenantId();
        List tenantApplications = com.digiwin.dap.middleware.util.StringUtils.isEmpty((Object)tenantId) ? new ArrayList() : this.tenantQueryService.getTenantApplicationByTenant(tenantId, GoodsCategoryEnum.SERVICE.id());
        return ResponseEntity.ok(tenantApplications);
    }

    @PostMapping(value={"/service/step"})
    public ResponseEntity<TenantAppIamVO> cbm(@RequestBody TenantAppIamVO input) {
        if (!com.digiwin.dap.middleware.util.StringUtils.isEmpty((Object)UserUtils.getTenantId())) {
            input.setTenantId(UserUtils.getTenantId());
            this.tenantQueryService.fillTenantApplicationByTenant(input, GoodsCategoryEnum.SERVICE.id());
        }
        return ResponseEntity.ok((Object)input);
    }

    @PostMapping(value={"/application/list"})
    public ResponseEntity<?> getTenantApplication11(@RequestBody TenantApplicationDTO dto, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, HttpServletRequest request) {
        logger.info("\u67e5\u8be2/application/list\u8bf7\u6c42\u8bb0\u5f55\uff0cheader:locale-{},Accept-Language-{},\u8bf7\u6c42\u53c2\u6570-{}", new Object[]{request.getHeader("locale"), request.getHeader("Accept-Language"), JsonUtils.writeValue((Object)dto)});
        if (com.digiwin.dap.middleware.util.StringUtils.isEmpty((Object)authoredUser.getTenantId())) {
            return ResponseEntity.ok(Collections.emptyList());
        }
        dto.setTenantId(authoredUser.getTenantId());
        dto.setIncludePlatForm(Optional.ofNullable(dto.getIncludePlatForm()).orElse(Boolean.FALSE));
        dto.setCategoryId(Boolean.FALSE.equals(dto.getIncludePlatForm()) ? GoodsCategoryEnum.APP.id() : GoodsCategoryEnum.PLATFORM.id());
        List tenantApplications = this.tenantQueryService.getTenantApplicationByTenant(dto);
        return ResponseEntity.ok((Object)tenantApplications);
    }

    @GetMapping(value={"/application"})
    public ResponseEntity<?> getTenantApplication(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, TenantAppConditionVO condition) {
        List tenantApplications;
        String tenantId = authoredUser.getTenantId();
        if (com.digiwin.dap.middleware.util.StringUtils.isEmpty((Object)tenantId)) {
            tenantApplications = new ArrayList();
        } else {
            tenantApplications = this.tenantQueryService.getTenantApplicationByTenant(tenantId, GoodsCategoryEnum.APP.id());
            tenantApplications = this.filterApps(condition, tenantApplications);
        }
        return ResponseEntity.ok(tenantApplications);
    }

    private List<TenantApplication> filterApps(TenantAppConditionVO condition, List<TenantApplication> tenantApplications) {
        if (condition != null) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            LocalDateTime expireTimeStart = null;
            LocalDateTime expireTimeEnd = null;
            if (com.digiwin.dap.middleware.util.StringUtils.hasLength((String)condition.getExpireTimeStart())) {
                expireTimeStart = LocalDateTime.parse(condition.getExpireTimeStart(), formatter);
            }
            if (com.digiwin.dap.middleware.util.StringUtils.hasLength((String)condition.getExpireTimeEnd())) {
                expireTimeEnd = LocalDateTime.parse(condition.getExpireTimeEnd(), formatter);
            }
            LocalDateTime left = expireTimeStart;
            LocalDateTime right = expireTimeEnd;
            tenantApplications = tenantApplications.stream().filter(app -> {
                LocalDateTime expiredTime = LocalDateTime.parse(app.getExpiredTime(), formatter);
                boolean matchesStart = left == null || expiredTime.isAfter(left) || expiredTime.isEqual(left);
                boolean matchesEnd = right == null || expiredTime.isBefore(right) || expiredTime.isEqual(right);
                return matchesStart && matchesEnd;
            }).collect(Collectors.toList());
        }
        return tenantApplications;
    }

    @GetMapping(value={"/course"})
    public ResponseEntity<?> getTenantCourse(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        String tenantId = authoredUser.getTenantId();
        List tenantApplications = com.digiwin.dap.middleware.util.StringUtils.isEmpty((Object)tenantId) ? new ArrayList() : this.tenantQueryService.getTenantApplicationByTenant(tenantId, GoodsCategoryEnum.COURSE.id());
        return ResponseEntity.ok(tenantApplications);
    }

    @PostMapping(value={"/auth/app/info/list"})
    public StdData getTenantApplications(@RequestBody TenantSysCascadeVO sysCascadeVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (ObjectUtils.isEmpty((Object)sysCascadeVO.getTenantId())) {
            sysCascadeVO.setTenantId(authoredUser.getTenantId());
        }
        return StdData.ok((Object)this.tenantQueryService.getTenantApplicationList(sysCascadeVO.getTenantId(), sysCascadeVO.getType(), sysCascadeVO.getSysVOs()));
    }

    @GetMapping(value={"/test/ids"})
    public StdData<?> getTestTenantIds() {
        return StdData.ok((Object)this.tenantMapper.getTestTenantIds());
    }

    @GetMapping(value={"/test/infos"})
    public StdData<?> getTestTenantInfos() {
        return StdData.ok((Object)this.tenantMapper.getTestTenantInfos());
    }

    @PostMapping(value={"/auth/app/sid"})
    public StdData<?> getTenantAuth(@RequestBody TenantAuthQueryVO vo) {
        if (ObjectUtils.isEmpty((Object)vo.getAppId())) {
            vo.setAppId(UserUtils.getSysId());
        }
        return StdData.ok((Object)this.tenantService.getTenantAuth(vo));
    }

    @PostMapping(value={"/application/list/simple"})
    public StdData<?> getTenantApplicationList(@RequestBody TenantApplicationDTO dto, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, HttpServletRequest request) {
        logger.info("\u67e5\u8be2/application/list/simple\u8bf7\u6c42\u8bb0\u5f55\uff0cheader:locale-{},Accept-Language-{},\u8bf7\u6c42\u53c2\u6570-{}", new Object[]{request.getHeader("locale"), request.getHeader("Accept-Language"), JsonUtils.writeValue((Object)dto)});
        if (!com.digiwin.dap.middleware.util.StringUtils.hasLength((String)authoredUser.getTenantId())) {
            return StdData.ok(Collections.emptyList());
        }
        dto.setTenantId(authoredUser.getTenantId());
        dto.setIncludePlatForm(Optional.ofNullable(dto.getIncludePlatForm()).orElse(Boolean.FALSE));
        dto.setCategoryId(Boolean.FALSE.equals(dto.getIncludePlatForm()) ? GoodsCategoryEnum.APP.id() : GoodsCategoryEnum.PLATFORM.id());
        List tenantApplications = this.tenantQueryService.getTenantApplicationByTenant(dto);
        List simpleVOS = tenantApplications.stream().map(arg_0 -> ((TenantApplicationSimpleVoConvertor)TenantApplicationSimpleVoConvertor.instance).from(arg_0)).collect(Collectors.toList());
        return StdData.ok(simpleVOS);
    }

    @PostMapping(value={"/batch/search"})
    public StdData<?> batchQueryTenantList(@RequestParam(value="pageNum", defaultValue="1") int pageNum, @RequestParam(value="pageSize", defaultValue="10") int pageSize, @RequestBody @Valid TenantSearchVO tenantSearchVO) {
        List tenantList = this.tenantQueryService.getTenantList(tenantSearchVO, pageNum, pageSize);
        PageSerializable tenantPage = new PageSerializable(tenantList);
        return StdData.ok((Object)tenantPage);
    }

    @PostMapping(value={"/delete/purchase/goods"})
    public StdData deletePurchaseGoods(@RequestBody DeletePurchaseGoods body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (!(this.authValidateService.checkAccessPermission(TargetType.Sys.name(), "POST", "/api/iam/v2/tenant/delete/purchase/goods", UserUtils.getSysId()).booleanValue() || this.envProperties.getManagerTenant().equals(authoredUser.getTenantId()) || authoredUser.getTenantId().equalsIgnoreCase(body.getTenantId()))) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        body.setUserId(authoredUser.getUserId());
        body.setUserName(authoredUser.getUserName());
        body.setDeleteDate(LocalDateTime.now());
        body.setCode(body.getGoodsCode());
        this.purchaseApplicationService.deletePurchaseGoods(body);
        return StdData.ok().build();
    }

    @PostMapping(value={"/same/customer"})
    public StdData querySameCustomer(@RequestBody TenantVO body) {
        if (ObjectUtils.isEmpty((Object)body.getTenantId())) {
            return StdData.ok(new ArrayList());
        }
        return StdData.ok((Object)this.tenantService.querySameCustomer(body.getTenantId()));
    }

    @DapEncrypt(response=true)
    @DapSign(response=true)
    @PostMapping(value={"/info/simple"})
    public StdData<?> getTenantInfoSimple(@RequestBody TenantDTO dto) {
        Assert.hasLength((String)dto.getId(), (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        if (!dto.getId().equals(UserUtils.getTenantId()) && !this.authValidateService.checkAccessPermission(TargetType.Sys.toString(), "POST", "/api/iam/v2/tenant/info/simple", UserUtils.getSysId()).booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        Tenant tenant = (Tenant)this.tenantCrudService.findById(dto.getId());
        if (tenant == null) {
            return StdData.of((int)500, (String)String.format("\u79df\u6237[%s]\u4e0d\u5b58\u5728", dto.getId()));
        }
        CommonVO vo = new CommonVO();
        vo.setId(tenant.getId());
        vo.setName(tenant.getName());
        vo.setTestTenant(Boolean.valueOf(tenant.isTestTenant()));
        return StdData.ok((Object)vo);
    }

    @GetMapping(value={"/org/{tenantSid}"})
    public ResponseEntity<?> queryOrg(@PathVariable(value="tenantSid") long tenantSid, @RequestParam(value="orgCatalogId") String orgCatalogId, @RequestParam(value="orgAspectId") String orgAspectId) {
        if (UserUtils.getTenantSid() != tenantSid) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        long orgCatalogSid = this.orgQueryService.getCatalogSid(orgCatalogId, tenantSid);
        long orgAspectSid = this.orgQueryService.getAspectSid(tenantSid, orgCatalogSid, orgAspectId);
        List orgResultVOS = this.orgQueryService.getAspect(Long.valueOf(tenantSid), orgAspectSid);
        return ResponseEntity.ok((Object)orgResultVOS);
    }

    @PostMapping(value={"/ldap/object/list"})
    public StdData<?> listLdapObject(@RequestBody TenantMetadataLdapDTO dto, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        List tenantMetadataVOList = this.tenantMetadataCrudService.getTenantMetadataValue(authoredUser.getTenantSid(), "ldap", IamConstants.LDAP_KEY_LIST);
        if (tenantMetadataVOList.isEmpty()) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21010);
        }
        TenantMetadataLdapVO vo = new TenantMetadataLdapVO(tenantMetadataVOList);
        String url = Optional.ofNullable(dto.getUrl()).orElse(vo.getUrl());
        String baseDn = Optional.ofNullable(dto.getBaseDn()).orElse(vo.getBaseDn());
        String adminAccount = Optional.ofNullable(dto.getAdminAccount()).orElse(vo.getAdminAccount());
        String adminPassword = AES.decrypt((String)Optional.ofNullable(dto.getAdminPassword()).orElse(vo.getAdminPassword()), (String)KeyConstant.WECHAT_UNION_ID);
        boolean ssl = BooleanStrEnum.TRUE.getValue().equals(Optional.ofNullable(dto.getSslEnabled()).orElse(vo.getSslEnabled()));
        String userFilter = Optional.ofNullable(dto.getUserFilter()).orElse(vo.getUserFilter());
        List list = this.ldapService.search(url, adminAccount, adminPassword, ssl, baseDn, userFilter);
        return StdData.ok((Object)list);
    }

    @PostMapping(value={"/ldap/object/search"})
    public StdData<?> listLdapObjectPage(@RequestBody TenantMetadataLdapDTO dto, @RequestParam(name="pageSize", defaultValue="500", required=false) int pageSize, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        List tenantMetadataVOList = this.tenantMetadataCrudService.getTenantMetadataValue(authoredUser.getTenantSid(), "ldap", IamConstants.LDAP_KEY_LIST);
        if (tenantMetadataVOList.isEmpty()) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21010);
        }
        TenantMetadataLdapVO vo = new TenantMetadataLdapVO(tenantMetadataVOList);
        String url = Optional.ofNullable(dto.getUrl()).orElse(vo.getUrl());
        String baseDn = Optional.ofNullable(dto.getBaseDn()).orElse(vo.getBaseDn());
        String adminAccount = Optional.ofNullable(dto.getAdminAccount()).orElse(vo.getAdminAccount());
        String adminPassword = AES.decrypt((String)Optional.ofNullable(dto.getAdminPassword()).orElse(vo.getAdminPassword()), (String)KeyConstant.WECHAT_UNION_ID);
        boolean ssl = BooleanStrEnum.TRUE.getValue().equals(Optional.ofNullable(dto.getSslEnabled()).orElse(vo.getSslEnabled()));
        String userFilter = Optional.ofNullable(dto.getUserFilter()).orElse(vo.getUserFilter());
        List list = this.ldapService.search(url, adminAccount, adminPassword, ssl, baseDn, userFilter, pageSize);
        return StdData.ok((Object)list);
    }

    @PostMapping(value={"/ad/user/sync"})
    public StdData<?> syncAdUser(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        this.rateLimiterCheck(authoredUser.getTenantId());
        if (!this.userInRoleService.checkSuperAdmin(Long.valueOf(authoredUser.getTenantSid()), Long.valueOf(authoredUser.getSid()))) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_USER_NOT_SUPER_ADMIN);
        }
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(authoredUser.getTenantSid());
        if (!tenant.isAdLogin()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_LOGIN_TENANT_AD_LOGIN_DISABLED_ERROR, new Object[]{authoredUser.getTenantId()});
        }
        List metadataVOList = this.tenantMetadataCrudService.getTenantMetadataValue(authoredUser.getTenantSid(), "ldap", IamConstants.LDAP_KEY_LIST);
        if (metadataVOList.isEmpty()) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21010);
        }
        this.userService.syncAdObject(tenant, new TenantMetadataLdapVO(metadataVOList), authoredUser, false);
        return StdData.ok().build();
    }

    @PostMapping(value={"/ad/ou/sync"})
    public StdData<?> syncAdOu(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        this.rateLimiterCheck(authoredUser.getTenantId());
        if (!this.userInRoleService.checkSuperAdmin(Long.valueOf(authoredUser.getTenantSid()), Long.valueOf(authoredUser.getSid()))) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_USER_NOT_SUPER_ADMIN);
        }
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(authoredUser.getTenantSid());
        if (!tenant.isAdLogin()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_LOGIN_TENANT_AD_LOGIN_DISABLED_ERROR, new Object[]{authoredUser.getTenantId()});
        }
        if (!tenant.isEoc()) {
            throw new BusinessException(StrUtil.indexedFormat((CharSequence)"\u79df\u6237{0}\u672a\u542f\u7528EOC\uff08\u4f01\u4e1a\u8fd0\u8425\u7ba1\u7406\uff09\u4e0d\u80fd\u8fdb\u884c\u7ec4\u7ec7\u53ca\u5458\u5de5\u540c\u6b65\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u4eba\u5458", (Object[])new Object[]{authoredUser.getTenantId()}));
        }
        List metadataVOList = this.tenantMetadataCrudService.getTenantMetadataValue(authoredUser.getTenantSid(), "ldap", IamConstants.LDAP_KEY_LIST);
        if (metadataVOList.isEmpty()) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21010);
        }
        this.userService.syncAdObject(tenant, new TenantMetadataLdapVO(metadataVOList), authoredUser, true);
        return StdData.ok().build();
    }

    private void rateLimiterCheck(String tenantId) {
        String key = String.format("iam:tenant:ad:user:sync:%s", tenantId);
        String lastAccessTime = (String)RedisUtils.get((Object)key, String.class);
        long currentTime = System.currentTimeMillis();
        if (lastAccessTime == null) {
            RedisUtils.set((String)key, (Object)String.valueOf(currentTime), (Duration)Duration.ofMinutes(10L));
            return;
        }
        long elapsedTime = currentTime - Long.parseLong(lastAccessTime);
        long remainingTime = TimeUnit.MINUTES.toMillis(10L) - elapsedTime;
        if (elapsedTime < TimeUnit.MINUTES.toMillis(10L)) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_AD_USER_SYNC_RATE_LIMIT_ERROR, new Object[]{10L, TimeUnit.MILLISECONDS.toMinutes(remainingTime)});
        }
        RedisUtils.set((String)key, (Object)String.valueOf(currentTime), (Duration)Duration.ofMinutes(10L));
    }

    @PostMapping(value={"/saml/exist"})
    public StdData<?> getSamlExist(@RequestBody TenantSimpleVO tenantSimpleVO) {
        Tenant tenant = (Tenant)this.tenantCrudService.findById(tenantSimpleVO.getTenantId());
        if (Objects.isNull(tenant) || !tenant.isSamlLogin()) {
            return StdData.ok((Object)false);
        }
        List tenantMetadataVOList = this.tenantMetadataCrudService.getTenantMetadataValue(tenant.getSid(), "saml", IamConstants.SAML_KEY_LIST);
        TenantMetadataSAMLVO samlVO = new TenantMetadataSAMLVO(tenantMetadataVOList);
        if (!com.digiwin.dap.middleware.util.StringUtils.hasText((String)samlVO.getSsoUrl())) {
            return StdData.ok((Object)false);
        }
        return StdData.ok((Object)true);
    }

    @PostMapping(value={"/cas/exist"})
    public StdData<?> getCasExist(@RequestBody TenantSimpleVO tenantSimpleVO) {
        Tenant tenant = (Tenant)this.tenantCrudService.findById(tenantSimpleVO.getTenantId());
        if (Objects.isNull(tenant) || !tenant.isCasLogin()) {
            return StdData.ok((Object)false);
        }
        List tenantMetadataVOList = this.tenantMetadataCrudService.getTenantMetadataValue(tenant.getSid(), "cas", IamConstants.CAS_KEY_LIST);
        TenantMetadataCasVO casVO = new TenantMetadataCasVO(tenantMetadataVOList);
        if (!com.digiwin.dap.middleware.util.StringUtils.hasText((String)casVO.getSsoUrl())) {
            return StdData.ok((Object)false);
        }
        return StdData.ok((Object)true);
    }

    @PostMapping(value={"/batch/auth"})
    public StdData<?> authCACByType(@RequestBody TenantBatchAuthVO vo) {
        vo.setTenantSid(Long.valueOf(UserUtils.getTenantSid()));
        vo.setTenantId(UserUtils.getTenantId());
        return StdData.ok((Object)this.tenantService.batchAuthCacBy(vo));
    }

    @PostMapping(value={"/batch/auth/count"})
    public StdData<?> queryAuthCacCountBy(@RequestBody TenantBatchAuthVO vo) {
        vo.setTenantSid(Long.valueOf(UserUtils.getTenantSid()));
        vo.setTenantId(UserUtils.getTenantId());
        return StdData.ok((Object)this.tenantService.queryAuthCacCountBy(vo));
    }

    @DapSign(force=false)
    @DapEncrypt(force=false)
    @PostMapping(value={"/skip/auth"})
    public StdData<?> configureNoAuthUser(@RequestBody GroundNoAuthUserVO vo) {
        vo.setTenantId(UserUtils.getTenantId());
        this.ramService.configureNoAuthUser(vo);
        return StdData.ok().build();
    }

    @PostMapping(value={"/skip/auth/find"})
    public StdData<?> findNoAuthUserFlag(@RequestBody GroundNoAuthUserVO vo) {
        vo.setTenantId(UserUtils.getTenantId());
        return StdData.ok((Object)this.ramService.findNoAuthUser(vo));
    }

    @PostMapping(value={"/dict/data/search"})
    public StdData<?> searchDict(@RequestBody DictDataDTO dto) {
        if (this.envProperties.isCloud()) {
            return StdData.ok().build();
        }
        return StdData.ok((Object)this.dictDataService.selectDictDataList(dto, dto.getPageNum(), dto.getPageSize(), Optional.ofNullable(dto.getOrderBy()).orElse("dd.dict_sort")));
    }

    @PostMapping(value={"/app/purchase/type"})
    public StdData queryTenantTryOutType(@RequestBody TenantAuthQueryVO queryVO) {
        if (ObjectUtils.isEmpty((Object)queryVO.getAppId())) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_PARAM_EMPTY_ERROR, new Object[]{"appId"});
        }
        if (ObjectUtils.isEmpty((Object)queryVO.getType())) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_PARAM_EMPTY_ERROR, new Object[]{"type"});
        }
        SyncTenantAuthScope authScope = this.syncTenantAuthScopeRepository.findByTenantSidAndPlatformAndAuthApp(Long.valueOf(UserUtils.getTenantSid()), queryVO.getType(), queryVO.getAppId());
        if (null != authScope) {
            return StdData.ok((Object)authScope.getTryoutType());
        }
        return StdData.ok().build();
    }

    @PostMapping(value={"/third/sync/info"})
    public StdData<?> queryTenantThirdSyncInfo(@RequestBody QueryTenantThirdSyncInfoRequest param, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        param.valid();
        SyncTenantAuthScope syncTenantAuthScope = this.syncTenantAuthScopeRepository.findByTenantSidAndPlatformAndAuthApp(Long.valueOf(authoredUser.getTenantSid()), param.getPlatform(), param.getAppId());
        return StdData.ok((Object)syncTenantAuthScope);
    }

    @PostMapping(value={"/double/check"})
    public StdData modUser(@RequestBody @Valid TenantDoubleCheckVO vo) {
        vo.setTenantSid(Long.valueOf(UserUtils.getTenantSid()));
        this.tenantService.modTenantDoubleCheck(vo);
        return StdData.ok().build();
    }

    @PostMapping(value={"/dict/data/search/restricted"})
    public StdData<?> searchDictRestricted(@RequestBody DictDataDTO dto) {
        List<String> allowKeys = Arrays.asList("pw_min_length");
        if (!allowKeys.contains(dto.getDictId())) {
            return StdData.ok().build();
        }
        return StdData.ok((Object)this.dictDataService.selectDictDataList(dto, dto.getPageNum(), dto.getPageSize(), Optional.ofNullable(dto.getOrderBy()).orElse("dd.dict_sort")));
    }

    @PostMapping(value={"/count"})
    public StdData<?> allTenantCount(@RequestBody List<String> tenantIds) {
        return StdData.ok((Object)this.tenantMapper.findAllTenantCount(tenantIds));
    }

    @PostMapping(value={"/user/disable/batch"})
    public StdData<?> batchDisableUser(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestBody RequestParameterVO body) {
        List userToDisable = body.getUserSids();
        if (!CollectionUtils.isEmpty((Collection)userToDisable)) {
            this.tenantBatchService.batchDisableUserFromTenant(user, userToDisable);
        }
        return StdData.ok().build();
    }

    @PostMapping(value={"/crmgg"})
    public StdData<?> getMiswsTenant(@RequestBody InvoiceInfoVO vo) {
        return StdData.ok((Object)this.miswsService.getMiswsTenant(vo.getInvoiceTitle(), vo.getTaxCode()));
    }

    @GetMapping(value={"/source/tenant"})
    public StdData<?> getSourceTenant(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("existed", false);
        Tenant tenant = this.tenantMapper.findSourceTenant(user.getTenantId());
        if (null != tenant) {
            result.put("existed", true);
            result.put("sid", tenant.getSid());
            result.put("id", tenant.getId());
            result.put("customerId", tenant.getCustomerId());
        }
        return StdData.ok(result);
    }

    @PostMapping(value={"/batch/auth/user/update"})
    public StdData batchUpdateUser(@RequestBody GoodsAuthDO goodsAuthDO) {
        this.otherValidateService.checkParam(goodsAuthDO);
        if (!this.userInRoleService.checkSuperAdmin(Long.valueOf(UserUtils.getTenantSid()), Long.valueOf(UserUtils.getUserSid()))) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_USER_PERMISSION_ERROR);
        }
        if (CollectionUtils.isEmpty((Collection)goodsAuthDO.getUserIds())) {
            if (!CollectionUtils.isEmpty((Collection)goodsAuthDO.getUserSids())) {
                List users = this.userMapper.findByIds(Long.valueOf(UserUtils.getTenantSid()), null, goodsAuthDO.getUserSids());
                if (CollectionUtils.isEmpty((Collection)users)) {
                    return StdData.of((int)20000, (String)"\u64cd\u4f5c\u7684\u6388\u6743\u7528\u6237\u4e0d\u5c5e\u4e8e\u5f53\u524d\u79df\u6237\u4e0b");
                }
                goodsAuthDO.setUserIds(users.stream().map(UserInfo::getId).collect(Collectors.toList()));
            } else {
                return StdData.of((int)20000, (String)"\u6388\u6743\u7528\u6237\u4e3a\u7a7a");
            }
        }
        if (1 == goodsAuthDO.getAction()) {
            return StdData.ok((Object)this.cacService.batchDeleteIncremental(goodsAuthDO.getAppId(), goodsAuthDO.getUserIds()));
        }
        return StdData.ok((Object)this.cacService.batchAddIncremental(goodsAuthDO.getAppId(), goodsAuthDO.getUserIds()));
    }

    @PostMapping(value={"/user/status"})
    public StdData<?> getTenantUserStatusById(@RequestBody QueryUserStatusVO input) {
        List result = this.tenantMapper.queryUserStatusInTenant(UserUtils.getTenantSid(), Collections.singletonList(input.getUserId()));
        if (result.isEmpty()) {
            if (ObjectUtils.nullSafeEquals((Object)Boolean.TRUE, (Object)input.getCheckEmp())) {
                UserStatusResultVO userStatusResultVO = this.tenantService.checkEmp(input.getUserId());
                if (null == userStatusResultVO) {
                    return StdData.of((int)500, (String)I18nUtils.getMessage((String)I18nError.USER_TENANT_EXISTED_ERROR.getCode(), (Object[])new Object[]{UserUtils.getTenantId(), input.getUserId()}));
                }
                return StdData.ok((Object)userStatusResultVO.isDisabledInTenant());
            }
            return StdData.of((int)500, (String)I18nUtils.getMessage((String)I18nError.USER_TENANT_EXISTED_ERROR.getCode(), (Object[])new Object[]{UserUtils.getTenantId(), input.getUserId()}));
        }
        UserStatusResultVO aUser = (UserStatusResultVO)result.get(0);
        return StdData.ok((Object)aUser.isDisabledInTenant());
    }

    @PostMapping(value={"/basic/by/apps"})
    public StdData<?> getTenantUserStatusById(@RequestBody QueryTenantByAppRequest input) {
        List purchases = this.cacService.findAuthByApps(input.getAppIds());
        if (CollectionUtils.isEmpty((Collection)purchases)) {
            return StdData.ok(new ArrayList());
        }
        List tenantIds = purchases.stream().map(AuthorizationVO::getCustomerId).distinct().collect(Collectors.toList());
        List tenantInfo = this.tenantMapper.findTenantsBasicByIds(tenantIds);
        Map<String, List<AuthorizationVO>> groupedByCode = purchases.stream().collect(Collectors.groupingBy(AuthorizationVO::getCode));
        Map<String, TenantSimpleVO> tenantMap = tenantInfo.stream().collect(Collectors.toMap(TenantSimpleVO::getTenantId, tenant -> tenant));
        ArrayList<AppTenantAuthVO> result = new ArrayList<AppTenantAuthVO>();
        for (Map.Entry<String, List<AuthorizationVO>> entry : groupedByCode.entrySet()) {
            String code = entry.getKey();
            List tenants = entry.getValue().stream().map(auth -> (TenantSimpleVO)tenantMap.get(auth.getCustomerId())).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            result.add(new AppTenantAuthVO(code, tenants));
        }
        return StdData.ok(result);
    }

    @GetMapping(value={"/count/batch"})
    public StdData<?> getTenantCount(QueryTenantCountRequest condition) {
        if (CollectionUtils.isEmpty((Collection)condition.getTenantIds()) && CollectionUtils.isEmpty((Collection)condition.getTenantSids())) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_INFO_EMPTY);
        }
        return StdData.ok((Object)this.tenantMapper.getTenantCount(condition));
    }

    @GetMapping(value={"/current/no/telephone"})
    public StdData<?> getCurrentNoTelephone() {
        return StdData.ok((Object)this.userInTenantMapper.getUserInTenantWithNoTelephone(UserUtils.getTenantSid()));
    }

    @PostMapping(value={"/code/item"})
    public ResponseEntity<?> getProjectCode(@RequestBody ItemConditionRequest request) {
        String tenantContent = String.valueOf(request.getFilters().get("code"));
        Integer pageSize = request.getPageSize();
        if (request.getPageSize() > 100) {
            pageSize = 100;
        }
        TenantSearchVO tenantSearchVO = new TenantSearchVO();
        tenantSearchVO.setTenantContent(tenantContent);
        PageSerializable tenantList = this.tenantQueryService.getTenantNameByPage(request.getPageNum(), pageSize, tenantSearchVO);
        return ResponseEntity.ok((Object)ItemPage.of((PageSerializable)tenantList));
    }
}

