/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.tenanthistory.TenantHistoryQueryService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2/tenanthistory"})
public class TenantHistoryController {
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private TenantHistoryQueryService tenantHistoryQueryService;

    @GetMapping(value={"/all/{tenantSid}"})
    public ResponseEntity<?> getTenantConfirmInfos(@PathVariable(value="tenantSid") long tenantSid) {
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{tenantSid});
        }
        List tenantHistories = this.tenantHistoryQueryService.getTenantHistories(tenantSid);
        return ResponseEntity.ok((Object)tenantHistories);
    }
}

