/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.Page;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.constant.ValidatedGroup;
import com.digiwin.dap.middleware.iam.domain.tenant.mapping.TenantMappingDTO;
import com.digiwin.dap.middleware.iam.entity.TenantMapping;
import com.digiwin.dap.middleware.iam.service.tenantmapping.TenantMappingCrudService;
import com.digiwin.dap.middleware.iam.service.tenantmapping.TenantMappingService;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2/tenantmapping"})
public class TenantMappingController {
    @Autowired
    private TenantMappingCrudService tenantMappingCrudService;
    @Autowired
    private TenantMappingService tenantMappingService;

    @Transactional
    @PostMapping(value={"/add"})
    public StdData<?> save(@Validated(value={ValidatedGroup.INSERT.class}) @RequestBody TenantMappingDTO dto, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        dto.setTenantSid(Long.valueOf(authoredUser.getTenantSid()));
        TenantMapping o = (TenantMapping)dto.doForward();
        this.checkExisted(new TenantMappingDTO(dto.getTenantSid(), dto.getAppId(), dto.getCompanyId(), dto.getAccount()), null);
        return StdData.ok((Object)this.tenantMappingCrudService.create((BaseEntity)o));
    }

    @GetMapping(value={"/find"})
    public StdData<?> find(@Validated(value={ValidatedGroup.FIND.class}) TenantMappingDTO dto, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        TenantMapping o = this.tenantMappingCrudService.findBySidAndTenantSid(dto.getSid(), Long.valueOf(authoredUser.getTenantSid()));
        return StdData.ok((Object)o);
    }

    @GetMapping(value={"/appid/company/account/find"})
    public StdData<?> findBySysIdAndType(@Validated(value={ValidatedGroup.FIND_1.class}) TenantMappingDTO dto, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        TenantMapping o = this.tenantMappingCrudService.findByAppIdAndCompanyIdAndAccountAndTenantSid(dto.getAppId(), dto.getCompanyId(), dto.getAccount(), Long.valueOf(authoredUser.getTenantSid()));
        return StdData.ok((Object)o);
    }

    @Transactional
    @PostMapping(value={"/mod"})
    public StdData<?> update(@Validated(value={ValidatedGroup.UPDATE.class}) @RequestBody TenantMappingDTO dto, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        TenantMapping old = this.tenantMappingCrudService.findBySidAndTenantSid(dto.getSid(), Long.valueOf(authoredUser.getTenantSid()));
        if (old == null) {
            throw new BusinessException(String.format("\u67e5\u8be2sid[%s]\u8d44\u6599\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u4fee\u6539", dto.getSid()));
        }
        dto.setTenantSid(Long.valueOf(authoredUser.getTenantSid()));
        TenantMapping o = (TenantMapping)dto.doForward();
        this.checkExisted(new TenantMappingDTO(dto.getTenantSid(), dto.getAppId(), dto.getCompanyId(), dto.getAccount()), dto.getSid());
        this.tenantMappingCrudService.update((BaseEntity)o);
        return StdData.ok((Object)dto.getSid());
    }

    @PostMapping(value={"/del"})
    public StdData<?> delete(@Validated(value={ValidatedGroup.DELETE.class}) @RequestBody TenantMappingDTO dto, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        this.tenantMappingCrudService.deleteBySidAndTenantSid(dto.getSid(), Long.valueOf(authoredUser.getTenantSid()));
        return StdData.ok((Object)Boolean.TRUE);
    }

    @GetMapping(value={"/list"})
    public StdData<?> list(TenantMappingDTO dto, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        dto.setTenantSid(Long.valueOf(authoredUser.getTenantSid()));
        return StdData.ok((Object)this.tenantMappingService.list(dto));
    }

    @GetMapping(value={"/search"})
    public StdData<?> list(Page page, TenantMappingDTO dto, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        dto.setTenantSid(Long.valueOf(authoredUser.getTenantSid()));
        return StdData.ok((Object)this.tenantMappingService.list(page, dto));
    }

    private void checkExisted(TenantMappingDTO dto, Long sidNot) {
        boolean existed;
        List list = this.tenantMappingService.list(dto);
        if (!StringUtils.hasLength((String)dto.getCompanyId()) || !StringUtils.hasLength((String)dto.getAccount())) {
            existed = list.stream().filter(x -> !Objects.equals(sidNot, x.getSid())).anyMatch(x -> !StringUtils.hasLength((String)x.getCompanyId()) || !StringUtils.hasLength((String)x.getAccount()));
        } else {
            boolean bl = existed = !list.isEmpty();
        }
        if (existed) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_MAPPING_EXISTED, new Object[]{dto.getAppId(), dto.getCompanyId(), dto.getAccount()});
        }
    }
}

