/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import com.alibaba.excel.util.CollectionUtils;
import com.digiwin.dap.middle.kms.constants.KeyConstant;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.constant.IamConstants;
import com.digiwin.dap.middleware.iam.constant.enums.BooleanStrEnum;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantCorpConfigDTO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantMetadataVO;
import com.digiwin.dap.middleware.iam.domain.tenant.metadata.TenantMetadataCasDTO;
import com.digiwin.dap.middleware.iam.domain.tenant.metadata.TenantMetadataCasVO;
import com.digiwin.dap.middleware.iam.domain.tenant.metadata.TenantMetadataLdapDTO;
import com.digiwin.dap.middleware.iam.domain.tenant.metadata.TenantMetadataLdapVO;
import com.digiwin.dap.middleware.iam.domain.tenant.metadata.TenantMetadataOIDCDTO;
import com.digiwin.dap.middleware.iam.domain.tenant.metadata.TenantMetadataOIDCVO;
import com.digiwin.dap.middleware.iam.domain.tenant.metadata.TenantMetadataSAMLDTO;
import com.digiwin.dap.middleware.iam.domain.tenant.metadata.TenantMetadataSAMLVO;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.service.tenant.AutoEOCService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantQueryService;
import com.digiwin.dap.middleware.iam.service.tenantmetadata.TenantMetadataColumnCrudService;
import com.digiwin.dap.middleware.iam.service.tenantmetadata.TenantMetadataCrudService;
import com.digiwin.dap.middleware.iam.service.tenantmetadata.TenantMetadataUpdateService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleService;
import com.digiwin.dap.middleware.iam.support.remote.LdapService;
import com.digiwin.dap.middleware.iam.util.IDPCredentialsUtil;
import com.digiwin.dap.middleware.iam.util.StringUtil;
import com.digiwin.dap.middleware.util.StringUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import io.github.resilience4j.ratelimiter.annotation.RateLimiter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.naming.directory.DirContext;
import javax.transaction.Transactional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2/tenant"})
public class TenantMetadataController {
    private static final Logger logger = LoggerFactory.getLogger(TenantMetadataController.class);
    public static final String ADMIN_PASSWORD = "adminPassword";
    @Autowired
    private TenantQueryService tenantQueryService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private TenantMetadataCrudService tenantMetadataCrudService;
    @Autowired
    private TenantMetadataUpdateService tenantMetadataUpdateService;
    @Autowired
    private AutoEOCService autoEOCService;
    @Autowired
    private TenantMetadataColumnCrudService tenantMetadataColumnCrudService;
    @Autowired
    private LdapService ldapService;
    @Autowired
    private UserInRoleService userInRoleService;

    @Transactional(rollbackOn={Exception.class})
    @PostMapping(value={"/metadata/language"})
    public StdData<?> updateTenantMetadata(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestBody TenantMetadataVO body) {
        try {
            Assert.isTrue((user.getTenantSid() > 0L ? 1 : 0) != 0, (String)"\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u79df\u6237\u4fe1\u606f\uff01");
            this.tenantMetadataUpdateService.updateTenantMetadataValue(user.getTenantSid(), body.getCatalogId(), body.getKey(), body.getValue());
            return StdData.ok().build();
        }
        catch (Exception ex) {
            return StdData.of((int)500, (String)ex.getMessage());
        }
    }

    @GetMapping(value={"/metadata/language"})
    @RateLimiter(name="/api/iam/v2/tenant/metadata/language")
    public StdData<?> getTenantMetadata(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        try {
            Assert.isTrue((user.getTenantSid() > 0L ? 1 : 0) != 0, (String)"\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u79df\u6237\u4fe1\u606f\uff01");
            String defaultLanguage = this.tenantMetadataCrudService.getTenantMetadataValue(user.getTenantSid(), "basic", "defaultLanguage");
            return StdData.ok((Object)defaultLanguage);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return StdData.of((int)500, (String)ex.getMessage());
        }
    }

    @GetMapping(value={"/metadata/corpid"})
    public StdData<?> getTenantMetadataCorpId(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        try {
            Assert.isTrue((user.getTenantSid() > 0L ? 1 : 0) != 0, (String)"\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u79df\u6237\u4fe1\u606f\uff01");
            String corpId = this.tenantMetadataCrudService.getTenantMetadataValue(user.getTenantSid(), "contact", "corpId");
            return StdData.ok((Object)corpId);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return StdData.of((int)500, (String)ex.getMessage());
        }
    }

    @PostMapping(value={"/metadata/corpid"})
    public StdData<?> updateTenantMetadataCorpId(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestBody TenantMetadataVO body) {
        Assert.isTrue((user.getTenantSid() > 0L ? 1 : 0) != 0, (String)"\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u79df\u6237\u4fe1\u606f\uff01");
        this.tenantMetadataUpdateService.updateTenantMetadataCorpId(user.getTenantSid(), body.getCatalogId(), body.getKey(), body.getValue());
        return StdData.ok().build();
    }

    @PostMapping(value={"/metadata/corpid/cbm"})
    public StdData<?> updateTenantMetadataCorpId4Cbm(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestBody TenantMetadataVO body) {
        Assert.isTrue((user.getTenantSid() > 0L ? 1 : 0) != 0, (String)"\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u79df\u6237\u4fe1\u606f\uff01");
        this.tenantMetadataUpdateService.updateTenantMetadataCorpId4CBM(user.getTenantSid(), body.getCatalogId(), body.getKey(), body.getValue());
        return StdData.ok().build();
    }

    @GetMapping(value={"/metadata/corpid/appconfig/exist"})
    public StdData<?> getTenantCorpIdAndAppConfig(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestParam(name="tenantId", required=false) String tenantId) {
        try {
            Assert.isTrue((user.getTenantSid() > 0L ? 1 : 0) != 0, (String)"\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u79df\u6237\u4fe1\u606f\uff01");
            long tenantSid = user.getTenantSid();
            if (!ObjectUtils.isEmpty((Object)tenantId) && !tenantId.equalsIgnoreCase(user.getTenantId())) {
                throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
            }
            TenantCorpConfigDTO corpIdAndAppConfig = this.tenantQueryService.getTenantCorpIdAndAppConfig(tenantSid);
            return StdData.ok((Object)corpIdAndAppConfig);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return StdData.of((int)500, (String)ex.getMessage());
        }
    }

    @GetMapping(value={"/metadata/corpid/appconfig/exist/cbm"})
    public StdData<?> getTenantCorpIdAndAppConfig4CBM(@RequestParam(name="tenantId", required=false) String tenantId) {
        Tenant tenant;
        long tenantSid = UserUtils.getTenantSid();
        if (StringUtils.hasLength((String)tenantId) && null != (tenant = (Tenant)this.tenantCrudService.findById(tenantId))) {
            tenantSid = tenant.getSid();
        }
        TenantCorpConfigDTO corpIdAndAppConfig = this.tenantQueryService.getTenantCorpIdAndAppConfig4CBM(tenantSid);
        return StdData.ok((Object)corpIdAndAppConfig);
    }

    @PostMapping(value={"/metadata/span"})
    public StdData<?> updateTenantSpan(@RequestBody TenantMetadataVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Assert.isTrue((authoredUser.getTenantSid() > 0L ? 1 : 0) != 0, (String)"\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u79df\u6237\u4fe1\u606f\uff01");
        this.tenantMetadataUpdateService.updateTenantPasswordSpan(authoredUser.getTenantSid(), body.getValue());
        return StdData.ok().build();
    }

    @PostMapping(value={"/metadata/attempts"})
    public StdData<?> updateTenantAttempts(@RequestBody TenantMetadataVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        this.tenantMetadataUpdateService.updateTenantAttempts(authoredUser.getTenantSid(), body.getValue());
        return StdData.ok().build();
    }

    @PostMapping(value={"/metadata/eoc"})
    public StdData<?> updateTenantEocEntrance(@RequestBody TenantMetadataVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        this.tenantMetadataUpdateService.updateTenantEocEntrance(authoredUser.getTenantSid(), body.getValue());
        Optional.ofNullable(body.getAutoEOC()).ifPresent(a -> this.tenantMetadataUpdateService.updateTenantAutoEOC(authoredUser.getTenantSid(), a));
        this.autoEOCService.autoEocInit(UserUtils.getTenantSid());
        return StdData.ok().build();
    }

    @PostMapping(value={"/metadata/data/column/default/save"})
    public StdData<?> initMetadataLdap() {
        this.tenantMetadataColumnCrudService.saveDefaultAll();
        return StdData.ok().build();
    }

    @GetMapping(value={"/metadata/data/catalogid/ldap"})
    public StdData<?> getTenantMetadataLdap(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        List tenantMetadataVOList = this.tenantMetadataCrudService.getTenantMetadataValue(user.getTenantSid(), "ldap", IamConstants.LDAP_KEY_LIST);
        TenantMetadataLdapVO ldapVO = new TenantMetadataLdapVO(tenantMetadataVOList);
        return StdData.ok((Object)ldapVO);
    }

    @PostMapping(value={"/metadata/data/catalogid/ldap/save"})
    public StdData<?> updateTenantMetadataLdap(@Valid @RequestBody TenantMetadataLdapDTO dto, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        Assert.hasText((String)dto.getAdminPassword(), (String)"\u7ba1\u7406\u5458\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        try {
            AES.decrypt((String)dto.getAdminPassword(), (String)KeyConstant.WECHAT_UNION_ID);
        }
        catch (Exception e) {
            throw new BusinessException((ErrorHandler)I18nError.PASSWORD_DECRYPT_ERROR);
        }
        if (!this.userInRoleService.checkSuperAdmin(Long.valueOf(user.getTenantSid()), Long.valueOf(user.getSid()))) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_USER_NOT_SUPER_ADMIN);
        }
        List tenantMetadataVOList = dto.getTenantMetadataVOList();
        this.tenantMetadataUpdateService.updateTenantMetadataValueList(user.getTenantSid(), tenantMetadataVOList);
        return StdData.ok().build();
    }

    @PostMapping(value={"/metadata/data/catalogid/ldap/test"})
    public StdData<?> testTenantMetadataLdap(@Valid @RequestBody TenantMetadataLdapDTO dto, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        String password;
        if (ObjectUtils.isEmpty((Object)dto.getAdminPassword())) {
            String adminPassword = this.tenantMetadataCrudService.getTenantMetadataValue(user.getTenantSid(), "ldap", ADMIN_PASSWORD);
            if (ObjectUtils.isEmpty((Object)adminPassword)) {
                Assert.hasText((String)adminPassword, (String)"\u7ba1\u7406\u5458\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            dto.setAdminPassword(adminPassword);
        }
        try {
            password = AES.decrypt((String)dto.getAdminPassword(), (String)KeyConstant.WECHAT_UNION_ID);
        }
        catch (Exception e) {
            throw new BusinessException((ErrorHandler)I18nError.PASSWORD_DECRYPT_ERROR);
        }
        boolean ssl = BooleanStrEnum.TRUE.getValue().equals(dto.getSslEnabled());
        DirContext connect = this.ldapService.connect(dto.getUrl(), dto.getAdminAccount(), password, ssl);
        if (connect == null) {
            return StdData.of((int)500, (String)((ssl ? "SSL " : "") + I18nError.IAM_LOGIN_AD_TEST_AUTH_ERROR.getErrorMessage()));
        }
        TenantMetadataLdapVO vo = new TenantMetadataLdapVO();
        vo.setUserLoginAttr(dto.getUserLoginAttr());
        vo.setUserNameAttr(dto.getUserNameAttr());
        vo.setUserFilter(dto.getUserFilter());
        vo.setOuFilter(dto.getOuFilter());
        vo.setOuUniqueIdAttr(dto.getOuUniqueIdAttr());
        List adUserList = new ArrayList();
        try {
            adUserList = this.ldapService.listAdUser(dto.getUrl(), dto.getAdminAccount(), password, ssl, dto.getBaseDn(), vo);
        }
        catch (Exception e) {
            logger.error("\u6d4b\u8bd5AD\u7528\u6237\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
        if (CollectionUtils.isEmpty(adUserList)) {
            return StdData.of((int)500, (String)I18nError.IAM_LOGIN_AD_USER_TEST_SEARCH_ERROR.getErrorMessage());
        }
        if (BooleanStrEnum.TRUE.getValue().equals(dto.getScheduledSyncOuEnabled())) {
            List adOuList = null;
            try {
                adOuList = this.ldapService.listAdOu(dto.getUrl(), dto.getAdminAccount(), password, ssl, dto.getBaseDn(), vo);
            }
            catch (Exception e) {
                logger.error("\u6d4b\u8bd5AD\u7ec4\u7ec7\u67e5\u8be2\u5931\u8d25", (Throwable)e);
            }
            if (CollectionUtils.isEmpty(adOuList)) {
                return StdData.of((int)500, (String)I18nError.IAM_LOGIN_AD_OU_TEST_SEARCH_ERROR.getErrorMessage());
            }
        }
        return StdData.ok((Object)true);
    }

    @GetMapping(value={"/metadata/data/catalogid/saml"})
    public StdData<?> getTenantMetadataSAML(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        List tenantMetadataVOList = this.tenantMetadataCrudService.getTenantMetadataValue(user.getTenantSid(), "saml", IamConstants.SAML_KEY_LIST);
        TenantMetadataSAMLVO samlVO = new TenantMetadataSAMLVO(tenantMetadataVOList);
        return StdData.ok((Object)samlVO);
    }

    @PostMapping(value={"/metadata/data/catalogid/saml/save"})
    public StdData<?> updateTenantMetadataSAML(@Valid @RequestBody TenantMetadataSAMLDTO dto, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        if (!this.userInRoleService.checkSuperAdmin(Long.valueOf(user.getTenantSid()), Long.valueOf(user.getSid()))) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_USER_NOT_SUPER_ADMIN);
        }
        dto.setCredentials(IDPCredentialsUtil.removeCertificateBeginEndLines((String)dto.getCredentials()));
        String credentials = dto.getCredentials();
        try {
            IDPCredentialsUtil.getBasicX509CredentialFromString((String)credentials);
        }
        catch (Exception e) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_SAML_IDP_CREDENTIALS_ERROR);
        }
        List tenantMetadataVOList = dto.getTenantMetadataVOList();
        this.tenantMetadataUpdateService.updateTenantMetadataValueList(user.getTenantSid(), tenantMetadataVOList);
        return StdData.ok().build();
    }

    @GetMapping(value={"/metadata/data/catalogid/oidc"})
    public StdData<?> getTenantMetadataOidc(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        List tenantMetadataVOList = this.tenantMetadataCrudService.getTenantMetadataValue(user.getTenantSid(), "oidc", IamConstants.OIDC_KEY_LIST);
        TenantMetadataOIDCVO vo = new TenantMetadataOIDCVO(tenantMetadataVOList);
        return StdData.ok((Object)vo);
    }

    @PostMapping(value={"/metadata/data/catalogid/oidc/save"})
    public StdData<?> updateTenantMetadataOidc(@Valid @RequestBody TenantMetadataOIDCDTO dto, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        if (!this.userInRoleService.checkSuperAdmin(Long.valueOf(user.getTenantSid()), Long.valueOf(user.getSid()))) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_USER_NOT_SUPER_ADMIN);
        }
        List tenantMetadataVOList = dto.getTenantMetadataVOList();
        this.tenantMetadataUpdateService.updateTenantMetadataValueList(user.getTenantSid(), tenantMetadataVOList);
        return StdData.ok().build();
    }

    @GetMapping(value={"/metadata/data/catalogid/cas"})
    public StdData<?> getTenantMetadataCas(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        List tenantMetadataVOList = this.tenantMetadataCrudService.getTenantMetadataValue(user.getTenantSid(), "cas", IamConstants.CAS_KEY_LIST);
        TenantMetadataCasVO casVO = new TenantMetadataCasVO(tenantMetadataVOList);
        return StdData.ok((Object)casVO);
    }

    @PostMapping(value={"/metadata/data/catalogid/cas/save"})
    public StdData<?> updateTenantMetadataCas(@Valid @RequestBody TenantMetadataCasDTO dto, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        if (!StringUtil.checkUrl((String)dto.getSsoUrl())) {
            throw new BusinessException((ErrorHandler)I18nError.URL_ILLEGAL, new Object[]{dto.getSsoUrl()});
        }
        if (!StringUtil.checkUrl((String)dto.getValidateUrl())) {
            throw new BusinessException((ErrorHandler)I18nError.URL_ILLEGAL, new Object[]{dto.getValidateUrl()});
        }
        if (StringUtils.hasText((String)dto.getLogoutUrl()) && !StringUtil.checkUrl((String)dto.getLogoutUrl())) {
            throw new BusinessException((ErrorHandler)I18nError.URL_ILLEGAL, new Object[]{dto.getLogoutUrl()});
        }
        if (!this.userInRoleService.checkSuperAdmin(Long.valueOf(user.getTenantSid()), Long.valueOf(user.getSid()))) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_USER_NOT_SUPER_ADMIN);
        }
        List tenantMetadataVOList = dto.getTenantMetadataVOList();
        this.tenantMetadataUpdateService.updateTenantMetadataValueList(user.getTenantSid(), tenantMetadataVOList);
        return StdData.ok().build();
    }

    @GetMapping(value={"/metadata/corpid/from"})
    public StdData<?> getTenantCorpIdMetadata(@RequestParam String comeFrom, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        String corpId = this.tenantMetadataCrudService.getTenantMetadataValue(user.getTenantSid(), "corpId", comeFrom);
        return StdData.ok((Object)corpId);
    }

    @GetMapping(value={"/metadata/swap/id"})
    public StdData<?> getTenantMetadataCas(@RequestParam String corpId, @RequestParam String comeFrom) {
        return StdData.ok((Object)this.tenantMetadataCrudService.getTenantIdFromCorpId(corpId, comeFrom));
    }
}

