/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.iam.domain.escloud.vo.TenantInfoVO;
import com.digiwin.dap.middleware.iam.domain.escloud.vo.UserWithTenantVo;
import com.digiwin.dap.middleware.iam.domain.sync.ApplicationSyncDTO;
import com.digiwin.dap.middleware.iam.domain.sync.AuthSyncDTO;
import com.digiwin.dap.middleware.iam.domain.sync.OrgSyncDTO;
import com.digiwin.dap.middleware.iam.domain.sync.SaveTenantAuthSyncDTO;
import com.digiwin.dap.middleware.iam.domain.sync.TenantSyncDTO;
import com.digiwin.dap.middleware.iam.domain.user.UserInfo;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.support.huawei.ProduceSyncService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2"})
public class ThirdPartyController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThirdPartyController.class);
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private ProduceSyncService produceSyncService;

    @PostMapping(value={"/query/tenant/byid"})
    public ResponseEntity<?> getTenant(@RequestBody TenantSyncDTO body) {
        Tenant tenant = this.tenantCrudService.findTenantByTenantId(body.getTenantId());
        UserWithTenantVo result = new UserWithTenantVo();
        if (tenant != null) {
            TenantInfoVO tenantInfo = new TenantInfoVO();
            tenantInfo.setSid(tenant.getSid());
            tenantInfo.setId(tenant.getId());
            tenantInfo.setName(tenant.getName());
            tenantInfo.setTenantId(tenant.getTenantId());
            result.setTenantInfo(tenantInfo);
            User user = (User)this.userCrudService.findBySid(tenant.getOwnerUserSid());
            if (user != null) {
                UserInfo userInfo = new UserInfo();
                userInfo.setSid(user.getSid());
                userInfo.setId(user.getId());
                userInfo.setName(user.getName());
                userInfo.setEmail(user.getEmail());
                userInfo.setTelephone(user.getTelephone());
                result.setUserInfo(userInfo);
            }
        }
        return ResponseEntity.ok((Object)result);
    }

    @PostMapping(value={"/tenant/sync/update"})
    public ResponseEntity<?> updateTenantSync(@RequestBody TenantSyncDTO dto, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        LOGGER.info("\u4fee\u6539\u79df\u6237\u4fe1\u606f dto={}, timeStamp={}", (Object)dto, (Object)dto.getTimeStamp());
        boolean success = this.produceSyncService.updateTenantSync(dto, authoredUser.getTenantSid());
        LOGGER.info("\u4fee\u6539\u79df\u6237\u4fe1\u606f\u7ed3 success={}, timeStamp={}", (Object)success, (Object)dto.getTimeStamp());
        return ResponseEntity.ok((Object)success);
    }

    @PostMapping(value={"/org/sync/save"})
    public ResponseEntity<?> saveOrgSync(@RequestBody OrgSyncDTO dto, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        LOGGER.info("\u4fdd\u5b58\u7ec4\u7ec7\u90e8\u95e8\u4fe1\u606f dto={}, timeStamp={}", (Object)dto, (Object)dto.getTimeStamp());
        boolean success = this.produceSyncService.saveOrgSync(dto, authoredUser);
        LOGGER.info("\u4fdd\u5b58\u7ec4\u7ec7\u90e8\u95e8\u4fe1\u606f success={}, timeStamp={}", (Object)success, (Object)dto.getTimeStamp());
        return ResponseEntity.ok((Object)success);
    }

    @PostMapping(value={"/org/all/sync/save"})
    public ResponseEntity<?> saveAllOrgSync(@RequestBody OrgSyncDTO dto, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        LOGGER.info("\u6279\u91cf\u4fdd\u5b58\u7ec4\u7ec7\u90e8\u95e8\u4fe1\u606f dto={}, timeStamp={}", (Object)dto, (Object)dto.getTimeStamp());
        boolean success = this.produceSyncService.saveAllOrgSync(dto, authoredUser);
        LOGGER.info("\u6279\u91cf\u4fdd\u5b58\u7ec4\u7ec7\u90e8\u95e8\u4fe1\u606f success={}, timeStamp={}", (Object)success, (Object)dto.getTimeStamp());
        return ResponseEntity.ok((Object)success);
    }

    @PostMapping(value={"/tenant/auth/sync/save/iam"})
    public ResponseEntity<?> saveTenantAuthSyncIam(@RequestBody AuthSyncDTO dto, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        LOGGER.info("\u79df\u6237\u5e94\u7528\u6388\u6743\u4fe1\u606f\u540c\u6b65 dto={}, timeStamp={}", (Object)dto, (Object)dto.getTimeStamp());
        SaveTenantAuthSyncDTO success = this.produceSyncService.saveTenantAuthSyncIAM(dto, authoredUser);
        LOGGER.info("\u79df\u6237\u5e94\u7528\u6388\u6743\u4fe1\u606f\u540c\u6b65 success={}, timeStamp={}", (Object)success, (Object)dto.getTimeStamp());
        return ResponseEntity.ok((Object)success);
    }

    @PostMapping(value={"/tenant/app/sync/save"})
    public ResponseEntity<?> saveTenantAppSyncSave(@RequestBody ApplicationSyncDTO dto) {
        LOGGER.info("\u66f4\u65b0\u79df\u6237\u5e94\u7528\u4fe1\u606f dto={}, timeStamp={}", (Object)dto, (Object)dto.getTimeStamp());
        boolean success = this.produceSyncService.saveTenantAppSyncSave(dto);
        LOGGER.info("\u66f4\u65b0\u79df\u6237\u5e94\u7528\u4fe1\u606f success={}, timeStamp={}", (Object)success, (Object)dto.getTimeStamp());
        return ResponseEntity.ok((Object)success);
    }
}

