/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.creator.TransferCreatorApplicationVO;
import com.digiwin.dap.middleware.iam.service.creator.TransferCreatorService;
import com.digiwin.dap.middleware.iam.support.validate.AuthValidateService;
import com.digiwin.dap.middleware.util.UserUtils;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v1/transfer"})
public class TransferCreatorController {
    @Resource
    private TransferCreatorService transferCreatorService;
    @Autowired
    private AuthValidateService authValidateService;

    @PostMapping(value={"/add"})
    public StdData<?> add(@RequestBody TransferCreatorApplicationVO body) {
        if (UserUtils.getTenantSid() != body.getTenantSid() && !this.authValidateService.checkAccessPermission(TargetType.Sys.name(), "POST", AppAuthContextHolder.getContext().getRequestInfo().getPath(), UserUtils.getSysId()).booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        this.transferCreatorService.create(body);
        return StdData.ok().build();
    }
}

