/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import com.digiwin.dap.middle.cache.lock.CacheLock;
import com.digiwin.dap.middle.encrypt.domain.annotation.DapEncrypt;
import com.digiwin.dap.middle.encrypt.domain.annotation.DapSign;
import com.digiwin.dap.middle.kms.constants.KeyConstant;
import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.AuthoredDevice;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.commons.core.codec.Base64;
import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middleware.commons.crypto.DigestUtils;
import com.digiwin.dap.middleware.commons.crypto.PwdUtils;
import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.Page;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.entity.BaseEntityWithId;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nCode;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.constant.enums.CaptchaSceneEnum;
import com.digiwin.dap.middleware.iam.constant.enums.TenantEnterpriseTypeEnum;
import com.digiwin.dap.middleware.iam.constant.enums.UserTypeEnum;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.cache.UserTempTokenCacheVO;
import com.digiwin.dap.middleware.iam.domain.enumeration.GoodsCategoryEnum;
import com.digiwin.dap.middleware.iam.domain.login.LoginFailureInfo;
import com.digiwin.dap.middleware.iam.domain.login.LoginUser;
import com.digiwin.dap.middleware.iam.domain.metadata.MetadataInfoVO;
import com.digiwin.dap.middleware.iam.domain.org.RequestParameterVO;
import com.digiwin.dap.middleware.iam.domain.permission.ApiPermissionQueryVO;
import com.digiwin.dap.middleware.iam.domain.permission.ApiPermissionVO;
import com.digiwin.dap.middleware.iam.domain.request.UserApplicationRequest;
import com.digiwin.dap.middleware.iam.domain.request.UserSimpleRequest;
import com.digiwin.dap.middleware.iam.domain.tenant.AddUsersToTenantVO;
import com.digiwin.dap.middleware.iam.domain.tenant.ReassignAdminVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantAppDTO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantApplicationSummaryVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantSimpleVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantVO;
import com.digiwin.dap.middleware.iam.domain.tenant.UpdateTenantInfoVO;
import com.digiwin.dap.middleware.iam.domain.user.ApplyTenantVO;
import com.digiwin.dap.middleware.iam.domain.user.BatchQueryTempUserTokenVO;
import com.digiwin.dap.middleware.iam.domain.user.EMCQueryDTO;
import com.digiwin.dap.middleware.iam.domain.user.EncryptUserVO;
import com.digiwin.dap.middleware.iam.domain.user.InternalUserUnfreezeVO;
import com.digiwin.dap.middleware.iam.domain.user.QueryParameterInfoVO;
import com.digiwin.dap.middleware.iam.domain.user.QueryParameterVO;
import com.digiwin.dap.middleware.iam.domain.user.QueryUserAllInfoVO;
import com.digiwin.dap.middleware.iam.domain.user.RegisterTempUserVO;
import com.digiwin.dap.middleware.iam.domain.user.RegisterUserVO;
import com.digiwin.dap.middleware.iam.domain.user.RegisterUserWithTenantVO;
import com.digiwin.dap.middleware.iam.domain.user.TenantRelationWithUserWithStatusVO;
import com.digiwin.dap.middleware.iam.domain.user.UpdatePasswordByAccountVO;
import com.digiwin.dap.middleware.iam.domain.user.UpdateUserBasicInfoVO;
import com.digiwin.dap.middleware.iam.domain.user.UserAccountPasswordVO;
import com.digiwin.dap.middleware.iam.domain.user.UserBasicInfoInTenantUpdateVO;
import com.digiwin.dap.middleware.iam.domain.user.UserBasicInfoInTenantVO;
import com.digiwin.dap.middleware.iam.domain.user.UserCondition;
import com.digiwin.dap.middleware.iam.domain.user.UserConditionVO;
import com.digiwin.dap.middleware.iam.domain.user.UserContacts;
import com.digiwin.dap.middleware.iam.domain.user.UserDeregisterRequest;
import com.digiwin.dap.middleware.iam.domain.user.UserDeregisterSelfRequest;
import com.digiwin.dap.middleware.iam.domain.user.UserEnterpriseVO;
import com.digiwin.dap.middleware.iam.domain.user.UserInRoleInfoVO;
import com.digiwin.dap.middleware.iam.domain.user.UserInTenantsWithSysAuthInfo;
import com.digiwin.dap.middleware.iam.domain.user.UserInfo;
import com.digiwin.dap.middleware.iam.domain.user.UserInfoWithTenantInfoVO;
import com.digiwin.dap.middleware.iam.domain.user.UserMetadataVO;
import com.digiwin.dap.middleware.iam.domain.user.UserQueryPageVO;
import com.digiwin.dap.middleware.iam.domain.user.UserSimpleVO;
import com.digiwin.dap.middleware.iam.domain.user.UserTempTokenVO;
import com.digiwin.dap.middleware.iam.domain.user.UserUnfreezeDTO;
import com.digiwin.dap.middleware.iam.domain.user.UserVO;
import com.digiwin.dap.middleware.iam.domain.user.UserWithRolesVO;
import com.digiwin.dap.middleware.iam.domain.usermapping.UserMappingVO;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserInTenant;
import com.digiwin.dap.middleware.iam.mapper.UserInRoleMapper;
import com.digiwin.dap.middleware.iam.mapper.UserMapper;
import com.digiwin.dap.middleware.iam.mapper.UserWholeMapper;
import com.digiwin.dap.middleware.iam.repository.UserDeregisterRecordRepository;
import com.digiwin.dap.middleware.iam.repository.UserRepository;
import com.digiwin.dap.middleware.iam.service.WhiteListService;
import com.digiwin.dap.middleware.iam.service.datapolicy.DataPolicyService;
import com.digiwin.dap.middleware.iam.service.login.IdentityService;
import com.digiwin.dap.middleware.iam.service.metadata.MetadataQueryService;
import com.digiwin.dap.middleware.iam.service.org.OrgQueryService;
import com.digiwin.dap.middleware.iam.service.permission.ApiPermissionService;
import com.digiwin.dap.middleware.iam.service.tenant.AutoEOCService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantQueryService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantRegisterService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantService;
import com.digiwin.dap.middleware.iam.service.user.RegisterService;
import com.digiwin.dap.middleware.iam.service.user.UserBasicInfoUpdateService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserDeregisterRecordService;
import com.digiwin.dap.middleware.iam.service.user.UserInOrgQueryService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleQueryService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantOperationService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantQueryService;
import com.digiwin.dap.middleware.iam.service.user.UserQueryForWeChatService;
import com.digiwin.dap.middleware.iam.service.user.UserQueryService;
import com.digiwin.dap.middleware.iam.service.user.UserService;
import com.digiwin.dap.middleware.iam.service.user.UserWholeService;
import com.digiwin.dap.middleware.iam.service.usermapping.UserMappingService;
import com.digiwin.dap.middleware.iam.support.auth.domain.IamAuthoredUser;
import com.digiwin.dap.middleware.iam.support.clean.PolicyCascadeDeleteService;
import com.digiwin.dap.middleware.iam.support.remote.CacService;
import com.digiwin.dap.middleware.iam.support.remote.LdapService;
import com.digiwin.dap.middleware.iam.support.remote.MessageService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEMCService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEocService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteLMCService;
import com.digiwin.dap.middleware.iam.support.remote.ServiceCloudRemoteService;
import com.digiwin.dap.middleware.iam.support.remote.domain.EmpInfoVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.TenantApplication;
import com.digiwin.dap.middleware.iam.support.remote.domain.TenantApplicationDTO;
import com.digiwin.dap.middleware.iam.support.validate.AuthValidateService;
import com.digiwin.dap.middleware.iam.support.validate.OtherValidateService;
import com.digiwin.dap.middleware.iam.util.StringUtil;
import com.digiwin.dap.middleware.iam.util.vlidator.PasswordValidator;
import com.digiwin.dap.middleware.iam.util.vlidator.UserIdValidator;
import com.digiwin.dap.middleware.util.DateUtils;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.github.pagehelper.PageSerializable;
import io.github.resilience4j.ratelimiter.annotation.RateLimiter;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2/user"})
public class UserController {
    private static final Logger logger = LoggerFactory.getLogger(UserController.class);
    private static DateTimeFormatter dateTimeFormatterForTempUser = DateTimeFormatter.ofPattern("yyyyMMdd");
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private OrgQueryService orgQueryService;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private RegisterService registerService;
    @Autowired
    private UserInRoleMapper userInRoleMapper;
    @Autowired
    private UserInRoleCrudService userInRoleCrudService;
    @Autowired
    private UserInOrgQueryService userInOrgQueryService;
    @Autowired
    private UserBasicInfoUpdateService userBasicInfoUpdateService;
    @Autowired
    private UserInTenantOperationService userInTenantOperationService;
    @Autowired
    private UserQueryService userQueryService;
    @Autowired
    private UserInRoleQueryService userInRoleQueryService;
    @Autowired
    private UserInTenantCrudService userInTenantCrudService;
    @Autowired
    private TenantQueryService tenantQueryService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private IdentityService defaultIdentityService;
    @Autowired
    private UserQueryForWeChatService userQueryForWeChatService;
    @Autowired
    private MetadataQueryService metadataQueryService;
    @Autowired
    private ApiPermissionService apiPermissionService;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private UserService userService;
    @Autowired
    private CacService cacService;
    @Autowired
    private UserWholeMapper userWholeMapper;
    @Autowired
    private PolicyCascadeDeleteService policyCascadeDeleteService;
    @Autowired
    private RemoteLMCService remoteLMCService;
    @Autowired
    private WhiteListService whiteListService;
    @Autowired
    private TenantRegisterService tenantRegisterService;
    @Autowired
    private DataPolicyService dataPolicyService;
    @Autowired
    private UserWholeService userWholeService;
    @Autowired
    private TenantService tenantService;
    @Autowired
    private UserMappingService userMappingService;
    @Autowired
    private AuthValidateService authValidateService;
    @Autowired
    private ServiceCloudRemoteService serviceCloudRemoteService;
    @Autowired
    private UserInTenantQueryService userInTenantQueryService;
    @Autowired
    private UserInRoleService userInRoleService;
    @Autowired
    private AutoEOCService autoEOCService;
    @Autowired
    private LdapService ldapService;
    @Autowired
    private RemoteEMCService remoteEMCService;
    @Autowired
    private UserDeregisterRecordService userDeregisterRecordService;
    @Autowired
    private OtherValidateService otherValidateService;
    @Autowired
    private RemoteEocService remoteEocService;
    @Autowired
    private UserDeregisterRecordRepository userDeregisterRecordRepository;

    @PostMapping
    @RateLimiter(name="/api/iam/v2/user")
    public ResponseEntity<?> getUser(@RequestBody RequestParameterVO body) {
        if (body.getSid() == 0L && StringUtils.isEmpty((CharSequence)body.getId())) {
            throw new IllegalArgumentException("\u7528\u6237Sid\u548c\u7528\u6237Id\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        AuthoredUser authoredUser = UserUtils.getAuthoredUser();
        User user = null;
        if (body.getSid() != 0L) {
            if (authoredUser.getSid() != body.getSid()) {
                if (!this.authValidateService.checkAccessPermission(TargetType.Sys.name(), "POST", AppAuthContextHolder.getContext().getRequestInfo().getPath(), UserUtils.getSysId()).booleanValue()) {
                    throw new BusinessException((ErrorHandler)I18nError.IAM_USER_PERMISSION_COMMON_ERROR, new Object[]{UserUtils.getUserName(), UserUtils.getUserId(), AppAuthContextHolder.getContext().getClientIP(), Base64.encode((String)JsonUtils.writeValue((Object)body))});
                }
                logger.error(I18nError.IAM_USER_PERMISSION_COMMON_ERROR_LOG.getMessage(new Object[]{UserUtils.getUserName(), UserUtils.getUserId(), AppAuthContextHolder.getContext().getClientIP(), "POST", "/api/iam/v2/user", UserUtils.getToken(), UserUtils.getAppToken(), Base64.encode((String)JsonUtils.writeValue((Object)body))}));
            }
            user = (User)this.userCrudService.findBySid(body.getSid());
        } else if (!StringUtils.isEmpty((CharSequence)body.getId())) {
            if (!authoredUser.getUserId().equalsIgnoreCase(body.getId())) {
                if (!this.authValidateService.checkAccessPermission(TargetType.Sys.name(), "POST", "/api/iam/v2/user", UserUtils.getSysId()).booleanValue()) {
                    throw new BusinessException((ErrorHandler)I18nError.IAM_USER_PERMISSION_COMMON_ERROR, new Object[]{UserUtils.getUserName(), UserUtils.getUserId(), AppAuthContextHolder.getContext().getClientIP(), Base64.encode((String)JsonUtils.writeValue((Object)body))});
                }
                logger.error(I18nError.IAM_USER_PERMISSION_COMMON_ERROR_LOG.getMessage(new Object[]{UserUtils.getUserName(), UserUtils.getUserId(), AppAuthContextHolder.getContext().getClientIP(), "POST", "/api/iam/v2/user", UserUtils.getToken(), UserUtils.getAppToken(), Base64.encode((String)JsonUtils.writeValue((Object)body))}));
            }
            user = (User)this.userCrudService.findById(body.getId());
        }
        if (user != null) {
            UserVO userVO = new UserVO(user);
            userVO.setUserMappings(this.userMappingService.getMappedByUser(0L, user.getSid()));
            return ResponseEntity.ok((Object)userVO);
        }
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/full"})
    public ResponseEntity<?> getUser4Backend(@RequestBody RequestParameterVO body) {
        if (body.getSid() == 0L && StringUtils.isEmpty((CharSequence)body.getId())) {
            throw new IllegalArgumentException("\u7528\u6237Sid\u548c\u7528\u6237Id\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        User user = body.getSid() == 0L ? (User)this.userCrudService.findById(body.getId()) : (User)this.userCrudService.findBySid(body.getSid());
        if (user != null) {
            UserVO userVO = new UserVO();
            userVO.setSid(user.getSid());
            userVO.setId(user.getId());
            userVO.setName(user.getName());
            userVO.setAliasId(user.getAliasId());
            userVO.setEmail(user.getEmail());
            userVO.setTelephone(user.getTelephone());
            userVO.setPhone(user.getPhone());
            userVO.setWechat(user.getWechat());
            userVO.setRemark(user.getRemark());
            userVO.setHeadImageUrl(user.getHeadImageUrl());
            userVO.setNickname(user.getNickname());
            userVO.setCellphonePrefix(user.getCellphonePrefix());
            userVO.setType(user.getType());
            userVO.setChanged(user.isChanged());
            userVO.setAgreeAgreement(user.getAgreeAgreement());
            List userMappings = this.userMappingService.getMappedByUser(0L, user.getSid());
            userVO.setUserMappings(userMappings);
            return ResponseEntity.ok((Object)userVO);
        }
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/list"})
    @RateLimiter(name="/api/iam/v2/user/list")
    public StdData getUserListInTenant(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestBody List<String> userIds) {
        Assert.isTrue((user.getTenantSid() > 0L ? 1 : 0) != 0, (String)"\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u79df\u6237\u4fe1\u606f\uff01");
        if (CollectionUtils.isEmpty(userIds)) {
            return StdData.ok().build();
        }
        List users = this.userMapper.getUsersByTenantSidAndUserIds(Long.valueOf(user.getTenantSid()), userIds);
        return StdData.ok((Object)users);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/agree/invitation"})
    public ResponseEntity<Map<String, Object>> agreeTenantInvitation(@RequestBody RequestParameterVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Assert.isTrue((body.getSid() > 0L ? 1 : 0) != 0, (String)"\u9080\u8bf7\u8bb0\u5f55Sid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        long userSid = authoredUser.getSid();
        List authorizationFailureApps = this.userInTenantOperationService.agreeTenantInvited(userSid, body.getSid());
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        if (authorizationFailureApps.size() > 0) {
            result.put("success", false);
            result.put("authorizationFailureApps", authorizationFailureApps);
        } else {
            result.put("success", true);
        }
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @PostMapping(value={"/email/exist"})
    public ResponseEntity<?> checkEmailIsExist(@RequestBody UserInfo body) {
        User user;
        if (body.getEmail() == null) {
            throw new BusinessException((ErrorHandler)I18nError.USER_EMAIL_EMPTY);
        }
        if (!StringUtil.checkEmail((String)body.getEmail())) {
            throw new BusinessException((ErrorHandler)I18nError.USER_EMAIL_FORMAT_ERROR);
        }
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(1);
        boolean isCheckEmail = true;
        if (!StringUtils.isEmpty((CharSequence)body.getId()) && (user = (User)this.userRepository.findById(body.getId())) != null && 1 == user.getType()) {
            isCheckEmail = false;
        }
        if (isCheckEmail) {
            result.put("isRegister", this.userRepository.existsByEmail(body.getEmail()));
        } else {
            result.put("isRegister", false);
        }
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @PostMapping(value={"/email/without/inner/exist"})
    public ResponseEntity<?> checkEmailWithoutInnerIsExist(@RequestBody UserInfo body) {
        if (body.getEmail() == null) {
            throw new BusinessException((ErrorHandler)I18nError.USER_EMAIL_EMPTY);
        }
        if (!StringUtil.checkEmail((String)body.getEmail())) {
            throw new BusinessException((ErrorHandler)I18nError.USER_EMAIL_FORMAT_ERROR);
        }
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(2);
        boolean existsUser = this.userRepository.existsByEmailAndType(body.getEmail(), Integer.valueOf(0));
        result.put("isRegister", existsUser);
        boolean internal = Boolean.FALSE;
        if (existsUser) {
            internal = body.getEmail().toLowerCase().endsWith("@digiwin.com");
        }
        result.put("internal", internal);
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @PostMapping(value={"/exists"})
    public ResponseEntity<?> checkUserIsExist(@RequestBody RequestParameterVO body) {
        Assert.notNull((Object)body.getId(), (String)"\u7528\u6237Id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        boolean existed = this.userCrudService.existsById(body.getId()) || this.userDeregisterRecordRepository.existsByUserId(body.getId());
        result.put("isExistId", existed);
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @CacheLock
    @PostMapping(value={"/mobilephone/exist"})
    public ResponseEntity<?> checkMobilePhoneIsExist(@RequestBody UserInfo body) {
        User user;
        if (StringUtils.isEmpty((CharSequence)body.getTelephone())) {
            throw new BusinessException((ErrorHandler)I18nError.USER_TELEPHONE_EMPTY);
        }
        if (!StringUtil.isInt((String)body.getTelephone())) {
            throw new BusinessException((ErrorHandler)I18nError.USER_TELEPHONE_FORMAT_ERROR);
        }
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(1);
        boolean isCheckTelephone = true;
        if (!StringUtils.isEmpty((CharSequence)body.getId()) && (user = (User)this.userRepository.findById(body.getId())) != null && 1 == user.getType()) {
            isCheckTelephone = false;
        }
        if (isCheckTelephone) {
            result.put("isRegister", this.userRepository.existsByTelephone(body.getTelephone()));
        } else {
            result.put("isRegister", false);
        }
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @PostMapping(value={"/mobilephone/without/inner/exist"})
    public ResponseEntity<?> checkMobilePhoneWithoutInnerIsExist(@RequestBody UserInfo body) {
        if (StringUtils.isEmpty((CharSequence)body.getTelephone())) {
            throw new BusinessException((ErrorHandler)I18nError.USER_TELEPHONE_EMPTY);
        }
        if (!StringUtil.isInt((String)body.getTelephone())) {
            throw new BusinessException((ErrorHandler)I18nError.USER_TELEPHONE_FORMAT_ERROR);
        }
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(1);
        result.put("isRegister", this.userRepository.existsByTelephoneAndType(body.getTelephone(), Integer.valueOf(0)));
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @GetMapping(value={"/id/{id}/inner"})
    public ResponseEntity<?> checkIdInner(@PathVariable String id) {
        User user = this.userCrudService.queryUserByIdOrEmailOrTelephoneAndType(id, id, id, null);
        if (user == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21001, new Object[]{id});
        }
        boolean inner = user.getId().toLowerCase().endsWith("@digiwin.com") || user.getEmail().toLowerCase().endsWith("@digiwin.com");
        return new ResponseEntity((Object)inner, HttpStatus.OK);
    }

    @GetMapping(value={"/openid/{openId}"})
    public ResponseEntity<?> registerByWeChat(@PathVariable(value="openId") String openId, @RequestParam(required=false) String tokenSeed, @RequestAttribute(value="digi-middleware-device-id-data", required=false) AuthoredDevice device) throws Exception {
        IamAuthoredUser authoredUser;
        if (!this.userRepository.existsByWechat(openId)) {
            authoredUser = new IamAuthoredUser();
        } else {
            if (!StringUtils.isEmpty((CharSequence)tokenSeed) && !openId.equalsIgnoreCase(this.serviceCloudRemoteService.getOpenId(AES.decrypt((String)tokenSeed, (String)KeyConstant.WECHAT_UNION_ID)))) {
                throw new BusinessException((ErrorHandler)I18nError.IAM_USER_WECHAT_VERIFY_ERROR);
            }
            authoredUser = this.userQueryForWeChatService.getIamAuthoredUser(openId, device);
        }
        return ResponseEntity.ok((Object)authoredUser);
    }

    @PostMapping(value={"/query"})
    public ResponseEntity<?> queryUser(@RequestBody QueryParameterInfoVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        QueryParameterVO queryParameter = body.getQueryParameter();
        Assert.notNull((Object)queryParameter, (String)"\u67e5\u8be2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)queryParameter.getType(), (String)"\u67e5\u8be2\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        List users = new ArrayList();
        switch (queryParameter.getType()) {
            case "org": {
                if (queryParameter.getSid() == 0L && StringUtils.isEmpty((CharSequence)queryParameter.getUri())) {
                    throw new IllegalArgumentException("\u67e5\u8be2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (queryParameter.getSid() == 0L) {
                    queryParameter.setSid(this.orgQueryService.getOrgSidByUri(authoredUser.getTenantSid(), queryParameter.getUri()).longValue());
                }
                users = this.userCrudService.queryUserByOrg(authoredUser.getTenantSid(), queryParameter.getSid());
                break;
            }
            case "orgCascade": {
                if (queryParameter.getSid() == 0L && StringUtils.isEmpty((CharSequence)queryParameter.getUri())) {
                    throw new IllegalArgumentException("\u67e5\u8be2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (queryParameter.getSid() == 0L) {
                    queryParameter.setSid(this.orgQueryService.getOrgSidByUri(authoredUser.getTenantSid(), queryParameter.getUri()).longValue());
                }
                users = this.userCrudService.queryUserCascadeByOrg(authoredUser.getTenantSid(), queryParameter.getSid());
                break;
            }
            case "disabled": {
                Assert.isTrue((authoredUser.getTenantSid() > 0L ? 1 : 0) != 0, (String)"\u65e0\u6cd5\u5f97\u5230\u5f53\u524d\u7528\u6237\u79df\u6237\u4fe1\u606f\uff01");
                users = this.userCrudService.queryUserListByTenantSidAndCondition(Long.valueOf(authoredUser.getTenantSid()), new UserCondition.Builder().disabled(Boolean.valueOf(true)).build());
                break;
            }
            case "all": {
                Assert.isTrue((authoredUser.getTenantSid() > 0L ? 1 : 0) != 0, (String)"\u65e0\u6cd5\u5f97\u5230\u5f53\u524d\u7528\u6237\u79df\u6237\u4fe1\u606f\uff01");
                users = this.userCrudService.queryUserListByTenantSidAndCondition(Long.valueOf(authoredUser.getTenantSid()), new UserCondition.Builder().readonly(Boolean.valueOf(false)).build());
                break;
            }
        }
        ArrayList userVOS = new ArrayList();
        users.forEach(u -> userVOS.add(UserVO.generate((User)u, (Boolean)true)));
        return new ResponseEntity(userVOS, HttpStatus.OK);
    }

    @PostMapping(value={"/query/alltenant"})
    public ResponseEntity<?> queryAllTenantUser(@RequestBody RequestParameterVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) throws JsonProcessingException {
        List userInfos;
        if (!"integration".equals(authoredUser.getUserId())) {
            throw new IllegalArgumentException("\u5f53\u524d\u767b\u5f55\u7528\u6237\u5fc5\u987b\u4e3aintegration\u7528\u6237\u624d\u53ef\u8bbf\u95ee\u6b64api");
        }
        if (body.getSid() == 0L && StringUtils.isEmpty((CharSequence)body.getId())) {
            userInfos = this.userQueryService.getTenantUsers();
        } else {
            Tenant tenant = body.getSid() == 0L ? (Tenant)this.tenantCrudService.findById(body.getId()) : (Tenant)this.tenantCrudService.findBySid(body.getSid());
            Assert.notNull((Object)tenant, (String)String.format("\u79df\u6237[%s]\u4e0d\u5b58\u5728", body.getSid() == 0L ? body.getId() : Long.valueOf(body.getSid())));
            boolean flag = this.userInTenantCrudService.existsByUnionKey(tenant.getSid(), authoredUser.getSid());
            Assert.isTrue((boolean)flag, (String)String.format("\u5f53\u524d\u767b\u5f55\u7528\u6237[%s]\u4e0d\u662f\u79df\u6237[%s]\u7684\u96c6\u6210\u7528\u6237\uff01", authoredUser.getUserId(), tenant.getId()));
            userInfos = this.userQueryService.getTenantUsers(tenant.getSid());
        }
        return ResponseEntity.ok((Object)AES.encryptCBC((String)JsonUtils.createObjectMapper().writeValueAsString((Object)userInfos), (String)KeyConstant.OTHER));
    }

    @PostMapping(value={"/register"})
    public ResponseEntity<?> register(@RequestBody RegisterUserVO body, @RequestAttribute(value="digi-middleware-auth-app-data", required=false) AuthoredSys sys) {
        if (StringUtils.isEmpty((CharSequence)body.getTelephoneHash()) && StringUtils.isEmpty((CharSequence)body.getEmailHash()) && StringUtils.isEmpty((CharSequence)body.getTelephone()) && StringUtils.isEmpty((CharSequence)body.getEmail())) {
            throw new IllegalArgumentException(I18nCode.EXCEL_IMPORT_USER_ERROR_EMPTY_TELEPHONE_EMAIL.getMessage());
        }
        try {
            if (ObjectUtils.isEmpty((Object)body.getPasswordHash())) {
                throw new BusinessException((ErrorHandler)I18nError.PARAM_ERROR);
            }
            String password = AES.decrypt((String)body.getPasswordHash(), (String)KeyConstant.WECHAT_UNION_ID);
            body.setPassword(password);
        }
        catch (Exception ex) {
            if (!this.authValidateService.checkAccessPermission(TargetType.Sys.name(), "POST", "/api/iam/v2/user/register", sys.getId()).booleanValue()) {
                throw new BusinessException((Throwable)ex);
            }
            logger.error("\u5bc6\u7801\u89e3\u6790\u5931\u8d25:", (Throwable)ex);
        }
        this.registerService.registerUser(body);
        IamAuthoredUser user = this.afterRegister(body, sys);
        return new ResponseEntity((Object)user, HttpStatus.OK);
    }

    @PostMapping(value={"/register/without/captcha"})
    public ResponseEntity<?> registerWithOutVerificationCode(@RequestBody RegisterUserVO body, @RequestAttribute(value="digi-middleware-auth-app-data", required=false) AuthoredSys sys) {
        if (!StringUtils.isEmpty((CharSequence)body.getEmail())) {
            this.otherValidateService.checkInsideEmail(body.getEmail());
        }
        try {
            if (ObjectUtils.isEmpty((Object)body.getPasswordHash())) {
                throw new BusinessException((ErrorHandler)I18nError.PARAM_ERROR);
            }
            String password = AES.decrypt((String)body.getPasswordHash(), (String)KeyConstant.WECHAT_UNION_ID);
            body.setPassword(password);
        }
        catch (Exception ex) {
            if (!this.authValidateService.checkAccessPermission(TargetType.Sys.name(), "POST", "/api/iam/v2/user/register/without/captcha", sys.getId()).booleanValue()) {
                throw new BusinessException((Throwable)ex);
            }
            logger.error("\u5bc6\u7801\u89e3\u6790\u5931\u8d25:", (Throwable)ex);
        }
        this.registerService.registerWithoutVerifyCode(body);
        if (!StringUtils.isEmpty((CharSequence)body.getUnionId())) {
            if (StringUtils.isEmpty((CharSequence)body.getAppId())) {
                logger.error("\u6ce8\u518c\u7528\u6237{}\u65f6\uff0c\u7ed1\u5b9a\u7b2c\u4e09\u65b9\u8d26\u53f7\u65f6\uff0c\u5f52\u5c5e\u7684\u5e94\u7528id\u4e0d\u80fd\u4e3a\u7a7a", (Object)body.getId());
            } else if (StringUtils.isEmpty((CharSequence)body.getComeFrom())) {
                logger.error("\u6ce8\u518c\u7528\u6237{}\u65f6\uff0c\u7ed1\u5b9a\u7b2c\u4e09\u65b9\u8d26\u53f7\u65f6\uff0c\u7ed1\u5b9a\u7684\u7528\u6237\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a", (Object)body.getId());
            } else {
                UserMappingVO userMappingVO = new UserMappingVO();
                userMappingVO.setUserId(body.getId());
                userMappingVO.setIdentityId(body.getAppId());
                userMappingVO.setVerifyUserId(body.getUnionId());
                userMappingVO.setAccount(body.getComeFrom());
                try {
                    this.userMappingService.map(0L, userMappingVO, true);
                }
                catch (Exception ex) {
                    logger.error("\u6620\u5c04\u7528\u6237{}\u5173\u7cfb\u5931\u8d25", (Object)body.getId(), (Object)ex);
                }
            }
        }
        IamAuthoredUser user = this.afterRegister(body, sys);
        return new ResponseEntity((Object)user, HttpStatus.OK);
    }

    private IamAuthoredUser afterRegister(RegisterUserVO body, AuthoredSys sys) {
        this.userService.updateInviteHistory(body.getUserSid(), body.getInviteSid());
        LoginUser loginUser = new LoginUser(body.getId(), new Sys(sys), body.getPassword());
        loginUser.setGclid(body.getGclid());
        IamAuthoredUser user = this.defaultIdentityService.login(loginUser);
        this.remoteLMCService.saveAgreeAgreementChangeLog(UserUtils.getAuthoredSys(), (AuthoredUser)user, user.getAgreeAgreement());
        return user;
    }

    @PostMapping(value={"/role"})
    @RateLimiter(name="/api/iam/v2/user/role")
    public ResponseEntity<?> getRoleInUser(@RequestBody RequestParameterVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (body.getSid() == 0L && Strings.isEmpty((CharSequence)body.getId())) {
            throw new IllegalArgumentException("\u7528\u6237Sid\u548c\u7528\u6237Id\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (body.getSid() == 0L) {
            body.setSid(this.userCrudService.getSidById(body.getId()));
        }
        User user = (User)this.userCrudService.findBySid(body.getSid());
        Assert.notNull((Object)user, (String)String.format("\u7528\u6237[%s]\u4e0d\u5b58\u5728\uff01", body.getSid()));
        List queryRoleResultVOList = this.userInRoleCrudService.getUserInRoleByUser(authoredUser.getTenantSid(), user.getSid());
        UserWithRolesVO userWithRolesVO = new UserWithRolesVO(user, queryRoleResultVOList);
        return new ResponseEntity((Object)userWithRolesVO, HttpStatus.OK);
    }

    @PostMapping(value={"/salt"})
    public ResponseEntity<?> getUserSalt(@RequestBody RequestParameterVO body) {
        if (Strings.isEmpty((CharSequence)body.getId())) {
            throw new IllegalArgumentException("\u7528\u6237Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String salt = this.userQueryService.getUserSalt(body.getId());
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("salt", salt);
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/setting/default/tenant"})
    public ResponseEntity<?> userAddDefaultTenant(@RequestBody QueryParameterVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (body.getSid() == 0L && StringUtils.isEmpty((CharSequence)body.getId())) {
            throw new IllegalArgumentException("\u79df\u6237Sid\u548cId\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        long tenantSid = body.getSid();
        if (tenantSid == 0L) {
            tenantSid = this.tenantCrudService.getSidById(body.getId());
        }
        Assert.isTrue((tenantSid > 0L ? 1 : 0) != 0, (String)String.format("\u79df\u6237[%s]\u4e0d\u5b58\u5728\uff01", tenantSid));
        UserInTenant userInTenant = this.userInTenantCrudService.findByUnionKey(tenantSid, authoredUser.getSid());
        Assert.notNull((Object)userInTenant, (String)String.format("\u7528\u6237[%s]\u5c1a\u672a\u52a0\u5165\u79df\u6237[%s]\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u4e3a\u9ed8\u8ba4\u79df\u6237\uff01", authoredUser.getUserId(), tenantSid));
        User user = (User)this.userCrudService.findBySid(authoredUser.getSid());
        user.setDefaultTenantSid(tenantSid);
        this.userCrudService.update((BaseEntity)user);
        return new ResponseEntity(HttpStatus.OK);
    }

    @GetMapping(value={"/simple"})
    @RateLimiter(name="/api/iam/v2/user/simple")
    public ResponseEntity<?> getUserSimpleByTenant(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Assert.isTrue((authoredUser.getTenantSid() > 0L ? 1 : 0) != 0, (String)String.format("\u5f53\u524d\u767b\u5f55%s\u7528\u6237\u6ca1\u6709\u643a\u5e26\u79df\u6237\u4fe1\u606f", authoredUser.getUserId()));
        return ResponseEntity.ok((Object)this.userQueryService.getUserSimpleByTenant(authoredUser.getTenantSid()));
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/tenant/apply"})
    public ResponseEntity<?> userApplyJoinTenant(@RequestBody ApplyTenantVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Tenant tenant;
        if (body.getTenantSid() == 0L && StringUtils.isEmpty((CharSequence)body.getTenantId())) {
            throw new IllegalArgumentException("tenantSid\u548ctenantId\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        long userSid = authoredUser.getSid();
        if (body.getTenantSid() != 0L) {
            tenant = (Tenant)this.tenantCrudService.findBySid(body.getTenantSid());
            Assert.notNull((Object)tenant, (String)String.format("\u8be5\u79df\u6237[%s]\u4e0d\u5b58\u5728\uff01", body.getTenantSid()));
        } else {
            tenant = (Tenant)this.tenantCrudService.findById(body.getTenantId());
            Assert.notNull((Object)tenant, (String)String.format("\u8be5\u79df\u6237[%s]\u4e0d\u5b58\u5728\uff01", body.getTenantId()));
        }
        this.userInTenantOperationService.applyJoinTenant(userSid, tenant, body.getContent(), body.getDueDate());
        this.messageService.sendApplyMessage(userSid, tenant.getSid(), body.getInviteApp());
        return new ResponseEntity(HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/update"})
    public ResponseEntity<?> updateUser(@RequestBody UserInfo body) {
        if (body.getSid() == 0L && Strings.isEmpty((CharSequence)body.getId())) {
            throw new IllegalArgumentException("\u7528\u6237Sid\u548c\u7528\u6237Id\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (body.getSid() != 0L && body.getSid() != UserUtils.getUserSid() || !Strings.isEmpty((CharSequence)body.getId()) && !body.getId().equalsIgnoreCase(UserUtils.getUserId())) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_USER_PERMISSION_COMMON_ERROR, new Object[]{UserUtils.getUserName(), UserUtils.getUserId(), AppAuthContextHolder.getContext().getClientIP(), Base64.encode((String)JsonUtils.writeValue((Object)body))});
        }
        if (com.digiwin.dap.middleware.util.StringUtils.hasLength((String)body.getPhoneHash())) {
            String phone = AES.decrypt((String)body.getPhoneHash(), (String)KeyConstant.WECHAT_UNION_ID);
            body.setPhone(phone);
        }
        if (com.digiwin.dap.middleware.util.StringUtils.hasLength((String)body.getTelephoneHash())) {
            String telephone = AES.decrypt((String)body.getTelephoneHash(), (String)KeyConstant.WECHAT_UNION_ID);
            body.setTelephone(telephone);
        }
        this.userBasicInfoUpdateService.updateUser(body);
        return new ResponseEntity(HttpStatus.OK);
    }

    @PostMapping(value={"/update/allinfo"})
    public ResponseEntity<?> updateUserAllInfo(@RequestBody UpdateUserBasicInfoVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (body.getUser().getSid() == 0L && Strings.isEmpty((CharSequence)body.getUser().getId())) {
            throw new IllegalArgumentException("\u7528\u6237Sid\u548c\u7528\u6237Id\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (body.getUser().getSid() == 0L) {
            body.getUser().setSid(this.userCrudService.getSidById(body.getUser().getId()));
        }
        this.userBasicInfoUpdateService.updateUserAllInfo(authoredUser.getTenantSid(), body, true);
        return new ResponseEntity(HttpStatus.OK);
    }

    @PostMapping(value={"/simple/update/tenant"})
    public StdData<?> updateUserInTenant(@RequestBody UserBasicInfoInTenantUpdateVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (null == body.getUser() || ObjectUtils.isEmpty((Object)body.getUser().getId())) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_PARAM_EMPTY_ERROR, new Object[]{"userId"});
        }
        this.userBasicInfoUpdateService.updateUserSimpleInTenant(authoredUser.getTenantSid(), body);
        return StdData.ok().build();
    }

    @PostMapping(value={"/withtenant"})
    public ResponseEntity<?> getUserWithTenant(@RequestBody RequestParameterVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        UserBasicInfoInTenantVO userBasicInfoInTenantVO;
        if (authoredUser.getSid() == 0L) {
            throw new BusinessException((ErrorHandler)I18nError.USER_TENANT_NULL_ERROR);
        }
        if (body.getSid() == 0L) {
            if (!Strings.isEmpty((CharSequence)body.getId())) {
                body.setSid(this.userCrudService.getSidById(body.getId()));
            } else {
                body.setSid(authoredUser.getSid());
            }
        }
        if (authoredUser.getSid() != body.getSid() && !this.authValidateService.checkAccessPermission(TargetType.Sys.toString(), "POST", AppAuthContextHolder.getContext().getRequestInfo().getPath(), UserUtils.getSysId()).booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_USER_PERMISSION_ERROR);
        }
        UserCondition userCondition = new UserCondition.Builder().sid(Long.valueOf(body.getSid())).build();
        User user = this.userCrudService.queryUserByTenantSidAndCondition(Long.valueOf(authoredUser.getTenantSid()), userCondition);
        if (user == null) {
            throw new BusinessException((ErrorHandler)I18nError.USER_TENANT_EXISTED_ERROR, new Object[]{authoredUser.getTenantSid(), body.getSid()});
        }
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(authoredUser.getTenantSid());
        if (Boolean.TRUE.equals(body.getSimple())) {
            userBasicInfoInTenantVO = new UserBasicInfoInTenantVO(user, tenant);
        } else {
            List roleResultVOList = this.userInRoleQueryService.queryUserInRoleByUser(authoredUser.getTenantSid(), user.getSid());
            List orgResultVOList = this.userInOrgQueryService.queryUserInOrgByUser(authoredUser.getTenantSid(), user.getSid());
            userBasicInfoInTenantVO = new UserBasicInfoInTenantVO(user, tenant, roleResultVOList, orgResultVOList);
        }
        return new ResponseEntity((Object)userBasicInfoInTenantVO, HttpStatus.OK);
    }

    @GetMapping(value={"/userid/{type}"})
    public ResponseEntity<?> getUserIdByEmailOrTelephone(@PathVariable String type, @RequestParam(name="account", required=true) String account) {
        User user = null;
        if ("email".equals(type)) {
            user = this.userRepository.findFirstByEmail(account);
        } else if ("contacts".equals(type)) {
            UserContacts userContacts = this.userQueryService.getUserContactsById(account);
            if (userContacts != null) {
                return ResponseEntity.ok((Object)StdData.ok((Object)userContacts));
            }
        } else {
            user = this.userRepository.findFirstByTelephone(account);
        }
        if (user != null) {
            return ResponseEntity.ok((Object)StdData.ok((Object)user.getId()));
        }
        return ResponseEntity.ok((Object)StdData.of((int)500, (String)String.format("\u7528\u6237[%s]\u4e0d\u5b58\u5728", account)));
    }

    @PostMapping(value={"/unfreeze"})
    public StdData<?> updateUserUnfreeze(@RequestBody @Valid UserUnfreezeDTO dto) {
        this.userBasicInfoUpdateService.unfreeze(dto);
        return StdData.ok().build();
    }

    @PostMapping(value={"/internal/unfreeze"})
    public StdData<?> unfreezeInternal(@RequestBody @Valid InternalUserUnfreezeVO dto) {
        this.userService.unfreezeInternal(dto);
        return StdData.ok().build();
    }

    @GetMapping(value={"/info"})
    public ResponseEntity<?> getEmpSimpleList(UserSimpleRequest body, Page page, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (page.getOrderBy() == null) {
            page.setOrderBy("id asc");
        }
        List users = this.userQueryService.getUserSimpleVOSByEmpSimple(body.toCondition(), page.getPageNum().intValue(), page.getPageSize().intValue(), page.getOrderBy(), authoredUser.getTenantSid());
        PageSerializable pageData = PageSerializable.of((List)users);
        if (CollectionUtils.isEmpty((Collection)users)) {
            return ResponseEntity.ok((Object)pageData);
        }
        List roles = this.userInRoleMapper.queryUserInRoleByUsers(authoredUser.getTenantSid(), users.stream().map(UserSimpleVO::getSid).collect(Collectors.toList()), true);
        List empInfos = this.remoteEocService.getEmpByUserIds(users.stream().map(UserSimpleVO::getId).collect(Collectors.toList()));
        Map<String, EmpInfoVO> empMap = empInfos.stream().collect(Collectors.toMap(EmpInfoVO::getUserId, a -> a, (k1, k2) -> k1));
        pageData.getList().forEach(user -> {
            List matchRoles = roles.stream().filter(r -> user.getSid() == r.getUserSid().longValue()).collect(Collectors.toList());
            user.setRoles(matchRoles);
            EmpInfoVO empInfo = (EmpInfoVO)empMap.get(user.getId());
            if (empInfo != null) {
                user.setEmpId(empInfo.getId());
                user.setEmpName(empInfo.getName());
            }
        });
        return ResponseEntity.ok((Object)pageData);
    }

    @PostMapping(value={"/info"})
    public ResponseEntity<?> getEmpUbindUsersList(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orderBy", defaultValue="id asc") String orderBy, @RequestBody UserSimpleVO userSimpleVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        List userSimpleVOS = this.userQueryService.getUserSimpleVOSByEmpSimple(userSimpleVO, pageNum.intValue(), pageSize.intValue(), orderBy, authoredUser.getTenantSid());
        return ResponseEntity.ok((Object)new PageSerializable(userSimpleVOS));
    }

    @PostMapping(value={"/mobilephone/update"})
    public StdData saveMobilePhone(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestBody UpdatePasswordByAccountVO updateUserInfo) {
        if (StringUtils.isEmpty((CharSequence)updateUserInfo.getAccount())) {
            throw new BusinessException((ErrorHandler)I18nError.USER_TELEPHONE_EMPTY);
        }
        if (authoredUser == null || authoredUser.getSid() == 0L) {
            throw new BusinessException("\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.userBasicInfoUpdateService.updateUserMobilePhone(authoredUser.getSid(), updateUserInfo);
        return StdData.ok().build();
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/mobilephone/update/cbm"})
    public StdData saveMobilePhone4CBM(@RequestBody UpdatePasswordByAccountVO updateUserInfo) {
        if (ObjectUtils.isEmpty((Object)updateUserInfo.getAccount())) {
            throw new BusinessException((ErrorHandler)I18nError.USER_TELEPHONE_EMPTY);
        }
        this.userBasicInfoUpdateService.updateUserMobilePhone4CBM(UserUtils.getUserSid(), updateUserInfo);
        return StdData.ok().build();
    }

    @PostMapping(value={"/email/update"})
    public StdData saveEmail(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestBody UpdatePasswordByAccountVO updateUserInfo) {
        if (StringUtils.isEmpty((CharSequence)updateUserInfo.getAccount())) {
            throw new BusinessException((ErrorHandler)I18nError.USER_EMAIL_EMPTY);
        }
        if (StringUtils.isEmpty((CharSequence)updateUserInfo.getVerificationCode())) {
            throw new BusinessException((ErrorHandler)I18nError.USER_VERIFICATION_CODE_EMPTY);
        }
        if (authoredUser == null || authoredUser.getSid() == 0L) {
            throw new BusinessException((ErrorHandler)I18nError.USER_ID_EXISTED);
        }
        this.userBasicInfoUpdateService.updateUserEmail(authoredUser.getSid(), updateUserInfo);
        return StdData.ok().build();
    }

    @PostMapping(value={"/simple/update"})
    public StdData saveSimple(@RequestBody UserInfo body) {
        User user = (User)this.userCrudService.findBySid(UserUtils.getUserSid());
        if (null == user) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST, new Object[]{UserUtils.getUserId()});
        }
        if (!StringUtils.isEmpty((CharSequence)body.getName())) {
            user.setName(body.getName());
        }
        user.setOneId(body.getOneId());
        this.userCrudService.update((BaseEntity)user);
        return StdData.ok().build();
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/email/update/cbm"})
    public StdData saveEmailCBM(@RequestBody UpdatePasswordByAccountVO updateUserInfo) {
        if (ObjectUtils.isEmpty((Object)updateUserInfo.getAccount())) {
            throw new BusinessException((ErrorHandler)I18nError.USER_EMAIL_EMPTY);
        }
        if (ObjectUtils.isEmpty((Object)updateUserInfo.getVerificationCode())) {
            throw new BusinessException((ErrorHandler)I18nError.USER_VERIFICATION_CODE_EMPTY);
        }
        this.userBasicInfoUpdateService.updateUserEmail4CBM(UserUtils.getUserSid(), updateUserInfo);
        return StdData.ok().build();
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/agreeagreement/update"})
    public StdData<?> updateAgreeAgreement(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestBody UpdatePasswordByAccountVO updateUserInfo) {
        if (updateUserInfo.getAgreeAgreement() == null) {
            throw new BusinessException((ErrorHandler)I18nError.USER_AGREE_AGREEMENT_EMPTY);
        }
        if (authoredUser == null || authoredUser.getSid() == 0L) {
            throw new BusinessException((ErrorHandler)I18nError.EXCEL_INVITED_ERROR_NULL_TENANT);
        }
        this.userBasicInfoUpdateService.updateUserAgreeAgreement(authoredUser.getSid(), updateUserInfo);
        return StdData.ok().build();
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/temp/register"})
    public ResponseEntity<?> tempRegister(@RequestBody RegisterTempUserVO body) {
        List datapermissions;
        String tenantId = body.getTenantId();
        String appId = body.getAppId();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{appId, tenantId})) {
            throw new IllegalArgumentException("\u5e94\u7528id\u548c\u79df\u6236id \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!tenantId.equalsIgnoreCase(UserUtils.getTenantId()) && !this.authValidateService.checkAccessPermission(TargetType.Sys.name(), "POST", AppAuthContextHolder.getContext().getRequestInfo().getPath(), UserUtils.getSysId()).booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        String userId = this.getTempUserId(tenantId);
        String password = this.getTempUserPassword();
        String userName = "tmpUser_" + tenantId + "_" + appId;
        RegisterUserVO userVO = new RegisterUserVO();
        userVO.setId(userId);
        userVO.setPassword(password);
        userVO.setName(userName);
        long userSid = this.userCrudService.create((BaseEntity)new User(userVO, this.envProperties.getCloud()));
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("userId", userId);
        result.put("userName", userName);
        result.put("userSid", userSid);
        result.put("userPassword", password);
        Tenant tenant = (Tenant)this.tenantCrudService.findById(tenantId);
        long tenantSid = tenant.getSid();
        if (!this.userInTenantCrudService.existsByUnionKey(tenantSid, userSid)) {
            UserInTenant userInTenant = new UserInTenant(userSid, tenantSid);
            this.userInTenantCrudService.create((BaseEntity)userInTenant);
        }
        if ((datapermissions = body.getDatapermissions()) != null && datapermissions.size() > 0) {
            ApiPermissionVO apiPermissionVO = new ApiPermissionVO(userId, tenantId, appId, datapermissions);
            List apiSids = this.apiPermissionService.addApiPermission(apiPermissionVO);
            result.put("apiSids", apiSids);
        }
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/temp/delete"})
    public ResponseEntity<?> tempDelete(@RequestBody LoginUser loginUser, @RequestAttribute(value="digi-middleware-auth-app-data", required=false) AuthoredSys sys) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        loginUser.setApp(new Sys(sys));
        if (org.springframework.util.StringUtils.hasText((String)loginUser.getTenantId()) && !loginUser.getTenantId().equalsIgnoreCase(UserUtils.getTenantId()) && !this.authValidateService.checkAccessPermission(TargetType.Sys.toString(), "POST", AppAuthContextHolder.getContext().getRequestInfo().getPath(), UserUtils.getSysId()).booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        ApiPermissionQueryVO input = this.apiPermissionService.getApiPermissionQueryVOByUser(loginUser);
        String userId = loginUser.getUserId();
        long userSid = this.userCrudService.getSidById(userId);
        Tenant tenant = (Tenant)this.tenantCrudService.findById(loginUser.getTenantId());
        long tenantSid = tenant.getSid();
        this.userInTenantCrudService.deleteByUnionKey(tenantSid, userSid);
        if (userSid > 0L) {
            this.userCrudService.deleteById(userSid);
        }
        this.apiPermissionService.deleteApiPermission(input);
        result.put("userId", userId);
        result.put("userSid", userSid);
        return new ResponseEntity(result, HttpStatus.OK);
    }

    private String getTempUserId(String tenantId) {
        boolean useLetters = false;
        boolean useNumbers = true;
        String rdnString = "";
        String result = "";
        String ymd = dateTimeFormatterForTempUser.format(LocalDateTime.now());
        int length = 3;
        for (int i = 0; i < 5; ++i) {
            rdnString = RandomStringUtils.random((int)length, (boolean)useLetters, (boolean)useNumbers);
            result = "tmpUserId_" + tenantId + "_" + ymd + "_" + rdnString;
            if (!this.userCrudService.existsById(result)) break;
            if (i != 4) continue;
            rdnString = RandomStringUtils.random((int)length, (boolean)true, (boolean)useNumbers);
            break;
        }
        return result;
    }

    private String getTempUserPassword() {
        int min = 24;
        int max = 44;
        int length = min + (int)(Math.random() * (double)(max - min + 1));
        String result = RandomStringUtils.random((int)length, (boolean)true, (boolean)true);
        return result;
    }

    @GetMapping(value={"/dev/tenant"})
    public StdData getDevTenant(@RequestParam String userContent) {
        Tenant tenant;
        if (StringUtils.isEmpty((CharSequence)userContent)) {
            throw new BusinessException((ErrorHandler)I18nError.USER_ID_EXISTED);
        }
        User user = this.userCrudService.queryUserByIdOrEmailOrTelephoneAndType(userContent, userContent, userContent, null);
        if (user != null && (tenant = this.tenantCrudService.findIndividualTenant(user.getSid(), null)) != null) {
            return StdData.ok((Object)tenant.getId());
        }
        return StdData.of((int)500, (String)"\u5f00\u53d1\u5546\u79df\u6237\u4e0d\u5b58\u5728");
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/enterprise"})
    public StdData saveEnterpriseUser(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestBody @Valid List<UserEnterpriseVO> userEnterpriseVOS) {
        ArrayList authorizationFailureApps = new ArrayList();
        for (UserEnterpriseVO o : userEnterpriseVOS) {
            User existed;
            User userExist;
            UserCondition userCondition;
            if (authoredUser.getTenantSid() == 0L) {
                throw new BusinessException("\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u79df\u6237\u4fe1\u606f\uff01");
            }
            if (this.envProperties.getCheckUserId().booleanValue() && UserIdValidator.validateUserId((String)o.getId())) {
                throw new BusinessException((ErrorHandler)I18nError.USER_ID_FORMAT_ERROR, new Object[]{o.getId()});
            }
            String password = o.getPassword();
            try {
                if (ObjectUtils.isEmpty((Object)o.getPasswordHash())) {
                    throw new BusinessException((ErrorHandler)I18nError.PARAM_ERROR);
                }
                try {
                    password = AES.decrypt((String)o.getPasswordHash(), (String)KeyConstant.WECHAT_UNION_ID);
                }
                catch (Exception exception) {
                    throw new BusinessException((ErrorHandler)I18nError.PASSWORD_DECRYPT_ERROR, exception.getMessage());
                }
            }
            catch (Exception ex) {
                if (!this.authValidateService.checkAccessPermission(TargetType.Sys.name(), "POST", "/api/iam/v2/user/enterprise", UserUtils.getSysId()).booleanValue()) {
                    throw ex;
                }
                logger.error("\u5bc6\u7801\u89e3\u6790\u9519\u8bef", (Throwable)ex);
            }
            if (StringUtils.isEmpty((CharSequence)password)) {
                throw new BusinessException((ErrorHandler)I18nError.USER_PASSWORD_EMPTY);
            }
            if (PasswordValidator.validatePassword((String)password)) {
                throw new BusinessException((ErrorHandler)I18nError.PASSWORD_UPDATE_FORMAT_ERROR);
            }
            User user = new User();
            user.setId(authoredUser.getTenantId() + "$" + o.getId());
            user.setPassword(DigestUtils.sha256((String)password));
            user.setChanged(false);
            user.setActivated(true);
            user.setType(Integer.valueOf(1));
            if (!Strings.isEmpty((CharSequence)o.getName())) {
                user.setName(o.getName());
            }
            if (!Strings.isEmpty((CharSequence)o.getEmail())) {
                if (!StringUtil.checkEmail((String)o.getEmail())) {
                    throw new BusinessException((ErrorHandler)I18nError.USER_EMAIL_FORMAT_ERROR);
                }
                userCondition = new UserCondition.Builder().type(UserTypeEnum.INTERNAL.getCode()).email(o.getEmail()).build();
                userExist = this.userCrudService.queryUserByTenantSidAndCondition(Long.valueOf(authoredUser.getTenantSid()), userCondition);
                if (null != userExist) {
                    throw new BusinessException((ErrorHandler)I18nError.USER_EMAIL_EXIST_ERROR);
                }
                user.setEmail(o.getEmail());
            }
            user.setCellphonePrefix(o.getCellphonePrefix());
            if (!Strings.isEmpty((CharSequence)o.getTelephone())) {
                if (!StringUtil.isInt((String)o.getTelephone())) {
                    throw new BusinessException((ErrorHandler)I18nError.USER_TELEPHONE_FORMAT_ERROR);
                }
                userCondition = new UserCondition.Builder().type(UserTypeEnum.INTERNAL.getCode()).telephone(o.getTelephone()).build();
                userExist = this.userCrudService.queryUserByTenantSidAndCondition(Long.valueOf(authoredUser.getTenantSid()), userCondition);
                if (null != userExist) {
                    throw new BusinessException((ErrorHandler)I18nError.USER_TELEPHONE_EXIST_ERROR);
                }
                user.setTelephone(o.getTelephone());
            }
            if ((existed = (User)this.userCrudService.findById(user.getId())) != null && this.userInTenantCrudService.existsByUnionKey(authoredUser.getTenantSid(), user.getSid())) {
                throw new BusinessException((ErrorHandler)I18nError.USER_ID_EXISTED, new Object[]{user.getId()});
            }
            long userSid = this.userCrudService.create((BaseEntity)user);
            user = (User)this.userCrudService.findBySid(userSid);
            if (!this.userInTenantCrudService.existsByUnionKey(authoredUser.getTenantSid(), userSid)) {
                UserInTenant userInTenant = new UserInTenant();
                userInTenant.setTenantSid(authoredUser.getTenantSid());
                userInTenant.setUserSid(userSid);
                userInTenant.setDueDate(o.getDueDate());
                if (o.getDueDate().isBefore(LocalDateTime.now())) {
                    userInTenant.setDisabled(true);
                }
                if (null != o.getUserType()) {
                    userInTenant.setUserType(o.getUserType().booleanValue());
                }
                this.userInTenantCrudService.create((BaseEntity)userInTenant);
            }
            Tenant tenant = (Tenant)this.tenantCrudService.findBySid(authoredUser.getTenantSid());
            authorizationFailureApps.addAll(this.userInTenantOperationService.initializeUserData(tenant, user, o.getRole(), o.getOrg(), o.getApp(), o.getWechat(), o.getUserType()));
            if (o.isSendEmail()) {
                this.messageService.sendDevUserEnterpriseAccountPassword(new UserAccountPasswordVO(o, authoredUser));
            }
            this.autoEOCService.userJoinTenant(o.getEmpId(), user, Long.valueOf(authoredUser.getTenantSid()), Optional.ofNullable(o.getUserType()).orElse(false).booleanValue(), Boolean.valueOf(false));
        }
        return StdData.ok(authorizationFailureApps);
    }

    @PostMapping(value={"/enterprise/check/userintenant"})
    public StdData checkUserInTenant(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestParam String id) {
        User user = (User)this.userCrudService.findById(authoredUser.getTenantId() + "$" + id);
        return StdData.ok((Object)(user != null && this.userInTenantCrudService.existsByUnionKey(authoredUser.getTenantSid(), user.getSid()) ? 1 : 0));
    }

    @PostMapping(value={"/enterprise/check/userintenant/email"})
    public StdData checkUserInTenantByEmail(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestBody RequestParameterVO requestParameterVO) {
        if (StringUtils.isEmpty((CharSequence)requestParameterVO.getEmail())) {
            return StdData.ok((Object)false);
        }
        UserCondition userCondition = new UserCondition.Builder().type(UserTypeEnum.INTERNAL.getCode()).email(requestParameterVO.getEmail()).build();
        User user = this.userCrudService.queryUserByTenantSidAndCondition(Long.valueOf(authoredUser.getTenantSid()), userCondition);
        return StdData.ok((Object)(user != null ? 1 : 0));
    }

    @PostMapping(value={"/enterprise/check/userintenant/telephone"})
    public StdData checkUserInTenantByTelephone(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestBody RequestParameterVO requestParameterVO) {
        UserCondition userCondition = new UserCondition.Builder().type(UserTypeEnum.INTERNAL.getCode()).telephone(requestParameterVO.getTelephone()).build();
        User user = this.userCrudService.queryUserByTenantSidAndCondition(Long.valueOf(authoredUser.getTenantSid()), userCondition);
        return StdData.ok((Object)(user != null ? 1 : 0));
    }

    @PostMapping(value={"/contacts"})
    public StdData getUserContacts(@RequestParam String id, @RequestParam(required=false) Integer type) {
        if (Strings.isEmpty((CharSequence)id)) {
            throw new IllegalArgumentException("\u7528\u6237Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return StdData.ok((Object)this.userQueryService.getUserContacts(id, type));
    }

    @GetMapping(value={"/enterprise/query"})
    public StdData findEnterpriseUsers(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orderBy", defaultValue="") String orderBy, @RequestParam(name="params", required=false) String params, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        PageSerializable result = this.userQueryService.getEnterpriseUsers(pageNum, pageSize, orderBy, UserConditionVO.getSelf((String)params), Long.valueOf(authoredUser.getTenantSid()));
        return StdData.ok((Object)result);
    }

    @GetMapping(value={"/info/without/servicecloud"})
    public StdData getUserInfo(@RequestParam(name="content") String content) {
        return StdData.ok((Object)this.userQueryService.getUserByIdOrEmailOrTelOrWechat(content));
    }

    @GetMapping(value={"/roles"})
    public StdData getUserRoles(@RequestParam(name="tenantId") String tenantId, @RequestParam(name="content") String content) {
        if (!tenantId.equalsIgnoreCase(UserUtils.getTenantId())) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        List userRoles = this.userQueryService.getUserWithRoles(content, tenantId);
        return StdData.ok((Object)userRoles);
    }

    @PostMapping(value={"/email"})
    public StdData queryTenantByEmail(@RequestBody UserConditionVO userConditionVO) {
        if (StringUtils.isEmpty((CharSequence)userConditionVO.getEmail())) {
            return StdData.of((int)20000, (String)"\u90ae\u7bb1\u5730\u5740\u4e3a\u7a7a");
        }
        User user = this.userRepository.findFirstByEmailAndType(userConditionVO.getEmail(), Integer.valueOf(0));
        if (user == null) {
            return StdData.of((int)21200, (String)String.format("\u90ae\u7bb1\u5730\u5740\u4e3a%s\u7684\u7528\u6237\u4e0d\u5b58\u5728", userConditionVO.getEmail()));
        }
        if (!StringUtils.isEmpty((CharSequence)userConditionVO.getTenantId()) && !this.userWholeMapper.existedInTenant(Long.valueOf(user.getSid()), userConditionVO.getTenantId())) {
            return StdData.of((int)21201, (String)String.format("\u90ae\u7bb1\u5730\u5740\u4e3a%s\u7684\u7528\u6237\u5b58\u5728\u4f46\u4e0d\u5728\u79df\u6237%s\u4e0b", userConditionVO.getEmail(), userConditionVO.getTenantId()));
        }
        if (!this.userInTenantCrudService.existsByUnionKey(UserUtils.getTenantSid(), user.getSid()) && !this.authValidateService.checkAccessPermission(TargetType.Sys.toString(), "POST", AppAuthContextHolder.getContext().getRequestInfo().getPath(), UserUtils.getSysId()).booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        UserInfo userInfo = new UserInfo();
        userInfo.setId(user.getId());
        userInfo.setName(user.getName());
        return StdData.ok((Object)userInfo);
    }

    @PostMapping(value={"/telephone"})
    public StdData queryTenantByTelephone(@RequestBody UserConditionVO userConditionVO) {
        if (StringUtils.isEmpty((CharSequence)userConditionVO.getTelephone())) {
            return StdData.of((int)20000, (String)"\u624b\u673a\u53f7\u7801\u4e3a\u7a7a");
        }
        User user = this.userRepository.findFirstByTelephoneAndType(userConditionVO.getTelephone(), Integer.valueOf(0));
        if (user == null) {
            return StdData.of((int)21200, (String)String.format("\u624b\u673a\u53f7\u7801\u4e3a%s\u7684\u7528\u6237\u4e0d\u5b58\u5728", userConditionVO.getTelephone()));
        }
        if (!this.userInTenantCrudService.existsByUnionKey(UserUtils.getTenantSid(), user.getSid()) && !this.authValidateService.checkAccessPermission(TargetType.Sys.toString(), "POST", AppAuthContextHolder.getContext().getRequestInfo().getPath(), UserUtils.getSysId()).booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        if (!StringUtils.isEmpty((CharSequence)userConditionVO.getTenantId()) && !this.userWholeMapper.existedInTenant(Long.valueOf(user.getSid()), userConditionVO.getTenantId())) {
            return StdData.of((int)21201, (String)String.format("\u624b\u673a\u53f7\u7801\u4e3a%s\u7684\u7528\u6237\u5b58\u5728\u4f46\u4e0d\u5728\u79df\u6237%s\u4e0b", userConditionVO.getTelephone(), userConditionVO.getTenantId()));
        }
        UserInfo userInfo = new UserInfo();
        userInfo.setId(user.getId());
        userInfo.setName(user.getName());
        return StdData.ok((Object)userInfo);
    }

    @PostMapping(value={"/auth/user/detail"})
    public StdData queryUserDetails(@RequestBody List<AddUsersToTenantVO> addUsersToTenantVOs) {
        List tenantIds = addUsersToTenantVOs.stream().map(AddUsersToTenantVO::getTenantId).distinct().collect(Collectors.toList());
        Boolean checkAuth = this.authValidateService.checkAccessPermission(TargetType.TenantSys.name(), "POST", "/api/iam/v2/user/auth/user/detail", String.format("%s-%s", UserUtils.getTenantId(), UserUtils.getSysId())) == false && this.authValidateService.checkAccessPermission(TargetType.Sys.name(), "POST", AppAuthContextHolder.getContext().getRequestInfo().getPath(), UserUtils.getSysId()) == false;
        if ((tenantIds.size() > 1 || !tenantIds.contains(UserUtils.getTenantId())) && checkAuth.booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        List userDataVOS = this.userQueryService.getUserDetailWithRolesInTenant(addUsersToTenantVOs);
        return StdData.ok((Object)userDataVOS);
    }

    @PostMapping(value={"/del"})
    public StdData<?> userDeregister(@RequestBody @Valid UserDeregisterRequest request, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        List userIdList = this.whiteListService.getWhiteList("USER_LOGOUT_WHITE_LIST");
        if (CollectionUtils.isEmpty((Collection)userIdList) || !userIdList.contains(authoredUser.getUserId())) {
            throw new BusinessException((ErrorHandler)I18nError.CURRENT_USER_NO_PERMISSION, new Object[]{authoredUser.getUserId()});
        }
        this.userService.deleteUser(request.getUserId(), authoredUser.getUserId(), request.getRemark());
        return StdData.ok().build();
    }

    @PostMapping(value={"/ground/del"})
    public StdData<?> userDeregister4Ground(@RequestBody @Valid UserDeregisterRequest request, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (this.envProperties.isCloud()) {
            throw new BusinessException((ErrorHandler)I18nError.CLOUD_FORBIDDEN);
        }
        this.userService.deleteUser(request.getUserId(), authoredUser.getUserId(), request.getRemark());
        return StdData.ok().build();
    }

    @PostMapping(value={"/current/del"})
    public StdData<?> userDeregisterSelf(@RequestBody UserDeregisterSelfRequest input, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (!this.remoteEMCService.checkVerificationCode(input.getAccount(), CaptchaSceneEnum.CANCEL_ACCOUNT.getScene(), input.getVerificationCode())) {
            throw new BusinessException((ErrorHandler)I18nError.USER_VERIFICATION_CODE_ERROR);
        }
        this.userService.deleteUser(authoredUser.getUserId(), authoredUser.getUserId(), "\u7528\u6237\u4e3b\u52a8\u6ce8\u9500");
        return StdData.ok().build();
    }

    @GetMapping(value={"/deregister/record/search"})
    public StdData<?> pageUserDeregisterRecord(Page page) {
        PageSerializable result = this.userDeregisterRecordService.pageUserLogoutRecord(page.getPageNum(), page.getPageSize(), page.getOrderBy());
        return StdData.ok((Object)result);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/remove"})
    public ResponseEntity<?> removeUser(@RequestBody RequestParameterVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (body.getSid() == 0L && Strings.isEmpty((CharSequence)body.getId())) {
            throw new IllegalArgumentException("\u7528\u6237Sid\u548c\u7528\u6237Id\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        long userSid = body.getSid();
        if (userSid == 0L) {
            userSid = this.userCrudService.getSidById(body.getId());
        }
        if (authoredUser.getSid() != userSid && !this.authValidateService.checkAccessPermission(TargetType.Sys.toString(), "POST", AppAuthContextHolder.getContext().getRequestInfo().getPath(), UserUtils.getSysId()).booleanValue() && !this.authValidateService.checkAccessPermission(TargetType.Tenant.toString(), "POST", AppAuthContextHolder.getContext().getRequestInfo().getPath(), UserUtils.getTenantId()).booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_USER_PERMISSION_ERROR);
        }
        List tenants = this.tenantCrudService.queryTenantByOwnerUserSid(userSid);
        if (null != tenants && tenants.size() > 0) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_DELETE_ERROR, new Object[]{body.getId(), String.join((CharSequence)",", tenants.stream().map(BaseEntityWithId::getId).collect(Collectors.toList()))});
        }
        logger.info("\u5f53\u524d\u64cd\u4f5c\u8005\uff1a{}\uff0c\u6b63\u5728\u5220\u9664\u7528\u6237user.sid={}, user.id={}", new Object[]{authoredUser.getUserId(), userSid, body.getId()});
        if (userSid > 0L) {
            this.userCrudService.deleteById(userSid);
        }
        this.policyCascadeDeleteService.deleteUser(userSid);
        this.cacService.batchDeleteUserAuthorization(body.getId());
        return new ResponseEntity(HttpStatus.OK);
    }

    @GetMapping(value={"/current"})
    public ResponseEntity<?> getCurrent(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestParam(required=false, defaultValue="false") Boolean withEmp, @RequestParam(required=false, defaultValue="false") Boolean isvTenant) {
        TenantRelationWithUserWithStatusVO tenantInfoVO;
        if (0L == authoredUser.getSid() && StringUtils.isEmpty((CharSequence)authoredUser.getUserId())) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST);
        }
        UserInfo user = this.userService.getCurrentInfo(authoredUser, withEmp.booleanValue());
        UserInfoWithTenantInfoVO userInfoWithTenantInfoVO = new UserInfoWithTenantInfoVO(user);
        if (isvTenant.booleanValue() && Objects.nonNull(tenantInfoVO = this.userInTenantQueryService.getOauthIsvTenantInfo(authoredUser.getSid(), authoredUser.getUserId(), authoredUser.getUserName()))) {
            userInfoWithTenantInfoVO.setTenantId(tenantInfoVO.getId());
            userInfoWithTenantInfoVO.setTenantName(tenantInfoVO.getName());
        }
        return ResponseEntity.ok((Object)userInfoWithTenantInfoVO);
    }

    @PostMapping(value={"/metadata/value"})
    public StdData<?> getMetadata(@RequestBody MetadataInfoVO body) {
        Tenant tenant = (Tenant)this.tenantCrudService.findById(body.getTenantId());
        User user = (User)this.userCrudService.findById(body.getUserId());
        UserMetadataVO metadataValue = null;
        if (tenant != null && user != null) {
            if (!UserUtils.getTenantId().equalsIgnoreCase(body.getTenantId()) && !this.authValidateService.checkAccessPermission(TargetType.Sys.toString(), "POST", AppAuthContextHolder.getContext().getRequestInfo().getPath(), UserUtils.getSysId()).booleanValue()) {
                throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
            }
            metadataValue = this.metadataQueryService.getUserMetadataValue(tenant.getSid(), user.getSid(), body.getCatalogId(), body.getKey());
        }
        return StdData.ok((Object)(metadataValue == null ? null : metadataValue.getValue()));
    }

    @PostMapping(value={"/current/join/tenant"})
    public StdData bindCurrentUserWithTenant(@RequestBody UpdateTenantInfoVO updateTenantInfoVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (authoredUser.getSid() == 0L) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST);
        }
        if (StringUtils.isEmpty((CharSequence)updateTenantInfoVO.getCustomerId())) {
            throw new BusinessException((ErrorHandler)I18nError.CUSTOM_ID_NOT_NULL);
        }
        TenantVO tenant = this.userInTenantOperationService.bindingCurrentUserWithTenant(updateTenantInfoVO.getCustomerId(), Long.valueOf(authoredUser.getSid()));
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("userId", authoredUser.getUserId());
        result.put("userName", authoredUser.getUserName());
        result.put("tenantId", tenant.getId());
        result.put("comeFrom", tenant.getComeFrom());
        result.put("customerId", tenant.getCustomerId());
        return StdData.ok(result);
    }

    @PostMapping(value={"/add/join/current/tenant"})
    public StdData addUserWithTenant(@RequestBody RegisterUserWithTenantVO registerUserWithTenantVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (authoredUser.getTenantSid() == 0L) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_ID_NOT_NULL);
        }
        try {
            if (ObjectUtils.isEmpty((Object)registerUserWithTenantVO.getPasswordHash())) {
                throw new BusinessException((ErrorHandler)I18nError.PARAM_ERROR);
            }
            try {
                String password = AES.decrypt((String)registerUserWithTenantVO.getPasswordHash(), (String)KeyConstant.WECHAT_UNION_ID);
                registerUserWithTenantVO.setPassword(password);
            }
            catch (Exception ex) {
                throw new BusinessException((ErrorHandler)I18nError.PASSWORD_DECRYPT_ERROR, ex.getMessage());
            }
        }
        catch (Exception e) {
            if (!this.authValidateService.checkAccessPermission(TargetType.Sys.name(), "POST", "/api/iam/v2/identity/user/add/join/current/tenant", UserUtils.getSysId()).booleanValue()) {
                throw e;
            }
            logger.error("\u5bc6\u7801\u89e3\u6790\u9519\u8bef", (Throwable)e);
        }
        if (0 != this.envProperties.getCloud() && !this.userInRoleService.checkSuperAdmin(Long.valueOf(authoredUser.getTenantSid()), Long.valueOf(authoredUser.getSid()))) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_USER_PERMISSION_OPERATE_ERROR);
        }
        Long userSid = this.userService.addUser(authoredUser.getTenantSid(), registerUserWithTenantVO);
        return StdData.ok((Object)userSid);
    }

    @PostMapping(value={"/add/join/tenant"})
    public StdData addUserInTenantWithAuth(@RequestBody RegisterTempUserVO registerTempUserVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestAttribute(value="digi-middleware-auth-app-data") AuthoredSys sys) {
        Assert.hasText((String)authoredUser.getUserId(), (String)"\u5f53\u524d\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        Tenant tenant = this.getTenant(registerTempUserVO.getTenantSid(), registerTempUserVO.getTenantId());
        boolean skip = this.whiteListService.getWhiteList("SKIP_AUTH_APPS").contains(sys.getId());
        if (!(skip || StringUtils.isEmpty((CharSequence)registerTempUserVO.getAppId()) || registerTempUserVO.getAppId().equals(sys.getId()))) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_1, new Object[]{sys.getId(), registerTempUserVO.getAppId()});
        }
        UserInTenant userInTenant = this.userInTenantCrudService.findByUnionKey(tenant.getSid(), UserUtils.getUserSid());
        if (userInTenant != null && Boolean.FALSE.equals(registerTempUserVO.getTenantVisible())) {
            registerTempUserVO.setTenantVisible(null);
        }
        this.userService.addUserInTenantWithAuth(tenant, authoredUser.getUserId(), registerTempUserVO);
        if (Boolean.TRUE.equals(registerTempUserVO.getAutoEoc())) {
            User user = (User)this.userCrudService.findBySid(authoredUser.getSid());
            this.autoEOCService.userJoinTenant(user.getId(), user, Long.valueOf(tenant.getSid()), false, Boolean.valueOf(false));
        }
        Optional.ofNullable(registerTempUserVO.getTenantVisible()).ifPresent(v -> this.userInTenantCrudService.changeTenantVisibility(tenant.getSid(), UserUtils.getUserSid(), v.booleanValue()));
        return StdData.ok((Object)HttpStatus.OK);
    }

    @DapSign(force=false)
    @DapEncrypt(force=false)
    @PostMapping(value={"/add/join/tenant/custom"})
    public StdData addUserInTenantWithAuth(@RequestBody RegisterTempUserVO registerTempUserVO, @RequestAttribute(value="digi-middleware-auth-app-data") AuthoredSys sys, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser authoredUser) {
        Assert.hasText((String)registerTempUserVO.getUserId(), (String)"\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        Tenant tenant = this.getTenant(registerTempUserVO.getTenantSid(), registerTempUserVO.getTenantId());
        if (!this.whiteListService.getWhiteList("WHITE_API_TENANTS").contains(tenant.getId())) {
            if (null == authoredUser || 0L == authoredUser.getSid()) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_2, new Object[]{tenant.getId()});
            }
            if (!this.userInTenantCrudService.existsByUnionKey(tenant.getSid(), authoredUser.getSid())) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_3, new Object[]{authoredUser.getUserId(), registerTempUserVO.getUserId(), tenant.getId()});
            }
        }
        if (!StringUtils.isEmpty((CharSequence)registerTempUserVO.getAppId()) && !registerTempUserVO.getAppId().equalsIgnoreCase(sys.getId())) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_1, new Object[]{sys.getId(), registerTempUserVO.getAppId()});
        }
        this.userService.addUserInTenantWithAuth(tenant, registerTempUserVO.getUserId(), registerTempUserVO);
        return StdData.ok((Object)HttpStatus.OK);
    }

    private Tenant getTenant(Long tenantSid, String tenantId) {
        Tenant tenant;
        if (tenantSid == null || tenantSid == 0L) {
            if (StringUtils.isEmpty((CharSequence)tenantId)) {
                throw new BusinessException((ErrorHandler)I18nError.TENANT_ID_NOT_NULL);
            }
            tenant = (Tenant)this.tenantCrudService.findById(tenantId);
            if (tenant == null) {
                throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{tenantId});
            }
        } else {
            tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid.longValue());
            if (tenant == null) {
                throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{tenantSid});
            }
        }
        return tenant;
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/individual/tenant/register"})
    public StdData registerByEmail(@RequestBody UserConditionVO userConditionVO) {
        if (StringUtils.isEmpty((CharSequence)userConditionVO.getEmail()) && StringUtils.isEmpty((CharSequence)userConditionVO.getTelephone())) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_4);
        }
        if (StringUtils.isEmpty((CharSequence)userConditionVO.getAppId())) {
            logger.warn(String.format("\u901a\u8fc7\u90ae\u7bb1%s\u6216\u624b\u673a%s\u6ce8\u518c\u4e2a\u4eba\u79df\u6237\u7684\u5e94\u7528\u4e3a\u7a7a\uff0c\u5c06\u4e0d\u8fdb\u884c\u5e94\u7528\u6388\u6743", userConditionVO.getEmail(), userConditionVO.getTelephone()));
        } else if (StringUtils.isEmpty((CharSequence)userConditionVO.getStrategyCode())) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_5, new Object[]{userConditionVO.getAppId()});
        }
        Map tenant = this.tenantRegisterService.registerIndividualTenantWithAuth(userConditionVO);
        return StdData.ok((Object)tenant);
    }

    @PostMapping(value={"/email/tenants/auth"})
    public StdData getTenantsByEmail(@RequestBody UserConditionVO userConditionVO) {
        if (ObjectUtils.isEmpty((Object)userConditionVO.getId()) && StringUtils.isEmpty((CharSequence)userConditionVO.getEmail()) && StringUtils.isEmpty((CharSequence)userConditionVO.getTelephone())) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_6);
        }
        UserInTenantsWithSysAuthInfo tenants = this.userWholeService.getTenants(userConditionVO);
        return StdData.ok((Object)tenants);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/tenant/user/auth"})
    public StdData authAppForTenant(@RequestBody UserConditionVO userConditionVO) {
        if (StringUtils.isEmpty((CharSequence)userConditionVO.getEmail()) && StringUtils.isEmpty((CharSequence)userConditionVO.getTelephone())) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_4);
        }
        if (StringUtils.isEmpty((CharSequence)userConditionVO.getTenantId())) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_ID_NOT_NULL);
        }
        if (StringUtils.isEmpty((CharSequence)userConditionVO.getAppId())) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_5, new Object[]{userConditionVO.getEmail(), userConditionVO.getTelephone()});
        }
        if ((userConditionVO.getTenantAuth() == null || !userConditionVO.getTenantAuth().booleanValue()) && StringUtils.isEmpty((CharSequence)userConditionVO.getStrategyCode())) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_8, new Object[]{userConditionVO.getAppId()});
        }
        this.tenantService.authApp(userConditionVO);
        return StdData.ok((Object)true);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/tenant/reassign/admin"})
    public StdData reassignAdmin(@RequestBody ReassignAdminVO reassignAdminVO) {
        if (CollectionUtils.isEmpty((Collection)reassignAdminVO.getUserIds())) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST);
        }
        this.userService.reassignAdmin(reassignAdminVO);
        return StdData.ok((Object)HttpStatus.OK);
    }

    @PostMapping(value={"/info/in/tenants"})
    public ResponseEntity<?> getUsersInTenants(@RequestBody UserInRoleInfoVO body) {
        if (body.getTenantIds().isEmpty()) {
            logger.error("\u79df\u6237\u6e05\u5355\u4e3a\u7a7a");
            return ResponseEntity.ok(new ArrayList());
        }
        List users = this.userMapper.queryUsersInTenants(body.getTenantIds(), body);
        if (body.getWithoutDigiwinUser() != null && body.getWithoutDigiwinUser().booleanValue()) {
            users = users.stream().filter(u -> !u.getId().endsWith("@digiwin.com") && (u.getEmail() == null || !u.getEmail().endsWith("@digiwin.com"))).collect(Collectors.toList());
        }
        users = users.stream().filter(u -> !StringUtils.isEmpty((CharSequence)u.getCustomerId()) && !u.getId().equals(u.getCustomerId())).collect(Collectors.toList());
        return ResponseEntity.ok(users);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/devagreement/update"})
    public StdData<?> updateAgreeAgreement(@RequestBody UpdatePasswordByAccountVO updateUserInfo) {
        if (updateUserInfo.getDevAgreementSigned() == null) {
            throw new BusinessException((ErrorHandler)I18nError.USER_AGREE_AGREEMENT_EMPTY);
        }
        this.userBasicInfoUpdateService.updateDevAgreement(UserUtils.getUserSid(), updateUserInfo);
        return StdData.ok().build();
    }

    @GetMapping(value={"/check/user/tenant/auth"})
    public ResponseEntity<?> checkUserInTenantWithAuth(@RequestParam(value="tenantId") String tenantId, @RequestParam(value="appId") String appId, @RequestParam(value="email") String email, @RequestParam(required=false, defaultValue="0") Integer type) {
        return ResponseEntity.ok((Object)StdData.ok((Object)this.tenantService.checkUserAuth(tenantId, email, type, appId)));
    }

    @PostMapping(value={"/email/sid"})
    public ResponseEntity<?> queryUserEmailBySids(@RequestBody EMCQueryDTO dto) {
        if (dto.isById()) {
            return ResponseEntity.ok((Object)this.userService.queryEmailByIds(dto.getUserIds()));
        }
        List result = this.userService.queryEmailBySids(dto.getUserSids());
        return ResponseEntity.ok((Object)result);
    }

    @GetMapping(value={"/application/simple"})
    public StdData<?> getUserApplicationSimple(UserApplicationRequest body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        TenantApplicationDTO dto = body.toCondition();
        dto.setTenantId(authoredUser.getTenantId());
        List tenantApplications = this.userQueryService.getUserApplication(dto);
        return StdData.ok((Object)tenantApplications);
    }

    @GetMapping(value={"/application"})
    @RateLimiter(name="/api/iam/v2/user/application")
    public ResponseEntity<?> getUserApplicationByUser(UserApplicationRequest body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (StringUtils.isEmpty((CharSequence)authoredUser.getTenantId())) {
            return ResponseEntity.ok(Collections.emptyList());
        }
        TenantApplicationDTO dto = body.toCondition();
        dto.setUserId(authoredUser.getUserId());
        dto.setTenantId(authoredUser.getTenantId());
        List tenantApplications = this.userQueryService.getTenantApplicationByUser(dto);
        return ResponseEntity.ok((Object)tenantApplications);
    }

    @GetMapping(value={"/service"})
    public ResponseEntity<?> getUserServiceByUser(@RequestParam(name="params", required=false) String params, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (StringUtils.isEmpty((CharSequence)authoredUser.getTenantId())) {
            return ResponseEntity.ok(Collections.emptyList());
        }
        TenantApplicationDTO dto = TenantApplicationDTO.getSelf((String)params);
        dto.setTenantId(authoredUser.getTenantId());
        dto.setCategoryId(GoodsCategoryEnum.SERVICE.id());
        dto.setIncludePlatForm(Boolean.FALSE);
        List tenantApplications = this.tenantQueryService.getTenantApplicationByTenant(dto);
        return new ResponseEntity((Object)tenantApplications, HttpStatus.OK);
    }

    @GetMapping(value={"/package"})
    public ResponseEntity<?> getUserPackageByUser(@RequestParam(name="params", required=false) String params, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (StringUtils.isEmpty((CharSequence)authoredUser.getTenantId())) {
            return ResponseEntity.ok(Collections.emptyList());
        }
        TenantApplicationDTO dto = TenantApplicationDTO.getSelf((String)params);
        dto.setTenantId(authoredUser.getTenantId());
        dto.setCategoryId(GoodsCategoryEnum.PACKAGE.id());
        dto.setIncludePlatForm(Boolean.FALSE);
        List tenantApplications = this.tenantQueryService.getTenantApplicationByTenant(dto);
        return new ResponseEntity((Object)tenantApplications, HttpStatus.OK);
    }

    @GetMapping(value={"/course"})
    public ResponseEntity<?> getUserCourseByUser(@RequestParam(name="params", required=false) String params, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (StringUtils.isEmpty((CharSequence)authoredUser.getTenantId())) {
            return ResponseEntity.ok(Collections.emptyList());
        }
        TenantApplicationDTO dto = TenantApplicationDTO.getSelf((String)params);
        dto.setTenantId(authoredUser.getTenantId());
        dto.setCategoryId(GoodsCategoryEnum.COURSE.id());
        dto.setIncludePlatForm(Boolean.FALSE);
        List tenantApplications = this.tenantQueryService.getTenantApplicationByTenant(dto);
        return new ResponseEntity((Object)tenantApplications, HttpStatus.OK);
    }

    @GetMapping(value={"/tenant/application/summary"})
    public StdData<?> getUserApplicationSummary(@RequestParam(required=false) Boolean showConsoleManagement, @RequestParam(required=false) Boolean showConsolePolicy, @RequestParam(required=false) Boolean filterBundle, @RequestParam(required=false) Boolean filterResource, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        List tenantApplications = this.getTenantApp(authoredUser.getTenantId(), showConsoleManagement, showConsolePolicy, filterBundle, filterResource);
        return StdData.ok((Object)this.getTenantAppSummary(tenantApplications));
    }

    private TenantApplicationSummaryVO getTenantAppSummary(List<TenantApplication> tenantApplications) {
        TenantApplicationSummaryVO summaryVO = new TenantApplicationSummaryVO();
        for (TenantApplication app : tenantApplications) {
            if (!GoodsCategoryEnum.isApi((String)app.getCategoryId()) && !GoodsCategoryEnum.isResource((String)app.getCategoryId())) {
                summaryVO.setAppTotalCount(summaryVO.getAppTotalCount() + 1);
                if (app.isAuthOpen() && !app.isExpired() && !app.isWillExpire()) {
                    summaryVO.setAppActivatedCount(summaryVO.getAppActivatedCount() + 1);
                }
                if (app.isWillExpire()) {
                    summaryVO.setAppWillExpireCount(summaryVO.getAppWillExpireCount() + 1);
                }
                if (!app.isExpired()) continue;
                summaryVO.setAppExpiredCount(summaryVO.getAppExpiredCount() + 1);
                continue;
            }
            if (!GoodsCategoryEnum.isResource((String)app.getCategoryId())) continue;
            summaryVO.setResourceTotalCount(summaryVO.getResourceTotalCount() + 1);
            if (app.isAuthOpen() && !app.isExhausted() && !app.isWillExhaust()) {
                summaryVO.setResourceActivatedCount(summaryVO.getResourceActivatedCount() + 1);
            }
            if (app.isWillExhaust()) {
                summaryVO.setResourceWillExhaustCount(summaryVO.getResourceWillExhaustCount() + 1);
            }
            if (!app.isExhausted()) continue;
            summaryVO.setResourceExhaustedCount(summaryVO.getResourceExhaustedCount() + 1);
        }
        return summaryVO;
    }

    @Deprecated
    @GetMapping(value={"/tenant/application"})
    @RateLimiter(name="/api/iam/v2/user/tenant/application")
    public ResponseEntity<?> getUserApplicationByTenant(@RequestParam(required=false) Boolean showConsoleManagement, @RequestParam(required=false) Boolean showConsolePolicy, @RequestParam(required=false) Boolean filterBundle, @RequestParam(required=false) Boolean filterResource, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        List tenantApplications = this.getTenantApp(authoredUser.getTenantId(), showConsoleManagement, showConsolePolicy, filterBundle, filterResource);
        return ResponseEntity.ok((Object)tenantApplications);
    }

    @GetMapping(value={"/tenant/application/auth"})
    public ResponseEntity<?> getUserApplicationByTenantAuth(@RequestParam(required=false) Boolean showConsolePolicy, @RequestParam(required=false) Boolean filterBundle, @RequestParam(required=false) Boolean filterResource, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        List tenantApplications = this.getTenantApp(authoredUser.getTenantId(), null, showConsolePolicy, filterBundle, filterResource);
        List filtered = new ArrayList(tenantApplications);
        filtered = this.dataPolicyService.getActionData(authoredUser.getTenantSid(), authoredUser.getSid(), filtered, "DigiwinCloud", "djc-cloud-management", "djc-mang-service");
        return ResponseEntity.ok(filtered);
    }

    private List<TenantApplication> getTenantApp(String tenantId, Boolean showConsoleManagement, Boolean showConsolePolicy, Boolean filterBundle, Boolean filterResource) {
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            return Collections.emptyList();
        }
        TenantApplicationDTO tenantApplicationDTO = new TenantApplicationDTO(tenantId);
        tenantApplicationDTO.setCountApiInvoke(Boolean.valueOf(true));
        List tenantApplications = this.tenantQueryService.getTenantApplicationAndPlatFormByTenant(tenantApplicationDTO);
        if (showConsoleManagement != null) {
            tenantApplications.removeIf(a -> !showConsoleManagement.equals(a.getShowConsoleManagement()));
        }
        if (showConsolePolicy != null) {
            tenantApplications.removeIf(a -> !showConsolePolicy.equals(a.getShowConsolePolicy()));
        }
        if (Boolean.TRUE.equals(filterBundle)) {
            tenantApplications.removeIf(a -> StrUtils.isNotEmpty((String)a.getBundleCode()));
        }
        if (Boolean.TRUE.equals(filterResource)) {
            tenantApplications.removeIf(a -> GoodsCategoryEnum.isResource((String)a.getCategoryId()));
        }
        this.setSummaryFieldsInfo(tenantApplications);
        return tenantApplications;
    }

    private void setSummaryFieldsInfo(List<TenantApplication> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        LocalDateTime now = DateUtils.now();
        list.forEach(app -> {
            this.setWillExpire(app, now);
            this.setWillExhaust(app);
            this.setExhausted(app);
        });
    }

    private void setWillExpire(TenantApplication app, LocalDateTime now) {
        if (!app.isAuthOpen() || app.isExpired()) {
            return;
        }
        LocalDateTime expired = DateUtils.getDateByStr((String)app.getExpiredTime());
        if (expired != null && expired.isBefore(now.plusDays(30L))) {
            app.setWillExpire(true);
        }
    }

    private void setWillExhaust(TenantApplication app) {
        boolean willExhaust;
        if (!app.isAuthOpen() || app.getAlertThreshold() == null) {
            return;
        }
        boolean bl = willExhaust = this.isGbUnit(app) ? this.getRemainGb(app).filter(r -> r.compareTo(BigDecimal.ZERO) > 0 && r.compareTo(BigDecimal.valueOf(app.getAlertThreshold().intValue())) < 0).isPresent() : Optional.ofNullable(app.getRemainingUsage()).filter(r -> r > 0 && r < app.getAlertThreshold()).isPresent();
        if (willExhaust) {
            app.setWillExhaust(true);
        }
    }

    private void setExhausted(TenantApplication app) {
        boolean exhausted;
        boolean bl = exhausted = this.isGbUnit(app) ? this.getRemainGb(app).filter(r -> r.compareTo(BigDecimal.ZERO) <= 0).isPresent() : Optional.ofNullable(app.getRemainingUsage()).filter(r -> r <= 0).isPresent();
        if (exhausted) {
            app.setExhausted(true);
        }
    }

    private boolean isGbUnit(TenantApplication app) {
        return "GB".equals(app.getCustomUnit());
    }

    private Optional<BigDecimal> getRemainGb(TenantApplication app) {
        return Optional.ofNullable(app.getRemainUsageCapacity()).filter(StringUtils::isNotBlank).map(BigDecimal::new);
    }

    @GetMapping(value={"/find/tenant"})
    public ResponseEntity<?> findTenant(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Boolean excludeSensitiveDate = true;
        if (this.authValidateService.checkAccessPermission(TargetType.Sys.toString(), "GET", "/api/iam/v2/user/find/tenant", UserUtils.getSysId()).booleanValue()) {
            excludeSensitiveDate = false;
        }
        List tenantRelationWithUserWithStatusVOS = this.userInTenantQueryService.queryUserJoinedTenant(Long.valueOf(authoredUser.getSid()), excludeSensitiveDate);
        return new ResponseEntity((Object)tenantRelationWithUserWithStatusVOS, HttpStatus.OK);
    }

    @GetMapping(value={"/find/tenant/ground"})
    public StdData<?> findUserTenant(@RequestParam Long userSid) {
        if (this.envProperties.isCloud()) {
            throw new BusinessException((ErrorHandler)I18nError.CLOUD_FORBIDDEN);
        }
        List tenantRelationWithUserWithStatusVOS = this.userInTenantQueryService.queryUserJoinedTenant(userSid, Boolean.valueOf(true));
        return StdData.ok((Object)tenantRelationWithUserWithStatusVOS);
    }

    @PostMapping(value={"/find"})
    public StdData<?> findUser(@RequestBody @Valid EncryptUserVO encryptUserVO) {
        long sid;
        try {
            sid = Long.parseLong(AES.decryptHex((String)encryptUserVO.getSid(), (String)KeyConstant.CAS));
        }
        catch (Exception e) {
            logger.error("decrypt userSid failed, sid: {}", (Object)encryptUserVO.getSid(), (Object)e);
            return StdData.of((int)500, (String)"\u7528\u6237sid\u65e0\u6548");
        }
        User user = (User)this.userCrudService.findBySid(sid);
        if (user != null) {
            return StdData.ok((Object)new UserSimpleVO(user));
        }
        return StdData.of((int)500, (String)"\u7528\u6237\u4e0d\u5b58\u5728");
    }

    @PostMapping(value={"/info/page"})
    public StdData<?> getUserInfo(@RequestBody @Valid UserQueryPageVO vo) {
        return StdData.ok((Object)this.userQueryService.getUserInfoPage(vo));
    }

    @PostMapping(value={"/login/failure"})
    public StdData getUserErrorCount(@RequestBody LoginUser loginUser) {
        Assert.hasText((String)loginUser.getUserId(), (String)"userId is null");
        LoginFailureInfo loginFailureInfo = (LoginFailureInfo)RedisUtils.get((Object)String.format("%s%s", "iam:failure:login:", loginUser.getUserId().toLowerCase()), LoginFailureInfo.class);
        if (null == loginFailureInfo) {
            loginFailureInfo = new LoginFailureInfo();
            loginFailureInfo.setCount(0);
        }
        return StdData.ok((Object)loginFailureInfo);
    }

    @PostMapping(value={"/tenant/auth/users"})
    public StdData getAuthUsers(@RequestBody TenantAppDTO tenantAppDTO) {
        if (ObjectUtils.isEmpty((Object)tenantAppDTO.getAppId())) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_PARAM_EMPTY_ERROR, new Object[]{"appId"});
        }
        if (ObjectUtils.isEmpty((Object)tenantAppDTO.getPageNum())) {
            tenantAppDTO.setPageNum(Integer.valueOf(0));
        }
        if (ObjectUtils.isEmpty((Object)tenantAppDTO.getPageSize())) {
            tenantAppDTO.setPageSize(Integer.valueOf(10));
        }
        tenantAppDTO.getTenantIds().add(UserUtils.getTenantId());
        PageSerializable users = this.userQueryService.getAuthUsers(tenantAppDTO);
        return StdData.ok((Object)users);
    }

    @PostMapping(value={"/tempToken/list"})
    public StdData<?> getUserTokenList(@RequestBody BatchQueryTempUserTokenVO batchQueryVO) {
        if (CollectionUtils.isEmpty((Collection)batchQueryVO.getUserList())) {
            return StdData.ok().build();
        }
        ArrayList result = new ArrayList();
        batchQueryVO.getUserList().forEach(e -> {
            UserTempTokenCacheVO cacheVO = new UserTempTokenCacheVO();
            cacheVO.setValue(String.join((CharSequence)"_", e.getUserId(), e.getTenantId(), e.getAppId()));
            cacheVO.setCreateTime(Long.valueOf(System.currentTimeMillis()));
            String tempToken = UUID.randomUUID().toString().toLowerCase();
            String tempTokenKey = String.format("iam:temp:token:%s", tempToken);
            RedisUtils.set((String)tempTokenKey, (Object)cacheVO, (Duration)Duration.ofMinutes(this.envProperties.getTempTokenExpire()));
            result.add(new UserTempTokenVO(e.getUserId(), PwdUtils.encodeHex((String)tempToken, (String)KeyConstant.TEMP_TOKEN_SECRET)));
        });
        return StdData.ok(result);
    }

    @PostMapping(value={"/sids"})
    public StdData getUserList(@RequestBody QueryUserAllInfoVO userAllInfoVO) {
        if (CollectionUtils.isEmpty((Collection)userAllInfoVO.getUserSids()) && CollectionUtils.isEmpty((Collection)userAllInfoVO.getUserIds())) {
            return StdData.ok().build();
        }
        if (userAllInfoVO.getUserSids().size() > 500 || userAllInfoVO.getUserIds().size() > 500) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_QUERY_SIZE_MAX_ERROR);
        }
        List users = this.userMapper.findByIds(Long.valueOf(UserUtils.getTenantSid()), userAllInfoVO.getUserIds(), userAllInfoVO.getUserSids());
        return StdData.ok((Object)users);
    }

    @GetMapping(value={"/id/from"})
    public StdData<?> checkSourceId(@RequestParam String userId) {
        User user = (User)this.userRepository.findById(userId);
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (user != null) {
            result.put("user", new UserSimpleVO(user));
            Tenant individualTenant = this.tenantCrudService.findIndividualTenant(user.getSid(), TenantEnterpriseTypeEnum.INDIVIDUAL_TENANT.getValue());
            if (individualTenant != null) {
                result.put("individualTenant", new TenantSimpleVO(individualTenant));
            }
        }
        return StdData.ok(result);
    }

    @PostMapping(value={"/infos/check"})
    public StdData<?> queryUserInfos(@RequestBody UserConditionVO conditionVO) {
        if (!CollectionUtils.isEmpty((Collection)conditionVO.getUserIds())) {
            return StdData.ok((Object)this.userMapper.filterUserIds(conditionVO));
        }
        return StdData.ok(Collections.emptyList());
    }
}

